/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.bidi.ParagraphSplitter;
import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.derived.BorderPropertySet;
import com.openhtmltopdf.css.style.derived.RectPropertySet;
import com.openhtmltopdf.layout.Breaker;
import com.openhtmltopdf.layout.FloatLayoutResult;
import com.openhtmltopdf.layout.FunctionData;
import com.openhtmltopdf.layout.InlineBoxMeasurements;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.LayoutUtil;
import com.openhtmltopdf.layout.LineBreakContext;
import com.openhtmltopdf.layout.Styleable;
import com.openhtmltopdf.layout.TextUtil;
import com.openhtmltopdf.layout.VerticalAlignContext;
import com.openhtmltopdf.render.AnonymousBlockBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.FSFontMetrics;
import com.openhtmltopdf.render.FloatDistances;
import com.openhtmltopdf.render.InlineBox;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.render.InlineText;
import com.openhtmltopdf.render.LineBox;
import com.openhtmltopdf.render.MarkerData;
import com.openhtmltopdf.render.StrutMetrics;
import com.openhtmltopdf.render.TextDecoration;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class InlineBoxing {
    private InlineBoxing() {
    }

    public static void layoutContent(LayoutContext c, BlockBox box, int initialY, int breakAtLine) {
        Element blockElement = box.getElement();
        ParagraphSplitter.Paragraph para = c.getParagraphSplitter().lookupBlockElement(blockElement);
        byte blockLayoutDirection = para.getActualDirection();
        SpaceVariables space = new SpaceVariables(box.getContentWidth());
        StateVariables current = new StateVariables();
        StateVariables previous = new StateVariables();
        current.line = InlineBoxing.newLine(c, initialY, (Box)box);
        current.line.setDirectionality(blockLayoutDirection);
        int contentStart = 0;
        List<InlineBox> openInlineBoxes = null;
        HashMap<InlineBox, InlineLayoutBox> iBMap = new HashMap<InlineBox, InlineLayoutBox>();
        if (box instanceof AnonymousBlockBox && (openInlineBoxes = ((AnonymousBlockBox)box).getOpenInlineBoxes()) != null) {
            openInlineBoxes = new ArrayList<InlineBox>(openInlineBoxes);
            current.layoutBox = InlineBoxing.addOpenInlineBoxes(c, current.line, openInlineBoxes, space.maxAvailableWidth, iBMap);
        }
        if (openInlineBoxes == null) {
            openInlineBoxes = new ArrayList<InlineBox>();
        }
        space.remainingWidth -= c.getBlockFormattingContext().getFloatDistance(c, current.line, space.remainingWidth);
        CalculatedStyle parentStyle = box.getStyle();
        int minimumLineHeight = (int)parentStyle.getLineHeight(c);
        int indent = (int)parentStyle.getFloatPropertyProportionalWidth(CSSName.TEXT_INDENT, space.maxAvailableWidth, c);
        space.remainingWidth -= indent;
        contentStart += indent;
        MarkerData markerData = c.getCurrentMarkerData();
        if (markerData != null && box.getStyle().isListMarkerInside()) {
            space.remainingWidth -= markerData.getLayoutWidth();
            contentStart += markerData.getLayoutWidth();
        }
        c.setCurrentMarkerData(null);
        ArrayList<FloatLayoutResult> pendingFloats = new ArrayList<FloatLayoutResult>();
        boolean hasFirstLinePEs = false;
        ArrayList<Layer> pendingInlineLayers = new ArrayList<Layer>();
        if (c.getFirstLinesTracker().hasStyles()) {
            box.styleText(c, c.getFirstLinesTracker().deriveAll(box.getStyle()));
            hasFirstLinePEs = true;
        }
        boolean needFirstLetter = c.getFirstLettersTracker().hasStyles();
        boolean zeroWidthInlineBlock = false;
        int lineOffset = 0;
        for (Styleable node : box.getInlineContent()) {
            if (node.getStyle().isInline()) {
                InlineBox inlineBox = (InlineBox)node;
                CalculatedStyle style = inlineBox.getStyle();
                if (inlineBox.isStartsHere()) {
                    InlineBoxing.startInlineBox(c, space, current, previous, openInlineBoxes, iBMap, inlineBox, style);
                }
                LineBreakContext lbContext = new LineBreakContext();
                if (inlineBox.isDynamicFunction()) {
                    lbContext.setMaster(inlineBox.getContentFunction().getLayoutReplacementText());
                } else {
                    lbContext.setMaster(inlineBox.getText());
                }
                boolean inCharBreakingMode = false;
                int troublesomeStartPosition = -1;
                int troublesomeAttemptCount = 0;
                do {
                    StartInlineTextResult result;
                    lbContext.reset();
                    int fit = 0;
                    if (lbContext.getStart() == 0) {
                        fit += space.pendingLeftMBP + space.pendingRightMBP;
                    }
                    boolean trimmedLeadingSpace = false;
                    if (InlineBoxing.hasTrimmableLeadingSpace(current.line, style, lbContext, zeroWidthInlineBlock)) {
                        trimmedLeadingSpace = true;
                        InlineBoxing.trimLeadingSpace(lbContext);
                    }
                    lbContext.setEndsOnNL(false);
                    zeroWidthInlineBlock = false;
                    if (lbContext.getStartSubstring().length() == 0) break;
                    if (needFirstLetter && !lbContext.isFinished()) {
                        InlineBoxing.startFirstLetterInlineLayoutBox(c, space, current, inlineBox, lbContext);
                        needFirstLetter = false;
                    } else if (style.getWordWrap() != IdentValue.BREAK_WORD) {
                        result = InlineBoxing.startInlineText(c, lbContext, inlineBox, space, current, fit, trimmedLeadingSpace, false);
                        if (result == StartInlineTextResult.RECONSUME_BELOW_FLOATS) {
                            continue;
                        }
                    } else {
                        result = InlineBoxing.startInlineText(c, lbContext, inlineBox, space, current, fit, trimmedLeadingSpace, inCharBreakingMode);
                        inCharBreakingMode = lbContext.isFinishedInCharBreakingMode();
                        if (result == StartInlineTextResult.RECONSUME_BELOW_FLOATS) continue;
                        if (result == StartInlineTextResult.RECONSUME_UNBREAKABLE_ON_NEW_LINE) {
                            if (troublesomeStartPosition == lbContext.getStart()) {
                                ++troublesomeAttemptCount;
                            } else {
                                troublesomeStartPosition = lbContext.getStart();
                                troublesomeAttemptCount = 1;
                            }
                            if (troublesomeAttemptCount > 5) {
                                XRLog.log(Level.SEVERE, LogMessageId.LogMessageId2Param.GENERAL_FATAL_INFINITE_LOOP_BUG_IN_LINE_BREAKING_ALGO, (Object)lbContext.getStartSubstring(), (Object)lbContext.getEnd());
                                throw new RuntimeException("Infinite loop bug in break-word line breaking algorithm!");
                            }
                        }
                    }
                    if (!lbContext.isNeedsNewLine()) continue;
                    InlineBoxing.startNewInlineLine(c, box, breakAtLine, blockLayoutDirection, space, current, previous, contentStart, openInlineBoxes, iBMap, minimumLineHeight, markerData, pendingFloats, hasFirstLinePEs, pendingInlineLayers, lineOffset, inlineBox, lbContext);
                    ++lineOffset;
                    markerData = null;
                    contentStart = 0;
                } while (!lbContext.isFinished());
                if (!inlineBox.isEndsHere()) continue;
                InlineBoxing.endInlineBox(c, space, current, previous, openInlineBoxes, pendingInlineLayers, inlineBox, style);
                continue;
            }
            BlockBox child = (BlockBox)node;
            if (child.getStyle().isNonFlowContent()) {
                space.remainingWidth -= InlineBoxing.processOutOfFlowContent(c, current.line, child, space.remainingWidth, pendingFloats);
                continue;
            }
            if (!child.getStyle().isInlineBlock() && !child.getStyle().isInlineTable()) continue;
            InlineBoxing.startInlineBlock(c, box, initialY, breakAtLine, blockLayoutDirection, space, current, previous, contentStart, openInlineBoxes, iBMap, minimumLineHeight, markerData, pendingFloats, hasFirstLinePEs, pendingInlineLayers, lineOffset, child);
            needFirstLetter = false;
            if (child.getWidth() == 0) {
                zeroWidthInlineBlock = true;
            }
            ++lineOffset;
            markerData = null;
            contentStart = 0;
        }
        current.line.trimTrailingSpace(c);
        InlineBoxing.saveLine(current.line, c, box, minimumLineHeight, space.maxAvailableWidth, pendingFloats, hasFirstLinePEs, pendingInlineLayers, markerData, contentStart, InlineBoxing.isAlwaysBreak(c, box, breakAtLine, lineOffset));
        if (current.line.isFirstLine() && current.line.getHeight() == 0 && markerData != null) {
            c.setCurrentMarkerData(markerData);
        }
        markerData = null;
        box.setContentWidth(space.maxAvailableWidth);
        box.setHeight(current.line.getY() + current.line.getHeight());
    }

    private static void startInlineBlock(LayoutContext c, BlockBox box, int initialY, int breakAtLine, byte blockLayoutDirection, SpaceVariables space, StateVariables current, StateVariables previous, int contentStart, List<InlineBox> openInlineBoxes, Map<InlineBox, InlineLayoutBox> iBMap, int minimumLineHeight, MarkerData markerData, List<FloatLayoutResult> pendingFloats, boolean hasFirstLinePEs, List<Layer> pendingInlineLayers, int lineOffset, BlockBox child) {
        InlineBoxing.layoutInlineBlockContent(c, box, child, initialY);
        if (child.getWidth() > space.remainingWidth && current.line.isContainsContent()) {
            InlineBoxing.saveLine(current.line, c, box, minimumLineHeight, space.maxAvailableWidth, pendingFloats, hasFirstLinePEs, pendingInlineLayers, markerData, contentStart, InlineBoxing.isAlwaysBreak(c, box, breakAtLine, lineOffset));
            previous.line = current.line;
            current.line = InlineBoxing.newLine(c, previous.line, (Box)box);
            current.line.setDirectionality(blockLayoutDirection);
            current.layoutBox = InlineBoxing.addOpenInlineBoxes(c, current.line, openInlineBoxes, space.maxAvailableWidth, iBMap);
            previous.layoutBox = current.layoutBox == null || current.layoutBox.getParent() instanceof LineBox ? null : (InlineLayoutBox)current.layoutBox.getParent();
            space.remainingWidth = space.maxAvailableWidth;
            space.remainingWidth -= c.getBlockFormattingContext().getFloatDistance(c, current.line, space.remainingWidth);
            child.reset(c);
            InlineBoxing.layoutInlineBlockContent(c, box, child, initialY);
        }
        if (current.layoutBox == null) {
            current.line.addChildForLayout(c, child);
        } else {
            current.layoutBox.addInlineChild(c, child);
        }
        current.line.setContainsContent(true);
        current.line.setContainsBlockLevelContent(true);
        space.remainingWidth -= child.getWidth();
        if (current.layoutBox != null && current.layoutBox.isStartsHere()) {
            space.pendingLeftMBP -= current.layoutBox.getStyle().getMarginBorderPadding(c, space.maxAvailableWidth, 1);
        }
    }

    private static void endInlineBox(LayoutContext c, SpaceVariables space, StateVariables current, StateVariables previous, List<InlineBox> openInlineBoxes, List<Layer> pendingInlineLayers, InlineBox inlineBox, CalculatedStyle style) {
        int rightMBP = style.getMarginBorderPadding(c, space.maxAvailableWidth, 2);
        space.pendingRightMBP -= rightMBP;
        space.remainingWidth -= rightMBP;
        openInlineBoxes.remove(openInlineBoxes.size() - 1);
        if (current.layoutBox.isPending()) {
            current.layoutBox.unmarkPending(c);
            current.layoutBox.setStartsHere(inlineBox.isStartsHere());
        }
        current.layoutBox.setEndsHere(true);
        if (current.layoutBox.getStyle().requiresLayer()) {
            if (!(current.layoutBox.isPending() || current.layoutBox.getElement() != null && current.layoutBox.getElement() == c.getLayer().getMaster().getElement())) {
                throw new RuntimeException("internal error");
            }
            if (!current.layoutBox.isPending()) {
                c.getLayer().setEnd(current.layoutBox);
                c.popLayer();
                pendingInlineLayers.add(current.layoutBox.getContainingLayer());
            }
        }
        previous.layoutBox = current.layoutBox;
        current.layoutBox = current.layoutBox.getParent() instanceof LineBox ? null : (InlineLayoutBox)current.layoutBox.getParent();
    }

    private static void startNewInlineLine(LayoutContext c, BlockBox box, int breakAtLine, byte blockLayoutDirection, SpaceVariables space, StateVariables current, StateVariables previous, int contentStart, List<InlineBox> openInlineBoxes, Map<InlineBox, InlineLayoutBox> iBMap, int minimumLineHeight, MarkerData markerData, List<FloatLayoutResult> pendingFloats, boolean hasFirstLinePEs, List<Layer> pendingInlineLayers, int lineOffset, InlineBox inlineBox, LineBreakContext lbContext) {
        IdentValue align = inlineBox.getStyle().getIdent(CSSName.TEXT_ALIGN);
        if (align != IdentValue.LEFT && (align != IdentValue.START || inlineBox.getTextDirection() != 0)) {
            current.line.trimTrailingSpace(c);
        }
        current.line.setEndsOnNL(lbContext.isEndsOnNL());
        InlineBoxing.saveLine(current.line, c, box, minimumLineHeight, space.maxAvailableWidth, pendingFloats, hasFirstLinePEs, pendingInlineLayers, markerData, contentStart, InlineBoxing.isAlwaysBreak(c, box, breakAtLine, lineOffset));
        if (current.line.isFirstLine() && hasFirstLinePEs) {
            lbContext.setMaster(TextUtil.transformText(inlineBox.getText(), inlineBox.getStyle()));
        }
        previous.line = current.line;
        current.line = InlineBoxing.newLine(c, previous.line, (Box)box);
        current.line.setDirectionality(blockLayoutDirection);
        current.layoutBox = InlineBoxing.addOpenInlineBoxes(c, current.line, openInlineBoxes, space.maxAvailableWidth, iBMap);
        previous.layoutBox = current.layoutBox.getParent() instanceof LineBox ? null : (InlineLayoutBox)current.layoutBox.getParent();
        space.remainingWidth = space.maxAvailableWidth;
        space.remainingWidth -= c.getBlockFormattingContext().getFloatDistance(c, current.line, space.remainingWidth);
    }

    private static StartInlineTextResult startInlineText(LayoutContext c, LineBreakContext lbContext, InlineBox inlineBox, SpaceVariables space, StateVariables current, int fit, boolean trimmedLeadingSpace, boolean tryToBreakAnywhere) {
        int delta;
        lbContext.saveEnd();
        CalculatedStyle style = inlineBox.getStyle();
        InlineText inlineText = InlineBoxing.layoutText(c, style, space.remainingWidth - fit, lbContext, false, inlineBox.getTextDirection(), tryToBreakAnywhere, space.maxAvailableWidth - fit);
        if (style.hasLetterSpacing()) {
            inlineText.setLetterSpacing(style.getFloatPropertyProportionalWidth(CSSName.LETTER_SPACING, 0.0f, c));
        }
        if (lbContext.isUnbreakable() && !current.line.isContainsContent() && (delta = c.getBlockFormattingContext().getNextLineBoxDelta(c, current.line, space.maxAvailableWidth)) > 0) {
            current.line.setY(current.line.getY() + delta);
            current.line.calcCanvasLocation();
            space.remainingWidth = space.maxAvailableWidth;
            space.remainingWidth -= c.getBlockFormattingContext().getFloatDistance(c, current.line, space.maxAvailableWidth);
            lbContext.resetEnd();
            return StartInlineTextResult.RECONSUME_BELOW_FLOATS;
        }
        if (!lbContext.isUnbreakable() || lbContext.isUnbreakable() && !current.line.isContainsContent()) {
            if (inlineBox.isDynamicFunction()) {
                inlineText.setFunctionData(new FunctionData(inlineBox.getContentFunction(), inlineBox.getFunction()));
            }
            inlineText.setTrimmedLeadingSpace(trimmedLeadingSpace);
            current.line.setContainsDynamicFunction(inlineText.isDynamicFunction());
            current.layoutBox.addInlineChild(c, inlineText);
            current.line.setContainsContent(true);
            lbContext.setStart(lbContext.getEnd());
            space.remainingWidth -= inlineText.getWidth();
            if (current.layoutBox.isStartsHere()) {
                int marginBorderPadding = current.layoutBox.getStyle().getMarginBorderPadding(c, space.maxAvailableWidth, 1);
                space.pendingLeftMBP -= marginBorderPadding;
                space.remainingWidth -= marginBorderPadding;
            }
            return StartInlineTextResult.LINE_FINISHED;
        }
        lbContext.resetEnd();
        return StartInlineTextResult.RECONSUME_UNBREAKABLE_ON_NEW_LINE;
    }

    private static void startFirstLetterInlineLayoutBox(LayoutContext c, SpaceVariables space, StateVariables current, InlineBox inlineBox, LineBreakContext lbContext) {
        InlineLayoutBox firstLetter = InlineBoxing.addFirstLetterBox(c, current.line, current.layoutBox, lbContext, space.maxAvailableWidth, space.remainingWidth, inlineBox.getTextDirection());
        space.remainingWidth -= firstLetter.getInlineWidth();
        if (current.layoutBox.isStartsHere()) {
            space.pendingLeftMBP -= current.layoutBox.getStyle().getMarginBorderPadding(c, space.maxAvailableWidth, 1);
        }
    }

    private static void startInlineBox(LayoutContext c, SpaceVariables space, StateVariables current, StateVariables previous, List<InlineBox> openInlineBoxes, Map<InlineBox, InlineLayoutBox> iBMap, InlineBox inlineBox, CalculatedStyle style) {
        previous.layoutBox = current.layoutBox;
        current.layoutBox = new InlineLayoutBox(c, inlineBox.getElement(), style, space.maxAvailableWidth);
        openInlineBoxes.add(inlineBox);
        iBMap.put(inlineBox, current.layoutBox);
        if (previous.layoutBox == null) {
            current.line.addChildForLayout(c, current.layoutBox);
        } else {
            previous.layoutBox.addInlineChild(c, current.layoutBox);
        }
        InlineBoxing.addBoxId(c, current);
        space.pendingLeftMBP += style.getMarginBorderPadding(c, space.maxAvailableWidth, 1);
        space.pendingRightMBP += style.getMarginBorderPadding(c, space.maxAvailableWidth, 2);
    }

    private static void addBoxId(LayoutContext c, StateVariables current) {
        if (current.layoutBox.getElement() != null) {
            String id;
            String name = c.getNamespaceHandler().getAnchorName(current.layoutBox.getElement());
            if (name != null) {
                c.addBoxId(name, current.layoutBox);
            }
            if ((id = c.getNamespaceHandler().getID(current.layoutBox.getElement())) != null) {
                c.addBoxId(id, current.layoutBox);
            }
        }
    }

    private static boolean isAlwaysBreak(LayoutContext c, BlockBox parent, int breakAtLine, int lineOffset) {
        if (parent.isCurrentBreakAtLineContext(c)) {
            return lineOffset == breakAtLine;
        }
        return breakAtLine > 0 && lineOffset == breakAtLine;
    }

    private static InlineLayoutBox addFirstLetterBox(LayoutContext c, LineBox current, InlineLayoutBox currentIB, LineBreakContext lbContext, int maxAvailableWidth, int remainingWidth, byte textDirection) {
        CalculatedStyle previous = currentIB.getStyle();
        currentIB.setStyle(c.getFirstLettersTracker().deriveAll(currentIB.getStyle()));
        InlineLayoutBox iB = new InlineLayoutBox(c, null, currentIB.getStyle(), maxAvailableWidth);
        iB.setStartsHere(true);
        iB.setEndsHere(true);
        currentIB.addInlineChild(c, iB);
        current.setContainsContent(true);
        InlineText text = InlineBoxing.layoutText(c, iB.getStyle(), remainingWidth, lbContext, true, textDirection, true, maxAvailableWidth);
        if (iB.getStyle().hasLetterSpacing()) {
            text.setLetterSpacing(iB.getStyle().getFloatPropertyProportionalWidth(CSSName.LETTER_SPACING, 0.0f, c));
        }
        iB.addInlineChild(c, text);
        iB.setInlineWidth(text.getWidth());
        lbContext.setStart(lbContext.getEnd());
        c.getFirstLettersTracker().clearStyles();
        currentIB.setStyle(previous);
        return iB;
    }

    private static void layoutInlineBlockContent(LayoutContext c, BlockBox containingBlock, BlockBox inlineBlock, int initialY) {
        inlineBlock.setContainingBlock(containingBlock);
        inlineBlock.setContainingLayer(c.getLayer());
        inlineBlock.initStaticPos(c, containingBlock, initialY);
        inlineBlock.calcCanvasLocation();
        inlineBlock.layout(c);
    }

    public static int positionHorizontallyRTL(CssContext c, Box current, int start, int width) {
        int x = start;
        InlineLayoutBox currentIB = null;
        if (current instanceof InlineLayoutBox) {
            currentIB = (InlineLayoutBox)current;
            x -= currentIB.getRightMarginPaddingBorder(c);
        }
        for (int i = 0; i < current.getChildCount(); ++i) {
            Box b = current.getChild(i);
            if (b instanceof InlineLayoutBox) {
                InlineLayoutBox iB = (InlineLayoutBox)b;
                int w = InlineBoxing.positionHorizontallyILBRTL(c, iB, x, width);
                InlineBoxing.positionHorizontallyILBRTL(c, iB, x, w);
                iB.setX(x -= w);
                continue;
            }
            b.setX(x -= b.getWidth());
        }
        if (currentIB != null) {
            currentIB.setInlineWidth(start - (x -= currentIB.getLeftMarginBorderPadding(c)));
        }
        return start - x;
    }

    private static int positionHorizontallyILBRTL(CssContext c, InlineLayoutBox current, int start, int width) {
        int xAbs = start;
        int xRel = width;
        int w = current.getRightMarginPaddingBorder(c);
        xAbs -= w;
        xRel -= w;
        for (int i = 0; i < current.getInlineChildCount(); ++i) {
            Object child = current.getInlineChild(i);
            if (child instanceof InlineLayoutBox) {
                InlineLayoutBox iB = (InlineLayoutBox)child;
                w = InlineBoxing.positionHorizontallyILBRTL(c, iB, xAbs, width);
                w = InlineBoxing.positionHorizontallyILBRTL(c, iB, xAbs, w);
                iB.setX(xAbs - w);
                xAbs -= w;
                xRel -= w;
                continue;
            }
            if (child instanceof InlineText) {
                InlineText iT = (InlineText)child;
                xAbs -= iT.getWidth();
                iT.setX(xRel -= iT.getWidth());
                continue;
            }
            if (!(child instanceof Box)) continue;
            Box b = (Box)child;
            xRel -= b.getWidth();
            b.setX(xAbs -= b.getWidth());
        }
        w = current.getLeftMarginBorderPadding(c);
        xRel -= w;
        current.setInlineWidth(start - (xAbs -= w));
        return start - xAbs;
    }

    public static int positionHorizontally(CssContext c, Box current, int start) {
        int x = start;
        InlineLayoutBox currentIB = null;
        if (current instanceof InlineLayoutBox) {
            currentIB = (InlineLayoutBox)current;
            x += currentIB.getLeftMarginBorderPadding(c);
        }
        for (int i = 0; i < current.getChildCount(); ++i) {
            Box b = current.getChild(i);
            if (b instanceof InlineLayoutBox) {
                InlineLayoutBox iB = (InlineLayoutBox)current.getChild(i);
                iB.setX(x);
                x += InlineBoxing.positionHorizontally(c, iB, x);
                continue;
            }
            b.setX(x);
            x += b.getWidth();
        }
        if (currentIB != null) {
            currentIB.setInlineWidth((x += currentIB.getRightMarginPaddingBorder(c)) - start);
        }
        return x - start;
    }

    private static int positionHorizontally(CssContext c, InlineLayoutBox current, int start) {
        int x = start;
        x += current.getLeftMarginBorderPadding(c);
        for (int i = 0; i < current.getInlineChildCount(); ++i) {
            Object child = current.getInlineChild(i);
            if (child instanceof InlineLayoutBox) {
                InlineLayoutBox iB = (InlineLayoutBox)child;
                iB.setX(x);
                x += InlineBoxing.positionHorizontally(c, iB, x);
                continue;
            }
            if (child instanceof InlineText) {
                InlineText iT = (InlineText)child;
                iT.setX(x - start);
                x += iT.getWidth();
                continue;
            }
            if (!(child instanceof Box)) continue;
            Box b = (Box)child;
            b.setX(x);
            x += b.getWidth();
        }
        current.setInlineWidth((x += current.getRightMarginPaddingBorder(c)) - start);
        return x - start;
    }

    public static StrutMetrics createDefaultStrutMetrics(LayoutContext c, Box container) {
        FSFontMetrics strutM = container.getStyle().getFSFontMetrics(c);
        InlineBoxMeasurements measurements = InlineBoxing.getInitialMeasurements(c, container, strutM);
        return new StrutMetrics(strutM.getAscent(), measurements.getBaseline(), strutM.getDescent());
    }

    private static void positionVertically(LayoutContext c, Box container, LineBox current, MarkerData markerData) {
        if (current.getChildCount() == 0 || !current.isContainsVisibleContent()) {
            current.setHeight(0);
        } else {
            FSFontMetrics strutM = container.getStyle().getFSFontMetrics(c);
            VerticalAlignContext vaContext = new VerticalAlignContext();
            InlineBoxMeasurements measurements = InlineBoxing.getInitialMeasurements(c, container, strutM);
            vaContext.setInitialMeasurements(measurements);
            List<TextDecoration> lBDecorations = InlineBoxing.calculateTextDecorations(container, measurements.getBaseline(), strutM);
            if (lBDecorations != null) {
                current.setTextDecorations(lBDecorations);
            }
            for (int i = 0; i < current.getChildCount(); ++i) {
                Box child = current.getChild(i);
                InlineBoxing.positionInlineContentVertically(c, vaContext, child);
            }
            vaContext.alignChildren();
            current.setHeight(vaContext.getLineBoxHeight());
            int paintingTop = vaContext.getPaintingTop();
            int paintingBottom = vaContext.getPaintingBottom();
            if (vaContext.getInlineTop() < 0) {
                InlineBoxing.moveLineContents(current, -vaContext.getInlineTop());
                if (lBDecorations != null) {
                    for (TextDecoration lBDecoration : lBDecorations) {
                        lBDecoration.setOffset(lBDecoration.getOffset() - vaContext.getInlineTop());
                    }
                }
                paintingTop -= vaContext.getInlineTop();
                paintingBottom -= vaContext.getInlineTop();
            }
            if (markerData != null) {
                StrutMetrics strutMetrics = markerData.getStructMetrics();
                strutMetrics.setBaseline(measurements.getBaseline() - vaContext.getInlineTop());
                markerData.setReferenceLine(current);
                current.setMarkerData(markerData);
            }
            current.setBaseline(measurements.getBaseline() - vaContext.getInlineTop());
            current.setPaintingTop(paintingTop);
            current.setPaintingHeight(paintingBottom - paintingTop);
        }
    }

    private static void positionInlineVertically(LayoutContext c, VerticalAlignContext vaContext, InlineLayoutBox iB) {
        InlineBoxMeasurements iBMeasurements = InlineBoxing.calculateInlineMeasurements(c, iB, vaContext);
        vaContext.pushMeasurements(iBMeasurements);
        InlineBoxing.positionInlineChildrenVertically(c, iB, vaContext);
        vaContext.popMeasurements();
    }

    private static void positionInlineBlockVertically(LayoutContext c, VerticalAlignContext vaContext, BlockBox inlineBlock) {
        int baseline;
        int ascent = baseline = inlineBlock.calcInlineBaseline(c);
        int descent = inlineBlock.getHeight() - baseline;
        InlineBoxing.alignInlineContent(c, inlineBlock, ascent, descent, vaContext);
        vaContext.updateInlineTop(inlineBlock.getY());
        vaContext.updatePaintingTop(inlineBlock.getY());
        vaContext.updateInlineBottom(inlineBlock.getY() + inlineBlock.getHeight());
        vaContext.updatePaintingBottom(inlineBlock.getY() + inlineBlock.getHeight());
    }

    private static void moveLineContents(LineBox current, int ty) {
        for (int i = 0; i < current.getChildCount(); ++i) {
            Box child = current.getChild(i);
            child.setY(child.getY() + ty);
            if (!(child instanceof InlineLayoutBox)) continue;
            InlineBoxing.moveInlineContents((InlineLayoutBox)child, ty);
        }
    }

    private static void moveInlineContents(InlineLayoutBox box, int ty) {
        for (int i = 0; i < box.getInlineChildCount(); ++i) {
            Object obj = box.getInlineChild(i);
            if (!(obj instanceof Box)) continue;
            ((Box)obj).setY(((Box)obj).getY() + ty);
            if (!(obj instanceof InlineLayoutBox)) continue;
            InlineBoxing.moveInlineContents((InlineLayoutBox)obj, ty);
        }
    }

    private static InlineBoxMeasurements calculateInlineMeasurements(LayoutContext c, InlineLayoutBox iB, VerticalAlignContext vaContext) {
        FSFontMetrics fm = iB.getStyle().getFSFontMetrics(c);
        CalculatedStyle style = iB.getStyle();
        float lineHeight = style.getLineHeight(c);
        int halfLeading = Math.round((lineHeight - iB.getStyle().getFont((CssContext)c).size) / 2.0f);
        if (halfLeading > 0) {
            halfLeading = Math.round((lineHeight - (fm.getDescent() + fm.getAscent())) / 2.0f);
        }
        iB.setBaseline(Math.round(fm.getAscent()));
        InlineBoxing.alignInlineContent(c, iB, fm.getAscent(), fm.getDescent(), vaContext);
        List<TextDecoration> decorations = InlineBoxing.calculateTextDecorations(iB, iB.getBaseline(), fm);
        if (decorations != null) {
            iB.setTextDecorations(decorations);
        }
        InlineBoxMeasurements result = new InlineBoxMeasurements();
        result.setBaseline(iB.getY() + iB.getBaseline());
        result.setInlineTop(iB.getY() - halfLeading);
        result.setInlineBottom(Math.round((float)result.getInlineTop() + lineHeight));
        result.setTextTop(iB.getY());
        result.setTextBottom((int)((float)result.getBaseline() + fm.getDescent()));
        RectPropertySet padding = iB.getPadding(c);
        BorderPropertySet border = iB.getBorder(c);
        result.setPaintingTop((int)Math.floor((float)iB.getY() - border.top() - padding.top()));
        result.setPaintingBottom((int)Math.ceil((float)iB.getY() + fm.getAscent() + fm.getDescent() + border.bottom() + padding.bottom()));
        return result;
    }

    public static List<TextDecoration> calculateTextDecorations(Box box, int baseline, FSFontMetrics fm) {
        ArrayList<TextDecoration> result = null;
        CalculatedStyle style = box.getStyle();
        List<IdentValue> idents = style.getTextDecorations();
        if (idents != null) {
            TextDecoration decoration;
            result = new ArrayList<TextDecoration>(idents.size());
            if (idents.contains(IdentValue.UNDERLINE)) {
                decoration = new TextDecoration(IdentValue.UNDERLINE);
                if (fm.getUnderlineOffset() == 0.0f) {
                    decoration.setOffset(Math.round((float)baseline + fm.getUnderlineThickness()));
                } else {
                    decoration.setOffset(Math.round((float)baseline + fm.getUnderlineOffset()));
                }
                decoration.setThickness(Math.round(fm.getUnderlineThickness()));
                if (fm.getUnderlineOffset() == 0.0f) {
                    int maxOffset = baseline + (int)fm.getDescent() - decoration.getThickness();
                    if (decoration.getOffset() > maxOffset) {
                        decoration.setOffset(maxOffset);
                    }
                }
                result.add(decoration);
            }
            if (idents.contains(IdentValue.LINE_THROUGH)) {
                decoration = new TextDecoration(IdentValue.LINE_THROUGH);
                decoration.setOffset(Math.round((float)baseline + fm.getStrikethroughOffset()));
                decoration.setThickness(Math.round(fm.getStrikethroughThickness()));
                result.add(decoration);
            }
            if (idents.contains(IdentValue.OVERLINE)) {
                decoration = new TextDecoration(IdentValue.OVERLINE);
                decoration.setOffset(0);
                decoration.setThickness(Math.round(fm.getUnderlineThickness()));
                result.add(decoration);
            }
        }
        return result;
    }

    private static void alignInlineContent(LayoutContext c, Box box, float ascent, float descent, VerticalAlignContext vaContext) {
        InlineBoxMeasurements measurements = vaContext.getParentMeasurements();
        CalculatedStyle style = box.getStyle();
        if (style.isLength(CSSName.VERTICAL_ALIGN)) {
            box.setY((int)((float)measurements.getBaseline() - ascent - style.getFloatPropertyProportionalTo(CSSName.VERTICAL_ALIGN, style.getLineHeight(c), c)));
        } else {
            IdentValue vAlign = style.getIdent(CSSName.VERTICAL_ALIGN);
            if (vAlign == IdentValue.BASELINE) {
                box.setY(Math.round((float)measurements.getBaseline() - ascent));
            } else if (vAlign == IdentValue.TEXT_TOP) {
                box.setY(measurements.getTextTop());
            } else if (vAlign == IdentValue.TEXT_BOTTOM) {
                box.setY(Math.round((float)measurements.getTextBottom() - descent - ascent));
            } else if (vAlign == IdentValue.MIDDLE) {
                box.setY(Math.round((float)((measurements.getBaseline() - measurements.getTextTop()) / 2) - (ascent + descent) / 2.0f));
            } else if (vAlign == IdentValue.SUPER) {
                box.setY(Math.round((float)measurements.getBaseline() - 3.0f * ascent / 2.0f));
            } else if (vAlign == IdentValue.SUB) {
                box.setY(Math.round((float)measurements.getBaseline() - ascent / 2.0f));
            } else {
                box.setY(Math.round((float)measurements.getBaseline() - ascent));
            }
        }
    }

    private static InlineBoxMeasurements getInitialMeasurements(LayoutContext c, Box container, FSFontMetrics strutM) {
        float lineHeight = container.getStyle().getLineHeight(c);
        int halfLeading = Math.round((lineHeight - container.getStyle().getFont((CssContext)c).size) / 2.0f);
        if (halfLeading > 0) {
            halfLeading = Math.round((lineHeight - (strutM.getDescent() + strutM.getAscent())) / 2.0f);
        }
        InlineBoxMeasurements measurements = new InlineBoxMeasurements();
        measurements.setBaseline((int)((float)halfLeading + strutM.getAscent()));
        measurements.setTextTop(halfLeading);
        measurements.setTextBottom((int)((float)measurements.getBaseline() + strutM.getDescent()));
        measurements.setInlineTop(halfLeading);
        measurements.setInlineBottom((int)((float)halfLeading + lineHeight));
        return measurements;
    }

    private static void positionInlineChildrenVertically(LayoutContext c, InlineLayoutBox current, VerticalAlignContext vaContext) {
        for (int i = 0; i < current.getInlineChildCount(); ++i) {
            Object child = current.getInlineChild(i);
            if (!(child instanceof Box)) continue;
            InlineBoxing.positionInlineContentVertically(c, vaContext, (Box)child);
        }
    }

    private static void positionInlineContentVertically(LayoutContext c, VerticalAlignContext vaContext, Box child) {
        IdentValue vAlign;
        VerticalAlignContext vaTarget = vaContext;
        if (!(child.getStyle().isLength(CSSName.VERTICAL_ALIGN) || (vAlign = child.getStyle().getIdent(CSSName.VERTICAL_ALIGN)) != IdentValue.TOP && vAlign != IdentValue.BOTTOM)) {
            vaTarget = vaContext.createChild(child);
        }
        if (child instanceof InlineLayoutBox) {
            InlineLayoutBox iB = (InlineLayoutBox)child;
            InlineBoxing.positionInlineVertically(c, vaTarget, iB);
        } else {
            InlineBoxing.positionInlineBlockVertically(c, vaTarget, (BlockBox)child);
        }
    }

    private static void saveLine(LineBox current, LayoutContext c, BlockBox block, int minHeight, int maxAvailableWidth, List<FloatLayoutResult> pendingFloats, boolean hasFirstLinePCs, List<Layer> pendingInlineLayers, MarkerData markerData, int contentStart, boolean alwaysBreak) {
        int totalLineWidth;
        current.setContentStart(contentStart);
        current.prunePendingInlineBoxes();
        if (current.isLayedOutRTL()) {
            totalLineWidth = InlineBoxing.positionHorizontallyRTL(c, current, 0, 0);
            InlineBoxing.positionHorizontallyRTL(c, current, totalLineWidth, totalLineWidth);
        } else {
            totalLineWidth = InlineBoxing.positionHorizontally((CssContext)c, current, 0);
        }
        current.setContentWidth(totalLineWidth);
        InlineBoxing.positionVertically(c, block, current, markerData);
        if (current.getHeight() != 0 && current.getHeight() < minHeight && !current.isContainsOnlyBlockLevelContent()) {
            current.setHeight(minHeight);
        }
        if (c.isPrint()) {
            current.checkPagePosition(c, alwaysBreak);
        }
        InlineBoxing.alignLine(c, current, maxAvailableWidth);
        current.calcChildLocations();
        block.addChildForLayout(c, current);
        if (pendingInlineLayers.size() > 0) {
            InlineBoxing.finishPendingInlineLayers(c, pendingInlineLayers);
            pendingInlineLayers.clear();
        }
        if (hasFirstLinePCs && current.isFirstLine()) {
            c.getFirstLinesTracker().clearStyles();
            block.styleText(c);
        }
        if (pendingFloats.size() > 0) {
            for (FloatLayoutResult layoutResult : pendingFloats) {
                LayoutUtil.layoutFloated(c, current, layoutResult.getBlock(), maxAvailableWidth, null);
                current.addNonFlowContent(layoutResult.getBlock());
            }
            pendingFloats.clear();
        }
    }

    private static void alignLine(final LayoutContext c, final LineBox current, final int maxAvailableWidth) {
        if (!current.isContainsDynamicFunction() && !current.getParent().getStyle().isTextJustify()) {
            current.setFloatDistances(new FloatDistances(){

                @Override
                public int getLeftFloatDistance() {
                    return c.getBlockFormattingContext().getLeftFloatDistance(c, current, maxAvailableWidth);
                }

                @Override
                public int getRightFloatDistance() {
                    return c.getBlockFormattingContext().getRightFloatDistance(c, current, maxAvailableWidth);
                }
            });
        } else {
            FloatDistances distances = new FloatDistances();
            distances.setLeftFloatDistance(c.getBlockFormattingContext().getLeftFloatDistance(c, current, maxAvailableWidth));
            distances.setRightFloatDistance(c.getBlockFormattingContext().getRightFloatDistance(c, current, maxAvailableWidth));
            current.setFloatDistances(distances);
        }
        current.align(false, c);
        if (!current.isContainsDynamicFunction() && !current.getParent().getStyle().isTextJustify()) {
            current.setFloatDistances(null);
        }
    }

    private static void finishPendingInlineLayers(LayoutContext c, List<Layer> layers) {
        for (Layer l : layers) {
            l.positionChildren(c);
        }
    }

    private static InlineText layoutText(LayoutContext c, CalculatedStyle style, int remainingWidth, LineBreakContext lbContext, boolean needFirstLetter, byte textDirection, boolean tryToBreakAnywhere, int lineWidth) {
        InlineText result = new InlineText();
        String masterText = lbContext.getMaster();
        if (needFirstLetter) {
            masterText = TextUtil.transformFirstLetterText(masterText, style);
            lbContext.setMaster(masterText);
            Breaker.breakFirstLetter(c, lbContext, remainingWidth, style);
        } else {
            Breaker.breakText(c, lbContext, remainingWidth, style, tryToBreakAnywhere, lineWidth);
        }
        result.setMasterText(masterText);
        result.setSubstring(lbContext.getStart(), lbContext.getEnd());
        result.setWidth(lbContext.getWidth());
        result.setTextDirection(textDirection);
        result.setEndsOnSoftHyphen(lbContext.isEndsOnSoftHyphen());
        return result;
    }

    private static int processOutOfFlowContent(LayoutContext c, LineBox current, BlockBox block, int available, List<FloatLayoutResult> pendingFloats) {
        int result = 0;
        CalculatedStyle style = block.getStyle();
        if (style.isAbsolute() || style.isFixed()) {
            LayoutUtil.layoutAbsolute(c, current, block);
            current.addNonFlowContent(block);
        } else if (style.isFloated()) {
            FloatLayoutResult layoutResult = LayoutUtil.layoutFloated(c, current, block, available, pendingFloats);
            if (layoutResult.isPending()) {
                pendingFloats.add(layoutResult);
            } else {
                result = layoutResult.getBlock().getWidth();
                current.addNonFlowContent(layoutResult.getBlock());
            }
        } else if (style.isRunning()) {
            block.setStaticEquivalent(current);
            c.getRootLayer().addRunningBlock(block);
        }
        return result;
    }

    private static boolean hasTrimmableLeadingSpace(LineBox line, CalculatedStyle style, LineBreakContext lbContext, boolean zeroWidthInlineBlock) {
        IdentValue whitespace;
        return (!line.isContainsContent() || zeroWidthInlineBlock) && lbContext.getStartSubstring().startsWith(" ") && ((whitespace = style.getWhitespace()) == IdentValue.NORMAL || whitespace == IdentValue.NOWRAP || whitespace == IdentValue.PRE_LINE || whitespace == IdentValue.PRE_WRAP && lbContext.getStart() > 0 && lbContext.getMaster().length() > lbContext.getStart() - 1 && lbContext.getMaster().charAt(lbContext.getStart() - 1) != '\n');
    }

    private static void trimLeadingSpace(LineBreakContext lbContext) {
        int i;
        String s = lbContext.getStartSubstring();
        for (i = 0; i < s.length() && s.charAt(i) == ' '; ++i) {
        }
        lbContext.setStart(lbContext.getStart() + i);
    }

    private static LineBox newLine(LayoutContext c, LineBox previousLine, Box box) {
        int y = 0;
        if (previousLine != null) {
            y = previousLine.getY() + previousLine.getHeight();
        }
        return InlineBoxing.newLine(c, y, box);
    }

    private static LineBox newLine(LayoutContext c, int y, Box box) {
        LineBox result = new LineBox();
        result.setStyle(box.getStyle().createAnonymousStyle(IdentValue.BLOCK));
        result.setParent(box);
        result.initContainingLayer(c);
        result.setY(y);
        result.calcCanvasLocation();
        return result;
    }

    private static InlineLayoutBox addOpenInlineBoxes(LayoutContext c, LineBox line, List<InlineBox> openParents, int cbWidth, Map<InlineBox, InlineLayoutBox> iBMap) {
        InlineLayoutBox currentIB = null;
        InlineLayoutBox previousIB = null;
        boolean first = true;
        for (InlineBox iB : openParents) {
            currentIB = new InlineLayoutBox(c, iB.getElement(), iB.getStyle(), cbWidth);
            InlineLayoutBox prev = iBMap.get(iB);
            if (prev != null) {
                currentIB.setPending(prev.isPending());
            }
            iBMap.put(iB, currentIB);
            if (first) {
                line.addChildForLayout(c, currentIB);
                first = false;
            } else {
                previousIB.addInlineChild(c, currentIB, false);
            }
            previousIB = currentIB;
        }
        return currentIB;
    }

    static class SpaceVariables {
        final int maxAvailableWidth;
        int remainingWidth;
        int pendingLeftMBP;
        int pendingRightMBP;

        SpaceVariables(int maxWidth) {
            this.remainingWidth = maxWidth;
            this.maxAvailableWidth = maxWidth;
        }
    }

    static class StateVariables {
        LineBox line;
        InlineLayoutBox layoutBox;

        StateVariables() {
        }
    }

    private static enum StartInlineTextResult {
        RECONSUME_BELOW_FLOATS,
        RECONSUME_UNBREAKABLE_ON_NEW_LINE,
        LINE_FINISHED;

    }
}

