/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.SimpleBidiReorderer;
import com.openhtmltopdf.context.StyleReference;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.value.FontSpecification;
import com.openhtmltopdf.extend.FSCanvas;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.render.FSFontMetrics;
import com.openhtmltopdf.render.PageBox;
import java.awt.Rectangle;

public class RenderingContext
implements CssContext {
    protected SharedContext sharedContext;
    private OutputDevice outputDevice;
    private FontContext fontContext;
    private int pageCount;
    private int pageNo;
    private PageBox page;
    private Layer rootLayer;
    private int initialPageNo;
    private BidiReorderer _bidi = new SimpleBidiReorderer();

    public RenderingContext(SharedContext sharedContext) {
        this.sharedContext = sharedContext;
    }

    public void setContext(SharedContext sharedContext) {
        this.sharedContext = sharedContext;
    }

    public void setBaseURL(String url) {
        this.sharedContext.setBaseURL(url);
    }

    public UserAgentCallback getUac() {
        return this.sharedContext.getUac();
    }

    public String getBaseURL() {
        return this.sharedContext.getBaseURL();
    }

    public float getDPI() {
        return this.sharedContext.getDPI();
    }

    @Override
    public float getMmPerDot() {
        return this.sharedContext.getMmPerPx();
    }

    @Override
    public int getDotsPerPixel() {
        return this.sharedContext.getDotsPerPixel();
    }

    @Override
    public float getFontSize2D(FontSpecification font) {
        return this.sharedContext.getFont(font).getSize2D();
    }

    @Override
    public float getXHeight(FontSpecification parentFont) {
        return this.sharedContext.getXHeight(this.getFontContext(), parentFont);
    }

    public TextRenderer getTextRenderer() {
        return this.sharedContext.getTextRenderer();
    }

    public void setBidiReorderer(BidiReorderer bidi) {
        this._bidi = bidi;
    }

    public BidiReorderer getBidiReorderer() {
        return this._bidi;
    }

    public boolean isPaged() {
        return this.sharedContext.isPaged();
    }

    public FontResolver getFontResolver() {
        return this.sharedContext.getFontResolver();
    }

    @Override
    public FSFont getFont(FontSpecification font) {
        return this.sharedContext.getFont(font);
    }

    public FSCanvas getCanvas() {
        return this.sharedContext.getCanvas();
    }

    public Rectangle getFixedRectangle() {
        Rectangle result = !this.isPrint() ? this.sharedContext.getFixedRectangle() : new Rectangle(0, -this.page.getTop(), this.page.getContentWidth(this), this.page.getContentHeight(this) - 1);
        result.translate(-1, -1);
        return result;
    }

    public Rectangle getViewportRectangle() {
        Rectangle result = new Rectangle(this.getFixedRectangle());
        result.y *= -1;
        return result;
    }

    public boolean debugDrawBoxes() {
        return this.sharedContext.debugDrawBoxes();
    }

    public boolean debugDrawLineBoxes() {
        return this.sharedContext.debugDrawLineBoxes();
    }

    public boolean debugDrawInlineBoxes() {
        return this.sharedContext.debugDrawInlineBoxes();
    }

    public boolean debugDrawFontMetrics() {
        return this.sharedContext.debugDrawFontMetrics();
    }

    public boolean isInteractive() {
        return this.sharedContext.isInteractive();
    }

    public boolean isPrint() {
        return this.sharedContext.isPrint();
    }

    public OutputDevice getOutputDevice() {
        return this.outputDevice;
    }

    public void setOutputDevice(OutputDevice outputDevice) {
        this.outputDevice = outputDevice;
    }

    public FontContext getFontContext() {
        return this.fontContext;
    }

    public void setFontContext(FontContext fontContext) {
        this.fontContext = fontContext;
    }

    public void setPage(int pageNo, PageBox page) {
        this.pageNo = pageNo;
        this.page = page;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public PageBox getPage() {
        return this.page;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    @Override
    public StyleReference getCss() {
        return this.sharedContext.getCss();
    }

    @Override
    public FSFontMetrics getFSFontMetrics(FSFont font) {
        return this.getTextRenderer().getFSFontMetrics(this.getFontContext(), font, "");
    }

    public Layer getRootLayer() {
        return this.rootLayer;
    }

    public void setRootLayer(Layer rootLayer) {
        this.rootLayer = rootLayer;
    }

    public int getInitialPageNo() {
        return this.initialPageNo;
    }

    public void setInitialPageNo(int initialPageNo) {
        this.initialPageNo = initialPageNo;
    }

    public Box getBoxById(String id) {
        return this.sharedContext.getBoxById(id);
    }
}

