/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.swing;

import com.openhtmltopdf.event.DocumentListener;
import com.openhtmltopdf.extend.FSCache;
import com.openhtmltopdf.extend.FSMultiThreadCache;
import com.openhtmltopdf.extend.FSStream;
import com.openhtmltopdf.extend.FSStreamFactory;
import com.openhtmltopdf.extend.FSUriResolver;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.resource.CSSResource;
import com.openhtmltopdf.resource.ImageResource;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.swing.AWTFSImage;
import com.openhtmltopdf.swing.FSCacheKey;
import com.openhtmltopdf.util.ImageUtil;
import com.openhtmltopdf.util.XRLog;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class NaiveUserAgent
implements UserAgentCallback,
DocumentListener {
    protected final LinkedHashMap<String, ImageResource> _imageCache = new LinkedHashMap();
    protected final FSUriResolver DEFAULT_URI_RESOLVER = new DefaultUriResolver();
    protected FSCache _externalCache = new NullFSCache(false);
    protected FSUriResolver _resolver = this.DEFAULT_URI_RESOLVER;
    protected String _baseUri;
    protected Map<String, FSStreamFactory> _protocolsStreamFactory = new HashMap<String, FSStreamFactory>(2);
    protected FSMultiThreadCache<String> _textCache = new NullCache<String>();
    protected FSMultiThreadCache<byte[]> _byteCache = new NullCache<byte[]>();

    public NaiveUserAgent() {
        DefaultHttpStreamFactory factory = new DefaultHttpStreamFactory();
        this._protocolsStreamFactory.put("http", factory);
        this._protocolsStreamFactory.put("https", factory);
    }

    public void setProtocolsStreamFactory(Map<String, FSStreamFactory> protocolsStreamFactory) {
        this._protocolsStreamFactory = protocolsStreamFactory;
    }

    public void setExternalCache(FSCache cache) {
        this._externalCache = cache;
    }

    public void setUriResolver(FSUriResolver resolver) {
        this._resolver = resolver;
    }

    public FSUriResolver getDefaultUriResolver() {
        return this.DEFAULT_URI_RESOLVER;
    }

    public void clearImageCache() {
        this._imageCache.clear();
    }

    protected FSStreamFactory getProtocolFactory(String protocol) {
        return this._protocolsStreamFactory.get(protocol);
    }

    protected boolean hasProtocolFactory(String protocol) {
        return this._protocolsStreamFactory.containsKey(protocol);
    }

    protected InputStream openStream(String uri) {
        InputStream is = null;
        try {
            URI urlObj = new URI(uri);
            String protocol = urlObj.getScheme();
            if (this.hasProtocolFactory(protocol)) {
                return this.getProtocolFactory(protocol).getUrl(uri).getStream();
            }
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found", e);
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
        }
        catch (URISyntaxException e1) {
            XRLog.exception("bad URL given: " + uri, e1);
        }
        return is;
    }

    protected Reader openReader(String uri) {
        InputStream is = null;
        try {
            URI urlObj = new URI(uri);
            String protocol = urlObj.getScheme();
            if (this.hasProtocolFactory(protocol)) {
                return this.getProtocolFactory(protocol).getUrl(uri).getReader();
            }
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found");
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
        }
        catch (URISyntaxException e1) {
            XRLog.exception("bad URL given: " + uri, e1);
        }
        try {
            return is == null ? null : new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            XRLog.exception("Failed to create stream reader", e);
            return null;
        }
    }

    protected String getCacheText(String uri) {
        String text = this._textCache.get(uri);
        if (text != null) {
            return text;
        }
        byte[] bytes = this._byteCache.get(uri);
        if (bytes != null) {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    protected String readAll(Reader reader) throws IOException {
        int numCharsRead;
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        return buffer.toString();
    }

    protected Reader getCacheReader(String uri) {
        String text = this.getCacheText(uri);
        if (text != null) {
            return new StringReader(text);
        }
        return null;
    }

    protected InputStream getCacheStream(String uri) {
        byte[] bytes = this._byteCache.get(uri);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CSSResource getCSSResource(String uri) {
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (resolved == null) {
            XRLog.load(Level.INFO, "URI resolver rejected loading CSS resource at (" + uri + ")");
            return null;
        }
        Reader reader = this.getCacheReader(resolved);
        if (reader != null) {
            return new CSSResource(reader);
        }
        if (this._textCache instanceof NullCache) return new CSSResource(this.openReader(resolved));
        Reader res = null;
        try {
            res = this.openReader(resolved);
            if (res == null) return null;
            String css = this.readAll(res);
            this._textCache.put(resolved, css);
            CSSResource cSSResource = new CSSResource(new StringReader(css));
            return cSSResource;
        }
        catch (IOException e) {
            XRLog.cssParse(Level.WARNING, "Couldn't load stylesheet at URI " + uri + ": " + e.getMessage(), e);
            return null;
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageResource getImageResource(String uri) {
        System.out.println("Getting image: " + uri);
        if (ImageUtil.isEmbeddedBase64Image(uri)) {
            BufferedImage image = ImageUtil.loadEmbeddedBase64Image(uri);
            return new ImageResource(null, AWTFSImage.createImage(image));
        }
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (resolved == null) {
            XRLog.load(Level.INFO, "URI resolver rejected loading image resource at (" + uri + ")");
            return null;
        }
        ImageResource ir = this._imageCache.get(resolved);
        if (ir != null) {
            return ir;
        }
        AWTFSImage fsImage = (AWTFSImage)this._externalCache.get(new FSCacheKey(resolved, AWTFSImage.class));
        if (fsImage != null) {
            return new ImageResource(resolved, fsImage);
        }
        InputStream is = this.openStream(resolved);
        if (is != null) {
            try {
                BufferedImage img = ImageIO.read(is);
                if (img == null) {
                    throw new IOException("ImageIO.read() returned null");
                }
                AWTFSImage fsImage2 = (AWTFSImage)AWTFSImage.createImage(img);
                this._externalCache.put(new FSCacheKey(resolved, AWTFSImage.class), fsImage2);
                ir = new ImageResource(resolved, fsImage2);
                this._imageCache.put(resolved, ir);
                ImageResource imageResource = ir;
                return imageResource;
            }
            catch (FileNotFoundException e) {
                XRLog.exception("Can't read image file; image at URI '" + resolved + "' not found");
            }
            catch (IOException e) {
                XRLog.exception("Can't read image file; unexpected problem for URI '" + resolved + "'", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return new ImageResource(resolved, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLResource getXMLResource(String uri) {
        XMLResource xmlResource;
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (resolved == null) {
            XRLog.load(Level.INFO, "URI resolver rejected loading XML resource at (" + uri + ")");
            return null;
        }
        XMLResource res = (XMLResource)this._externalCache.get(new FSCacheKey(resolved, XMLResource.class));
        if (res != null) {
            return res;
        }
        Reader inputReader = this.openReader(resolved);
        try {
            xmlResource = XMLResource.load(inputReader);
        }
        finally {
            if (inputReader != null) {
                try {
                    inputReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this._externalCache.put(new FSCacheKey(resolved, XMLResource.class), xmlResource);
        return xmlResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBinaryResource(String uri) {
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (resolved == null) {
            XRLog.load(Level.INFO, "URI resolver rejected loading binary resource at (" + uri + ")");
            return null;
        }
        byte[] bytes = (byte[])this._externalCache.get(new FSCacheKey(resolved, byte[].class));
        if (bytes != null) {
            return bytes;
        }
        InputStream is = this.openStream(resolved);
        if (is == null) {
            return null;
        }
        try {
            int i;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buf = new byte[10240];
            while ((i = is.read(buf)) != -1) {
                result.write(buf, 0, i);
            }
            is.close();
            is = null;
            byte[] bytes2 = result.toByteArray();
            this._externalCache.put(new FSCacheKey(resolved, byte[].class), bytes2);
            byte[] byArray = bytes2;
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean isVisited(String uri) {
        return false;
    }

    @Override
    public void setBaseURL(String uri) {
        this._baseUri = uri;
    }

    @Override
    public String getBaseURL() {
        return this._baseUri;
    }

    @Override
    public void documentStarted() {
        this.clearImageCache();
    }

    @Override
    public void documentLoaded() {
    }

    @Override
    public void onLayoutException(Throwable t) {
    }

    @Override
    public void onRenderException(Throwable t) {
    }

    @Override
    public String resolveURI(String uri) {
        return this._resolver.resolveURI(this.getBaseURL(), uri);
    }

    @Override
    public String resolveUri(String baseUri, String uri) {
        return this._resolver.resolveURI(baseUri, uri);
    }

    public void setExternalTextCache(FSMultiThreadCache<String> textCache) {
        this._textCache = textCache;
    }

    public void setExternalByteCache(FSMultiThreadCache<byte[]> byteCache) {
        this._byteCache = byteCache;
    }

    public static class DefaultUriResolver
    implements FSUriResolver {
        @Override
        public String resolveURI(String baseUri, String uri) {
            if (uri == null || uri.isEmpty()) {
                return null;
            }
            try {
                URI possiblyRelative = new URI(uri);
                if (possiblyRelative.isAbsolute()) {
                    return possiblyRelative.toString();
                }
                if (baseUri == null) {
                    XRLog.load(Level.WARNING, "Couldn't resolve relative URI(" + uri + ") because no base URI was provided.");
                    return null;
                }
                if (baseUri.startsWith("jar")) {
                    URL base = new URL(baseUri);
                    URL absolute = new URL(base, uri);
                    return absolute.toString();
                }
                URI base = new URI(baseUri);
                URI absolute = base.resolve(uri);
                return absolute.toString();
            }
            catch (URISyntaxException e) {
                XRLog.exception("When trying to load uri(" + uri + ") with base URI(" + baseUri + "), one or both were invalid URIs.", e);
                return null;
            }
            catch (MalformedURLException e) {
                XRLog.exception("When trying to load uri(" + uri + ") with base jar scheme URI(" + baseUri + "), one or both were invalid URIs.", e);
                return null;
            }
        }
    }

    public static class NullFSCache
    implements FSCache {
        private final boolean _log;

        public NullFSCache(boolean log) {
            this._log = log;
        }

        @Override
        public Object get(FSCacheKey cacheKey) {
            if (this._log) {
                XRLog.load(Level.INFO, "Trying to retrieve object from cache: " + cacheKey.toString());
            }
            return null;
        }

        @Override
        public void put(FSCacheKey cacheKey, Object obj) {
            if (this._log) {
                XRLog.load(Level.INFO, "Trying to put object in cache: " + cacheKey.toString());
            }
        }
    }

    public static class DefaultHttpStreamFactory
    implements FSStreamFactory {
        @Override
        public FSStream getUrl(String uri) {
            InputStream is = null;
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found");
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
            return new DefaultHttpStream(is);
        }
    }

    public static class DefaultHttpStream
    implements FSStream {
        private InputStream strm;

        public DefaultHttpStream(InputStream strm) {
            this.strm = strm;
        }

        @Override
        public InputStream getStream() {
            return this.strm;
        }

        @Override
        public Reader getReader() {
            if (this.strm != null) {
                try {
                    return new InputStreamReader(this.strm, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    XRLog.exception("Exception when creating stream reader", e);
                }
            }
            return null;
        }
    }

    protected static class NullCache<T>
    implements FSMultiThreadCache<T> {
        protected NullCache() {
        }

        @Override
        public T get(String uri) {
            return null;
        }

        @Override
        public void put(String uri, T value) {
        }
    }
}

