/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.constants.MarginBoxName;
import com.openhtmltopdf.css.constants.PageElementPosition;
import com.openhtmltopdf.css.newmatch.PageInfo;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.EmptyStyle;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.css.style.derived.ListValue;
import com.openhtmltopdf.css.style.derived.RectPropertySet;
import com.openhtmltopdf.layout.BlockFormattingContext;
import com.openhtmltopdf.layout.BoxCollector;
import com.openhtmltopdf.layout.BoxRangeHelper;
import com.openhtmltopdf.layout.BoxRangeLists;
import com.openhtmltopdf.layout.CollapsedBorderSide;
import com.openhtmltopdf.layout.InlinePaintable;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.LayoutState;
import com.openhtmltopdf.layout.PaintingInfo;
import com.openhtmltopdf.newtable.CollapsedBorderValue;
import com.openhtmltopdf.newtable.TableBox;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.BoxDimensions;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.ViewportBox;
import com.openhtmltopdf.render.displaylist.TransformCreator;
import com.openhtmltopdf.util.XRLog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class Layer {
    public static final short PAGED_MODE_SCREEN = 1;
    public static final short PAGED_MODE_PRINT = 2;
    private Layer _parent;
    private boolean _stackingContext;
    private List<Layer> _children;
    private Box _master;
    private Box _end;
    private List<BlockBox> _floats;
    private boolean _fixedBackground;
    private boolean _inline;
    private boolean _requiresLayout;
    private List<PageBox> _pages;
    private PageBox _lastRequestedPage = null;
    private Set<BlockBox> _pageSequences;
    private List<BlockBox> _sortedPageSequences;
    private Map _runningBlocks;
    private Box _selectionStart;
    private Box _selectionEnd;
    private int _selectionStartX;
    private int _selectionStartY;
    private int _selectionEndX;
    private int _selectionEndY;
    private AffineTransform _ctm;
    private final boolean _hasLocalTransform;
    public static final int POSITIVE = 1;
    public static final int ZERO = 2;
    public static final int NEGATIVE = 3;
    public static final int AUTO = 4;

    public Layer(Box master, CssContext c) {
        this(null, master, c);
        this.setStackingContext(true);
    }

    public Layer(Layer parent, Box master, CssContext c) {
        this._parent = parent;
        this._master = master;
        this.setStackingContext(master.getStyle().isPositioned() && !master.getStyle().isAutoZIndex() || !master.getStyle().isIdent(CSSName.TRANSFORM, IdentValue.NONE));
        master.setLayer(this);
        master.setContainingLayer(this);
        this._hasLocalTransform = !master.getStyle().isIdent(CSSName.TRANSFORM, IdentValue.NONE);
    }

    public void propagateCurrentTransformationMatrix(CssContext c) {
        AffineTransform parentCtm = this._parent == null ? null : this._parent._ctm;
        this._ctm = this._hasLocalTransform ? TransformCreator.createDocumentCoordinatesTransform(this.getMaster(), c, parentCtm) : parentCtm;
        for (Layer child : this.getChildren()) {
            child.propagateCurrentTransformationMatrix(c);
        }
    }

    public AffineTransform getCurrentTransformMatrix() {
        return this._ctm;
    }

    public boolean hasLocalTransform() {
        return this._hasLocalTransform;
    }

    public Layer getParent() {
        return this._parent;
    }

    public boolean isStackingContext() {
        return this._stackingContext;
    }

    public void setStackingContext(boolean stackingContext) {
        this._stackingContext = stackingContext;
    }

    public int getZIndex() {
        if (this._master.getStyle().isIdent(CSSName.Z_INDEX, IdentValue.AUTO)) {
            return 0;
        }
        return (int)this._master.getStyle().asFloat(CSSName.Z_INDEX);
    }

    public boolean isZIndexAuto() {
        return this._master.getStyle().isIdent(CSSName.Z_INDEX, IdentValue.AUTO);
    }

    public Box getMaster() {
        return this._master;
    }

    public void addChild(Layer layer) {
        if (this._children == null) {
            this._children = new ArrayList<Layer>();
        }
        this._children.add(layer);
    }

    public static PageBox createPageBox(CssContext c, String pseudoPage) {
        PageBox result = new PageBox();
        String pageName = null;
        if (c instanceof LayoutContext) {
            pageName = ((LayoutContext)c).getPageName();
        }
        PageInfo pageInfo = c.getCss().getPageStyle(pageName, pseudoPage);
        result.setPageInfo(pageInfo);
        CalculatedStyle cs = new EmptyStyle().deriveStyle(pageInfo.getPageStyle());
        result.setStyle(cs);
        result.setOuterPageWidth(result.getWidth(c));
        return result;
    }

    public void removeFloat(BlockBox floater) {
        if (this._floats != null) {
            this._floats.remove(floater);
        }
    }

    private void paintFloats(RenderingContext c) {
        if (this._floats != null) {
            for (int i = this._floats.size() - 1; i >= 0; --i) {
                BlockBox floater = this._floats.get(i);
                this.paintAsLayer(c, floater);
            }
        }
    }

    private void paintLayers(RenderingContext c, List layers) {
        for (int i = 0; i < layers.size(); ++i) {
            Layer layer = (Layer)layers.get(i);
            layer.paint(c);
        }
    }

    public void addFloat(BlockBox floater, BlockFormattingContext bfc) {
        if (this._floats == null) {
            this._floats = new ArrayList<BlockBox>();
        }
        this._floats.add(floater);
        floater.getFloatedBoxData().setDrawingLayer(this);
    }

    public List<Layer> collectLayers(int which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        List<Layer> children = this.getChildren();
        result.addAll(this.getStackingContextLayers(which));
        for (Layer child : children) {
            if (child.isStackingContext()) continue;
            if (which == 4 && child.isZIndexAuto()) {
                result.add(child);
            } else if (which == 3 && child.getZIndex() < 0) {
                result.add(child);
            } else if (which == 1 && child.getZIndex() > 0) {
                result.add(child);
            } else if (which == 2 && !child.isZIndexAuto() && child.getZIndex() == 0) {
                result.add(child);
            }
            result.addAll(child.collectLayers(which));
        }
        return result;
    }

    private List<Layer> getStackingContextLayers(int which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        List<Layer> children = this.getChildren();
        for (Layer target : children) {
            if (!target.isStackingContext()) continue;
            if (!target.isZIndexAuto()) {
                int zIndex = target.getZIndex();
                if (which == 3 && zIndex < 0) {
                    result.add(target);
                    continue;
                }
                if (which == 1 && zIndex > 0) {
                    result.add(target);
                    continue;
                }
                if (which != 2 || zIndex != 0) continue;
                result.add(target);
                continue;
            }
            if (which != 4) continue;
            result.add(target);
        }
        return result;
    }

    public List<Layer> getSortedLayers(int which) {
        List<Layer> result = this.collectLayers(which);
        Collections.sort(result, new ZIndexComparator());
        return result;
    }

    private void paintBackgroundsAndBorders(RenderingContext c, List<Box> blocks, Map collapsedTableBorders, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c.getOutputDevice(), rangeLists.getBlock());
        for (int i = 0; i < blocks.size(); ++i) {
            List borders;
            TableCellBox cell;
            helper.popClipRegions(c, i);
            BlockBox box = (BlockBox)blocks.get(i);
            box.paintBackground(c);
            box.paintBorder(c);
            if (c.debugDrawBoxes()) {
                box.paintDebugOutline(c);
            }
            if (collapsedTableBorders != null && box instanceof TableCellBox && (cell = (TableCellBox)box).hasCollapsedPaintingBorder() && (borders = (List)collapsedTableBorders.get(cell)) != null) {
                this.paintCollapsedTableBorders(c, borders);
            }
            helper.pushClipRegion(c, i);
        }
        helper.popClipRegions(c, blocks.size());
    }

    private void paintSelection(RenderingContext c, List lines) {
        if (c.getOutputDevice().isSupportsSelection()) {
            for (InlinePaintable paintable : lines) {
                if (!(paintable instanceof InlineLayoutBox)) continue;
                ((InlineLayoutBox)paintable).paintSelection(c);
            }
        }
    }

    public Dimension getPaintingDimension(LayoutContext c) {
        return this.calcPaintingDimension(c).getOuterMarginCorner();
    }

    private void paintInlineContent(RenderingContext c, List lines, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c.getOutputDevice(), rangeLists.getInline());
        for (int i = 0; i < lines.size(); ++i) {
            helper.popClipRegions(c, i);
            helper.pushClipRegion(c, i);
            InlinePaintable paintable = (InlinePaintable)lines.get(i);
            paintable.paintInline(c);
        }
        helper.popClipRegions(c, lines.size());
    }

    public void paint(RenderingContext c) {
        if (this.getMaster().getStyle().isFixed()) {
            this.positionFixedLayer(c);
        }
        List<AffineTransform> inverse = null;
        if (this.isRootLayer()) {
            this.getMaster().paintRootElementBackground(c);
        }
        if (!this.isInline() && ((BlockBox)this.getMaster()).isReplaced()) {
            inverse = this.applyTranform(c, this.getMaster());
            this.paintLayerBackgroundAndBorder(c);
            this.paintReplacedElement(c, (BlockBox)this.getMaster());
            c.getOutputDevice().popTransforms(inverse);
        } else {
            BoxRangeLists rangeLists = new BoxRangeLists();
            ArrayList<Box> blocks = new ArrayList<Box>();
            ArrayList<Box> lines = new ArrayList<Box>();
            BoxCollector collector = new BoxCollector();
            collector.collect(c, c.getOutputDevice().getClip(), this, blocks, lines, rangeLists);
            inverse = this.applyTranform(c, this.getMaster());
            if (!this.isInline()) {
                this.paintLayerBackgroundAndBorder(c);
                if (c.debugDrawBoxes()) {
                    ((BlockBox)this.getMaster()).paintDebugOutline(c);
                }
            }
            if (this.isRootLayer() || this.isStackingContext()) {
                this.paintLayers(c, this.getSortedLayers(3));
            }
            Map collapsedTableBorders = this.collectCollapsedTableBorders(c, blocks);
            this.paintBackgroundsAndBorders(c, blocks, collapsedTableBorders, rangeLists);
            this.paintFloats(c);
            this.paintListMarkers(c, blocks, rangeLists);
            this.paintInlineContent(c, lines, rangeLists);
            this.paintReplacedElements(c, blocks, rangeLists);
            this.paintSelection(c, lines);
            if (this.isRootLayer() || this.isStackingContext()) {
                this.paintLayers(c, this.collectLayers(4));
                this.paintLayers(c, this.getSortedLayers(2));
                this.paintLayers(c, this.getSortedLayers(1));
            }
            c.getOutputDevice().popTransforms(inverse);
        }
    }

    private float convertAngleToRadians(PropertyValue param) {
        if (param.getPrimitiveType() == 11) {
            return (float)Math.toRadians(param.getFloatValue());
        }
        if (param.getPrimitiveType() == 12) {
            return param.getFloatValue();
        }
        return (float)((double)param.getFloatValue() * 0.015707963267948967);
    }

    public List<BlockBox> getFloats() {
        return this._floats == null ? Collections.emptyList() : this._floats;
    }

    protected List<AffineTransform> applyTranform(RenderingContext c, Box box) {
        FSDerivedValue transforms = box.getStyle().valueByName(CSSName.TRANSFORM);
        if (transforms.isIdent() && transforms.asIdentValue() == IdentValue.NONE) {
            return Collections.emptyList();
        }
        float relOriginX = box.getStyle().getFloatPropertyProportionalWidth(CSSName.FS_TRANSFORM_ORIGIN_X, box.getWidth(), c);
        float relOriginY = box.getStyle().getFloatPropertyProportionalHeight(CSSName.FS_TRANSFORM_ORIGIN_Y, box.getHeight(), c);
        float flipFactor = c.getOutputDevice().isPDF() ? -1.0f : 1.0f;
        float absTranslateX = relOriginX + (float)box.getAbsX();
        float absTranslateY = relOriginY + (float)box.getAbsY();
        float relTranslateX = absTranslateX - c.getOutputDevice().getAbsoluteTransformOriginX();
        float relTranslateY = absTranslateY - c.getOutputDevice().getAbsoluteTransformOriginY();
        if (c.getOutputDevice().isPDF()) {
            RectPropertySet margin = c.getPage().getMargin(c);
            relTranslateX += margin.left();
            relTranslateY += margin.top();
            for (int i = 0; i < c.getPageNo() && i < this.getPages().size(); ++i) {
                RectPropertySet prevMargin = this.getPages().get(i).getMargin(c);
                relTranslateY += prevMargin.top() + prevMargin.bottom();
            }
            MarginBoxName[] marginBoxNames = c.getPage().getCurrentMarginBoxNames();
            if (marginBoxNames != null) {
                boolean isLeft = false;
                boolean isTop = false;
                boolean isRight = false;
                boolean isTopRight = false;
                boolean isTopLeft = true;
                boolean isBottom = false;
                boolean isBottomRight = false;
                boolean isBottomLeft = false;
                for (MarginBoxName name : marginBoxNames) {
                    if (name == MarginBoxName.LEFT_TOP || name == MarginBoxName.LEFT_MIDDLE || name == MarginBoxName.LEFT_BOTTOM) {
                        isLeft = true;
                    }
                    if (name == MarginBoxName.TOP_LEFT || name == MarginBoxName.TOP_CENTER || name == MarginBoxName.TOP_RIGHT) {
                        isTop = true;
                    }
                    if (name == MarginBoxName.BOTTOM_LEFT || name == MarginBoxName.BOTTOM_CENTER || name == MarginBoxName.BOTTOM_RIGHT) {
                        isBottom = true;
                    }
                    if (name == MarginBoxName.TOP_LEFT_CORNER) {
                        isTopLeft = true;
                    }
                    if (name == MarginBoxName.TOP_RIGHT_CORNER) {
                        isTopRight = true;
                    }
                    if (name == MarginBoxName.BOTTOM_LEFT_CORNER) {
                        isBottomLeft = true;
                    }
                    if (name != MarginBoxName.BOTTOM_RIGHT_CORNER) continue;
                    isBottomRight = true;
                }
                if (isLeft) {
                    relTranslateX -= margin.left();
                }
                if (isTop) {
                    relTranslateY -= margin.top();
                }
                if (isBottom) {
                    relTranslateY -= margin.top() + margin.bottom();
                }
                if (isTopLeft) {
                    relTranslateX -= margin.left();
                    relTranslateY -= margin.top();
                }
                if (isTopRight) {
                    relTranslateX -= margin.left();
                    relTranslateY -= margin.top();
                }
                if (isRight) {
                    relTranslateY -= margin.top();
                    relTranslateX -= margin.left() + margin.right();
                }
                if (isBottom) {
                    relTranslateY -= margin.top() + margin.bottom();
                }
                if (isBottomLeft) {
                    // empty if block
                }
                if (isBottomRight) {
                    relTranslateX -= margin.left();
                    relTranslateY -= margin.top() + margin.bottom();
                }
            }
        }
        List<PropertyValue> transformList = ((ListValue)transforms).getValues();
        ArrayList<AffineTransform> resultTransforms = new ArrayList<AffineTransform>();
        AffineTransform translateToOrigin = AffineTransform.getTranslateInstance(relTranslateX, relTranslateY);
        AffineTransform translateBackFromOrigin = AffineTransform.getTranslateInstance(-relTranslateX, -relTranslateY);
        resultTransforms.add(translateToOrigin);
        this.applyTransformFunctions(flipFactor, transformList, resultTransforms);
        resultTransforms.add(translateBackFromOrigin);
        return c.getOutputDevice().pushTransforms(resultTransforms);
    }

    private void applyTransformFunctions(float flipFactor, List<PropertyValue> transformList, List<AffineTransform> resultTransforms) {
        for (PropertyValue transform : transformList) {
            float radians;
            String fName = transform.getFunction().getName();
            List<PropertyValue> params = transform.getFunction().getParameters();
            if ("rotate".equalsIgnoreCase(fName)) {
                radians = flipFactor * this.convertAngleToRadians(params.get(0));
                resultTransforms.add(AffineTransform.getRotateInstance(radians));
                continue;
            }
            if ("scale".equalsIgnoreCase(fName) || "scalex".equalsIgnoreCase(fName) || "scaley".equalsIgnoreCase(fName)) {
                float scaleX = params.get(0).getFloatValue();
                float scaleY = params.get(0).getFloatValue();
                if (params.size() > 1) {
                    scaleY = params.get(1).getFloatValue();
                }
                if ("scalex".equalsIgnoreCase(fName)) {
                    scaleY = 1.0f;
                }
                if ("scaley".equalsIgnoreCase(fName)) {
                    scaleX = 1.0f;
                }
                resultTransforms.add(AffineTransform.getScaleInstance(scaleX, scaleY));
                continue;
            }
            if ("skew".equalsIgnoreCase(fName)) {
                float radiansX = flipFactor * this.convertAngleToRadians(params.get(0));
                float radiansY = 0.0f;
                if (params.size() > 1) {
                    radiansY = this.convertAngleToRadians(params.get(1));
                }
                resultTransforms.add(AffineTransform.getShearInstance(Math.tan(radiansX), Math.tan(radiansY)));
                continue;
            }
            if ("skewx".equalsIgnoreCase(fName)) {
                radians = flipFactor * this.convertAngleToRadians(params.get(0));
                resultTransforms.add(AffineTransform.getShearInstance(Math.tan(radians), 0.0));
                continue;
            }
            if ("skewy".equalsIgnoreCase(fName)) {
                radians = flipFactor * this.convertAngleToRadians(params.get(0));
                resultTransforms.add(AffineTransform.getShearInstance(0.0, Math.tan(radians)));
                continue;
            }
            if ("matrix".equalsIgnoreCase(fName)) {
                resultTransforms.add(new AffineTransform(params.get(0).getFloatValue(), params.get(1).getFloatValue(), params.get(2).getFloatValue(), params.get(3).getFloatValue(), params.get(4).getFloatValue(), params.get(5).getFloatValue()));
                continue;
            }
            if ("translate".equalsIgnoreCase(fName)) {
                XRLog.layout(Level.WARNING, "translate function not implemented at this time");
                continue;
            }
            if ("translateX".equalsIgnoreCase(fName)) {
                XRLog.layout(Level.WARNING, "translateX function not implemented at this time");
                continue;
            }
            if (!"translateY".equalsIgnoreCase(fName)) continue;
            XRLog.layout(Level.WARNING, "translateY function not implemented at this time");
        }
    }

    private Box find(CssContext cssCtx, int absX, int absY, List layers, boolean findAnonymous) {
        Box result = null;
        for (int i = layers.size() - 1; i >= 0; --i) {
            Layer l = (Layer)layers.get(i);
            result = l.find(cssCtx, absX, absY, findAnonymous);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        Box result = null;
        if (this.isRootLayer() || this.isStackingContext()) {
            result = this.find(cssCtx, absX, absY, this.getSortedLayers(1), findAnonymous);
            if (result != null) {
                return result;
            }
            result = this.find(cssCtx, absX, absY, this.getSortedLayers(2), findAnonymous);
            if (result != null) {
                return result;
            }
            result = this.find(cssCtx, absX, absY, this.collectLayers(4), findAnonymous);
            if (result != null) {
                return result;
            }
        }
        for (int i = 0; i < this.getFloats().size(); ++i) {
            Box floater = this.getFloats().get(i);
            result = floater.find(cssCtx, absX, absY, findAnonymous);
            if (result == null) continue;
            return result;
        }
        result = this.getMaster().find(cssCtx, absX, absY, findAnonymous);
        if (result != null) {
            return result;
        }
        if ((this.isRootLayer() || this.isStackingContext()) && (result = this.find(cssCtx, absX, absY, this.getSortedLayers(3), findAnonymous)) != null) {
            return result;
        }
        return null;
    }

    private void paintCollapsedTableBorders(RenderingContext c, List borders) {
        for (CollapsedBorderSide border : borders) {
            border.getCell().paintCollapsedBorder(c, border.getSide());
        }
    }

    private Map collectCollapsedTableBorders(RenderingContext c, List blocks) {
        ArrayList<CollapsedBorderSide> borders;
        HashMap<TableBox, ArrayList<CollapsedBorderSide>> cellBordersByTable = new HashMap<TableBox, ArrayList<CollapsedBorderSide>>();
        HashMap<TableBox, TableCellBox> triggerCellsByTable = new HashMap<TableBox, TableCellBox>();
        HashSet<CollapsedBorderValue> all = new HashSet<CollapsedBorderValue>();
        for (Box b : blocks) {
            TableCellBox cell;
            if (!(b instanceof TableCellBox) || !(cell = (TableCellBox)b).hasCollapsedPaintingBorder()) continue;
            borders = (ArrayList<CollapsedBorderSide>)cellBordersByTable.get(cell.getTable());
            if (borders == null) {
                borders = new ArrayList<CollapsedBorderSide>();
                cellBordersByTable.put(cell.getTable(), borders);
            }
            triggerCellsByTable.put(cell.getTable(), cell);
            cell.addCollapsedBorders(all, borders);
        }
        if (triggerCellsByTable.size() == 0) {
            return null;
        }
        HashMap<TableCellBox, ArrayList<CollapsedBorderSide>> result = new HashMap<TableCellBox, ArrayList<CollapsedBorderSide>>();
        for (TableCellBox cell : triggerCellsByTable.values()) {
            borders = (List)cellBordersByTable.get(cell.getTable());
            Collections.sort(borders);
            result.put(cell, borders);
        }
        return result;
    }

    public void paintAsLayer(RenderingContext c, BlockBox startingPoint) {
        BoxRangeLists rangeLists = new BoxRangeLists();
        ArrayList<Box> blocks = new ArrayList<Box>();
        ArrayList<Box> lines = new ArrayList<Box>();
        BoxCollector collector = new BoxCollector();
        collector.collect(c, c.getOutputDevice().getClip(), this, startingPoint, blocks, lines, rangeLists);
        Map collapsedTableBorders = this.collectCollapsedTableBorders(c, blocks);
        this.paintBackgroundsAndBorders(c, blocks, collapsedTableBorders, rangeLists);
        this.paintListMarkers(c, blocks, rangeLists);
        this.paintInlineContent(c, lines, rangeLists);
        this.paintSelection(c, lines);
        this.paintReplacedElements(c, blocks, rangeLists);
    }

    private void paintListMarkers(RenderingContext c, List blocks, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c.getOutputDevice(), rangeLists.getBlock());
        for (int i = 0; i < blocks.size(); ++i) {
            helper.popClipRegions(c, i);
            BlockBox box = (BlockBox)blocks.get(i);
            box.paintListMarker(c);
            helper.pushClipRegion(c, i);
        }
        helper.popClipRegions(c, blocks.size());
    }

    private void paintReplacedElements(RenderingContext c, List blocks, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c.getOutputDevice(), rangeLists.getBlock());
        for (int i = 0; i < blocks.size(); ++i) {
            helper.popClipRegions(c, i);
            BlockBox box = (BlockBox)blocks.get(i);
            if (box.isReplaced()) {
                this.paintReplacedElement(c, box);
            }
            helper.pushClipRegion(c, i);
        }
        helper.popClipRegions(c, blocks.size());
    }

    private void paintLayerBackgroundAndBorder(RenderingContext c) {
        if (this.getMaster() instanceof BlockBox) {
            BlockBox box = (BlockBox)this.getMaster();
            box.paintBackground(c);
            box.paintBorder(c);
        }
    }

    public void positionFixedLayer(RenderingContext c) {
        Rectangle rect = c.getFixedRectangle();
        Box fixed = this.getMaster();
        fixed.setX(0);
        fixed.setY(0);
        fixed.setAbsX(0);
        fixed.setAbsY(0);
        fixed.setContainingBlock(new ViewportBox(rect));
        ((BlockBox)fixed).positionAbsolute(c, 3);
        fixed.calcPaintingInfo(c, false);
    }

    public boolean isRootLayer() {
        return this.getParent() == null && this.isStackingContext();
    }

    private void moveIfGreater(Dimension result, Dimension test) {
        if (test.width > result.width) {
            result.width = test.width;
        }
        if (test.height > result.height) {
            result.height = test.height;
        }
    }

    private void paintReplacedElement(RenderingContext c, BlockBox replaced) {
        Rectangle contentBounds = replaced.getContentAreaEdge(replaced.getAbsX(), replaced.getAbsY(), c);
        Point loc = replaced.getReplacedElement().getLocation();
        if (contentBounds.x != loc.x || contentBounds.y != loc.y) {
            replaced.getReplacedElement().setLocation(contentBounds.x, contentBounds.y);
        }
        if (!c.isInteractive() || replaced.getReplacedElement().isRequiresInteractivePaint()) {
            c.getOutputDevice().paintReplacedElement(c, replaced);
        }
    }

    public void positionChildren(LayoutContext c) {
        for (Layer child : this.getChildren()) {
            child.position(c);
        }
    }

    private PaintingInfo calcPaintingDimension(LayoutContext c) {
        this.getMaster().calcPaintingInfo(c, true);
        PaintingInfo result = this.getMaster().getPaintingInfo().copyOf();
        List<Layer> children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Layer child = children.get(i);
            if (child.getMaster().getStyle().isFixed() || !child.getMaster().getStyle().isAbsolute()) continue;
            PaintingInfo info = child.calcPaintingDimension(c);
            this.moveIfGreater(result.getOuterMarginCorner(), info.getOuterMarginCorner());
        }
        return result;
    }

    private boolean containsFixedLayer() {
        for (Layer child : this.getChildren()) {
            if (!child.getMaster().getStyle().isFixed() && !child.containsFixedLayer()) continue;
            return true;
        }
        return false;
    }

    public boolean containsFixedContent() {
        return this._fixedBackground || this.containsFixedLayer();
    }

    public void setFixedBackground(boolean b) {
        this._fixedBackground = b;
    }

    public List<Layer> getChildren() {
        return this._children == null ? Collections.emptyList() : Collections.unmodifiableList(this._children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Layer layer) {
        boolean removed = false;
        Layer layer2 = this;
        synchronized (layer2) {
            if (this._children != null) {
                Iterator<Layer> i = this._children.iterator();
                while (i.hasNext()) {
                    Layer child = i.next();
                    if (child != layer) continue;
                    removed = true;
                    i.remove();
                    break;
                }
            }
        }
        if (!removed) {
            throw new RuntimeException("Could not find layer to remove");
        }
    }

    public void detach() {
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    public boolean isInline() {
        return this._inline;
    }

    public void setInline(boolean inline) {
        this._inline = inline;
    }

    public Box getEnd() {
        return this._end;
    }

    public void setEnd(Box end) {
        this._end = end;
    }

    public boolean isRequiresLayout() {
        return this._requiresLayout;
    }

    public void setRequiresLayout(boolean requiresLayout) {
        this._requiresLayout = requiresLayout;
    }

    public void finish(LayoutContext c) {
        if (c.isPrint()) {
            this.layoutAbsoluteChildren(c);
        }
        if (!this.isInline()) {
            this.positionChildren(c);
        }
    }

    private void layoutAbsoluteChildren(LayoutContext c) {
        List<Layer> children = this.getChildren();
        if (children.size() > 0) {
            LayoutState state = c.captureLayoutState();
            for (int i = 0; i < children.size(); ++i) {
                Layer child = children.get(i);
                if (!child.isRequiresLayout()) continue;
                this.layoutAbsoluteChild(c, child);
                if (child.getMaster().getStyle().isAvoidPageBreakInside() && child.getMaster().crossesPageBreak(c)) {
                    child.getMaster().reset(c);
                    ((BlockBox)child.getMaster()).setNeedPageClear(true);
                    this.layoutAbsoluteChild(c, child);
                    if (child.getMaster().crossesPageBreak(c)) {
                        child.getMaster().reset(c);
                        this.layoutAbsoluteChild(c, child);
                    }
                }
                child.setRequiresLayout(false);
                child.finish(c);
                c.getRootLayer().ensureHasPage(c, child.getMaster());
            }
            c.restoreLayoutState(state);
        }
    }

    private void position(LayoutContext c) {
        if (this.getMaster().getStyle().isAbsolute() && !c.isPrint()) {
            ((BlockBox)this.getMaster()).positionAbsolute(c, 3);
        } else if (this.getMaster().getStyle().isRelative() && (this.isInline() || ((BlockBox)this.getMaster()).isInline())) {
            this.getMaster().positionRelative(c);
            if (!this.isInline()) {
                this.getMaster().calcCanvasLocation();
                this.getMaster().calcChildLocations();
            }
        }
    }

    public List<PageBox> getPages() {
        if (this._pages == null) {
            return this._parent == null ? Collections.emptyList() : this._parent.getPages();
        }
        return this._pages;
    }

    public void setPages(List<PageBox> pages) {
        this._pages = pages;
    }

    public boolean isLastPage(PageBox pageBox) {
        return this._pages.get(this._pages.size() - 1) == pageBox;
    }

    private void layoutAbsoluteChild(LayoutContext c, Layer child) {
        BlockBox master = (BlockBox)child.getMaster();
        if (child.getMaster().getStyle().isBottomAuto()) {
            master.positionAbsolute(c, 3);
            master.positionAbsoluteOnPage(c);
            c.reInit(true);
            ((BlockBox)child.getMaster()).layout(c);
            master.positionAbsolute(c, 2);
        } else {
            c.reInit(true);
            master.layout(c);
            BoxDimensions before = master.getBoxDimensions();
            master.reset(c);
            BoxDimensions after = master.getBoxDimensions();
            master.setBoxDimensions(before);
            master.positionAbsolute(c, 3);
            master.positionAbsoluteOnPage(c);
            master.setBoxDimensions(after);
            c.reInit(true);
            ((BlockBox)child.getMaster()).layout(c);
        }
    }

    public void removeLastPage() {
        PageBox pageBox = this._pages.remove(this._pages.size() - 1);
        if (pageBox == this.getLastRequestedPage()) {
            this.setLastRequestedPage(null);
        }
    }

    public void addPage(CssContext c) {
        List<PageBox> pages;
        String pseudoPage = null;
        if (this._pages == null) {
            this._pages = new ArrayList<PageBox>();
        }
        pseudoPage = (pages = this.getPages()).size() == 0 ? "first" : (pages.size() % 2 == 0 ? "right" : "left");
        PageBox pageBox = Layer.createPageBox(c, pseudoPage);
        if (pages.size() == 0) {
            pageBox.setTopAndBottom(c, 0);
        } else {
            PageBox previous = pages.get(pages.size() - 1);
            pageBox.setTopAndBottom(c, previous.getBottom());
        }
        pageBox.setPageNo(pages.size());
        pages.add(pageBox);
    }

    public PageBox getFirstPage(CssContext c, Box box) {
        return this.getPage(c, box.getAbsY());
    }

    public PageBox getLastPage(CssContext c, Box box) {
        return this.getPage(c, box.getAbsY() + box.getHeight() - 1);
    }

    public void ensureHasPage(CssContext c, Box box) {
        this.getLastPage(c, box);
    }

    public PageBox getPage(CssContext c, int yOffset) {
        List<PageBox> pages = this.getPages();
        if (yOffset < 0) {
            return null;
        }
        PageBox lastRequested = this.getLastRequestedPage();
        if (lastRequested != null && yOffset >= lastRequested.getTop() && yOffset < lastRequested.getBottom()) {
            return lastRequested;
        }
        PageBox last = pages.get(pages.size() - 1);
        if (yOffset < last.getBottom()) {
            int count = pages.size();
            for (int i = count - 1; i >= 0 && i >= count - 5; --i) {
                PageBox pageBox = pages.get(i);
                if (yOffset < pageBox.getTop() || yOffset >= pageBox.getBottom()) continue;
                this.setLastRequestedPage(pageBox);
                return pageBox;
            }
            int low = 0;
            int high = count - 6;
            while (low <= high) {
                int mid = low + high >> 1;
                PageBox pageBox = pages.get(mid);
                if (yOffset >= pageBox.getTop() && yOffset < pageBox.getBottom()) {
                    this.setLastRequestedPage(pageBox);
                    return pageBox;
                }
                if (pageBox.getTop() < yOffset) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
        } else {
            this.addPagesUntilPosition(c, yOffset);
            PageBox result = pages.get(pages.size() - 1);
            this.setLastRequestedPage(result);
            return result;
        }
        throw new RuntimeException("internal error");
    }

    private void addPagesUntilPosition(CssContext c, int position) {
        List<PageBox> pages = this.getPages();
        PageBox last = pages.get(pages.size() - 1);
        while (position >= last.getBottom()) {
            this.addPage(c);
            last = pages.get(pages.size() - 1);
        }
    }

    public void trimEmptyPages(CssContext c, int maxYHeight) {
        PageBox page;
        List<PageBox> pages = this.getPages();
        for (int i = pages.size() - 1; i > 0 && (page = pages.get(i)).getTop() >= maxYHeight; --i) {
            if (page == this.getLastRequestedPage()) {
                this.setLastRequestedPage(null);
            }
            pages.remove(i);
        }
    }

    public void trimPageCount(int newPageCount) {
        while (this._pages.size() > newPageCount) {
            PageBox pageBox = this._pages.remove(this._pages.size() - 1);
            if (pageBox != this.getLastRequestedPage()) continue;
            this.setLastRequestedPage(null);
        }
    }

    public void assignPagePaintingPositions(CssContext cssCtx, short mode) {
        this.assignPagePaintingPositions(cssCtx, mode, 0);
    }

    public void assignPagePaintingPositions(CssContext cssCtx, int mode, int additionalClearance) {
        List<PageBox> pages = this.getPages();
        int paintingTop = additionalClearance;
        for (PageBox page : pages) {
            page.setPaintingTop(paintingTop);
            if (mode == 1) {
                page.setPaintingBottom(paintingTop + page.getHeight(cssCtx));
            } else if (mode == 2) {
                page.setPaintingBottom(paintingTop + page.getContentHeight(cssCtx));
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            paintingTop = page.getPaintingBottom() + additionalClearance;
        }
    }

    public int getMaxPageWidth(CssContext cssCtx, int additionalClearance) {
        List<PageBox> pages = this.getPages();
        int maxWidth = 0;
        for (PageBox page : pages) {
            int pageWidth = page.getWidth(cssCtx) + additionalClearance * 2;
            if (pageWidth <= maxWidth) continue;
            maxWidth = pageWidth;
        }
        return maxWidth;
    }

    public PageBox getLastPage() {
        List<PageBox> pages = this.getPages();
        return pages.size() == 0 ? null : pages.get(pages.size() - 1);
    }

    public boolean crossesPageBreak(LayoutContext c, int top, int bottom) {
        if (top < 0) {
            return false;
        }
        PageBox page = this.getPage(c, top);
        return bottom >= page.getBottom() - c.getExtraSpaceBottom();
    }

    public Layer findRoot() {
        if (this.isRootLayer()) {
            return this;
        }
        return this.getParent().findRoot();
    }

    public void addRunningBlock(BlockBox block) {
        String identifier;
        ArrayList<BlockBox> blocks;
        if (this._runningBlocks == null) {
            this._runningBlocks = new HashMap();
        }
        if ((blocks = (ArrayList<BlockBox>)this._runningBlocks.get(identifier = block.getStyle().getRunningName())) == null) {
            blocks = new ArrayList<BlockBox>();
            this._runningBlocks.put(identifier, blocks);
        }
        blocks.add(block);
        Collections.sort(blocks, new Comparator(){

            public int compare(Object o1, Object o2) {
                BlockBox b1 = (BlockBox)o1;
                BlockBox b2 = (BlockBox)o2;
                return b1.getAbsY() - b2.getAbsY();
            }
        });
    }

    public void removeRunningBlock(BlockBox block) {
        if (this._runningBlocks == null) {
            return;
        }
        String identifier = block.getStyle().getRunningName();
        List blocks = (List)this._runningBlocks.get(identifier);
        if (blocks == null) {
            return;
        }
        blocks.remove(block);
    }

    public BlockBox getRunningBlock(String identifer, PageBox page, PageElementPosition which) {
        if (this._runningBlocks == null) {
            return null;
        }
        List blocks = (List)this._runningBlocks.get(identifer);
        if (blocks == null) {
            return null;
        }
        if (which == PageElementPosition.START) {
            BlockBox b;
            BlockBox prev = null;
            Iterator i = blocks.iterator();
            while (i.hasNext() && (b = (BlockBox)i.next()).getStaticEquivalent().getAbsY() < page.getTop()) {
                prev = b;
            }
            return prev;
        }
        if (which == PageElementPosition.FIRST) {
            for (BlockBox b : blocks) {
                int absY = b.getStaticEquivalent().getAbsY();
                if (absY < page.getTop() || absY >= page.getBottom()) continue;
                return b;
            }
            return this.getRunningBlock(identifer, page, PageElementPosition.START);
        }
        if (which == PageElementPosition.LAST) {
            BlockBox b;
            BlockBox prev = null;
            Iterator i = blocks.iterator();
            while (i.hasNext() && (b = (BlockBox)i.next()).getStaticEquivalent().getAbsY() <= page.getBottom()) {
                prev = b;
            }
            return prev;
        }
        if (which == PageElementPosition.LAST_EXCEPT) {
            BlockBox prev = null;
            for (BlockBox b : blocks) {
                int absY = b.getStaticEquivalent().getAbsY();
                if (absY >= page.getTop() && absY < page.getBottom()) {
                    return null;
                }
                if (absY > page.getBottom()) break;
                prev = b;
            }
            return prev;
        }
        throw new RuntimeException("bug: internal error");
    }

    public void layoutPages(LayoutContext c) {
        c.setRootDocumentLayer(c.getRootLayer());
        for (PageBox pageBox : this._pages) {
            pageBox.layout(c);
        }
    }

    public void addPageSequence(BlockBox start) {
        if (this._pageSequences == null) {
            this._pageSequences = new HashSet<BlockBox>();
        }
        this._pageSequences.add(start);
    }

    private List getSortedPageSequences() {
        if (this._pageSequences == null) {
            return null;
        }
        if (this._sortedPageSequences == null) {
            ArrayList<BlockBox> result = new ArrayList<BlockBox>(this._pageSequences);
            Collections.sort(result, new Comparator<BlockBox>(){

                @Override
                public int compare(BlockBox b1, BlockBox b2) {
                    return b1.getAbsY() - b2.getAbsY();
                }
            });
            this._sortedPageSequences = result;
        }
        return this._sortedPageSequences;
    }

    public int getRelativePageNo(RenderingContext c, int absY) {
        List sequences = this.getSortedPageSequences();
        int initial = 0;
        if (c.getInitialPageNo() > 0) {
            initial = c.getInitialPageNo() - 1;
        }
        if (sequences == null || sequences.isEmpty()) {
            return initial + this.getPage(c, absY).getPageNo();
        }
        BlockBox pageSequence = this.findPageSequence(sequences, absY);
        int sequenceStartAbsolutePageNo = this.getPage(c, pageSequence.getAbsY()).getPageNo();
        int absoluteRequiredPageNo = this.getPage(c, absY).getPageNo();
        return absoluteRequiredPageNo - sequenceStartAbsolutePageNo;
    }

    private BlockBox findPageSequence(List sequences, int absY) {
        BlockBox result = null;
        for (int i = 0; i < sequences.size(); ++i) {
            result = (BlockBox)sequences.get(i);
            if (i < sequences.size() - 1 && ((BlockBox)sequences.get(i + 1)).getAbsY() > absY) break;
        }
        return result;
    }

    public int getRelativePageNo(RenderingContext c) {
        List sequences = this.getSortedPageSequences();
        int initial = 0;
        if (c.getInitialPageNo() > 0) {
            initial = c.getInitialPageNo() - 1;
        }
        if (sequences == null) {
            return initial + c.getPageNo();
        }
        int sequenceStartIndex = this.getPageSequenceStart(c, sequences, c.getPage());
        if (sequenceStartIndex == -1) {
            return initial + c.getPageNo();
        }
        BlockBox block = (BlockBox)sequences.get(sequenceStartIndex);
        return c.getPageNo() - this.getFirstPage(c, block).getPageNo();
    }

    public int getRelativePageCount(RenderingContext c) {
        int lastPage;
        BlockBox block;
        int firstPage;
        List sequences = this.getSortedPageSequences();
        int initial = 0;
        if (c.getInitialPageNo() > 0) {
            initial = c.getInitialPageNo() - 1;
        }
        if (sequences == null) {
            return initial + c.getPageCount();
        }
        int sequenceStartIndex = this.getPageSequenceStart(c, sequences, c.getPage());
        if (sequenceStartIndex == -1) {
            firstPage = 0;
        } else {
            block = (BlockBox)sequences.get(sequenceStartIndex);
            firstPage = this.getFirstPage(c, block).getPageNo();
        }
        if (sequenceStartIndex < sequences.size() - 1) {
            block = (BlockBox)sequences.get(sequenceStartIndex + 1);
            lastPage = this.getFirstPage(c, block).getPageNo();
        } else {
            lastPage = c.getPageCount();
        }
        int sequenceLength = lastPage - firstPage;
        if (sequenceStartIndex == -1) {
            sequenceLength += initial;
        }
        return sequenceLength;
    }

    private int getPageSequenceStart(RenderingContext c, List sequences, PageBox page) {
        for (int i = sequences.size() - 1; i >= 0; --i) {
            BlockBox start = (BlockBox)sequences.get(i);
            if (start.getAbsY() >= page.getBottom() - 1) continue;
            return i;
        }
        return -1;
    }

    public Box getSelectionEnd() {
        return this._selectionEnd;
    }

    public void setSelectionEnd(Box selectionEnd) {
        this._selectionEnd = selectionEnd;
    }

    public Box getSelectionStart() {
        return this._selectionStart;
    }

    public void setSelectionStart(Box selectionStart) {
        this._selectionStart = selectionStart;
    }

    public int getSelectionEndX() {
        return this._selectionEndX;
    }

    public void setSelectionEndX(int selectionEndX) {
        this._selectionEndX = selectionEndX;
    }

    public int getSelectionEndY() {
        return this._selectionEndY;
    }

    public void setSelectionEndY(int selectionEndY) {
        this._selectionEndY = selectionEndY;
    }

    public int getSelectionStartX() {
        return this._selectionStartX;
    }

    public void setSelectionStartX(int selectionStartX) {
        this._selectionStartX = selectionStartX;
    }

    public int getSelectionStartY() {
        return this._selectionStartY;
    }

    public void setSelectionStartY(int selectionStartY) {
        this._selectionStartY = selectionStartY;
    }

    private PageBox getLastRequestedPage() {
        return this._lastRequestedPage;
    }

    private void setLastRequestedPage(PageBox lastRequestedPage) {
        this._lastRequestedPage = lastRequestedPage;
    }

    private static class ZIndexComparator
    implements Comparator<Layer> {
        private ZIndexComparator() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            return l1.getZIndex() - l2.getZIndex();
        }
    }
}

