/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render.displaylist;

import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.displaylist.DisplayListCollector;
import com.openhtmltopdf.render.displaylist.DisplayListContainer;
import com.openhtmltopdf.render.displaylist.DisplayListOperation;
import com.openhtmltopdf.render.displaylist.PagedBoxCollector;
import com.openhtmltopdf.render.displaylist.SinglePageBoxCollector;
import java.util.Collections;

public class SinglePageDisplayListCollector
extends DisplayListCollector {
    private final int pageNumber;
    private final PageBox pageBox;

    public SinglePageDisplayListCollector(PageBox pageBox, int pageNo) {
        super(Collections.singletonList(pageBox));
        this.pageNumber = pageNo;
        this.pageBox = pageBox;
    }

    @Override
    protected void addItem(DisplayListOperation item, int pgStart, int pgEnd, DisplayListContainer dlPages) {
        dlPages.getPageInstructions(0).addOp(item);
    }

    @Override
    protected PagedBoxCollector createBoxCollector() {
        return new SinglePageBoxCollector(this.pageNumber, this.pageBox);
    }

    @Override
    protected int findStartPage(RenderingContext c, Layer layer) {
        return this.pageNumber;
    }

    @Override
    protected int findEndPage(RenderingContext c, Layer layer) {
        return this.pageNumber;
    }

    public DisplayListContainer collectFixed(RenderingContext c, Layer layer) {
        DisplayListContainer res = new DisplayListContainer(1);
        this.collect(c, layer, res, true);
        return res;
    }
}

