/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render.displaylist;

import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.PaintingInfo;
import com.openhtmltopdf.newtable.TableBox;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.newtable.TableSectionBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.DisplayListItem;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.render.LineBox;
import com.openhtmltopdf.render.OperatorClip;
import com.openhtmltopdf.render.OperatorSetClip;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PagedBoxCollector {
    private final List<PageResult> result;
    private final List<PageBox> pages;
    private final PageFinder finder;

    protected PagedBoxCollector() {
        this.result = null;
        this.pages = null;
        this.finder = null;
    }

    public PagedBoxCollector(List<PageBox> pages) {
        this.pages = pages;
        this.result = new ArrayList<PageResult>(pages.size());
        this.finder = new PageFinder(pages);
        for (int i = 0; i < pages.size(); ++i) {
            this.result.add(new PageResult());
        }
    }

    public void collect(CssContext c, Layer layer) {
        if (layer.isInline()) {
            this.collectInline(c, layer);
        } else {
            this.collect(c, layer, layer.getMaster());
        }
    }

    private void collectInline(CssContext c, Layer layer) {
        InlineLayoutBox iB = (InlineLayoutBox)layer.getMaster();
        List content = iB.getElementWithContent();
        for (Box b : content) {
            int pgStart = this.findStartPage(c, b, layer.getCurrentTransformMatrix());
            int pgEnd = this.findEndPage(c, b, layer.getCurrentTransformMatrix());
            for (int i = pgStart; i <= pgEnd; ++i) {
                Rectangle pageClip;
                if (i < 0 || i > this.getMaxPageNumber() || !b.intersects(c, pageClip = this.getPageResult(i).getContentWindowOnDocument(this.getPageBox(i), c))) continue;
                if (b instanceof InlineLayoutBox) {
                    this.getPageResult(i).addInline(b);
                    continue;
                }
                BlockBox bb = (BlockBox)b;
                if (bb.isInline()) {
                    if (!this.intersectsAny(c, pageClip, b, b)) continue;
                    this.getPageResult(i).addInline(b);
                    continue;
                }
                this.collect(c, layer, bb);
            }
        }
    }

    public void collect(CssContext c, Layer layer, Box container) {
        block17: {
            PageResult pageResult;
            int i;
            int pgEnd;
            int pgStart;
            block16: {
                if (layer != container.getContainingLayer()) {
                    return;
                }
                pgStart = -1;
                pgEnd = -1;
                if (!(container instanceof LineBox)) break block16;
                pgStart = this.findStartPage(c, container, layer.getCurrentTransformMatrix());
                pgEnd = this.findEndPage(c, container, layer.getCurrentTransformMatrix());
                for (int i2 = pgStart; i2 <= pgEnd; ++i2) {
                    if (i2 < 0 || i2 > this.getMaxPageNumber()) continue;
                    PageResult res = this.getPageResult(i2);
                    res.addInline(container);
                    ((LineBox)container).addAllChildren(res._inlines, layer);
                }
                break block17;
            }
            Rectangle ourClip = null;
            if (container.getLayer() == null || layer.getMaster() == container || !(container instanceof BlockBox)) {
                BlockBox block;
                pgStart = this.findStartPage(c, container, layer.getCurrentTransformMatrix());
                pgEnd = this.findEndPage(c, container, layer.getCurrentTransformMatrix());
                if (c instanceof RenderingContext && container instanceof BlockBox && (block = (BlockBox)container).isNeedsClipOnPaint((RenderingContext)c)) {
                    ourClip = block.getChildrenClipEdge((RenderingContext)c);
                }
                for (i = pgStart; i <= pgEnd; ++i) {
                    Rectangle pageClip;
                    if (i < 0 || i > this.getMaxPageNumber() || !this.intersectsAggregateBounds(pageClip = (pageResult = this.getPageResult(i)).getContentWindowOnDocument(this.getPageBox(i), c), container)) continue;
                    pageResult.addBlock(container);
                    if (container instanceof BlockBox) {
                        BlockBox block2 = (BlockBox)container;
                        if (block2.getReplacedElement() != null) {
                            pageResult.addReplaced(block2);
                        }
                        if (block2.isListItem()) {
                            pageResult.addListItem(block2);
                        }
                    }
                    if (container instanceof TableCellBox && ((TableCellBox)container).hasCollapsedPaintingBorder()) {
                        pageResult.addTableCell((TableCellBox)container);
                    }
                    if (ourClip == null) continue;
                    pageResult.clipAll(new OperatorClip(ourClip));
                }
            }
            if (container instanceof TableSectionBox && (((TableSectionBox)container).isHeader() || ((TableSectionBox)container).isFooter()) && ((TableSectionBox)container).getTable().hasContentLimitContainer() && (container.getLayer() == null || container == layer.getMaster()) && c instanceof RenderingContext) {
                TableBox table = ((TableSectionBox)container).getTable();
                RenderingContext rc = (RenderingContext)c;
                int tableStart = this.findStartPage(c, table, layer.getCurrentTransformMatrix());
                int tableEnd = this.findEndPage(c, table, layer.getCurrentTransformMatrix());
                for (int pgTable = tableStart; pgTable <= tableEnd; ++pgTable) {
                    if (pgTable < 0 || pgTable > this.getMaxPageNumber()) continue;
                    rc.setPage(pgTable, this.getPageBox(pgTable));
                    table.updateHeaderFooterPosition(rc);
                    for (int i3 = 0; i3 < container.getChildCount(); ++i3) {
                        Box child = container.getChild(i3);
                        this.collect(c, layer, child);
                    }
                }
            } else if (container.getLayer() == null || container == layer.getMaster()) {
                for (i = 0; i < container.getChildCount(); ++i) {
                    Box child = container.getChild(i);
                    this.collect(c, layer, child);
                }
            }
            if (ourClip == null) break block17;
            for (int i4 = pgStart; i4 <= pgEnd; ++i4) {
                Rectangle pageClip;
                if (i4 < 0 || i4 > this.getMaxPageNumber() || !this.intersectsAggregateBounds(pageClip = (pageResult = this.getPageResult(i4)).getContentWindowOnDocument(this.getPageBox(i4), c), container)) continue;
                pageResult.setClipAll(new OperatorSetClip(null));
            }
        }
    }

    private boolean intersectsAggregateBounds(Shape clip, Box box) {
        if (clip == null) {
            return true;
        }
        PaintingInfo info = box.getPaintingInfo();
        if (info == null) {
            return false;
        }
        Rectangle bounds = info.getAggregateBounds();
        AffineTransform ctm = box.getContainingLayer().getCurrentTransformMatrix();
        if (ctm == null) {
            return clip.intersects(bounds);
        }
        Shape boxShape = ctm.createTransformedShape(bounds);
        return clip.intersects(boxShape.getBounds2D());
    }

    private boolean intersectsAny(CssContext c, Shape clip, Box master, Box container) {
        if (container instanceof LineBox) {
            if (container.intersects(c, clip)) {
                return true;
            }
        } else {
            if ((container.getLayer() == null || !(container instanceof BlockBox)) && container.intersects(c, clip)) {
                return true;
            }
            if (container.getLayer() == null || container == master) {
                for (int i = 0; i < container.getChildCount(); ++i) {
                    Box child = container.getChild(i);
                    boolean possibleResult = this.intersectsAny(c, clip, master, child);
                    if (!possibleResult) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static double getMinYFromTransformedBox(Rectangle bounds, AffineTransform transform) {
        Point2D.Double ul = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
        Point2D.Double ur = new Point2D.Double(bounds.getMaxX(), bounds.getMinY());
        Point2D.Double ll = new Point2D.Double(bounds.getMinX(), bounds.getMaxY());
        Point2D.Double lr = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
        Point2D ult = transform.transform(ul, null);
        Point2D urt = transform.transform(ur, null);
        Point2D llt = transform.transform(ll, null);
        Point2D lrt = transform.transform(lr, null);
        double minY = Math.min(ult.getY(), urt.getY());
        minY = Math.min(llt.getY(), minY);
        minY = Math.min(lrt.getY(), minY);
        return minY;
    }

    private static double getMaxYFromTransformedBox(Rectangle bounds, AffineTransform transform) {
        Point2D.Double ul = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
        Point2D.Double ur = new Point2D.Double(bounds.getMaxX(), bounds.getMinY());
        Point2D.Double ll = new Point2D.Double(bounds.getMinX(), bounds.getMaxY());
        Point2D.Double lr = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
        Point2D ult = transform.transform(ul, null);
        Point2D urt = transform.transform(ur, null);
        Point2D llt = transform.transform(ll, null);
        Point2D lrt = transform.transform(lr, null);
        double maxY = Math.max(ult.getY(), urt.getY());
        maxY = Math.max(llt.getY(), maxY);
        maxY = Math.max(lrt.getY(), maxY);
        return maxY;
    }

    protected int findStartPage(CssContext c, Box container, AffineTransform transform) {
        PaintingInfo info = container.calcPaintingInfo(c, true);
        if (info == null) {
            return -1;
        }
        Rectangle bounds = info.getAggregateBounds();
        if (bounds == null) {
            return -1;
        }
        double minY = transform == null ? bounds.getMinY() : PagedBoxCollector.getMinYFromTransformedBox(bounds, transform);
        return this.finder.findPage(c, (int)minY);
    }

    protected int findEndPage(CssContext c, Box container, AffineTransform transform) {
        PaintingInfo info = container.calcPaintingInfo(c, true);
        if (info == null) {
            return -1;
        }
        Rectangle bounds = info.getAggregateBounds();
        if (bounds == null) {
            return -1;
        }
        double maxY = transform == null ? bounds.getMaxY() : PagedBoxCollector.getMaxYFromTransformedBox(bounds, transform);
        return this.finder.findPage(c, (int)maxY);
    }

    protected PageResult getPageResult(int pageNo) {
        return this.result.get(pageNo);
    }

    protected int getMaxPageNumber() {
        return this.result.size() - 1;
    }

    protected PageBox getPageBox(int pageNo) {
        return this.pages.get(pageNo);
    }

    public static int findStartPage(CssContext c, Box container, List<PageBox> pages) {
        PageFinder finder = new PageFinder(pages);
        PaintingInfo info = container.calcPaintingInfo(c, true);
        if (info == null) {
            return -1;
        }
        Rectangle bounds = info.getAggregateBounds();
        if (bounds == null) {
            return -1;
        }
        AffineTransform transform = container.getContainingLayer().getCurrentTransformMatrix();
        double minY = transform == null ? bounds.getMinY() : PagedBoxCollector.getMinYFromTransformedBox(bounds, transform);
        return finder.findPage(c, (int)minY);
    }

    public static int findEndPage(CssContext c, Box container, List<PageBox> pages) {
        PageFinder finder = new PageFinder(pages);
        PaintingInfo info = container.calcPaintingInfo(c, true);
        if (info == null) {
            return -1;
        }
        Rectangle bounds = info.getAggregateBounds();
        if (bounds == null) {
            return -1;
        }
        AffineTransform transform = container.getContainingLayer().getCurrentTransformMatrix();
        double maxY = transform == null ? bounds.getMaxY() : PagedBoxCollector.getMaxYFromTransformedBox(bounds, transform);
        return finder.findPage(c, (int)maxY);
    }

    public List<PageResult> getCollectedPageResults() {
        return this.result;
    }

    public static class PageFinder {
        private int lastRequested = 0;
        private final List<PageBox> pages;

        public PageFinder(List<PageBox> pages) {
            this.pages = pages;
        }

        public int findPage(CssContext c, int yOffset) {
            if (yOffset < 0) {
                return -1;
            }
            PageBox lastRequest = this.pages.get(this.lastRequested);
            if (yOffset >= lastRequest.getTop() && yOffset < lastRequest.getBottom()) {
                return this.lastRequested;
            }
            PageBox last = this.pages.get(this.pages.size() - 1);
            if (yOffset >= last.getTop() && yOffset < last.getBottom()) {
                this.lastRequested = this.pages.size() - 1;
                return this.lastRequested;
            }
            if (yOffset < last.getBottom()) {
                int count = this.pages.size();
                for (int i = count - 1; i >= 0 && i >= count - 5; --i) {
                    PageBox pageBox = this.pages.get(i);
                    if (yOffset < pageBox.getTop() || yOffset >= pageBox.getBottom()) continue;
                    this.lastRequested = i;
                    return i;
                }
                int low = 0;
                int high = count - 6;
                while (low <= high) {
                    int mid = low + high >> 1;
                    PageBox pageBox = this.pages.get(mid);
                    if (yOffset >= pageBox.getTop() && yOffset < pageBox.getBottom()) {
                        this.lastRequested = mid;
                        return mid;
                    }
                    if (pageBox.getTop() < yOffset) {
                        low = mid + 1;
                        continue;
                    }
                    high = mid - 1;
                }
            } else {
                return -1;
            }
            return -1;
        }
    }

    public static class PageResult {
        private List<DisplayListItem> _blocks = null;
        private List<DisplayListItem> _inlines = null;
        private List<TableCellBox> _tcells = null;
        private List<DisplayListItem> _replaceds = null;
        private List<DisplayListItem> _listItems = null;
        private boolean _hasListItems = false;
        private boolean _hasReplaceds = false;
        private Rectangle contentWindowOnDocument = null;

        private void addBlock(DisplayListItem block) {
            if (this._blocks == null) {
                this._blocks = new ArrayList<DisplayListItem>();
            }
            this._blocks.add(block);
        }

        private void addInline(DisplayListItem inline) {
            if (this._inlines == null) {
                this._inlines = new ArrayList<DisplayListItem>();
            }
            this._inlines.add(inline);
        }

        private void addTableCell(TableCellBox tcell) {
            if (this._tcells == null) {
                this._tcells = new ArrayList<TableCellBox>();
            }
            this._tcells.add(tcell);
        }

        private void addReplaced(DisplayListItem replaced) {
            if (this._replaceds == null) {
                this._replaceds = new ArrayList<DisplayListItem>();
            }
            this._replaceds.add(replaced);
            if (!(replaced instanceof OperatorClip) && !(replaced instanceof OperatorSetClip)) {
                this._hasReplaceds = true;
            }
        }

        private void addListItem(DisplayListItem listItem) {
            if (this._listItems == null) {
                this._listItems = new ArrayList<DisplayListItem>();
            }
            this._listItems.add(listItem);
            if (!(listItem instanceof OperatorClip) && !(listItem instanceof OperatorSetClip)) {
                this._hasListItems = true;
            }
        }

        private void clipAll(OperatorClip dli) {
            this.addBlock(dli);
            this.addInline(dli);
            this.addReplaced(dli);
            this.addListItem(dli);
        }

        private void setClipAll(OperatorSetClip dli) {
            this.addBlock(dli);
            this.addInline(dli);
            this.addReplaced(dli);
            this.addListItem(dli);
        }

        public List<DisplayListItem> blocks() {
            return this._blocks == null ? Collections.emptyList() : this._blocks;
        }

        public List<DisplayListItem> inlines() {
            return this._inlines == null ? Collections.emptyList() : this._inlines;
        }

        public List<TableCellBox> tcells() {
            return this._tcells == null ? Collections.emptyList() : this._tcells;
        }

        public List<DisplayListItem> replaceds() {
            return this._hasReplaceds ? this._replaceds : Collections.emptyList();
        }

        public List<DisplayListItem> listItems() {
            return this._hasListItems ? this._listItems : Collections.emptyList();
        }

        private Rectangle getContentWindowOnDocument(PageBox page, CssContext c) {
            if (this.contentWindowOnDocument == null) {
                this.contentWindowOnDocument = page.getDocumentCoordinatesContentBounds(c);
            }
            return this.contentWindowOnDocument;
        }
    }
}

