/*
 * Decompiled with CFR 0.152.
 */
package com.openai.models.embeddings;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.openai.core.BaseDeserializer;
import com.openai.core.BaseSerializer;
import com.openai.core.JsonValue;
import com.openai.core.Utils;
import com.openai.errors.OpenAIInvalidDataException;
import com.openai.models.embeddings.EmbeddingValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0004\u001e\u001f !B1\b\u0002\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001f\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0006J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0011J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0013J\u0006\u0010\u0018\u001a\u00020\u0013J\u0006\u0010\u0019\u001a\u00020\u0013J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\u0006\u0010\u001b\u001a\u00020\u0000J\r\u0010\u001c\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001dR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/openai/models/embeddings/EmbeddingValue;", "", "floats", "", "", "base64", "", "_json", "Lcom/openai/core/JsonValue;", "(Ljava/util/List;Ljava/lang/String;Lcom/openai/core/JsonValue;)V", "accept", "T", "visitor", "Lcom/openai/models/embeddings/EmbeddingValue$Visitor;", "(Lcom/openai/models/embeddings/EmbeddingValue$Visitor;)Ljava/lang/Object;", "asBase64", "asFloats", "Ljava/util/Optional;", "equals", "", "other", "hashCode", "", "isBase64", "isFloats", "isValid", "toString", "validate", "validity", "validity$openai_java_core", "Companion", "Deserializer", "Serializer", "Visitor", "openai-java-core"})
public final class EmbeddingValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final List<Float> floats;
    @Nullable
    private final String base64;
    @Nullable
    private final JsonValue _json;

    private EmbeddingValue(List<Float> floats, String base64, JsonValue _json) {
        this.floats = floats;
        this.base64 = base64;
        this._json = _json;
    }

    /* synthetic */ EmbeddingValue(List list2, String string, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            jsonValue = null;
        }
        this(list2, string, jsonValue);
    }

    @NotNull
    public final Optional<List<Float>> floats() {
        Optional<List<Float>> optional = Optional.ofNullable(this.floats);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(floats)");
        return optional;
    }

    @NotNull
    public final Optional<String> base64() {
        Optional<String> optional = Optional.ofNullable(this.base64);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(base64)");
        return optional;
    }

    public final boolean isFloats() {
        return this.floats != null;
    }

    public final boolean isBase64() {
        return this.base64 != null;
    }

    @NotNull
    public final List<Float> asFloats() {
        List list2;
        if (this.floats != null) {
            list2 = this.floats;
        } else if (this.base64 != null) {
            list2 = EmbeddingValue.Companion.decodeBase64ToFloats(this.base64);
        } else {
            throw new IllegalStateException("Invalid EmbeddingValue");
        }
        return list2;
    }

    @NotNull
    public final String asBase64() {
        String string;
        if (this.base64 != null) {
            string = this.base64;
        } else if (this.floats != null) {
            string = EmbeddingValue.Companion.encodeFloatsAsBase64(this.floats);
        } else {
            throw new IllegalStateException("Invalid EmbeddingValue");
        }
        return string;
    }

    @Nullable
    public final JsonValue _json() {
        return this._json;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.floats != null ? visitor.visitFloats(this.floats) : (this.base64 != null ? visitor.visitBase64(this.base64) : visitor.unknown(this._json));
    }

    @NotNull
    public final EmbeddingValue validate() {
        EmbeddingValue embeddingValue;
        EmbeddingValue $this$validate_u24lambda_u240 = embeddingValue = this;
        boolean bl = false;
        $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

            public void visitFloats(@NotNull List<Float> floats) {
                Intrinsics.checkNotNullParameter(floats, (String)"floats");
            }

            public void visitBase64(@NotNull String base64) {
                Intrinsics.checkNotNullParameter((Object)base64, (String)"base64");
            }
        });
        return embeddingValue;
    }

    public final boolean isValid() {
        boolean bl;
        try {
            this.validate();
            bl = true;
        }
        catch (OpenAIInvalidDataException e) {
            bl = false;
        }
        return bl;
    }

    public final /* synthetic */ int validity$openai_java_core() {
        return this.floats != null ? this.floats.size() : (this.base64 != null ? 1 : 0);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EmbeddingValue && Intrinsics.areEqual(this.floats, ((EmbeddingValue)other).floats) && Intrinsics.areEqual((Object)this.base64, (Object)((EmbeddingValue)other).base64);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.floats, this.base64};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.floats != null) {
            string = "EmbeddingValue{floats=" + this.floats + '}';
        } else if (this.base64 != null) {
            string = "EmbeddingValue{base64=" + this.base64 + '}';
        } else if (this._json != null) {
            string = "EmbeddingValue{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid EmbeddingValue");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final EmbeddingValue ofFloats(@NotNull List<Float> floats) {
        return Companion.ofFloats(floats);
    }

    @JvmStatic
    @NotNull
    public static final EmbeddingValue ofBase64(@NotNull String base64) {
        return Companion.ofBase64(base64);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\f\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a8\u0006\r"}, d2={"Lcom/openai/models/embeddings/EmbeddingValue$Companion;", "", "()V", "decodeBase64ToFloats", "", "", "base64", "", "encodeFloatsAsBase64", "floats", "ofBase64", "Lcom/openai/models/embeddings/EmbeddingValue;", "ofFloats", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nEmbeddingValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddingValue.kt\ncom/openai/models/embeddings/EmbeddingValue$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1855#2,2:227\n*S KotlinDebug\n*F\n+ 1 EmbeddingValue.kt\ncom/openai/models/embeddings/EmbeddingValue$Companion\n*L\n157#1:227,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final EmbeddingValue ofFloats(@NotNull List<Float> floats) {
            Intrinsics.checkNotNullParameter(floats, (String)"floats");
            return new EmbeddingValue(Utils.toImmutable(floats), null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final EmbeddingValue ofBase64(@NotNull String base64) {
            Intrinsics.checkNotNullParameter((Object)base64, (String)"base64");
            return new EmbeddingValue(null, base64, null, 5, null);
        }

        private final List<Float> decodeBase64ToFloats(String base64) {
            List list2;
            byte[] bytes2 = Base64.getDecoder().decode(base64);
            FloatBuffer floats = ByteBuffer.wrap(bytes2).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
            List $this$decodeBase64ToFloats_u24lambda_u240 = list2 = CollectionsKt.createListBuilder((int)floats.remaining());
            boolean bl = false;
            while (floats.hasRemaining()) {
                $this$decodeBase64ToFloats_u24lambda_u240.add(Float.valueOf(floats.get()));
            }
            return CollectionsKt.build((List)list2);
        }

        private final String encodeFloatsAsBase64(List<Float> floats) {
            ByteBuffer buffer = ByteBuffer.allocate(floats.size() * 4).order(ByteOrder.LITTLE_ENDIAN);
            Iterable $this$forEach$iv = floats;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                float it = ((Number)element$iv).floatValue();
                boolean bl = false;
                buffer.putFloat(it);
            }
            String string = Base64.getEncoder().encodeToString(buffer.array());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEncoder().encodeToString(buffer.array())");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/openai/models/embeddings/EmbeddingValue$Deserializer;", "Lcom/openai/core/BaseDeserializer;", "Lcom/openai/models/embeddings/EmbeddingValue;", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nEmbeddingValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddingValue.kt\ncom/openai/models/embeddings/EmbeddingValue$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n43#2:227\n43#2:228\n288#3,2:229\n*S KotlinDebug\n*F\n+ 1 EmbeddingValue.kt\ncom/openai/models/embeddings/EmbeddingValue$Deserializer\n*L\n192#1:227\n195#1:228\n206#1:229,2\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<EmbeddingValue> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(EmbeddingValue.class));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected EmbeddingValue deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            Object v9;
            EmbeddingValue embeddingValue;
            List bestMatches2;
            block9: {
                EmbeddingValue embeddingValue2;
                EmbeddingValue embeddingValue3;
                EmbeddingValue embeddingValue4;
                String it;
                Object[] objectArray;
                int n;
                int $i$f$jacksonTypeRef;
                Object[] objectArray2;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                JsonValue json2 = JsonValue.Companion.fromJsonNode(node);
                Object[] objectArray3 = objectArray2 = new EmbeddingValue[2];
                int n2 = $i$f$jacksonTypeRef = 0;
                List list2 = (List)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<List<? extends Float>>(){});
                if (list2 != null) {
                    List list3 = list2;
                    n = n2;
                    objectArray = objectArray3;
                    boolean bl = false;
                    embeddingValue4 = new EmbeddingValue((List)((Object)it), null, json2, 2, null);
                    objectArray3 = objectArray;
                    n2 = n;
                    embeddingValue3 = embeddingValue4;
                } else {
                    embeddingValue3 = null;
                }
                objectArray3[n2] = embeddingValue3;
                Object[] objectArray4 = objectArray2;
                int n3 = 1;
                $i$f$jacksonTypeRef = 0;
                String string = (String)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<String>(){});
                if (string != null) {
                    it = string;
                    n = n3;
                    objectArray = objectArray4;
                    boolean bl = false;
                    embeddingValue4 = new EmbeddingValue(null, it, json2, 1, null);
                    objectArray4 = objectArray;
                    n3 = n;
                    embeddingValue2 = embeddingValue4;
                } else {
                    embeddingValue2 = null;
                }
                objectArray4[n3] = embeddingValue2;
                bestMatches2 = CollectionsKt.toList((Iterable)Utils.allMaxBy(SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray2)), deserialize.bestMatches.3.INSTANCE));
                switch (bestMatches2.size()) {
                    case 0: {
                        embeddingValue = new EmbeddingValue(null, null, json2, 3, null);
                        return embeddingValue;
                    }
                    case 1: {
                        embeddingValue = (EmbeddingValue)CollectionsKt.single((List)bestMatches2);
                        return embeddingValue;
                    }
                }
                Iterable $this$firstOrNull$iv = bestMatches2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EmbeddingValue it2 = (EmbeddingValue)element$iv;
                    boolean bl = false;
                    if (!it2.isValid()) continue;
                    v9 = element$iv;
                    break block9;
                }
                v9 = null;
            }
            EmbeddingValue embeddingValue5 = v9;
            embeddingValue = embeddingValue5;
            if (embeddingValue5 != null) return embeddingValue;
            embeddingValue = (EmbeddingValue)CollectionsKt.first((List)bestMatches2);
            return embeddingValue;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/openai/models/embeddings/EmbeddingValue$Serializer;", "Lcom/openai/core/BaseSerializer;", "Lcom/openai/models/embeddings/EmbeddingValue;", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "openai-java-core"})
    public static final class Serializer
    extends BaseSerializer<EmbeddingValue> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(EmbeddingValue.class));
        }

        public void serialize(@NotNull EmbeddingValue value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (value.floats != null) {
                generator.writeObject((Object)value.floats);
            } else if (value.base64 != null) {
                generator.writeObject((Object)value.base64);
            } else if (value._json != null) {
                generator.writeObject((Object)value._json);
            } else {
                throw new IllegalStateException("Invalid EmbeddingValue");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u000b\u001a\u00028\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH&\u00a2\u0006\u0002\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/openai/models/embeddings/EmbeddingValue$Visitor;", "T", "", "unknown", "json", "Lcom/openai/core/JsonValue;", "(Lcom/openai/core/JsonValue;)Ljava/lang/Object;", "visitBase64", "base64", "", "(Ljava/lang/String;)Ljava/lang/Object;", "visitFloats", "floats", "", "", "(Ljava/util/List;)Ljava/lang/Object;", "openai-java-core"})
    public static interface Visitor<T> {
        public T visitFloats(@NotNull List<Float> var1);

        public T visitBase64(@NotNull String var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new OpenAIInvalidDataException("Unknown EmbeddingValue: " + json2, null, 2, null);
        }
    }
}

