/*
 * Decompiled with CFR 0.152.
 */
package com.openai.services.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.openai.core.ClientOptions;
import com.openai.core.PrepareRequest;
import com.openai.core.RequestOptions;
import com.openai.core.handlers.ErrorHandler;
import com.openai.core.http.HttpMethod;
import com.openai.core.http.HttpRequest;
import com.openai.core.http.HttpRequestBody;
import com.openai.core.http.HttpResponse;
import com.openai.core.http.HttpResponseFor;
import com.openai.core.http.HttpResponseForKt;
import com.openai.errors.OpenAIError;
import com.openai.errors.OpenAIException;
import com.openai.models.Model;
import com.openai.models.ModelDeleteParams;
import com.openai.models.ModelDeleted;
import com.openai.models.ModelListPage;
import com.openai.models.ModelListParams;
import com.openai.models.ModelRetrieveParams;
import com.openai.services.blocking.ModelService;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/openai/services/blocking/ModelServiceImpl;", "Lcom/openai/services/blocking/ModelService;", "clientOptions", "Lcom/openai/core/ClientOptions;", "<init>", "(Lcom/openai/core/ClientOptions;)V", "withRawResponse", "Lcom/openai/services/blocking/ModelService$WithRawResponse;", "getWithRawResponse", "()Lcom/openai/services/blocking/ModelService$WithRawResponse;", "withRawResponse$delegate", "Lkotlin/Lazy;", "retrieve", "Lcom/openai/models/Model;", "params", "Lcom/openai/models/ModelRetrieveParams;", "requestOptions", "Lcom/openai/core/RequestOptions;", "list", "Lcom/openai/models/ModelListPage;", "Lcom/openai/models/ModelListParams;", "delete", "Lcom/openai/models/ModelDeleted;", "Lcom/openai/models/ModelDeleteParams;", "WithRawResponseImpl", "openai-java-core"})
public final class ModelServiceImpl
implements ModelService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final Lazy withRawResponse$delegate;

    public ModelServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.withRawResponse$delegate = LazyKt.lazy(() -> ModelServiceImpl.withRawResponse_delegate$lambda$0(this));
    }

    private final ModelService.WithRawResponse getWithRawResponse() {
        Lazy lazy = this.withRawResponse$delegate;
        return (ModelService.WithRawResponse)lazy.getValue();
    }

    @Override
    @NotNull
    public ModelService.WithRawResponse withRawResponse() {
        return this.getWithRawResponse();
    }

    @Override
    @NotNull
    public Model retrieve(@NotNull ModelRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().retrieve(params, requestOptions).parse();
    }

    @Override
    @NotNull
    public ModelListPage list(@NotNull ModelListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().list(params, requestOptions).parse();
    }

    @Override
    @NotNull
    public ModelDeleted delete(@NotNull ModelDeleteParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        return this.withRawResponse().delete(params, requestOptions).parse();
    }

    private static final WithRawResponseImpl withRawResponse_delegate$lambda$0(ModelServiceImpl this$0) {
        return new WithRawResponseImpl(this$0.clientOptions);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\u0006\u0010\r\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/openai/services/blocking/ModelServiceImpl$WithRawResponseImpl;", "Lcom/openai/services/blocking/ModelService$WithRawResponse;", "clientOptions", "Lcom/openai/core/ClientOptions;", "<init>", "(Lcom/openai/core/ClientOptions;)V", "errorHandler", "Lcom/openai/core/http/HttpResponse$Handler;", "Lcom/openai/errors/OpenAIError;", "retrieveHandler", "Lcom/openai/models/Model;", "retrieve", "Lcom/openai/core/http/HttpResponseFor;", "params", "Lcom/openai/models/ModelRetrieveParams;", "requestOptions", "Lcom/openai/core/RequestOptions;", "listHandler", "Lcom/openai/models/ModelListPage$Response;", "list", "Lcom/openai/models/ModelListPage;", "Lcom/openai/models/ModelListParams;", "deleteHandler", "Lcom/openai/models/ModelDeleted;", "delete", "Lcom/openai/models/ModelDeleteParams;", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nModelServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelServiceImpl.kt\ncom/openai/services/blocking/ModelServiceImpl$WithRawResponseImpl\n+ 2 JsonHandler.kt\ncom/openai/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 HttpRequestBodies.kt\ncom/openai/core/http/HttpRequestBodies\n*L\n1#1,133:1\n13#2,9:134\n13#2,9:143\n13#2,9:152\n1#3:161\n22#4:162\n34#4:163\n*S KotlinDebug\n*F\n+ 1 ModelServiceImpl.kt\ncom/openai/services/blocking/ModelServiceImpl$WithRawResponseImpl\n*L\n52#1:134,9\n78#1:143,9\n106#1:152,9\n116#1:162\n116#1:163\n*E\n"})
    public static final class WithRawResponseImpl
    implements ModelService.WithRawResponse {
        @NotNull
        private final ClientOptions clientOptions;
        @NotNull
        private final HttpResponse.Handler<OpenAIError> errorHandler;
        @NotNull
        private final HttpResponse.Handler<Model> retrieveHandler;
        @NotNull
        private final HttpResponse.Handler<ModelListPage.Response> listHandler;
        @NotNull
        private final HttpResponse.Handler<ModelDeleted> deleteHandler;

        public WithRawResponseImpl(@NotNull ClientOptions clientOptions) {
            Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
            this.clientOptions = clientOptions;
            this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
            JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
            boolean $i$f$jsonHandler = false;
            this.retrieveHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Model>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public Model handle(HttpResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Model>(){});
                    }
                    catch (Exception e) {
                        throw new OpenAIException("Error reading response", e);
                    }
                }
            }, this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelListPage.Response>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public ModelListPage.Response handle(HttpResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelListPage.Response>(){});
                    }
                    catch (Exception e) {
                        throw new OpenAIException("Error reading response", e);
                    }
                }
            }, this.errorHandler);
            jsonMapper$iv = this.clientOptions.jsonMapper();
            $i$f$jsonHandler = false;
            this.deleteHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelDeleted>(jsonMapper$iv){
                final /* synthetic */ JsonMapper $jsonMapper;
                {
                    this.$jsonMapper = $jsonMapper;
                }

                public ModelDeleted handle(HttpResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    try {
                        boolean $i$f$jacksonTypeRef = false;
                        return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelDeleted>(){});
                    }
                    catch (Exception e) {
                        throw new OpenAIException("Error reading response", e);
                    }
                }
            }, this.errorHandler);
        }

        @Override
        @NotNull
        public HttpResponseFor<Model> retrieve(@NotNull ModelRetrieveParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"models", params.getPathParam(0)};
            HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, params.model());
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$openai_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions2);
            return HttpResponseForKt.parseable(response, () -> WithRawResponseImpl.retrieve$lambda$2(response, this, requestOptions2));
        }

        @Override
        @NotNull
        public HttpResponseFor<ModelListPage> list(@NotNull ModelListParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            String[] stringArray = new String[]{"models"};
            HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$openai_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions2);
            return HttpResponseForKt.parseable(response, () -> WithRawResponseImpl.list$lambda$6(response, this, requestOptions2, params));
        }

        @Override
        @NotNull
        public HttpResponseFor<ModelDeleted> delete(@NotNull ModelDeleteParams params, @NotNull RequestOptions requestOptions) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
            Object object = new String[]{"models", params.getPathParam(0)};
            Object $this$delete_u24lambda_u249 = object = HttpRequest.Companion.builder().method(HttpMethod.DELETE).addPathSegments((String[])object);
            boolean bl = false;
            params._body$openai_java_core().ifPresent(arg_0 -> WithRawResponseImpl.delete$lambda$9$lambda$8(arg_0 -> WithRawResponseImpl.delete$lambda$9$lambda$7((HttpRequest.Builder)$this$delete_u24lambda_u249, this, arg_0), arg_0));
            HttpRequest request = PrepareRequest.prepare(((HttpRequest.Builder)object).build(), this.clientOptions, params, params.model());
            RequestOptions requestOptions2 = requestOptions.applyDefaults(RequestOptions.Companion.from$openai_java_core(this.clientOptions));
            HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions2);
            return HttpResponseForKt.parseable(response, () -> WithRawResponseImpl.delete$lambda$12(response, this, requestOptions2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Model retrieve$lambda$2(HttpResponse $response, WithRawResponseImpl this$0, RequestOptions $requestOptions) {
            Object it;
            Object object = $response;
            Throwable throwable = null;
            try {
                it = (HttpResponse)object;
                boolean bl = false;
                it = this$0.retrieveHandler.handle((HttpResponse)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Object it2 = object = it;
            boolean bl = false;
            Boolean bl2 = $requestOptions.getResponseValidation();
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                ((Model)it2).validate();
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final ModelListPage list$lambda$6(HttpResponse $response, WithRawResponseImpl this$0, RequestOptions $requestOptions, ModelListParams $params) {
            Object it;
            Object object = $response;
            Throwable throwable = null;
            try {
                it = (HttpResponse)object;
                boolean bl = false;
                it = this$0.listHandler.handle((HttpResponse)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Object it2 = object = it;
            boolean bl = false;
            Boolean bl2 = $requestOptions.getResponseValidation();
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                ((ModelListPage.Response)it2).validate();
            }
            it2 = object;
            boolean bl3 = false;
            return ModelListPage.Companion.of(new ModelServiceImpl(this$0.clientOptions), $params, (ModelListPage.Response)it2);
        }

        private static final Unit delete$lambda$9$lambda$7(HttpRequest.Builder $this_apply, WithRawResponseImpl this$0, Map it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            JsonMapper jsonMapper$iv = this$0.clientOptions.jsonMapper();
            boolean $i$f$json = false;
            $this_apply.body(new HttpRequestBody(jsonMapper$iv, it){
                private final Lazy bytes$delegate;
                {
                    this.bytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>($jsonMapper, $value){
                        final /* synthetic */ JsonMapper $jsonMapper;
                        final /* synthetic */ T $value;
                        {
                            this.$jsonMapper = $jsonMapper;
                            this.$value = $value;
                        }

                        public final byte[] invoke() {
                            return this.$jsonMapper.writeValueAsBytes(this.$value);
                        }
                    }));
                }

                private final byte[] getBytes() {
                    Lazy lazy = this.bytes$delegate;
                    Object object = lazy.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                    return (byte[])object;
                }

                public void writeTo(OutputStream outputStream) {
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    outputStream.write(this.getBytes());
                }

                public String contentType() {
                    return "application/json";
                }

                public long contentLength() {
                    return this.getBytes().length;
                }

                public boolean repeatable() {
                    return true;
                }

                public void close() {
                }
            });
            return Unit.INSTANCE;
        }

        private static final void delete$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final ModelDeleted delete$lambda$12(HttpResponse $response, WithRawResponseImpl this$0, RequestOptions $requestOptions) {
            Object it;
            Object object = $response;
            Throwable throwable = null;
            try {
                it = (HttpResponse)object;
                boolean bl = false;
                it = this$0.deleteHandler.handle((HttpResponse)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            Object it2 = object = it;
            boolean bl = false;
            Boolean bl2 = $requestOptions.getResponseValidation();
            Intrinsics.checkNotNull((Object)bl2);
            if (bl2.booleanValue()) {
                ((ModelDeleted)it2).validate();
            }
            return object;
        }
    }
}

