/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.repository.http;

import com.ontotext.graphdb.repository.http.GraphDBHTTPRepository;
import com.ontotext.graphdb.repository.http.GraphDBProtocolSession;
import com.ontotext.graphdb.repository.http.GraphDBScheduledThreadPoolExecutor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;

class GraphDBSharedHttpClientSessionManager
extends SharedHttpClientSessionManager {
    private final ScheduledExecutorService executor;
    private final GraphDBHTTPRepository repository;

    GraphDBSharedHttpClientSessionManager(HttpClientBuilder httpClientBuilder, GraphDBHTTPRepository repository) {
        this(GraphDBSharedHttpClientSessionManager.createHttpClient(httpClientBuilder), repository, new GraphDBScheduledThreadPoolExecutor());
    }

    private GraphDBSharedHttpClientSessionManager(CloseableHttpClient httpClient, GraphDBHTTPRepository repository, ScheduledExecutorService executor) {
        super(httpClient, executor);
        this.repository = repository;
        this.executor = executor;
    }

    public RDF4JProtocolSession createRDF4JProtocolSession(String serverURL) {
        GraphDBProtocolSession session = new GraphDBProtocolSession(this.getHttpClient(), this.executor, this.repository);
        session.setServerURL(serverURL);
        return session;
    }

    private static CloseableHttpClient createHttpClient(HttpClientBuilder httpClientBuilder) {
        if (httpClientBuilder == null) {
            httpClientBuilder = GraphDBSharedHttpClientSessionManager.createDefaultHttpClientBuilder();
        }
        return httpClientBuilder.build();
    }

    static HttpClientBuilder createDefaultHttpClientBuilder() {
        return HttpClientBuilder.create().useSystemProperties().disableAutomaticRetries();
    }
}

