/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.repository.http;

import com.ontotext.graphdb.repository.http.GraphDBGraphQuery;
import com.ontotext.graphdb.repository.http.GraphDBProtocolSession;
import com.ontotext.graphdb.repository.http.GraphDBRequestPreprocessor;
import com.ontotext.graphdb.repository.http.GraphDBTupleQuery;
import com.ontotext.graphdb.repository.http.RequestHeaderAware;
import com.ontotext.graphdb.repository.http.ResponseHeaderAware;
import java.util.List;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.repository.http.HTTPRepository;
import org.eclipse.rdf4j.repository.http.HTTPRepositoryConnectionOffshore;

class GraphDBHTTPRepositoryConnection
extends HTTPRepositoryConnectionOffshore
implements RequestHeaderAware,
ResponseHeaderAware {
    private final GraphDBProtocolSession protocolSession;

    GraphDBHTTPRepositoryConnection(HTTPRepository repository, GraphDBProtocolSession protocolSession) {
        super(repository, protocolSession);
        this.protocolSession = protocolSession;
    }

    @Override
    public void setHeader(String name, String value) {
        this.protocolSession.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.protocolSession.addHeader(name, value);
    }

    @Override
    public void removeHeader(String name) {
        this.protocolSession.removeHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.protocolSession.getHeaders(name);
    }

    @Override
    public String getFirstHeader(String name) {
        return this.protocolSession.getFirstHeader(name);
    }

    @Override
    public void setRequestPreprocessor(GraphDBRequestPreprocessor requestPreprocessor) {
        this.protocolSession.setRequestPreprocessor(requestPreprocessor);
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new GraphDBTupleQuery(super.prepareTupleQuery(ql, queryString, baseURI), this.protocolSession);
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new GraphDBGraphQuery(super.prepareGraphQuery(ql, queryString, baseURI), this.protocolSession);
    }
}

