/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.service.settings;

import com.onlyoffice.client.DocumentServerClient;
import com.onlyoffice.exception.DocumentServerResponseException;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.commandservice.CommandRequest;
import com.onlyoffice.model.commandservice.CommandResponse;
import com.onlyoffice.model.commandservice.commandrequest.Command;
import com.onlyoffice.model.common.CommonResponse;
import com.onlyoffice.model.convertservice.ConvertRequest;
import com.onlyoffice.model.convertservice.ConvertResponse;
import com.onlyoffice.model.settings.HttpClientSettings;
import com.onlyoffice.model.settings.security.Security;
import com.onlyoffice.model.settings.validation.ValidationResult;
import com.onlyoffice.model.settings.validation.status.Status;
import com.onlyoffice.service.settings.SettingsValidationService;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;

public class DefaultSettingsValidationServiceV2
implements SettingsValidationService {
    private DocumentServerClient documentServerClient;
    private UrlManager urlManager;

    @Override
    public ValidationResult checkDocumentServer() {
        Boolean healthcheck = this.documentServerClient.healthcheck();
        if (healthcheck.booleanValue()) {
            return ValidationResult.builder().status(Status.SUCCESS).build();
        }
        return ValidationResult.builder().status(Status.FAILED).error(CommonResponse.Error.HEALTHCHECK).build();
    }

    @Override
    public ValidationResult checkConvertService(String productUrl) {
        String testConvertUrl = this.urlManager.getTestConvertUrl(productUrl);
        ConvertRequest convertRequest = ConvertRequest.builder().async(false).filetype("txt").outputtype("docx").key(new SimpleDateFormat("MMddyyyyHHmmss").format(new Date())).url(testConvertUrl).build();
        ConvertResponse convertResponse = this.documentServerClient.convert(convertRequest);
        if (convertResponse.getError() != null) {
            return ValidationResult.builder().status(Status.FAILED).error(convertResponse.getError()).build();
        }
        String fileUrl = convertResponse.getFileUrl();
        try {
            byte[] bytes = this.documentServerClient.getFile(fileUrl);
            if (bytes.length > 0) {
                return ValidationResult.builder().status(Status.SUCCESS).build();
            }
            return ValidationResult.builder().status(Status.FAILED).error(CommonResponse.Error.DOWNLOAD_RESULT).build();
        }
        catch (DocumentServerResponseException e) {
            return ValidationResult.builder().status(Status.FAILED).error(CommonResponse.Error.DOWNLOAD_RESULT).build();
        }
    }

    @Override
    public ValidationResult checkCommandService() {
        CommandRequest commandRequest = CommandRequest.builder().c(Command.VERSION).build();
        CommandResponse commandResponse = this.documentServerClient.command(commandRequest);
        if (commandResponse.getError() != null && commandResponse.getError().equals(CommandResponse.Error.NO)) {
            return ValidationResult.builder().status(Status.SUCCESS).build();
        }
        return ValidationResult.builder().status(Status.FAILED).error(commandResponse.getError()).build();
    }

    @Override
    public ValidationResult checkDocumentServer(String url, HttpClientSettings httpClientSettings) {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Override
    public ValidationResult checkConvertService() {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Override
    public ValidationResult checkConvertService(String url, String productInnerUrl, Security security, HttpClientSettings httpClientSettings) {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Override
    public ValidationResult checkCommandService(String url, Security security, HttpClientSettings httpClientSettings) {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Generated
    public DefaultSettingsValidationServiceV2(DocumentServerClient documentServerClient, UrlManager urlManager) {
        this.documentServerClient = documentServerClient;
        this.urlManager = urlManager;
    }

    @Generated
    protected DocumentServerClient getDocumentServerClient() {
        return this.documentServerClient;
    }

    @Generated
    protected void setDocumentServerClient(DocumentServerClient documentServerClient) {
        this.documentServerClient = documentServerClient;
    }

    @Generated
    protected UrlManager getUrlManager() {
        return this.urlManager;
    }

    @Generated
    protected void setUrlManager(UrlManager urlManager) {
        this.urlManager = urlManager;
    }
}

