/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.model.documenteditor.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.onlyoffice.model.documenteditor.config.document.Info;
import com.onlyoffice.model.documenteditor.config.document.Permissions;
import com.onlyoffice.model.documenteditor.config.document.ReferenceData;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class Document {
    private String fileType;
    private String key;
    private ReferenceData referenceData;
    private String title;
    private String url;
    private Info info;
    private Permissions permissions;

    Document(String fileType, String key, ReferenceData referenceData, String title, String url, Info info, Permissions permissions) {
        this.fileType = fileType;
        this.key = key;
        this.referenceData = referenceData;
        this.title = title;
        this.url = url;
        this.info = info;
        this.permissions = permissions;
    }

    public static DocumentBuilder builder() {
        return new DocumentBuilder();
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getKey() {
        return this.key;
    }

    public ReferenceData getReferenceData() {
        return this.referenceData;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public Info getInfo() {
        return this.info;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setReferenceData(ReferenceData referenceData) {
        this.referenceData = referenceData;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public static class DocumentBuilder {
        private String fileType;
        private String key;
        private ReferenceData referenceData;
        private String title;
        private String url;
        private Info info;
        private Permissions permissions;

        DocumentBuilder() {
        }

        public DocumentBuilder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public DocumentBuilder key(String key) {
            this.key = key;
            return this;
        }

        public DocumentBuilder referenceData(ReferenceData referenceData) {
            this.referenceData = referenceData;
            return this;
        }

        public DocumentBuilder title(String title) {
            this.title = title;
            return this;
        }

        public DocumentBuilder url(String url) {
            this.url = url;
            return this;
        }

        public DocumentBuilder info(Info info) {
            this.info = info;
            return this;
        }

        public DocumentBuilder permissions(Permissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public Document build() {
            return new Document(this.fileType, this.key, this.referenceData, this.title, this.url, this.info, this.permissions);
        }

        public String toString() {
            return "Document.DocumentBuilder(fileType=" + this.fileType + ", key=" + this.key + ", referenceData=" + this.referenceData + ", title=" + this.title + ", url=" + this.url + ", info=" + this.info + ", permissions=" + this.permissions + ")";
        }
    }
}

