/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.manager.document;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.onlyoffice.manager.document.DocumentManager;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.model.common.Format;
import com.onlyoffice.model.documenteditor.config.document.DocumentType;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class DefaultDocumentManager
implements DocumentManager {
    private static final int DEFAULT_MAX_FILE_SIZE = 0x500000;
    private SettingsManager settingsManager;
    private static List<Format> formats;

    @Override
    public List<Format> getFormats() {
        return formats;
    }

    @Override
    public abstract String getDocumentKey(String var1, boolean var2);

    @Override
    public abstract String getDocumentName(String var1);

    @Override
    public String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (!fileName.contains(".")) {
            return null;
        }
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (extension.isEmpty()) {
            return null;
        }
        return extension.toLowerCase();
    }

    @Override
    public String getBaseName(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (!fileName.contains(".")) {
            return fileName;
        }
        String baseName = fileName.substring(0, fileName.lastIndexOf("."));
        if (baseName.isEmpty()) {
            return null;
        }
        return baseName;
    }

    @Override
    public DocumentType getDocumentType(String fileName) {
        String fileExtension = this.getExtension(fileName);
        for (Format format : formats) {
            if (!format.getName().equals(fileExtension)) continue;
            return format.getType();
        }
        return null;
    }

    @Override
    public boolean isEditable(String fileName) {
        String extension = this.getExtension(fileName);
        if (extension == null) {
            return false;
        }
        Boolean lossyEditable = this.getLossyEditableMap().get(extension);
        if (lossyEditable != null) {
            return this.hasAction(fileName, "edit") || lossyEditable != false;
        }
        return this.hasAction(fileName, "edit");
    }

    @Override
    public boolean isViewable(String fileName) {
        return this.hasAction(fileName, "view");
    }

    @Override
    public boolean isFillable(String fileName) {
        return this.hasAction(fileName, "fill");
    }

    @Override
    public boolean hasAction(String fileName, String action) {
        String fileExtension = this.getExtension(fileName);
        if (fileExtension == null) {
            return false;
        }
        for (Format format : formats) {
            if (!format.getName().equals(fileExtension) || !format.getActions().contains(action)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream getNewBlankFile(String extension, Locale locale) {
        String pathTemplate = "assets/document-templates/{0}/new.{1}";
        String path = MessageFormat.format(pathTemplate, locale.toLanguageTag(), extension);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            path = MessageFormat.format(pathTemplate, locale.getLanguage(), extension);
            inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        if (inputStream == null) {
            path = MessageFormat.format(pathTemplate, "en", extension);
            inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        return inputStream;
    }

    @Override
    public String getDefaultExtension(DocumentType documentType) {
        if (documentType == null) {
            return null;
        }
        switch (documentType) {
            case WORD: {
                return "docx";
            }
            case CELL: {
                return "xlsx";
            }
            case SLIDE: {
                return "pptx";
            }
        }
        return null;
    }

    @Override
    public String getDefaultConvertExtension(String fileName) {
        String extension = this.getExtension(fileName);
        if (extension == null) {
            return null;
        }
        for (Format format : formats) {
            if (!format.getName().equals(extension)) continue;
            switch (format.getType()) {
                case WORD: {
                    if (format.getName().equals("docxf") && format.getConvert().contains("oform")) {
                        return "oform";
                    }
                    if (!format.getConvert().contains("docx")) break;
                    return "docx";
                }
                case CELL: {
                    if (!format.getConvert().contains("xlsx")) break;
                    return "xlsx";
                }
                case SLIDE: {
                    if (!format.getConvert().contains("pptx")) break;
                    return "pptx";
                }
            }
        }
        return null;
    }

    @Override
    public List<String> getConvertExtensionList(String fileName) {
        String extension = this.getExtension(fileName);
        if (extension == null) {
            return null;
        }
        for (Format format : formats) {
            if (!format.getName().equals(extension)) continue;
            return format.getConvert();
        }
        return null;
    }

    @Override
    public Map<String, Boolean> getLossyEditableMap() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        List<Object> formatsLossyEditList = new ArrayList();
        String formatsLossyEdit = this.settingsManager.getSetting("lossyEdit");
        if (formatsLossyEdit != null && !formatsLossyEdit.isEmpty()) {
            formatsLossyEditList = Arrays.asList(formatsLossyEdit.replace("[", "").replace("]", "").split(", "));
        }
        for (Format format : formats) {
            if (!format.getActions().contains("lossy-edit")) continue;
            result.put(format.getName(), formatsLossyEditList.contains(format.getName()));
        }
        return result;
    }

    @Override
    public List<String> getInsertImageExtensions() {
        return this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getEditingService().getInsertImage();
    }

    @Override
    public List<String> getCompareFileExtensions() {
        List<Format> supportedFormats = formats;
        ArrayList<String> result = new ArrayList<String>();
        for (Format format : supportedFormats) {
            if (!DocumentType.WORD.equals((Object)format.getType())) continue;
            result.add(format.getName());
        }
        return result;
    }

    @Override
    public List<String> getMailMergeExtensions() {
        List<Format> supportedFormats = formats;
        ArrayList<String> result = new ArrayList<String>();
        for (Format format : supportedFormats) {
            if (!DocumentType.CELL.equals((Object)format.getType())) continue;
            result.add(format.getName());
        }
        return result;
    }

    @Override
    public long getMaxFileSize() {
        long size = this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getEditingService().getMaxFileSize();
        return size > 0L ? size : 0x500000L;
    }

    @Override
    public long getMaxConversionFileSize() {
        long size = this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getConvertService().getMaxFileSize();
        return size > 0L ? size : 0x500000L;
    }

    protected static void init() {
        ObjectMapper objectMapper = new ObjectMapper();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/document-formats/onlyoffice-docs-formats.json");
        try {
            formats = (List)objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).readValue(inputStream, (TypeReference)new TypeReference<List<Format>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DefaultDocumentManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    protected SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    protected void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    static {
        DefaultDocumentManager.init();
    }
}

