/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.registration.impl;

import android.content.Context;
import android.util.Base64;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.FirebaseMessaging;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.config.FCMConfigModel;
import com.onesignal.core.internal.device.IDeviceService;
import com.onesignal.notifications.internal.registration.impl.GooglePlayServicesUpgradePrompt;
import com.onesignal.notifications.internal.registration.impl.PushRegistratorAbstractGoogle;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lcom/onesignal/notifications/internal/registration/impl/PushRegistratorFCM;", "Lcom/onesignal/notifications/internal/registration/impl/PushRegistratorAbstractGoogle;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "upgradePrompt", "Lcom/onesignal/notifications/internal/registration/impl/GooglePlayServicesUpgradePrompt;", "deviceService", "Lcom/onesignal/core/internal/device/IDeviceService;", "(Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/notifications/internal/registration/impl/GooglePlayServicesUpgradePrompt;Lcom/onesignal/core/internal/device/IDeviceService;)V", "get_applicationService", "()Lcom/onesignal/core/internal/application/IApplicationService;", "get_configModelStore", "()Lcom/onesignal/core/internal/config/ConfigModelStore;", "set_configModelStore", "(Lcom/onesignal/core/internal/config/ConfigModelStore;)V", "apiKey", "", "appId", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "projectId", "providerName", "getProviderName", "()Ljava/lang/String;", "getToken", "senderId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTokenWithClassFirebaseMessaging", "initFirebaseApp", "", "Companion", "com.onesignal.notifications"})
public final class PushRegistratorFCM
extends PushRegistratorAbstractGoogle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ConfigModelStore _configModelStore;
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final String projectId;
    @NotNull
    private final String appId;
    @NotNull
    private final String apiKey;
    @Nullable
    private FirebaseApp firebaseApp;
    @NotNull
    private static final String FCM_APP_NAME = "ONESIGNAL_SDK_FCM_APP_NAME";
    @NotNull
    private static final String FCM_DEFAULT_PROJECT_ID = "onesignal-shared-public";
    @NotNull
    private static final String FCM_DEFAULT_APP_ID = "1:754795614042:android:c682b8144a8dd52bc1ad63";
    @NotNull
    private static final String FCM_DEFAULT_API_KEY_BASE64 = "QUl6YVN5QW5UTG41LV80TWMyYTJQLWRLVWVFLWFCdGd5Q3JqbFlV";

    public PushRegistratorFCM(@NotNull ConfigModelStore _configModelStore, @NotNull IApplicationService _applicationService, @NotNull GooglePlayServicesUpgradePrompt upgradePrompt, @NotNull IDeviceService deviceService) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)upgradePrompt, (String)"upgradePrompt");
        Intrinsics.checkNotNullParameter((Object)deviceService, (String)"deviceService");
        super(deviceService, _configModelStore, upgradePrompt);
        this._configModelStore = _configModelStore;
        this._applicationService = _applicationService;
        FCMConfigModel fcpParams = ((ConfigModel)this._configModelStore.getModel()).getFcmParams();
        String string3 = fcpParams.getProjectId();
        if (string3 == null) {
            string3 = this.projectId = FCM_DEFAULT_PROJECT_ID;
        }
        if ((string2 = fcpParams.getAppId()) == null) {
            string2 = FCM_DEFAULT_APP_ID;
        }
        this.appId = string2;
        byte[] byArray = Base64.decode((String)FCM_DEFAULT_API_KEY_BASE64, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        String defaultApiKey = new String(byArray2, Charsets.UTF_8);
        String string4 = fcpParams.getApiKey();
        if (string4 == null) {
            string4 = defaultApiKey;
        }
        this.apiKey = string4;
    }

    @NotNull
    public final ConfigModelStore get_configModelStore() {
        return this._configModelStore;
    }

    public final void set_configModelStore(@NotNull ConfigModelStore configModelStore) {
        Intrinsics.checkNotNullParameter((Object)configModelStore, (String)"<set-?>");
        this._configModelStore = configModelStore;
    }

    @NotNull
    public final IApplicationService get_applicationService() {
        return this._applicationService;
    }

    @Override
    @NotNull
    public String getProviderName() {
        return "FCM";
    }

    @Override
    @Nullable
    public Object getToken(@NotNull String senderId, @NotNull Continuation<? super String> $completion) throws ExecutionException, InterruptedException {
        this.initFirebaseApp(senderId);
        return this.getTokenWithClassFirebaseMessaging();
    }

    private final String getTokenWithClassFirebaseMessaging() throws ExecutionException, InterruptedException {
        FirebaseApp firebaseApp = this.firebaseApp;
        Intrinsics.checkNotNull((Object)firebaseApp);
        FirebaseMessaging fcmInstance = (FirebaseMessaging)firebaseApp.get(FirebaseMessaging.class);
        Task task = fcmInstance.getToken();
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"getToken(...)");
        Task tokenTask = task;
        try {
            Object object = Tasks.await((Task)tokenTask);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"await(...)");
            return (String)object;
        }
        catch (ExecutionException e) {
            Exception exception = tokenTask.getException();
            throw exception == null ? (Throwable)e : (Throwable)exception;
        }
    }

    private final void initFirebaseApp(String senderId) {
        if (this.firebaseApp != null) {
            return;
        }
        FirebaseOptions firebaseOptions = new FirebaseOptions.Builder().setGcmSenderId(senderId).setApplicationId(this.appId).setApiKey(this.apiKey).setProjectId(this.projectId).build();
        Intrinsics.checkNotNullExpressionValue((Object)firebaseOptions, (String)"build(...)");
        FirebaseOptions firebaseOptions2 = firebaseOptions;
        this.firebaseApp = FirebaseApp.initializeApp((Context)this._applicationService.getAppContext(), (FirebaseOptions)firebaseOptions2, (String)FCM_APP_NAME);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/onesignal/notifications/internal/registration/impl/PushRegistratorFCM$Companion;", "", "()V", "FCM_APP_NAME", "", "FCM_DEFAULT_API_KEY_BASE64", "FCM_DEFAULT_APP_ID", "FCM_DEFAULT_PROJECT_ID", "com.onesignal.notifications"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

