/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.device.impl;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.onesignal.common.AndroidUtils;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.device.IDeviceService;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\nH\u0002J\b\u0010\u001a\u001a\u00020\nH\u0002J\b\u0010\u001b\u001a\u00020\nH\u0002J\b\u0010\u001c\u001a\u00020\nH\u0002J\b\u0010\u001d\u001a\u00020\nH\u0002J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\nH\u0002J\b\u0010\"\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\f\u00a8\u0006$"}, d2={"Lcom/onesignal/core/internal/device/impl/DeviceService;", "Lcom/onesignal/core/internal/device/IDeviceService;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "(Lcom/onesignal/core/internal/application/IApplicationService;)V", "deviceType", "Lcom/onesignal/core/internal/device/IDeviceService$DeviceType;", "getDeviceType", "()Lcom/onesignal/core/internal/device/IDeviceService$DeviceType;", "hasAllHMSLibrariesForPushKit", "", "getHasAllHMSLibrariesForPushKit", "()Z", "hasFCMLibrary", "getHasFCMLibrary", "isAndroidDeviceType", "isFireOSDeviceType", "isGMSInstalledAndEnabled", "isHuaweiDeviceType", "jetpackLibraryStatus", "Lcom/onesignal/core/internal/device/IDeviceService$JetpackLibraryStatus;", "getJetpackLibraryStatus", "()Lcom/onesignal/core/internal/device/IDeviceService$JetpackLibraryStatus;", "supportsHMS", "getSupportsHMS", "hasHMSAGConnectLibrary", "hasHMSAvailabilityLibrary", "hasHMSPushKitLibrary", "isHMSCoreInstalledAndEnabled", "isHMSCoreInstalledAndEnabledFallback", "packageInstalledAndEnabled", "packageName", "", "supportsADM", "supportsGooglePush", "Companion", "com.onesignal.core"})
public final class DeviceService
implements IDeviceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private static final String HMS_CORE_SERVICES_PACKAGE = "com.huawei.hwid";
    @NotNull
    private static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    @NotNull
    private static final String PREFER_HMS_METADATA_NAME = "com.onesignal.preferHMS";
    private static final int HMS_AVAILABLE_SUCCESSFUL = 0;

    public DeviceService(@NotNull IApplicationService _applicationService) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        this._applicationService = _applicationService;
    }

    @Override
    public boolean isAndroidDeviceType() {
        return this.getDeviceType() == IDeviceService.DeviceType.Android;
    }

    @Override
    public boolean isFireOSDeviceType() {
        return this.getDeviceType() == IDeviceService.DeviceType.Fire;
    }

    @Override
    public boolean isHuaweiDeviceType() {
        return this.getDeviceType() == IDeviceService.DeviceType.Huawei;
    }

    @Override
    @NotNull
    public IDeviceService.DeviceType getDeviceType() {
        if (this.supportsADM()) {
            return IDeviceService.DeviceType.Fire;
        }
        boolean supportsHMS = this.getSupportsHMS();
        boolean supportsFCM = this.supportsGooglePush();
        if (supportsFCM && supportsHMS) {
            Context context = this._applicationService.getAppContext();
            boolean preferHMS = AndroidUtils.INSTANCE.getManifestMetaBoolean(context, PREFER_HMS_METADATA_NAME);
            return preferHMS ? IDeviceService.DeviceType.Huawei : IDeviceService.DeviceType.Android;
        }
        if (supportsFCM) {
            return IDeviceService.DeviceType.Android;
        }
        if (supportsHMS) {
            return IDeviceService.DeviceType.Huawei;
        }
        if (this.isGMSInstalledAndEnabled()) {
            return IDeviceService.DeviceType.Android;
        }
        return this.isHMSCoreInstalledAndEnabledFallback() ? IDeviceService.DeviceType.Huawei : IDeviceService.DeviceType.Android;
    }

    @Override
    @NotNull
    public IDeviceService.JetpackLibraryStatus getJetpackLibraryStatus() {
        boolean hasNotificationManagerCompat = AndroidUtils.INSTANCE.hasNotificationManagerCompat();
        if (!hasNotificationManagerCompat) {
            return IDeviceService.JetpackLibraryStatus.MISSING;
        }
        return IDeviceService.JetpackLibraryStatus.OK;
    }

    @Override
    public boolean supportsGooglePush() {
        return !this.getHasFCMLibrary() ? false : this.isGMSInstalledAndEnabled();
    }

    private final boolean isHMSCoreInstalledAndEnabledFallback() {
        return this.packageInstalledAndEnabled(HMS_CORE_SERVICES_PACKAGE);
    }

    @Override
    public boolean isGMSInstalledAndEnabled() {
        return this.packageInstalledAndEnabled(GOOGLE_PLAY_SERVICES_PACKAGE);
    }

    private final boolean packageInstalledAndEnabled(String packageName) {
        boolean bl;
        try {
            PackageManager pm = this._applicationService.getAppContext().getPackageManager();
            PackageInfo info = pm.getPackageInfo(packageName, 128);
            bl = info.applicationInfo.enabled;
        }
        catch (PackageManager.NameNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean getHasFCMLibrary() {
        boolean bl;
        try {
            Class.forName("com.google.firebase.messaging.FirebaseMessaging");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean getSupportsHMS() {
        return !this.hasHMSAvailabilityLibrary() || !this.getHasAllHMSLibrariesForPushKit() ? false : this.isHMSCoreInstalledAndEnabled();
    }

    private final boolean isHMSCoreInstalledAndEnabled() {
        try {
            Class<?> clazz = Class.forName("com.huawei.hms.api.HuaweiApiAvailability");
            Method newInstanceMethod = clazz.getMethod("getInstance", new Class[0]);
            Class[] classArray = new Class[]{Context.class};
            Method isHuaweiMobileServicesAvailableMethod = clazz.getMethod("isHuaweiMobileServicesAvailable", classArray);
            Object availabilityInstance = newInstanceMethod.invoke(null, new Object[0]);
            Object[] objectArray = new Object[]{this._applicationService.getAppContext()};
            Object object = isHuaweiMobileServicesAvailableMethod.invoke(availabilityInstance, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            int result = (Integer)object;
            return result == 0;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean getHasAllHMSLibrariesForPushKit() {
        return this.hasHMSAGConnectLibrary() && this.hasHMSPushKitLibrary();
    }

    private final boolean hasHMSAGConnectLibrary() {
        boolean bl;
        try {
            Class.forName("com.huawei.agconnect.config.AGConnectServicesConfig");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    private final boolean hasHMSPushKitLibrary() {
        boolean bl;
        try {
            Class.forName("com.huawei.hms.aaid.HmsInstanceId");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    private final boolean hasHMSAvailabilityLibrary() {
        boolean bl;
        try {
            Class.forName("com.huawei.hms.api.HuaweiApiAvailability");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    private final boolean supportsADM() {
        boolean bl;
        try {
            Class.forName("com.amazon.device.messaging.ADM");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/onesignal/core/internal/device/impl/DeviceService$Companion;", "", "()V", "GOOGLE_PLAY_SERVICES_PACKAGE", "", "HMS_AVAILABLE_SUCCESSFUL", "", "HMS_CORE_SERVICES_PACKAGE", "PREFER_HMS_METADATA_NAME", "com.onesignal.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

