/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.user.internal.service;

import com.onesignal.common.modeling.ISingletonModelStoreChangeHandler;
import com.onesignal.common.modeling.ModelChangedArgs;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.operations.IOperationRepo;
import com.onesignal.core.internal.startup.IBootstrapService;
import com.onesignal.debug.LogLevel;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.user.internal.identity.IdentityModel;
import com.onesignal.user.internal.identity.IdentityModelStore;
import com.onesignal.user.internal.operations.LoginUserOperation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/onesignal/user/internal/service/IdentityVerificationService;", "Lcom/onesignal/core/internal/startup/IBootstrapService;", "Lcom/onesignal/common/modeling/ISingletonModelStoreChangeHandler;", "Lcom/onesignal/core/internal/config/ConfigModel;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_identityModelStore", "Lcom/onesignal/user/internal/identity/IdentityModelStore;", "opRepo", "Lcom/onesignal/core/internal/operations/IOperationRepo;", "(Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/user/internal/identity/IdentityModelStore;Lcom/onesignal/core/internal/operations/IOperationRepo;)V", "bootstrap", "", "onModelReplaced", "model", "tag", "", "onModelUpdated", "args", "Lcom/onesignal/common/modeling/ModelChangedArgs;", "com.onesignal.core"})
public final class IdentityVerificationService
implements IBootstrapService,
ISingletonModelStoreChangeHandler<ConfigModel> {
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private final IdentityModelStore _identityModelStore;
    @NotNull
    private final IOperationRepo opRepo;

    public IdentityVerificationService(@NotNull ConfigModelStore _configModelStore, @NotNull IdentityModelStore _identityModelStore, @NotNull IOperationRepo opRepo) {
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)_identityModelStore, (String)"_identityModelStore");
        Intrinsics.checkNotNullParameter((Object)opRepo, (String)"opRepo");
        this._configModelStore = _configModelStore;
        this._identityModelStore = _identityModelStore;
        this.opRepo = opRepo;
    }

    @Override
    public void bootstrap() {
        this._configModelStore.subscribe(this);
    }

    @Override
    public void onModelReplaced(@NotNull ConfigModel model, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!Intrinsics.areEqual((Object)tag, (Object)"HYDRATE")) {
            return;
        }
        if (model.getUseIdentityVerification() && ((IdentityModel)this._identityModelStore.getModel()).getJwtToken() == null) {
            Logging.log(LogLevel.INFO, "A valid JWT is required for user " + ((IdentityModel)this._identityModelStore.getModel()).getExternalId() + '.');
            return;
        }
        IOperationRepo.DefaultImpls.enqueue$default(this.opRepo, new LoginUserOperation(((ConfigModel)this._configModelStore.getModel()).getAppId(), ((IdentityModel)this._identityModelStore.getModel()).getOnesignalId(), ((IdentityModel)this._identityModelStore.getModel()).getExternalId(), null, 8, null), false, 2, null);
    }

    @Override
    public void onModelUpdated(@NotNull ModelChangedArgs args, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }
}

