/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.debug.internal.logging;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.util.Log;
import com.onesignal.common.threading.ThreadUtilsKt;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.debug.ILogListener;
import com.onesignal.debug.LogLevel;
import com.onesignal.debug.OneSignalLogEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0007J\"\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u001c\u0010#\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u001c\u0010$\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u001c\u0010%\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u001c\u0010&\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u0018\u0010'\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0004H\u0007J\"\u0010'\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\"\u0010(\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014J\"\u0010*\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u001c\u0010+\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u001c\u0010,\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0011\u00a8\u0006-"}, d2={"Lcom/onesignal/debug/internal/logging/Logging;", "", "()V", "TAG", "", "applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "getApplicationService", "()Lcom/onesignal/core/internal/application/IApplicationService;", "setApplicationService", "(Lcom/onesignal/core/internal/application/IApplicationService;)V", "logLevel", "Lcom/onesignal/debug/LogLevel;", "getLogLevel$annotations", "getLogLevel", "()Lcom/onesignal/debug/LogLevel;", "setLogLevel", "(Lcom/onesignal/debug/LogLevel;)V", "logListeners", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Lcom/onesignal/debug/ILogListener;", "visualLogLevel", "getVisualLogLevel$annotations", "getVisualLogLevel", "setVisualLogLevel", "addListener", "", "listener", "atLogLevel", "", "level", "callLogListeners", "message", "throwable", "", "debug", "error", "fatal", "info", "log", "logToLogcat", "removeListener", "showVisualLogging", "verbose", "warn", "com.onesignal.core"})
public final class Logging {
    @NotNull
    public static final Logging INSTANCE = new Logging();
    @NotNull
    private static final String TAG = "OneSignal";
    @Nullable
    private static IApplicationService applicationService;
    @NotNull
    private static final CopyOnWriteArraySet<ILogListener> logListeners;
    @NotNull
    private static LogLevel logLevel;
    @NotNull
    private static LogLevel visualLogLevel;

    private Logging() {
    }

    @Nullable
    public final IApplicationService getApplicationService() {
        return applicationService;
    }

    public final void setApplicationService(@Nullable IApplicationService iApplicationService) {
        applicationService = iApplicationService;
    }

    @NotNull
    public static final LogLevel getLogLevel() {
        return logLevel;
    }

    public static final void setLogLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
        Logging.logLevel = logLevel;
    }

    @JvmStatic
    public static /* synthetic */ void getLogLevel$annotations() {
    }

    @NotNull
    public static final LogLevel getVisualLogLevel() {
        return visualLogLevel;
    }

    public static final void setVisualLogLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
        visualLogLevel = logLevel;
    }

    @JvmStatic
    public static /* synthetic */ void getVisualLogLevel$annotations() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean atLogLevel(@NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        if (level.compareTo((Enum)visualLogLevel) < 1) return true;
        if (level.compareTo((Enum)logLevel) >= 1) return false;
        return true;
    }

    @JvmStatic
    public static final void verbose(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logging.log(LogLevel.VERBOSE, message, throwable);
    }

    public static /* synthetic */ void verbose$default(String string2, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        Logging.verbose(string2, throwable);
    }

    @JvmStatic
    public static final void debug(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logging.log(LogLevel.DEBUG, message, throwable);
    }

    public static /* synthetic */ void debug$default(String string2, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        Logging.debug(string2, throwable);
    }

    @JvmStatic
    public static final void info(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logging.log(LogLevel.INFO, message, throwable);
    }

    public static /* synthetic */ void info$default(String string2, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        Logging.info(string2, throwable);
    }

    @JvmStatic
    public static final void warn(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logging.log(LogLevel.WARN, message, throwable);
    }

    public static /* synthetic */ void warn$default(String string2, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        Logging.warn(string2, throwable);
    }

    @JvmStatic
    public static final void error(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logging.log(LogLevel.ERROR, message, throwable);
    }

    public static /* synthetic */ void error$default(String string2, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        Logging.error(string2, throwable);
    }

    @JvmStatic
    public static final void fatal(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logging.log(LogLevel.FATAL, message, throwable);
    }

    public static /* synthetic */ void fatal$default(String string2, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        Logging.fatal(string2, throwable);
    }

    @JvmStatic
    public static final void log(@NotNull LogLevel level, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logging.log(level, message, null);
    }

    @JvmStatic
    public static final void log(@NotNull LogLevel level, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String fullMessage = '[' + Thread.currentThread().getName() + "] " + message;
        INSTANCE.logToLogcat(level, fullMessage, throwable);
        INSTANCE.showVisualLogging(level, fullMessage, throwable);
        INSTANCE.callLogListeners(level, fullMessage, throwable);
    }

    private final void logToLogcat(LogLevel level, String message, Throwable throwable) {
        if (level.compareTo((Enum)logLevel) >= 1) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                Log.v((String)TAG, (String)message, (Throwable)throwable);
                break;
            }
            case 2: {
                Log.d((String)TAG, (String)message, (Throwable)throwable);
                break;
            }
            case 3: {
                Log.i((String)TAG, (String)message, (Throwable)throwable);
                break;
            }
            case 4: {
                Log.w((String)TAG, (String)message, (Throwable)throwable);
                break;
            }
            case 5: 
            case 6: {
                Log.e((String)TAG, (String)message, (Throwable)throwable);
            }
        }
    }

    private final void showVisualLogging(LogLevel level, String message, Throwable throwable) {
        if (level.compareTo((Enum)visualLogLevel) >= 1) {
            return;
        }
        try {
            String fullMessage = StringsKt.trimIndent((String)(message + '\n'));
            if (throwable != null) {
                fullMessage = fullMessage + throwable.getMessage();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                throwable.printStackTrace(pw);
                fullMessage = fullMessage + sw;
            }
            String finalFullMessage = fullMessage;
            ThreadUtilsKt.suspendifyOnMain((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(level, finalFullMessage, null){
                int label;
                final /* synthetic */ LogLevel $level;
                final /* synthetic */ String $finalFullMessage;
                {
                    this.$level = $level;
                    this.$finalFullMessage = $finalFullMessage;
                    super(1, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Activity currentActivity;
                            ResultKt.throwOnFailure((Object)object);
                            IApplicationService iApplicationService = Logging.INSTANCE.getApplicationService();
                            Object object2 = currentActivity = iApplicationService != null ? iApplicationService.getCurrent() : null;
                            if (currentActivity != null) {
                                new AlertDialog.Builder((Context)currentActivity).setTitle((CharSequence)this.$level.toString()).setMessage((CharSequence)this.$finalFullMessage).show();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"Error showing logging message.", (Throwable)t);
        }
    }

    private final void callLogListeners(LogLevel level, String message, Throwable throwable) {
        if (logListeners.isEmpty()) {
            return;
        }
        String logEntry = message;
        if (throwable != null) {
            logEntry = logEntry + '\n' + Log.getStackTraceString((Throwable)throwable);
        }
        for (ILogListener listener : logListeners) {
            listener.onLogEvent(new OneSignalLogEvent(level, logEntry));
        }
    }

    public final void addListener(@NotNull ILogListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        logListeners.add(listener);
    }

    public final void removeListener(@NotNull ILogListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        logListeners.remove(listener);
    }

    static {
        logListeners = new CopyOnWriteArraySet();
        logLevel = LogLevel.WARN;
        visualLogLevel = LogLevel.NONE;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            nArray[LogLevel.VERBOSE.ordinal()] = 1;
            nArray[LogLevel.DEBUG.ordinal()] = 2;
            nArray[LogLevel.INFO.ordinal()] = 3;
            nArray[LogLevel.WARN.ordinal()] = 4;
            nArray[LogLevel.ERROR.ordinal()] = 5;
            nArray[LogLevel.FATAL.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

