/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.operations.impl;

import com.onesignal.common.events.EventProducer;
import com.onesignal.common.events.IEventNotifier;
import com.onesignal.common.modeling.IModelStore;
import com.onesignal.common.threading.WaiterWithValue;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.operations.ExecutionResponse;
import com.onesignal.core.internal.operations.ExecutionResult;
import com.onesignal.core.internal.operations.GroupComparisonType;
import com.onesignal.core.internal.operations.IOperationExecutor;
import com.onesignal.core.internal.operations.IOperationRepo;
import com.onesignal.core.internal.operations.IOperationRepoLoadedListener;
import com.onesignal.core.internal.operations.Operation;
import com.onesignal.core.internal.operations.impl.OperationModelStore;
import com.onesignal.core.internal.operations.impl.OperationRepo;
import com.onesignal.core.internal.startup.IStartableService;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.LogLevel;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.user.internal.operations.impl.states.NewRecordsState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KClass;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.ThreadPoolDispatcherKt;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\"\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0002QRB3\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0004H\u0016J \u0010-\u001a\u00020\u001c\"\b\b\u0000\u0010.*\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H.01H\u0016J#\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020\u00142\b\u00104\u001a\u0004\u0018\u00010\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\u0018\u00106\u001a\u00020+2\u0006\u00107\u001a\u00020/2\u0006\u00108\u001a\u00020\u001cH\u0016J!\u00109\u001a\u00020\u001c2\u0006\u00107\u001a\u00020/2\u0006\u00108\u001a\u00020\u001cH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J!\u0010;\u001a\u00020+2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020$0\u0006H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b=\u0010>J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020$0\u00062\u0006\u0010@\u001a\u00020$H\u0002J\u001d\u0010A\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010\u00062\u0006\u0010B\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bCJ1\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020$2\u0006\u00108\u001a\u00020\u001c2\u0006\u0010F\u001a\u00020\u001c2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010HJ\r\u0010I\u001a\u00020+H\u0000\u00a2\u0006\u0002\bJJ\u0011\u0010K\u001a\u00020+H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010LJ\b\u0010M\u001a\u00020+H\u0016J\u0010\u0010N\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0004H\u0016J\u0010\u0010O\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0004H\u0016J\u0011\u0010P\u001a\u00020+H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010LR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00070\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006S"}, d2={"Lcom/onesignal/core/internal/operations/impl/OperationRepo;", "Lcom/onesignal/core/internal/operations/IOperationRepo;", "Lcom/onesignal/core/internal/startup/IStartableService;", "Lcom/onesignal/common/events/IEventNotifier;", "Lcom/onesignal/core/internal/operations/IOperationRepoLoadedListener;", "executors", "", "Lcom/onesignal/core/internal/operations/IOperationExecutor;", "_operationModelStore", "Lcom/onesignal/core/internal/operations/impl/OperationModelStore;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_time", "Lcom/onesignal/core/internal/time/ITime;", "_newRecordState", "Lcom/onesignal/user/internal/operations/impl/states/NewRecordsState;", "(Ljava/util/List;Lcom/onesignal/core/internal/operations/impl/OperationModelStore;Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/core/internal/time/ITime;Lcom/onesignal/user/internal/operations/impl/states/NewRecordsState;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "enqueueIntoBucket", "", "executeBucket", "getExecuteBucket", "()I", "executorsMap", "", "", "hasSubscribers", "", "getHasSubscribers", "()Z", "loadedSubscription", "Lcom/onesignal/common/events/EventProducer;", "paused", "queue", "", "Lcom/onesignal/core/internal/operations/impl/OperationRepo$OperationQueueItem;", "getQueue$com_onesignal_core", "()Ljava/util/List;", "waiter", "Lcom/onesignal/common/threading/WaiterWithValue;", "Lcom/onesignal/core/internal/operations/impl/OperationRepo$LoopWaiterMessage;", "addOperationLoadedListener", "", "handler", "containsInstanceOf", "T", "Lcom/onesignal/core/internal/operations/Operation;", "type", "Lkotlin/reflect/KClass;", "delayBeforeNextExecution", "retries", "retryAfterSeconds", "(ILjava/lang/Integer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "enqueue", "operation", "flush", "enqueueAndWait", "(Lcom/onesignal/core/internal/operations/Operation;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeOperations", "ops", "executeOperations$com_onesignal_core", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getGroupableOperations", "startingOp", "getNextOps", "bucketFilter", "getNextOps$com_onesignal_core", "internalEnqueue", "queueItem", "addToStore", "index", "(Lcom/onesignal/core/internal/operations/impl/OperationRepo$OperationQueueItem;ZZLjava/lang/Integer;)Z", "loadSavedOperations", "loadSavedOperations$com_onesignal_core", "processQueueForever", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "start", "subscribe", "unsubscribe", "waitForNewOperationAndExecutionInterval", "LoopWaiterMessage", "OperationQueueItem", "com.onesignal.core"})
public final class OperationRepo
implements IOperationRepo,
IStartableService,
IEventNotifier<IOperationRepoLoadedListener> {
    @NotNull
    private final OperationModelStore _operationModelStore;
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private final ITime _time;
    @NotNull
    private final NewRecordsState _newRecordState;
    @NotNull
    private final Map<String, IOperationExecutor> executorsMap;
    @NotNull
    private final List<OperationQueueItem> queue;
    @NotNull
    private final WaiterWithValue<LoopWaiterMessage> waiter;
    private boolean paused;
    @NotNull
    private CoroutineScope coroutineScope;
    @NotNull
    private final EventProducer<IOperationRepoLoadedListener> loadedSubscription;
    private int enqueueIntoBucket;

    public OperationRepo(@NotNull List<? extends IOperationExecutor> executors, @NotNull OperationModelStore _operationModelStore, @NotNull ConfigModelStore _configModelStore, @NotNull ITime _time, @NotNull NewRecordsState _newRecordState) {
        Intrinsics.checkNotNullParameter(executors, (String)"executors");
        Intrinsics.checkNotNullParameter((Object)_operationModelStore, (String)"_operationModelStore");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)_time, (String)"_time");
        Intrinsics.checkNotNullParameter((Object)_newRecordState, (String)"_newRecordState");
        this._operationModelStore = _operationModelStore;
        this._configModelStore = _configModelStore;
        this._time = _time;
        this._newRecordState = _newRecordState;
        this.queue = new ArrayList();
        this.waiter = new WaiterWithValue();
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)ThreadPoolDispatcherKt.newSingleThreadContext((String)"OpRepo")));
        this.loadedSubscription = new EventProducer();
        Map executorsMap = new LinkedHashMap();
        for (IOperationExecutor iOperationExecutor : executors) {
            for (String operation : iOperationExecutor.getOperations()) {
                executorsMap.put(operation, iOperationExecutor);
            }
        }
        this.executorsMap = executorsMap;
    }

    @NotNull
    public final List<OperationQueueItem> getQueue$com_onesignal_core() {
        return this.queue;
    }

    @Override
    public boolean getHasSubscribers() {
        return this.loadedSubscription.getHasSubscribers();
    }

    @Override
    public void unsubscribe(@NotNull IOperationRepoLoadedListener handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.loadedSubscription.unsubscribe(handler);
    }

    @Override
    public void subscribe(@NotNull IOperationRepoLoadedListener handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.loadedSubscription.subscribe(handler);
    }

    private final int getExecuteBucket() {
        return this.enqueueIntoBucket == 0 ? 0 : this.enqueueIntoBucket - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Operation> boolean containsInstanceOf(@NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        List<OperationQueueItem> list = this.queue;
        synchronized (list) {
            boolean bl;
            block6: {
                boolean bl2 = false;
                Iterable $this$any$iv = this.queue;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        OperationQueueItem it = (OperationQueueItem)element$iv;
                        boolean bl3 = false;
                        if (!type.isInstance((Object)it.getOperation())) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            boolean bl4 = bl;
            return bl4;
        }
    }

    @Override
    public void addOperationLoadedListener(@NotNull IOperationRepoLoadedListener handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.subscribe(handler);
    }

    @Override
    public void start() {
        this.paused = false;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ OperationRepo this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.loadSavedOperations$com_onesignal_core();
                        this.label = 1;
                        Object object3 = OperationRepo.access$processQueueForever(this.this$0, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void enqueue(@NotNull Operation operation, boolean flush) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Logging.log(LogLevel.DEBUG, "OperationRepo.enqueue(operation: " + operation + ", flush: " + flush + ')');
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        operation.setId(string);
        OperationRepo.internalEnqueue$default(this, new OperationQueueItem(operation, null, this.enqueueIntoBucket, 0, 10, null), flush, true, null, 8, null);
    }

    @Override
    @Nullable
    public Object enqueueAndWait(@NotNull Operation operation, boolean flush, @NotNull Continuation<? super Boolean> $completion) {
        Logging.log(LogLevel.DEBUG, "OperationRepo.enqueueAndWait(operation: " + operation + ", force: " + flush + ')');
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        operation.setId(string);
        WaiterWithValue<? super Boolean> waiter = new WaiterWithValue<Boolean>();
        OperationRepo.internalEnqueue$default(this, new OperationQueueItem(operation, waiter, this.enqueueIntoBucket, 0, 8, null), flush, true, null, 8, null);
        return waiter.waitForWake($completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean internalEnqueue(OperationQueueItem queueItem, boolean flush, boolean addToStore, Integer index) {
        List<OperationQueueItem> list = this.queue;
        synchronized (list) {
            Boolean bl;
            block11: {
                boolean hasExisting;
                block10: {
                    boolean bl2;
                    boolean bl3 = false;
                    Iterable $this$any$iv = this.queue;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            OperationQueueItem it = (OperationQueueItem)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getOperation().getId(), (Object)queueItem.getOperation().getId())) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = hasExisting = false;
                    }
                }
                if (!hasExisting) break block11;
                Logging.debug$default("OperationRepo: internalEnqueue - operation.id: " + queueItem.getOperation().getId() + " already exists in the queue.", null, 2, null);
                boolean bl5 = false;
                return bl5;
            }
            if (index != null) {
                this.queue.add(index, queueItem);
                bl = Unit.INSTANCE;
            } else {
                bl = this.queue.add(queueItem);
            }
            Boolean bl6 = bl;
        }
        if (addToStore) {
            IModelStore.DefaultImpls.add$default(this._operationModelStore, queueItem.getOperation(), null, 2, null);
        }
        this.waiter.wake(new LoopWaiterMessage(flush, 0L));
        return true;
    }

    static /* synthetic */ boolean internalEnqueue$default(OperationRepo operationRepo, OperationQueueItem operationQueueItem, boolean bl, boolean bl2, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return operationRepo.internalEnqueue(operationQueueItem, bl, bl2, n);
    }

    /*
     * Unable to fully structure code
     */
    private final Object processQueueForever(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof processQueueForever.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ OperationRepo this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OperationRepo.access$processQueueForever(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        block0 : switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.waitForNewOperationAndExecutionInterval((Continuation<? super Unit>)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (OperationRepo)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                var2_5 = this.enqueueIntoBucket;
                this.enqueueIntoBucket = var2_5 + 1;
lbl25:
                // 4 sources

                while (true) {
                    if (this.paused) {
                        Logging.debug$default("OperationRepo is paused", null, 2, null);
                        return Unit.INSTANCE;
                    }
                    ops = this.getNextOps$com_onesignal_core(this.getExecuteBucket());
                    Logging.debug$default("processQueueForever:ops:\n" + ops, null, 2, null);
                    if (ops == null) break block0;
                    $continuation.L$0 = this;
                    $continuation.label = 2;
                    v1 = this.executeOperations$com_onesignal_core(ops, (Continuation<? super Unit>)$continuation);
                    if (v1 == var6_4) {
                        return var6_4;
                    }
                    ** GOTO lbl42
                    break;
                }
            }
            case 2: {
                this = (OperationRepo)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl42:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.label = 3;
                v2 = DelayKt.delay((long)((ConfigModel)this._configModelStore.getModel()).getOpRepoPostWakeDelay(), (Continuation)$continuation);
                if (v2 != var6_4) ** GOTO lbl25
                return var6_4;
            }
            case 3: {
                this = (OperationRepo)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                ** GOTO lbl25
            }
        }
        $continuation.L$0 = this;
        $continuation.label = 4;
        v3 = this.waitForNewOperationAndExecutionInterval((Continuation<? super Unit>)$continuation);
        if (v3 == var6_4) {
            return var6_4;
        }
        ** GOTO lbl62
        {
            case 4: {
                this = (OperationRepo)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl62:
                // 2 sources

                var3_7 = this.enqueueIntoBucket;
                this.enqueueIntoBucket = var3_7 + 1;
                ** continue;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitForNewOperationAndExecutionInterval(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof waitForNewOperationAndExecutionInterval.1)) ** GOTO lbl-1000
        var8_2 = var1_1;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ OperationRepo this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OperationRepo.access$waitForNewOperationAndExecutionInterval(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_6 = wakeMessage = new Ref.ObjectRef();
                $continuation.L$0 = this;
                $continuation.L$1 = wakeMessage;
                $continuation.L$2 = var6_6;
                $continuation.label = 1;
                v0 = this.waiter.waitForWake((Continuation<LoopWaiterMessage>)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl27
            }
            case 1: {
                var6_6 = (Ref.ObjectRef)$continuation.L$2;
                wakeMessage = (Ref.ObjectRef)$continuation.L$1;
                this = (OperationRepo)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                var6_6.element = v0;
                remainingTime = ((ConfigModel)this._configModelStore.getModel()).getOpRepoExecutionInterval() - ((LoopWaiterMessage)wakeMessage.element).getPreviousWaitedTime();
lbl29:
                // 2 sources

                while (!((LoopWaiterMessage)wakeMessage.element).getForce()) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = wakeMessage;
                    $continuation.L$2 = null;
                    $continuation.label = 2;
                    v1 = TimeoutKt.withTimeoutOrNull((long)remainingTime, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<LoopWaiterMessage>)wakeMessage, this, null){
                        Object L$0;
                        int label;
                        final /* synthetic */ Ref.ObjectRef<LoopWaiterMessage> $wakeMessage;
                        final /* synthetic */ OperationRepo this$0;
                        {
                            this.$wakeMessage = $wakeMessage;
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.L$0 = var2_3 = this.$wakeMessage;
                                    this.label = 1;
                                    v0 = OperationRepo.access$getWaiter$p(this.this$0).waitForWake((Continuation)this);
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl15
                                }
                                case 1: {
                                    var2_3 = (Ref.ObjectRef<LoopWaiterMessage>)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl15:
                                    // 2 sources

                                    var2_3.element = v0;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var9_4) {
                        return var9_4;
                    }
                    ** GOTO lbl44
                }
                ** GOTO lbl48
            }
            case 2: {
                wakeMessage = (Ref.ObjectRef)$continuation.L$1;
                this = (OperationRepo)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl44:
                // 2 sources

                v2 = waitedTheFullTime = v1 == null;
                if (waitedTheFullTime) ** GOTO lbl48
                remainingTime = ((ConfigModel)this._configModelStore.getModel()).getOpRepoExecutionInterval();
                ** GOTO lbl29
lbl48:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object executeOperations$com_onesignal_core(@NotNull List<OperationQueueItem> var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof executeOperations.1)) ** GOTO lbl-1000
        var24_3 = var2_2;
        if ((var24_3.label & -2147483648) != 0) {
            var24_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ OperationRepo this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeOperations$com_onesignal_core(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var25_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                startingOp = (OperationQueueItem)CollectionsKt.first((List)ops);
                v0 = this.executorsMap.get(startingOp.getOperation().getName());
                if (v0 == null) {
                    throw new Exception("Could not find executor for operation " + startingOp.getOperation().getName());
                }
                executor = v0;
                $this$map$iv = ops;
                $i$f$map = false;
                var8_16 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var13_53 = (OperationQueueItem)item$iv$iv;
                    var22_63 = destination$iv$iv;
                    $i$a$-map-OperationRepo$executeOperations$operations$1 = false;
                    var22_63.add(it.getOperation());
                }
                operations = (List)destination$iv$iv;
                $continuation.L$0 = this;
                $continuation.L$1 = ops;
                $continuation.L$2 = startingOp;
                $continuation.L$3 = operations;
                $continuation.label = 1;
                v1 = executor.execute(operations, (Continuation<? super ExecutionResponse>)$continuation);
                ** if (v1 != var25_5) goto lbl40
lbl39:
                // 1 sources

                return var25_5;
lbl40:
                // 1 sources

                ** GOTO lbl50
            }
            case 1: {
                operations = (List)$continuation.L$3;
                startingOp = (OperationQueueItem)$continuation.L$2;
                ops = (List)$continuation.L$1;
                this = (OperationRepo)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl50:
                // 2 sources

                response = (ExecutionResponse)v1;
                Logging.debug$default("OperationRepo: execute response = " + (Object)response.getResult(), null, 2, null);
                if (response.getIdTranslations() != null) {
                    $this$forEach$iv = ops;
                    $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        it = (OperationQueueItem)element$iv;
                        $i$a$-forEach-OperationRepo$executeOperations$2 = false;
                        it.getOperation().translateIds(response.getIdTranslations());
                    }
                    $i$f$forEach = this.queue;
                    synchronized ($i$f$forEach) {
                        $i$a$-synchronized-OperationRepo$executeOperations$3 = false;
                        $this$forEach$iv = this.queue;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (OperationQueueItem)element$iv;
                            $i$a$-forEach-OperationRepo$executeOperations$3$1 = false;
                            it.getOperation().translateIds(response.getIdTranslations());
                        }
                        $i$a$-synchronized-OperationRepo$executeOperations$3 = Unit.INSTANCE;
                    }
                    $this$forEach$iv = response.getIdTranslations().values();
                    $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        it = (String)element$iv;
                        $i$a$-forEach-OperationRepo$executeOperations$4 = false;
                        this._newRecordState.add(it);
                    }
                    BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        long J$0;
                        int label;
                        final /* synthetic */ OperationRepo this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.J$0 = waitTime = ((ConfigModel)OperationRepo.access$get_configModelStore$p(this.this$0).getModel()).getOpRepoPostCreateDelay();
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)waitTime, (Continuation)((Continuation)this));
                                    if (v0 == var8_2) {
                                        return var8_2;
                                    }
                                    ** GOTO lbl15
                                }
                                case 1: {
                                    waitTime = this.J$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl15:
                                    // 2 sources

                                    var4_4 = this.this$0.getQueue$com_onesignal_core();
                                    var5_5 = this.this$0;
                                    var6_6 = var4_4;
                                    synchronized (var6_6) {
                                        $i$a$-synchronized-OperationRepo$executeOperations$5$1 = false;
                                        if (((Collection)var5_5.getQueue$com_onesignal_core()).isEmpty() == false) {
                                            OperationRepo.access$getWaiter$p(var5_5).wake(new LoopWaiterMessage(false, waitTime));
                                        }
                                        var7_8 = Unit.INSTANCE;
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
                highestRetries = new Ref.IntRef();
                switch (WhenMappings.$EnumSwitchMapping$0[response.getResult().ordinal()]) {
                    case 1: {
                        $this$forEach$iv = ops;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (OperationQueueItem)element$iv;
                            $i$a$-forEach-OperationRepo$executeOperations$6 = false;
                            IModelStore.DefaultImpls.remove$default(this._operationModelStore, it.getOperation().getId(), null, 2, null);
                        }
                        $this$forEach$iv = ops;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (OperationQueueItem)element$iv;
                            $i$a$-forEach-OperationRepo$executeOperations$7 = false;
                            v2 = it.getWaiter();
                            if (v2 != null) {
                                v2.wake(Boxing.boxBoolean((boolean)true));
                                v3 = Unit.INSTANCE;
                                continue;
                            }
                            v3 = null;
                        }
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Logging.error$default("Operation execution failed without retry: " + operations, null, 2, null);
                        $this$forEach$iv = ops;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (OperationQueueItem)element$iv;
                            $i$a$-forEach-OperationRepo$executeOperations$8 = false;
                            IModelStore.DefaultImpls.remove$default(this._operationModelStore, it.getOperation().getId(), null, 2, null);
                        }
                        $this$forEach$iv = ops;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (OperationQueueItem)element$iv;
                            $i$a$-forEach-OperationRepo$executeOperations$9 = false;
                            v4 = it.getWaiter();
                            if (v4 != null) {
                                v4.wake(Boxing.boxBoolean((boolean)false));
                                v5 = Unit.INSTANCE;
                                continue;
                            }
                            v5 = null;
                        }
                        break;
                    }
                    case 5: {
                        IModelStore.DefaultImpls.remove$default(this._operationModelStore, startingOp.getOperation().getId(), null, 2, null);
                        v6 = startingOp.getWaiter();
                        if (v6 != null) {
                            v6.wake(Boxing.boxBoolean((boolean)true));
                            v7 = Unit.INSTANCE;
                        } else {
                            v7 = null;
                        }
                        var11_32 = this.queue;
                        synchronized (var11_32) {
                            $i$a$-synchronized-OperationRepo$executeOperations$10 = false;
                            $this$filter$iv = ops;
                            $i$f$filter = false;
                            $i$a$-forEach-OperationRepo$executeOperations$9 = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (OperationQueueItem)element$iv$iv;
                                $i$a$-filter-OperationRepo$executeOperations$10$1 = false;
                                if (!(Intrinsics.areEqual((Object)it, (Object)startingOp) == false)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$forEach$iv = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (OperationQueueItem)element$iv;
                                $i$a$-forEach-OperationRepo$executeOperations$10$2 = false;
                                this.queue.add(0, it);
                            }
                            $i$a$-synchronized-OperationRepo$executeOperations$10 = Unit.INSTANCE;
                            break;
                        }
                    }
                    case 6: {
                        Logging.error$default("Operation execution failed, retrying: " + operations, null, 2, null);
                        var11_32 = this.queue;
                        synchronized (var11_32) {
                            $i$a$-synchronized-OperationRepo$executeOperations$11 = false;
                            $this$forEach$iv = CollectionsKt.reversed((Iterable)ops);
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (OperationQueueItem)element$iv;
                                $i$a$-forEach-OperationRepo$executeOperations$11$1 = false;
                                it.setRetries(it.getRetries() + 1);
                                if (it.getRetries() > highestRetries.element) {
                                    highestRetries.element = it.getRetries();
                                }
                                this.queue.add(0, it);
                            }
                            $i$a$-synchronized-OperationRepo$executeOperations$11 = Unit.INSTANCE;
                            break;
                        }
                    }
                    case 7: {
                        Logging.error$default("Operation execution failed with eventual retry, pausing the operation repo: " + operations, null, 2, null);
                        this.paused = true;
                        var11_32 = this.queue;
                        synchronized (var11_32) {
                            $i$a$-synchronized-OperationRepo$executeOperations$12 = false;
                            $this$forEach$iv = CollectionsKt.reversed((Iterable)ops);
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (OperationQueueItem)element$iv;
                                $i$a$-forEach-OperationRepo$executeOperations$12$1 = false;
                                this.queue.add(0, it);
                            }
                            $i$a$-synchronized-OperationRepo$executeOperations$12 = Unit.INSTANCE;
                            break;
                        }
                    }
                }
                if (response.getOperations() != null) {
                    $i$a$-synchronized-OperationRepo$executeOperations$3 = this.queue;
                    synchronized ($i$a$-synchronized-OperationRepo$executeOperations$3) {
                        $i$a$-synchronized-OperationRepo$executeOperations$13 = false;
                        for (Operation op : CollectionsKt.reversed((Iterable)response.getOperations())) {
                            v8 = UUID.randomUUID().toString();
                            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"randomUUID().toString()");
                            op.setId(v8);
                            queueItem = new OperationQueueItem(op, null, 0, 0, 10, null);
                            this.queue.add(0, queueItem);
                            IModelStore.DefaultImpls.add$default(this._operationModelStore, 0, queueItem.getOperation(), null, 4, null);
                        }
                        var10_30 = Unit.INSTANCE;
                    }
                }
                $continuation.L$0 = this;
                $continuation.L$1 = ops;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v9 = this.delayBeforeNextExecution(highestRetries.element, response.getRetryAfterSeconds(), (Continuation<? super Unit>)$continuation);
                ** if (v9 != var25_5) goto lbl233
lbl232:
                // 1 sources

                return var25_5;
lbl233:
                // 1 sources

                ** GOTO lbl263
            }
            case 2: {
                ops = (List)$continuation.L$1;
                this = (OperationRepo)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
                }
                catch (Throwable e) {
                    Logging.log(LogLevel.ERROR, "Error attempting to execute operation: " + ops, e);
                    $this$forEach$iv = ops;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (OperationQueueItem)element$iv;
                        $i$a$-forEach-OperationRepo$executeOperations$14 = false;
                        IModelStore.DefaultImpls.remove$default(this._operationModelStore, it.getOperation().getId(), null, 2, null);
                    }
                    $this$forEach$iv = ops;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (OperationQueueItem)element$iv;
                        $i$a$-forEach-OperationRepo$executeOperations$15 = false;
                        v10 = it.getWaiter();
                        if (v10 != null) {
                            v10.wake(Boxing.boxBoolean((boolean)false));
                            v11 = Unit.INSTANCE;
                            continue;
                        }
                        v11 = null;
                    }
                }
lbl263:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object delayBeforeNextExecution(int retries, @Nullable Integer retryAfterSeconds, @NotNull Continuation<? super Unit> $completion) {
        Logging.debug$default("retryAfterSeconds: " + retryAfterSeconds, null, 2, null);
        Integer n = retryAfterSeconds;
        long retryAfterSecondsNonNull = n != null ? (long)n.intValue() : 0L;
        long delayForOnRetries = (long)retries * ((ConfigModel)this._configModelStore.getModel()).getOpRepoDefaultFailRetryBackoff();
        long delayFor = Math.max(delayForOnRetries, retryAfterSecondsNonNull * (long)1000);
        if (delayFor < 1L) {
            return Unit.INSTANCE;
        }
        Logging.error$default("Operations being delay for: " + delayFor + " ms", null, 2, null);
        Object object = DelayKt.delay((long)delayFor, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final List<OperationQueueItem> getNextOps$com_onesignal_core(int bucketFilter) {
        List<OperationQueueItem> list;
        List<OperationQueueItem> list2 = this.queue;
        synchronized (list2) {
            List<OperationQueueItem> list3;
            Object v1;
            block6: {
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.queue;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    OperationQueueItem it = (OperationQueueItem)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = it.getOperation().getCanStartExecute() && this._newRecordState.canAccess(it.getOperation().getApplyToRecordId()) && it.getBucket() <= bucketFilter;
                    if (!bl3) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            OperationQueueItem startingOp = v1;
            if (startingOp != null) {
                this.queue.remove(startingOp);
                list3 = this.getGroupableOperations(startingOp);
            } else {
                list3 = null;
            }
            list = list3;
        }
        return list;
    }

    private final List<OperationQueueItem> getGroupableOperations(OperationQueueItem startingOp) {
        List ops = new ArrayList();
        ops.add(startingOp);
        if (startingOp.getOperation().getGroupComparisonType() == GroupComparisonType.NONE) {
            return ops;
        }
        String startingKey = startingOp.getOperation().getGroupComparisonType() == GroupComparisonType.CREATE ? startingOp.getOperation().getCreateComparisonKey() : startingOp.getOperation().getModifyComparisonKey();
        if (!((Collection)this.queue).isEmpty()) {
            for (OperationQueueItem item : CollectionsKt.toList((Iterable)this.queue)) {
                String itemKey;
                String string = itemKey = startingOp.getOperation().getGroupComparisonType() == GroupComparisonType.CREATE ? item.getOperation().getCreateComparisonKey() : item.getOperation().getModifyComparisonKey();
                if (Intrinsics.areEqual((Object)itemKey, (Object)"") && Intrinsics.areEqual((Object)startingKey, (Object)"")) {
                    throw new Exception("Both comparison keys can not be blank!");
                }
                if (!Intrinsics.areEqual((Object)itemKey, (Object)startingKey)) continue;
                this.queue.remove(item);
                ops.add(item);
            }
        }
        return ops;
    }

    public final void loadSavedOperations$com_onesignal_core() {
        this._operationModelStore.loadOperations();
        int successfulIndex = 0;
        for (Operation operation : this._operationModelStore.list()) {
            boolean successful = this.internalEnqueue(new OperationQueueItem(operation, null, this.enqueueIntoBucket, 0, 10, null), false, false, successfulIndex);
            if (!successful) continue;
            ++successfulIndex;
        }
        this.loadedSubscription.fire((Function1<IOperationRepoLoadedListener, Unit>)((Function1)loadSavedOperations.1.INSTANCE));
    }

    public static final /* synthetic */ Object access$processQueueForever(OperationRepo $this, Continuation $completion) {
        return $this.processQueueForever((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$waitForNewOperationAndExecutionInterval(OperationRepo $this, Continuation $completion) {
        return $this.waitForNewOperationAndExecutionInterval((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ WaiterWithValue access$getWaiter$p(OperationRepo $this) {
        return $this.waiter;
    }

    public static final /* synthetic */ ConfigModelStore access$get_configModelStore$p(OperationRepo $this) {
        return $this._configModelStore;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/onesignal/core/internal/operations/impl/OperationRepo$OperationQueueItem;", "", "operation", "Lcom/onesignal/core/internal/operations/Operation;", "waiter", "Lcom/onesignal/common/threading/WaiterWithValue;", "", "bucket", "", "retries", "(Lcom/onesignal/core/internal/operations/Operation;Lcom/onesignal/common/threading/WaiterWithValue;II)V", "getBucket", "()I", "getOperation", "()Lcom/onesignal/core/internal/operations/Operation;", "getRetries", "setRetries", "(I)V", "getWaiter", "()Lcom/onesignal/common/threading/WaiterWithValue;", "toString", "", "com.onesignal.core"})
    public static final class OperationQueueItem {
        @NotNull
        private final Operation operation;
        @Nullable
        private final WaiterWithValue<Boolean> waiter;
        private final int bucket;
        private int retries;

        public OperationQueueItem(@NotNull Operation operation, @Nullable WaiterWithValue<Boolean> waiter, int bucket, int retries) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            this.operation = operation;
            this.waiter = waiter;
            this.bucket = bucket;
            this.retries = retries;
        }

        public /* synthetic */ OperationQueueItem(Operation operation, WaiterWithValue waiterWithValue, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                waiterWithValue = null;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            this(operation, waiterWithValue, n, n2);
        }

        @NotNull
        public final Operation getOperation() {
            return this.operation;
        }

        @Nullable
        public final WaiterWithValue<Boolean> getWaiter() {
            return this.waiter;
        }

        public final int getBucket() {
            return this.bucket;
        }

        public final int getRetries() {
            return this.retries;
        }

        public final void setRetries(int n) {
            this.retries = n;
        }

        @NotNull
        public String toString() {
            return "bucket:" + this.bucket + ", retries:" + this.retries + ", operation:" + this.operation + '\n';
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/onesignal/core/internal/operations/impl/OperationRepo$LoopWaiterMessage;", "", "force", "", "previousWaitedTime", "", "(ZJ)V", "getForce", "()Z", "getPreviousWaitedTime", "()J", "com.onesignal.core"})
    public static final class LoopWaiterMessage {
        private final boolean force;
        private final long previousWaitedTime;

        public LoopWaiterMessage(boolean force, long previousWaitedTime) {
            this.force = force;
            this.previousWaitedTime = previousWaitedTime;
        }

        public /* synthetic */ LoopWaiterMessage(boolean bl, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = 0L;
            }
            this(bl, l);
        }

        public final boolean getForce() {
            return this.force;
        }

        public final long getPreviousWaitedTime() {
            return this.previousWaitedTime;
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExecutionResult.values().length];
            nArray[ExecutionResult.SUCCESS.ordinal()] = 1;
            nArray[ExecutionResult.FAIL_UNAUTHORIZED.ordinal()] = 2;
            nArray[ExecutionResult.FAIL_NORETRY.ordinal()] = 3;
            nArray[ExecutionResult.FAIL_CONFLICT.ordinal()] = 4;
            nArray[ExecutionResult.SUCCESS_STARTING_ONLY.ordinal()] = 5;
            nArray[ExecutionResult.FAIL_RETRY.ordinal()] = 6;
            nArray[ExecutionResult.FAIL_PAUSE_OPREPO.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

