/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.user.internal.builduser.impl;

import com.onesignal.common.modeling.Model;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.operations.Operation;
import com.onesignal.user.internal.builduser.IRebuildUserService;
import com.onesignal.user.internal.identity.IdentityModel;
import com.onesignal.user.internal.identity.IdentityModelStore;
import com.onesignal.user.internal.operations.CreateSubscriptionOperation;
import com.onesignal.user.internal.operations.LoginUserOperation;
import com.onesignal.user.internal.operations.RefreshUserOperation;
import com.onesignal.user.internal.properties.PropertiesModel;
import com.onesignal.user.internal.properties.PropertiesModelStore;
import com.onesignal.user.internal.subscriptions.SubscriptionModel;
import com.onesignal.user.internal.subscriptions.SubscriptionModelStore;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/onesignal/user/internal/builduser/impl/RebuildUserService;", "Lcom/onesignal/user/internal/builduser/IRebuildUserService;", "_identityModelStore", "Lcom/onesignal/user/internal/identity/IdentityModelStore;", "_propertiesModelStore", "Lcom/onesignal/user/internal/properties/PropertiesModelStore;", "_subscriptionsModelStore", "Lcom/onesignal/user/internal/subscriptions/SubscriptionModelStore;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "(Lcom/onesignal/user/internal/identity/IdentityModelStore;Lcom/onesignal/user/internal/properties/PropertiesModelStore;Lcom/onesignal/user/internal/subscriptions/SubscriptionModelStore;Lcom/onesignal/core/internal/config/ConfigModelStore;)V", "getRebuildOperationsIfCurrentUser", "", "Lcom/onesignal/core/internal/operations/Operation;", "appId", "", "onesignalId", "core_release"})
public final class RebuildUserService
implements IRebuildUserService {
    @NotNull
    private final IdentityModelStore _identityModelStore;
    @NotNull
    private final PropertiesModelStore _propertiesModelStore;
    @NotNull
    private final SubscriptionModelStore _subscriptionsModelStore;
    @NotNull
    private final ConfigModelStore _configModelStore;

    public RebuildUserService(@NotNull IdentityModelStore _identityModelStore, @NotNull PropertiesModelStore _propertiesModelStore, @NotNull SubscriptionModelStore _subscriptionsModelStore, @NotNull ConfigModelStore _configModelStore) {
        Intrinsics.checkNotNullParameter((Object)_identityModelStore, (String)"_identityModelStore");
        Intrinsics.checkNotNullParameter((Object)_propertiesModelStore, (String)"_propertiesModelStore");
        Intrinsics.checkNotNullParameter((Object)_subscriptionsModelStore, (String)"_subscriptionsModelStore");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        this._identityModelStore = _identityModelStore;
        this._propertiesModelStore = _propertiesModelStore;
        this._subscriptionsModelStore = _subscriptionsModelStore;
        this._configModelStore = _configModelStore;
    }

    @Override
    @Nullable
    public List<Operation> getRebuildOperationsIfCurrentUser(@NotNull String appId2, @NotNull String onesignalId) {
        Object v0;
        List operations;
        block4: {
            Intrinsics.checkNotNullParameter((Object)appId2, (String)"appId");
            Intrinsics.checkNotNullParameter((Object)onesignalId, (String)"onesignalId");
            IdentityModel identityModel = new IdentityModel();
            identityModel.initializeFromModel(null, (Model)this._identityModelStore.getModel());
            PropertiesModel propertiesModel = new PropertiesModel();
            propertiesModel.initializeFromModel(null, (Model)this._propertiesModelStore.getModel());
            List subscriptionModels = new ArrayList();
            for (SubscriptionModel activeSubscriptionModel : this._subscriptionsModelStore.list()) {
                SubscriptionModel subscriptionModel = new SubscriptionModel();
                subscriptionModel.initializeFromModel(null, activeSubscriptionModel);
                subscriptionModels.add(subscriptionModel);
            }
            if (!Intrinsics.areEqual((Object)identityModel.getOnesignalId(), (Object)onesignalId)) {
                return null;
            }
            operations = new ArrayList();
            operations.add(new LoginUserOperation(appId2, onesignalId, identityModel.getExternalId(), null, 8, null));
            Iterable $this$firstOrNull$iv = subscriptionModels;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SubscriptionModel it = (SubscriptionModel)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)((ConfigModel)this._configModelStore.getModel()).getPushSubscriptionId())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        SubscriptionModel pushSubscription = v0;
        if (pushSubscription != null) {
            operations.add(new CreateSubscriptionOperation(appId2, onesignalId, pushSubscription.getId(), pushSubscription.getType(), pushSubscription.getOptedIn(), pushSubscription.getAddress(), pushSubscription.getStatus()));
        }
        operations.add(new RefreshUserOperation(appId2, onesignalId));
        return operations;
    }
}

