/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.IBinder;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class TrackGooglePurchase {
    private static int iapEnabled = -99;
    private ServiceConnection mServiceConn;
    private static Class<?> IInAppBillingServiceClass;
    private Object mIInAppBillingService;
    private Method getPurchasesMethod;
    private Method getSkuDetailsMethod;
    private Context appContext;
    private ArrayList<String> purchaseTokens;
    private SharedPreferences.Editor prefsEditor;
    private boolean newAsExisting = true;
    private boolean isWaitingForPurchasesRequest = false;

    TrackGooglePurchase(Context activity) {
        this.appContext = activity;
        SharedPreferences prefs = this.appContext.getSharedPreferences("GTPlayerPurchases", 0);
        this.prefsEditor = prefs.edit();
        this.purchaseTokens = new ArrayList();
        try {
            JSONArray jsonPurchaseTokens = new JSONArray(prefs.getString("purchaseTokens", "[]"));
            for (int i = 0; i < jsonPurchaseTokens.length(); ++i) {
                this.purchaseTokens.add(jsonPurchaseTokens.get(i).toString());
            }
            boolean bl = this.newAsExisting = jsonPurchaseTokens.length() == 0;
            if (this.newAsExisting) {
                this.newAsExisting = prefs.getBoolean("ExistingPurchases", true);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.trackIAP();
    }

    static boolean CanTrack(Context context) {
        if (iapEnabled == -99) {
            iapEnabled = context.checkCallingOrSelfPermission("com.android.vending.BILLING");
        }
        try {
            if (iapEnabled == 0) {
                IInAppBillingServiceClass = Class.forName("com.android.vending.billing.IInAppBillingService");
            }
        }
        catch (Throwable t) {
            iapEnabled = 0;
            return false;
        }
        return iapEnabled == 0;
    }

    void trackIAP() {
        if (this.mServiceConn == null) {
            this.mServiceConn = new ServiceConnection(){

                public void onServiceDisconnected(ComponentName name) {
                    iapEnabled = -99;
                    TrackGooglePurchase.this.mIInAppBillingService = null;
                }

                public void onServiceConnected(ComponentName name, IBinder service) {
                    try {
                        Class<?> stubClass = Class.forName("com.android.vending.billing.IInAppBillingService$Stub");
                        Method asInterfaceMethod = TrackGooglePurchase.getAsInterfaceMethod(stubClass);
                        asInterfaceMethod.setAccessible(true);
                        TrackGooglePurchase.this.mIInAppBillingService = asInterfaceMethod.invoke(null, service);
                        TrackGooglePurchase.this.QueryBoughtItems();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            };
            Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            serviceIntent.setPackage("com.android.vending");
            this.appContext.bindService(serviceIntent, this.mServiceConn, 1);
        } else if (this.mIInAppBillingService != null) {
            this.QueryBoughtItems();
        }
    }

    private void QueryBoughtItems() {
        if (this.isWaitingForPurchasesRequest) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                TrackGooglePurchase.this.isWaitingForPurchasesRequest = true;
                try {
                    Bundle ownedItems;
                    if (TrackGooglePurchase.this.getPurchasesMethod == null) {
                        TrackGooglePurchase.this.getPurchasesMethod = TrackGooglePurchase.getGetPurchasesMethod(IInAppBillingServiceClass);
                        TrackGooglePurchase.this.getPurchasesMethod.setAccessible(true);
                    }
                    if ((ownedItems = (Bundle)TrackGooglePurchase.this.getPurchasesMethod.invoke(TrackGooglePurchase.this.mIInAppBillingService, 3, TrackGooglePurchase.this.appContext.getPackageName(), "inapp", null)).getInt("RESPONSE_CODE") == 0) {
                        ArrayList<String> skusToAdd = new ArrayList<String>();
                        ArrayList<String> newPurchaseTokens = new ArrayList<String>();
                        ArrayList ownedSkus = ownedItems.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
                        ArrayList purchaseDataList = ownedItems.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
                        for (int i = 0; i < purchaseDataList.size(); ++i) {
                            String purchaseData = (String)purchaseDataList.get(i);
                            String sku = (String)ownedSkus.get(i);
                            JSONObject itemPurchased = new JSONObject(purchaseData);
                            String purchaseToken = itemPurchased.getString("purchaseToken");
                            if (TrackGooglePurchase.this.purchaseTokens.contains(purchaseToken) || newPurchaseTokens.contains(purchaseToken)) continue;
                            newPurchaseTokens.add(purchaseToken);
                            skusToAdd.add(sku);
                        }
                        if (skusToAdd.size() > 0) {
                            TrackGooglePurchase.this.sendPurchases(skusToAdd, newPurchaseTokens);
                        } else if (purchaseDataList.size() == 0) {
                            TrackGooglePurchase.this.newAsExisting = false;
                            TrackGooglePurchase.this.prefsEditor.putBoolean("ExistingPurchases", false);
                            TrackGooglePurchase.this.prefsEditor.commit();
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                TrackGooglePurchase.this.isWaitingForPurchasesRequest = false;
            }
        }).start();
    }

    private void sendPurchases(ArrayList<String> skusToAdd, final ArrayList<String> newPurchaseTokens) {
        try {
            if (this.getSkuDetailsMethod == null) {
                this.getSkuDetailsMethod = TrackGooglePurchase.getGetSkuDetailsMethod(IInAppBillingServiceClass);
                this.getSkuDetailsMethod.setAccessible(true);
            }
            Bundle querySkus = new Bundle();
            querySkus.putStringArrayList("ITEM_ID_LIST", skusToAdd);
            Bundle skuDetails = (Bundle)this.getSkuDetailsMethod.invoke(this.mIInAppBillingService, 3, this.appContext.getPackageName(), "inapp", querySkus);
            int response = skuDetails.getInt("RESPONSE_CODE");
            if (response == 0) {
                ArrayList responseList = skuDetails.getStringArrayList("DETAILS_LIST");
                HashMap<String, JSONObject> currentSkus = new HashMap<String, JSONObject>();
                for (Object thisResponse : responseList) {
                    JSONObject object = new JSONObject((String)thisResponse);
                    String sku = object.getString("productId");
                    BigDecimal price = new BigDecimal(object.getString("price_amount_micros"));
                    price = price.divide(new BigDecimal(1000000));
                    JSONObject jsonItem = new JSONObject();
                    jsonItem.put("sku", (Object)sku);
                    jsonItem.put("iso", (Object)object.getString("price_currency_code"));
                    jsonItem.put("amount", (Object)price.toString());
                    currentSkus.put(sku, jsonItem);
                }
                JSONArray purchasesToReport = new JSONArray();
                for (String sku : skusToAdd) {
                    if (!currentSkus.containsKey(sku)) continue;
                    purchasesToReport.put(currentSkus.get(sku));
                }
                if (purchasesToReport.length() > 0) {
                    OneSignalRestClient.ResponseHandler restResponseHandler = new OneSignalRestClient.ResponseHandler(){

                        public void onFailure(int statusCode, JSONObject response, Throwable throwable) {
                            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "HTTP sendPurchases failed to send.", throwable);
                            TrackGooglePurchase.this.isWaitingForPurchasesRequest = false;
                        }

                        @Override
                        public void onSuccess(String response) {
                            TrackGooglePurchase.this.purchaseTokens.addAll(newPurchaseTokens);
                            TrackGooglePurchase.this.prefsEditor.putString("purchaseTokens", TrackGooglePurchase.this.purchaseTokens.toString());
                            TrackGooglePurchase.this.prefsEditor.remove("ExistingPurchases");
                            TrackGooglePurchase.this.prefsEditor.commit();
                            TrackGooglePurchase.this.newAsExisting = false;
                            TrackGooglePurchase.this.isWaitingForPurchasesRequest = false;
                        }
                    };
                    OneSignal.sendPurchases(purchasesToReport, this.newAsExisting, restResponseHandler);
                }
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Failed to track IAP purchases", t);
        }
    }

    private static Method getAsInterfaceMethod(Class clazz) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] args = method.getParameterTypes();
            if (args.length != 1 || args[0] != IBinder.class) continue;
            return method;
        }
        return null;
    }

    private static Method getGetPurchasesMethod(Class clazz) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] args = method.getParameterTypes();
            if (args.length != 4 || args[0] != Integer.TYPE || args[1] != String.class || args[2] != String.class || args[3] != String.class) continue;
            return method;
        }
        return null;
    }

    private static Method getGetSkuDetailsMethod(Class clazz) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] args = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            if (args.length != 4 || args[0] != Integer.TYPE || args[1] != String.class || args[2] != String.class || args[3] != Bundle.class || returnType != Bundle.class) continue;
            return method;
        }
        return null;
    }
}

