/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadSystemException;
import android.os.Handler;
import android.os.Looper;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.JobIntentService;
import androidx.core.app.NotificationManagerCompat;
import androidx.legacy.content.WakefulBroadcastReceiver;
import com.google.android.gms.location.LocationListener;
import com.google.firebase.messaging.FirebaseMessaging;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.location.LocationCallback;
import com.onesignal.ApplicationInfoHelper;
import com.onesignal.GetPackageInfoResult;
import com.onesignal.OneSignal;
import com.onesignal.PackageInfoHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSUtils {
    public static final int UNINITIALIZABLE_STATUS = -999;
    private static final String PREFER_HMS_METADATA_NAME = "com.onesignal.preferHMS";
    public static int MAX_NETWORK_REQUEST_ATTEMPT_COUNT = 3;
    static final int[] NO_RETRY_NETWROK_REQUEST_STATUS_CODES = new int[]{401, 402, 403, 404, 410};
    private static final int HMS_AVAILABLE_SUCCESSFUL = 0;
    private static final String HMS_CORE_SERVICES_PACKAGE = "com.huawei.hwid";

    OSUtils() {
    }

    public static boolean shouldRetryNetworkRequest(int statusCode) {
        for (int code : NO_RETRY_NETWROK_REQUEST_STATUS_CODES) {
            if (statusCode != code) continue;
            return false;
        }
        return true;
    }

    int initializationChecker(Context context, String oneSignalAppId) {
        Integer supportErrorType;
        Integer pushErrorType;
        int subscribableStatus = 1;
        int deviceType = this.getDeviceType();
        try {
            UUID.fromString(oneSignalAppId);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "OneSignal AppId format is invalid.\nExample: 'b2f7f966-d8cc-11e4-bed1-df8f05be55ba'\n", t);
            return -999;
        }
        if ("b2f7f966-d8cc-11e4-bed1-df8f05be55ba".equals(oneSignalAppId) || "5eb5a37e-b458-11e3-ac11-000c2940e62c".equals(oneSignalAppId)) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "OneSignal Example AppID detected, please update to your app's id found on OneSignal.com");
        }
        if (deviceType == 1 && (pushErrorType = this.checkForGooglePushLibrary()) != null) {
            subscribableStatus = pushErrorType;
        }
        if ((supportErrorType = this.checkAndroidSupportLibrary(context)) != null) {
            subscribableStatus = supportErrorType;
        }
        return subscribableStatus;
    }

    @Keep
    private static boolean opaqueHasClass(Class<?> _class) {
        return true;
    }

    static boolean hasFCMLibrary() {
        try {
            return OSUtils.opaqueHasClass(FirebaseMessaging.class);
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    static boolean hasGMSLocationLibrary() {
        try {
            return OSUtils.opaqueHasClass(LocationListener.class);
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private static boolean hasHMSAvailabilityLibrary() {
        try {
            return OSUtils.opaqueHasClass(HuaweiApiAvailability.class);
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private static boolean hasHMSPushKitLibrary() {
        try {
            return OSUtils.opaqueHasClass(HmsInstanceId.class);
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private static boolean hasHMSAGConnectLibrary() {
        try {
            return OSUtils.opaqueHasClass(AGConnectServicesConfig.class);
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    static boolean hasHMSLocationLibrary() {
        try {
            return OSUtils.opaqueHasClass(LocationCallback.class);
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    static boolean hasAllHMSLibrariesForPushKit() {
        return OSUtils.hasHMSAGConnectLibrary() && OSUtils.hasHMSPushKitLibrary();
    }

    Integer checkForGooglePushLibrary() {
        boolean hasFCMLibrary = OSUtils.hasFCMLibrary();
        if (!hasFCMLibrary) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "The Firebase FCM library is missing! Please make sure to include it in your project.");
            return -4;
        }
        return null;
    }

    private static boolean hasWakefulBroadcastReceiver() {
        try {
            return WakefulBroadcastReceiver.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean hasNotificationManagerCompat() {
        try {
            return NotificationManagerCompat.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean hasJobIntentService() {
        try {
            return JobIntentService.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private Integer checkAndroidSupportLibrary(Context context) {
        boolean hasWakefulBroadcastReceiver = OSUtils.hasWakefulBroadcastReceiver();
        boolean hasNotificationManagerCompat = OSUtils.hasNotificationManagerCompat();
        if (!hasWakefulBroadcastReceiver && !hasNotificationManagerCompat) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "Could not find the Android Support Library. Please make sure it has been correctly added to your project.");
            return -3;
        }
        if (!hasWakefulBroadcastReceiver || !hasNotificationManagerCompat) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "The included Android Support Library is to old or incomplete. Please update to the 26.0.0 revision or newer.");
            return -5;
        }
        if (Build.VERSION.SDK_INT >= 26 && OSUtils.getTargetSdkVersion(context) >= 26 && !OSUtils.hasJobIntentService()) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "The included Android Support Library is to old or incomplete. Please update to the 26.0.0 revision or newer.");
            return -5;
        }
        return null;
    }

    private static boolean packageInstalledAndEnabled(@NonNull String packageName) {
        GetPackageInfoResult result = PackageInfoHelper.Companion.getInfo(OneSignal.appContext, packageName, 128);
        if (!result.getSuccessful()) {
            return false;
        }
        PackageInfo info = result.getPackageInfo();
        if (info == null) {
            return false;
        }
        return info.applicationInfo.enabled;
    }

    static boolean isGMSInstalledAndEnabled() {
        return OSUtils.packageInstalledAndEnabled("com.google.android.gms");
    }

    @TargetApi(value=24)
    private static boolean isHMSCoreInstalledAndEnabled() {
        HuaweiApiAvailability availability = HuaweiApiAvailability.getInstance();
        try {
            return availability.isHuaweiMobileServicesAvailable(OneSignal.appContext) == 0;
        }
        catch (Exception e) {
            if (!(e instanceof DeadSystemException)) {
                throw e;
            }
            return false;
        }
    }

    private static boolean isHMSCoreInstalledAndEnabledFallback() {
        return OSUtils.packageInstalledAndEnabled(HMS_CORE_SERVICES_PACKAGE);
    }

    private boolean supportsADM() {
        try {
            Class.forName("com.amazon.device.messaging.ADM");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean supportsHMS() {
        if (!OSUtils.hasHMSAvailabilityLibrary() || !OSUtils.hasAllHMSLibrariesForPushKit()) {
            return false;
        }
        return OSUtils.isHMSCoreInstalledAndEnabled();
    }

    private boolean supportsGooglePush() {
        if (!OSUtils.hasFCMLibrary()) {
            return false;
        }
        return OSUtils.isGMSInstalledAndEnabled();
    }

    int getDeviceType() {
        if (this.supportsADM()) {
            return 2;
        }
        boolean supportsHMS = this.supportsHMS();
        boolean supportsFCM = this.supportsGooglePush();
        if (supportsFCM && supportsHMS) {
            Context context = OneSignal.appContext;
            boolean preferHMS = context != null && OSUtils.getManifestMetaBoolean(context, PREFER_HMS_METADATA_NAME);
            return preferHMS ? 13 : 1;
        }
        if (supportsFCM) {
            return 1;
        }
        if (supportsHMS) {
            return 13;
        }
        if (OSUtils.isGMSInstalledAndEnabled()) {
            return 1;
        }
        if (OSUtils.isHMSCoreInstalledAndEnabledFallback()) {
            return 13;
        }
        return 1;
    }

    static boolean isAndroidDeviceType() {
        return new OSUtils().getDeviceType() == 1;
    }

    static boolean isFireOSDeviceType() {
        return new OSUtils().getDeviceType() == 2;
    }

    static boolean isHuaweiDeviceType() {
        return new OSUtils().getDeviceType() == 13;
    }

    Integer getNetType() {
        ConnectivityManager cm = (ConnectivityManager)OneSignal.appContext.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        if (netInfo != null) {
            int networkType = netInfo.getType();
            if (networkType == 1 || networkType == 9) {
                return 0;
            }
            return 1;
        }
        return null;
    }

    String getCarrierName() {
        try {
            TelephonyManager manager = (TelephonyManager)OneSignal.appContext.getSystemService("phone");
            String carrierName = manager.getNetworkOperatorName();
            return "".equals(carrierName) ? null : carrierName;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    static Bundle getManifestMetaBundle(Context context) {
        ApplicationInfo ai = ApplicationInfoHelper.Companion.getInfo(context);
        if (ai == null) {
            return null;
        }
        return ai.metaData;
    }

    static boolean getManifestMetaBoolean(Context context, String metaName) {
        Bundle bundle = OSUtils.getManifestMetaBundle(context);
        if (bundle != null) {
            return bundle.getBoolean(metaName);
        }
        return false;
    }

    static String getManifestMeta(Context context, String metaName) {
        Bundle bundle = OSUtils.getManifestMetaBundle(context);
        if (bundle != null) {
            return bundle.getString(metaName);
        }
        return null;
    }

    static String getResourceString(Context context, String key, String defaultStr) {
        Resources resources = context.getResources();
        int bodyResId = resources.getIdentifier(key, "string", context.getPackageName());
        if (bodyResId != 0) {
            return resources.getString(bodyResId);
        }
        return defaultStr;
    }

    static boolean isValidEmail(String email) {
        if (email == null) {
            return false;
        }
        String emRegex = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern pattern = Pattern.compile(emRegex);
        return pattern.matcher(email).matches();
    }

    static boolean isStringNotEmpty(String body) {
        return !TextUtils.isEmpty((CharSequence)body);
    }

    static boolean areNotificationsEnabled(Context context) {
        try {
            return NotificationManagerCompat.from((Context)OneSignal.appContext).areNotificationsEnabled();
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    static boolean isRunningOnMainThread() {
        return Thread.currentThread().equals(Looper.getMainLooper().getThread());
    }

    static void runOnMainUIThread(Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(runnable);
        }
    }

    static void runOnMainThreadDelayed(Runnable runnable, int delay) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(runnable, (long)delay);
    }

    static int getTargetSdkVersion(Context context) {
        ApplicationInfo applicationInfo = ApplicationInfoHelper.Companion.getInfo(context);
        if (applicationInfo == null) {
            return 15;
        }
        return applicationInfo.targetSdkVersion;
    }

    static boolean isValidResourceName(String name) {
        return name != null && !name.matches("^[0-9]");
    }

    static Uri getSoundUri(Context context, String sound) {
        int soundId;
        Resources resources = context.getResources();
        String packageName = context.getPackageName();
        if (OSUtils.isValidResourceName(sound) && (soundId = resources.getIdentifier(sound, "raw", packageName)) != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        soundId = resources.getIdentifier("onesignal_default_sound", "raw", packageName);
        if (soundId != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        return null;
    }

    static long[] parseVibrationPattern(JSONObject fcmBundle) {
        try {
            Object patternObj = fcmBundle.opt("vib_pt");
            JSONArray jsonVibArray = patternObj instanceof String ? new JSONArray((String)patternObj) : (JSONArray)patternObj;
            long[] longArray = new long[jsonVibArray.length()];
            for (int i = 0; i < jsonVibArray.length(); ++i) {
                longArray[i] = jsonVibArray.optLong(i);
            }
            return longArray;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static void openURLInBrowser(@NonNull String url) {
        OSUtils.openURLInBrowser(Uri.parse((String)url.trim()));
    }

    private static void openURLInBrowser(@NonNull Uri uri) {
        Intent intent = OSUtils.openURLInBrowserIntent(uri);
        OneSignal.appContext.startActivity(intent);
    }

    @NonNull
    static Intent openURLInBrowserIntent(@NonNull Uri uri) {
        Intent intent;
        SchemaType type;
        SchemaType schemaType = type = uri.getScheme() != null ? SchemaType.fromString(uri.getScheme()) : null;
        if (type == null) {
            type = SchemaType.HTTP;
            if (!uri.toString().contains("://")) {
                uri = Uri.parse((String)("http://" + uri.toString()));
            }
        }
        switch (type) {
            case DATA: {
                intent = Intent.makeMainSelectorActivity((String)"android.intent.action.MAIN", (String)"android.intent.category.APP_BROWSER");
                intent.setData(uri);
                break;
            }
            default: {
                intent = new Intent("android.intent.action.VIEW", uri);
            }
        }
        intent.addFlags(0x10000000);
        return intent;
    }

    static <T> Set<T> newConcurrentSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    static Set<String> newStringSetFromJSONArray(JSONArray jsonArray) throws JSONException {
        HashSet<String> stringSet = new HashSet<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringSet.add(jsonArray.getString(i));
        }
        return stringSet;
    }

    static boolean hasConfigChangeFlag(Activity activity, int configChangeFlag) {
        boolean hasFlag = false;
        try {
            int configChanges = activity.getPackageManager().getActivityInfo((ComponentName)activity.getComponentName(), (int)0).configChanges;
            int flagInt = configChanges & configChangeFlag;
            hasFlag = flagInt != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return hasFlag;
    }

    @NonNull
    static Collection<String> extractStringsFromCollection(@Nullable Collection<Object> collection) {
        ArrayList<String> result = new ArrayList<String>();
        if (collection == null) {
            return result;
        }
        for (Object value : collection) {
            if (!(value instanceof String)) continue;
            result.add((String)value);
        }
        return result;
    }

    @Nullable
    static Bundle jsonStringToBundle(@NonNull String data) {
        try {
            JSONObject jsonObject = new JSONObject(data);
            Bundle bundle = new Bundle();
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = jsonObject.getString(key);
                bundle.putString(key, value);
            }
            return bundle;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    static boolean shouldLogMissingAppIdError(@Nullable String appId) {
        if (appId != null) {
            return false;
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "OneSignal was not initialized, ensure to always initialize OneSignal from the onCreate of your Application class.");
        return true;
    }

    static int getRandomDelay(int minDelay, int maxDelay) {
        return new Random().nextInt(maxDelay + 1 - minDelay) + minDelay;
    }

    @NonNull
    static Throwable getRootCauseThrowable(@NonNull Throwable subjectThrowable) {
        Throwable throwable;
        for (throwable = subjectThrowable; throwable.getCause() != null && throwable.getCause() != throwable; throwable = throwable.getCause()) {
        }
        return throwable;
    }

    static String getRootCauseMessage(@NonNull Throwable throwable) {
        return OSUtils.getRootCauseThrowable(throwable).getMessage();
    }

    static void startThreadWithRetry(@NonNull Thread thread) {
        boolean started = false;
        while (!started) {
            try {
                thread.start();
                started = true;
            }
            catch (OutOfMemoryError ignored) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static enum SchemaType {
        DATA("data"),
        HTTPS("https"),
        HTTP("http");

        private final String text;

        private SchemaType(String text) {
            this.text = text;
        }

        public static SchemaType fromString(String text) {
            for (SchemaType type : SchemaType.values()) {
                if (!type.text.equalsIgnoreCase(text)) continue;
                return type;
            }
            return null;
        }
    }
}

