/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;

abstract class OSBackgroundSync {
    protected static final Object LOCK = new Object();
    protected boolean needsJobReschedule = false;
    private Thread syncBgThread;

    OSBackgroundSync() {
    }

    protected abstract String getSyncTaskThreadId();

    protected abstract int getSyncTaskId();

    protected abstract Class getSyncServiceJobClass();

    protected abstract Class getSyncServicePendingIntentClass();

    protected abstract void scheduleSyncTask(Context var1);

    void doBackgroundSync(Context context, Runnable runnable) {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "OSBackground sync, calling initWithContext");
        OneSignal.initWithContext(context);
        this.syncBgThread = new Thread(runnable, this.getSyncTaskThreadId());
        OSUtils.startThreadWithRetry(this.syncBgThread);
    }

    boolean stopSyncBgThread() {
        if (this.syncBgThread == null) {
            return false;
        }
        if (!this.syncBgThread.isAlive()) {
            return false;
        }
        this.syncBgThread.interrupt();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleBackgroundSyncTask(Context context, long delayMs) {
        Object object = LOCK;
        synchronized (object) {
            if (OSBackgroundSync.useJob()) {
                this.scheduleSyncServiceAsJob(context, delayMs);
            } else {
                this.scheduleSyncServiceAsAlarm(context, delayMs);
            }
        }
    }

    private boolean hasBootPermission(Context context) {
        return AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.RECEIVE_BOOT_COMPLETED") == 0;
    }

    @RequiresApi(api=21)
    private boolean isJobIdRunning(Context context) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        for (JobInfo jobInfo : jobScheduler.getAllPendingJobs()) {
            if (jobInfo.getId() != this.getSyncTaskId() || this.syncBgThread == null || !this.syncBgThread.isAlive()) continue;
            return true;
        }
        return false;
    }

    @RequiresApi(value=21)
    private void scheduleSyncServiceAsJob(Context context, long delayMs) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "OSBackgroundSync scheduleSyncServiceAsJob:atTime: " + delayMs);
        if (this.isJobIdRunning(context)) {
            OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "OSBackgroundSync scheduleSyncServiceAsJob Scheduler already running!");
            this.needsJobReschedule = true;
            return;
        }
        JobInfo.Builder jobBuilder = new JobInfo.Builder(this.getSyncTaskId(), new ComponentName(context, this.getSyncServiceJobClass()));
        jobBuilder.setMinimumLatency(delayMs).setRequiredNetworkType(1);
        if (this.hasBootPermission(context)) {
            jobBuilder.setPersisted(true);
        }
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        try {
            int result = jobScheduler.schedule(jobBuilder.build());
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "OSBackgroundSync scheduleSyncServiceAsJob:result: " + result);
        }
        catch (NullPointerException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "scheduleSyncServiceAsJob called JobScheduler.jobScheduler which triggered an internal null Android error. Skipping job.", e);
        }
    }

    private void scheduleSyncServiceAsAlarm(Context context, long delayMs) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, this.getClass().getSimpleName() + " scheduleServiceSyncTask:atTime: " + delayMs);
        PendingIntent pendingIntent = this.syncServicePendingIntent(context);
        AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
        long triggerAtMs = OneSignal.getTime().getCurrentTimeMillis() + delayMs;
        alarm.set(0, triggerAtMs, pendingIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelBackgroundSyncTask(Context context) {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + " cancel background sync");
        Object object = LOCK;
        synchronized (object) {
            if (OSBackgroundSync.useJob()) {
                JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
                jobScheduler.cancel(this.getSyncTaskId());
            } else {
                AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                alarmManager.cancel(this.syncServicePendingIntent(context));
            }
        }
    }

    private PendingIntent syncServicePendingIntent(Context context) {
        return PendingIntent.getService((Context)context, (int)this.getSyncTaskId(), (Intent)new Intent(context, this.getSyncServicePendingIntentClass()), (int)0xC000000);
    }

    private static boolean useJob() {
        return Build.VERSION.SDK_INT >= 21;
    }
}

