/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;

class OneSignalAnimate {
    OneSignalAnimate() {
    }

    static Animation animateViewByTranslation(View view, float deltaFromY, float deltaToY, int duration, Interpolator interpolator, Animation.AnimationListener animCallback) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, deltaFromY, deltaToY);
        translateAnimation.setDuration((long)duration);
        translateAnimation.setInterpolator(interpolator);
        if (animCallback != null) {
            translateAnimation.setAnimationListener(animCallback);
        }
        view.setAnimation((Animation)translateAnimation);
        return translateAnimation;
    }

    static ValueAnimator animateViewColor(final View view, int duration, int colorStart, int colorEnd, Animator.AnimatorListener animCallback) {
        ValueAnimator backgroundAnimation = new ValueAnimator();
        backgroundAnimation.setDuration((long)duration);
        backgroundAnimation.setIntValues(new int[]{colorStart, colorEnd});
        backgroundAnimation.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        backgroundAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                view.setBackgroundColor(((Integer)valueAnimator.getAnimatedValue()).intValue());
            }
        });
        if (animCallback != null) {
            backgroundAnimation.addListener(animCallback);
        }
        return backgroundAnimation;
    }

    static Animation animateViewSmallToLarge(View view, int duration, Interpolator interpolator, Animation.AnimationListener animCallback) {
        ScaleAnimation scaleAnimation = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.5f);
        scaleAnimation.setDuration((long)duration);
        scaleAnimation.setInterpolator(interpolator);
        if (animCallback != null) {
            scaleAnimation.setAnimationListener(animCallback);
        }
        view.setAnimation((Animation)scaleAnimation);
        return scaleAnimation;
    }
}

