/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.Nullable;
import com.onesignal.ImmutableJSONObject;
import com.onesignal.JSONUtils;
import com.onesignal.LocationController;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.UserState;
import java.util.HashMap;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

abstract class UserStateSynchronizer {
    private static final String CURRENT_STATE = "CURRENT_STATE";
    private static final String TOSYNC_STATE = "TOSYNC_STATE";
    private static final String SESSION = "session";
    private static final String ID = "id";
    private static final String ERRORS = "errors";
    protected static final String IDENTIFIER = "identifier";
    protected static final String DEVICE_TYPE = "device_type";
    protected static final String DEVICE_PLAYER_ID = "device_player_id";
    protected static final String PARENT_PLAYER_ID = "parent_player_id";
    protected static final String USER_SUBSCRIBE_PREF = "userSubscribePref";
    protected static final String ANDROID_PERMISSION = "androidPermission";
    protected static final String SUBSCRIBABLE_STATUS = "subscribableStatus";
    protected static final String TAGS = "tags";
    protected static final String LANGUAGE = "language";
    protected static final String EXTERNAL_USER_ID = "external_user_id";
    protected static final String EMAIL_KEY = "email";
    protected static final String LOGOUT_EMAIL = "logoutEmail";
    protected static final String SMS_NUMBER_KEY = "sms_number";
    static final String EXTERNAL_USER_ID_AUTH_HASH = "external_user_id_auth_hash";
    static final String EMAIL_AUTH_HASH_KEY = "email_auth_hash";
    static final String SMS_AUTH_HASH_KEY = "sms_auth_hash";
    static final String APP_ID = "app_id";
    protected final Object LOCK = new Object();
    private OneSignalStateSynchronizer.UserStateSynchronizerType channel;
    private boolean canMakeUpdates;
    private AtomicBoolean runningSyncUserState = new AtomicBoolean();
    private final Queue<OneSignal.ChangeTagsUpdateHandler> sendTagsHandlers = new ConcurrentLinkedQueue<OneSignal.ChangeTagsUpdateHandler>();
    private final Queue<OneSignal.OSInternalExternalUserIdUpdateCompletionHandler> externalUserIdUpdateHandlers = new ConcurrentLinkedQueue<OneSignal.OSInternalExternalUserIdUpdateCompletionHandler>();
    private final Queue<OneSignalStateSynchronizer.OSDeviceInfoCompletionHandler> deviceInfoCompletionHandler = new ConcurrentLinkedQueue<OneSignalStateSynchronizer.OSDeviceInfoCompletionHandler>();
    HashMap<Integer, NetworkHandlerThread> networkHandlerThreads = new HashMap();
    private final Object networkHandlerSyncLock = new Object(){};
    protected boolean waitingForSessionResponse = false;
    private UserState currentUserState;
    private UserState toSyncUserState;

    UserStateSynchronizer(OneSignalStateSynchronizer.UserStateSynchronizerType channel) {
        this.channel = channel;
    }

    OneSignalStateSynchronizer.UserStateSynchronizerType getChannelType() {
        return this.channel;
    }

    String getChannelString() {
        return this.channel.name().toLowerCase();
    }

    abstract void saveChannelId(String var1);

    abstract boolean getSubscribed();

    String getRegistrationId() {
        return this.getToSyncUserState().getSyncValues().optString(IDENTIFIER, null);
    }

    abstract GetTagsResult getTags(boolean var1);

    @Nullable
    abstract String getExternalId(boolean var1);

    boolean hasQueuedHandlers() {
        return this.externalUserIdUpdateHandlers.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject generateJsonDiff(JSONObject cur, JSONObject changedTo, JSONObject baseOutput, Set<String> includeFields) {
        Object object = this.LOCK;
        synchronized (object) {
            return JSONUtils.generateJsonDiff(cur, changedTo, baseOutput, includeFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserState getCurrentUserState() {
        if (this.currentUserState == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.currentUserState == null) {
                    this.currentUserState = this.newUserState(CURRENT_STATE, true);
                }
            }
        }
        return this.currentUserState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserState getToSyncUserState() {
        if (this.toSyncUserState == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.toSyncUserState == null) {
                    this.toSyncUserState = this.newUserState(TOSYNC_STATE, true);
                }
            }
        }
        return this.toSyncUserState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initUserState() {
        if (this.currentUserState == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.currentUserState == null) {
                    this.currentUserState = this.newUserState(CURRENT_STATE, true);
                }
            }
        }
        this.getToSyncUserState();
    }

    protected abstract UserState newUserState(String var1, boolean var2);

    void clearLocation() {
        this.getToSyncUserState().clearLocation();
        this.getToSyncUserState().persistState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean persist() {
        if (this.toSyncUserState != null) {
            Object object = this.LOCK;
            synchronized (object) {
                boolean unSynced = this.getCurrentUserState().generateJsonDiff(this.toSyncUserState, this.isSessionCall()) != null;
                this.toSyncUserState.persistState();
                return unSynced;
            }
        }
        return false;
    }

    protected abstract OneSignal.LOG_LEVEL getLogLevel();

    protected abstract String getId();

    private boolean isSessionCall() {
        boolean toSyncSession = this.getToSyncUserState().getDependValues().optBoolean(SESSION);
        return (toSyncSession || this.getId() == null) && !this.waitingForSessionResponse;
    }

    private boolean syncEmailLogout() {
        return this.getToSyncUserState().getDependValues().optBoolean(LOGOUT_EMAIL, false);
    }

    void syncUserState(boolean fromSyncService) {
        this.runningSyncUserState.set(true);
        this.internalSyncUserState(fromSyncService);
        this.runningSyncUserState.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSyncUserState(boolean fromSyncService) {
        JSONObject dependDiff;
        JSONObject jsonBody;
        String userId = this.getId();
        if (this.syncEmailLogout() && userId != null) {
            this.doEmailLogout(userId);
            return;
        }
        if (this.currentUserState == null) {
            this.initUserState();
        }
        boolean isSessionCall = !fromSyncService && this.isSessionCall();
        Object object = this.LOCK;
        synchronized (object) {
            jsonBody = this.getCurrentUserState().generateJsonDiff(this.getToSyncUserState(), isSessionCall);
            UserState toSyncState = this.getToSyncUserState();
            dependDiff = this.getCurrentUserState().generateJsonDiffFromDependValues(toSyncState, null);
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "UserStateSynchronizer internalSyncUserState from session call: " + isSessionCall + " jsonBody: " + jsonBody);
            if (jsonBody == null) {
                this.getCurrentUserState().persistStateAfterSync(dependDiff, null);
                this.sendTagsHandlersPerformOnSuccess();
                this.externalUserIdUpdateHandlersPerformOnSuccess();
                this.deviceInfoHandlersPerformOnSuccess();
                return;
            }
            this.getToSyncUserState().persistState();
        }
        if (!isSessionCall) {
            this.doPutSync(userId, jsonBody, dependDiff);
        } else {
            this.doCreateOrNewSession(userId, jsonBody, dependDiff);
        }
    }

    private void doEmailLogout(String userId) {
        String urlStr = "players/" + userId + "/email_logout";
        JSONObject jsonBody = new JSONObject();
        try {
            ImmutableJSONObject syncValues;
            ImmutableJSONObject dependValues = this.getCurrentUserState().getDependValues();
            if (dependValues.has(EMAIL_AUTH_HASH_KEY)) {
                jsonBody.put(EMAIL_AUTH_HASH_KEY, (Object)dependValues.optString(EMAIL_AUTH_HASH_KEY));
            }
            if ((syncValues = this.getCurrentUserState().getSyncValues()).has(PARENT_PLAYER_ID)) {
                jsonBody.put(PARENT_PLAYER_ID, (Object)syncValues.optString(PARENT_PLAYER_ID));
            }
            jsonBody.put(APP_ID, (Object)syncValues.optString(APP_ID));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        OneSignalRestClient.postSync(urlStr, jsonBody, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Failed last request. statusCode: " + statusCode + "\nresponse: " + response);
                if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "already logged out of email")) {
                    UserStateSynchronizer.this.logoutEmailSyncSuccess();
                    return;
                }
                if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "not a valid device_type")) {
                    UserStateSynchronizer.this.handlePlayerDeletedFromServer();
                } else {
                    UserStateSynchronizer.this.handleNetworkFailure(statusCode);
                }
            }

            @Override
            void onSuccess(String response) {
                UserStateSynchronizer.this.logoutEmailSyncSuccess();
            }
        });
    }

    private void logoutEmailSyncSuccess() {
        this.getToSyncUserState().removeFromDependValues(LOGOUT_EMAIL);
        this.toSyncUserState.removeFromDependValues(EMAIL_AUTH_HASH_KEY);
        this.toSyncUserState.removeFromSyncValues(PARENT_PLAYER_ID);
        this.toSyncUserState.removeFromSyncValues(EMAIL_KEY);
        this.toSyncUserState.persistState();
        this.getCurrentUserState().removeFromDependValues(EMAIL_AUTH_HASH_KEY);
        this.getCurrentUserState().removeFromSyncValues(PARENT_PLAYER_ID);
        String emailLoggedOut = this.getCurrentUserState().getSyncValues().optString(EMAIL_KEY);
        this.getCurrentUserState().removeFromSyncValues(EMAIL_KEY);
        OneSignalStateSynchronizer.setNewSessionForEmail();
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Device successfully logged out of email: " + emailLoggedOut);
        OneSignal.handleSuccessfulEmailLogout();
    }

    private void doPutSync(String userId, final JSONObject jsonBody, final JSONObject dependDiff) {
        if (userId == null) {
            OneSignal.onesignalLog(this.getLogLevel(), "Error updating the user record because of the null user id");
            this.sendTagsHandlersPerformOnFailure(new OneSignal.SendTagsError(-1, "Unable to update tags: the current user is not registered with OneSignal"));
            this.externalUserIdUpdateHandlersPerformOnFailure();
            this.deviceInfoHandlersPerformOnFailure(new OneSignalStateSynchronizer.OSDeviceInfoError(-1, "Unable to set Language: the current user is not registered with OneSignal"));
            return;
        }
        OneSignalRestClient.putSync("players/" + userId, jsonBody, new OneSignalRestClient.ResponseHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Failed PUT sync request with status code: " + statusCode + " and response: " + response);
                Object object = UserStateSynchronizer.this.LOCK;
                synchronized (object) {
                    if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "No user with this id found")) {
                        UserStateSynchronizer.this.handlePlayerDeletedFromServer();
                    } else {
                        UserStateSynchronizer.this.handleNetworkFailure(statusCode);
                    }
                }
                if (jsonBody.has(UserStateSynchronizer.TAGS)) {
                    UserStateSynchronizer.this.sendTagsHandlersPerformOnFailure(new OneSignal.SendTagsError(statusCode, response));
                }
                if (jsonBody.has(UserStateSynchronizer.EXTERNAL_USER_ID)) {
                    OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Error setting external user id for push with status code: " + statusCode + " and message: " + response);
                    UserStateSynchronizer.this.externalUserIdUpdateHandlersPerformOnFailure();
                }
                if (jsonBody.has(UserStateSynchronizer.LANGUAGE)) {
                    UserStateSynchronizer.this.deviceInfoHandlersPerformOnFailure(new OneSignalStateSynchronizer.OSDeviceInfoError(statusCode, response));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onSuccess(String response) {
                Object object = UserStateSynchronizer.this.LOCK;
                synchronized (object) {
                    UserStateSynchronizer.this.getCurrentUserState().persistStateAfterSync(dependDiff, jsonBody);
                    UserStateSynchronizer.this.onSuccessfulSync(jsonBody);
                }
                if (jsonBody.has(UserStateSynchronizer.TAGS)) {
                    UserStateSynchronizer.this.sendTagsHandlersPerformOnSuccess();
                }
                if (jsonBody.has(UserStateSynchronizer.EXTERNAL_USER_ID)) {
                    UserStateSynchronizer.this.externalUserIdUpdateHandlersPerformOnSuccess();
                }
                if (jsonBody.has(UserStateSynchronizer.LANGUAGE)) {
                    UserStateSynchronizer.this.deviceInfoHandlersPerformOnSuccess();
                }
            }
        });
    }

    private void doCreateOrNewSession(final String userId, final JSONObject jsonBody, final JSONObject dependDiff) {
        String urlStr = userId == null ? "players" : "players/" + userId + "/on_session";
        this.waitingForSessionResponse = true;
        this.addOnSessionOrCreateExtras(jsonBody);
        OneSignalRestClient.postSync(urlStr, jsonBody, new OneSignalRestClient.ResponseHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                Object object = UserStateSynchronizer.this.LOCK;
                synchronized (object) {
                    UserStateSynchronizer.this.waitingForSessionResponse = false;
                    OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Failed last request. statusCode: " + statusCode + "\nresponse: " + response);
                    if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "not a valid device_type")) {
                        UserStateSynchronizer.this.handlePlayerDeletedFromServer();
                    } else {
                        UserStateSynchronizer.this.handleNetworkFailure(statusCode);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onSuccess(String response) {
                Object object = UserStateSynchronizer.this.LOCK;
                synchronized (object) {
                    UserStateSynchronizer.this.waitingForSessionResponse = false;
                    UserStateSynchronizer.this.getCurrentUserState().persistStateAfterSync(dependDiff, jsonBody);
                    try {
                        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "doCreateOrNewSession:response: " + response);
                        JSONObject jsonResponse = new JSONObject(response);
                        if (jsonResponse.has(UserStateSynchronizer.ID)) {
                            String newUserId = jsonResponse.optString(UserStateSynchronizer.ID);
                            UserStateSynchronizer.this.updateIdDependents(newUserId);
                            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Device registered, UserId = " + newUserId);
                        } else {
                            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "session sent, UserId = " + userId);
                        }
                        UserStateSynchronizer.this.getUserStateForModification().putOnDependValues(UserStateSynchronizer.SESSION, false);
                        UserStateSynchronizer.this.getUserStateForModification().persistState();
                        if (jsonResponse.has("in_app_messages")) {
                            OneSignal.getInAppMessageController().receivedInAppMessageJson(jsonResponse.getJSONArray("in_app_messages"));
                        }
                        UserStateSynchronizer.this.onSuccessfulSync(jsonBody);
                    }
                    catch (JSONException e) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "ERROR parsing on_session or create JSON Response.", e);
                    }
                }
            }
        });
    }

    protected abstract void onSuccessfulSync(JSONObject var1);

    private void handleNetworkFailure(int statusCode) {
        if (statusCode == 403) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "403 error updating player, omitting further retries!");
            this.fireNetworkFailureEvents();
            return;
        }
        boolean retried = this.getNetworkHandlerThread(0).doRetry();
        if (!retried) {
            this.fireNetworkFailureEvents();
        }
    }

    private void fireNetworkFailureEvents() {
        JSONObject jsonBody = this.getCurrentUserState().generateJsonDiff(this.toSyncUserState, false);
        if (jsonBody != null) {
            this.fireEventsForUpdateFailure(jsonBody);
        }
        if (this.getToSyncUserState().getDependValues().optBoolean(LOGOUT_EMAIL, false)) {
            OneSignal.handleFailedEmailLogout();
        }
    }

    protected abstract void fireEventsForUpdateFailure(JSONObject var1);

    protected abstract void addOnSessionOrCreateExtras(JSONObject var1);

    private boolean response400WithErrorsContaining(int statusCode, String response, String contains) {
        if (statusCode == 400 && response != null) {
            try {
                JSONObject responseJson = new JSONObject(response);
                return responseJson.has(ERRORS) && responseJson.optString(ERRORS).contains(contains);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NetworkHandlerThread getNetworkHandlerThread(Integer type) {
        Object object = this.networkHandlerSyncLock;
        synchronized (object) {
            if (!this.networkHandlerThreads.containsKey(type)) {
                this.networkHandlerThreads.put(type, new NetworkHandlerThread(type));
            }
            return this.networkHandlerThreads.get(type);
        }
    }

    protected UserState getUserStateForModification() {
        if (this.toSyncUserState == null) {
            this.toSyncUserState = this.getCurrentUserState().deepClone(TOSYNC_STATE);
        }
        this.scheduleSyncToServer();
        return this.toSyncUserState;
    }

    protected abstract void scheduleSyncToServer();

    void updateDeviceInfo(JSONObject deviceInfo, @Nullable OneSignalStateSynchronizer.OSDeviceInfoCompletionHandler handler) {
        if (handler != null) {
            this.deviceInfoCompletionHandler.add(handler);
        }
        this.getUserStateForModification().generateJsonDiffFromIntoSyncValued(deviceInfo, null);
    }

    abstract void updateState(JSONObject var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNewSession() {
        try {
            Object object = this.LOCK;
            synchronized (object) {
                this.getUserStateForModification().putOnDependValues(SESSION, true);
                this.getUserStateForModification().persistState();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    boolean getSyncAsNewSession() {
        return this.getUserStateForModification().getDependValues().optBoolean(SESSION);
    }

    void sendTags(JSONObject tags, @Nullable OneSignal.ChangeTagsUpdateHandler handler) {
        if (handler != null) {
            this.sendTagsHandlers.add(handler);
        }
        UserState userStateTags = this.getUserStateForModification();
        userStateTags.generateJsonDiffFromIntoSyncValued(tags, null);
    }

    void syncHashedEmail(JSONObject emailFields) {
        this.getUserStateForModification().generateJsonDiffFromIntoSyncValued(emailFields, null);
    }

    void setExternalUserId(String externalId, String externalIdAuthHash, OneSignal.OSInternalExternalUserIdUpdateCompletionHandler handler) throws JSONException {
        if (handler != null) {
            this.externalUserIdUpdateHandlers.add(handler);
        }
        UserState userState = this.getUserStateForModification();
        userState.putOnSyncValues(EXTERNAL_USER_ID, externalId);
        if (externalIdAuthHash != null) {
            userState.putOnSyncValues(EXTERNAL_USER_ID_AUTH_HASH, externalIdAuthHash);
        }
    }

    abstract void setSubscription(boolean var1);

    private void handlePlayerDeletedFromServer() {
        OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Creating new player based on missing player_id noted above.");
        OneSignal.handleSuccessfulEmailLogout();
        this.resetCurrentState();
        this.updateIdDependents(null);
        this.scheduleSyncToServer();
    }

    void resetCurrentState() {
        this.getCurrentUserState().setSyncValues(new JSONObject());
        this.getCurrentUserState().persistState();
    }

    public abstract boolean getUserSubscribePreference();

    public abstract void setPermission(boolean var1);

    void updateLocation(LocationController.LocationPoint point) {
        UserState userState = this.getUserStateForModification();
        userState.setLocation(point);
    }

    abstract void updateIdDependents(String var1);

    abstract void logoutChannel();

    void sendPurchases(JSONObject jsonBody, OneSignalRestClient.ResponseHandler responseHandler) {
        OneSignalRestClient.post("players/" + this.getId() + "/on_purchase", jsonBody, responseHandler);
    }

    void readyToUpdate(boolean canMakeUpdates) {
        boolean changed = this.canMakeUpdates != canMakeUpdates;
        this.canMakeUpdates = canMakeUpdates;
        if (changed && canMakeUpdates) {
            this.scheduleSyncToServer();
        }
    }

    private void sendTagsHandlersPerformOnSuccess() {
        OneSignal.ChangeTagsUpdateHandler handler;
        JSONObject tags = OneSignalStateSynchronizer.getTags((boolean)false).result;
        while ((handler = this.sendTagsHandlers.poll()) != null) {
            handler.onSuccess(tags);
        }
    }

    private void sendTagsHandlersPerformOnFailure(OneSignal.SendTagsError error) {
        OneSignal.ChangeTagsUpdateHandler handler;
        while ((handler = this.sendTagsHandlers.poll()) != null) {
            handler.onFailure(error);
        }
    }

    private void externalUserIdUpdateHandlersPerformOnSuccess() {
        OneSignal.OSInternalExternalUserIdUpdateCompletionHandler handler;
        while ((handler = this.externalUserIdUpdateHandlers.poll()) != null) {
            handler.onComplete(this.getChannelString(), true);
        }
    }

    private void externalUserIdUpdateHandlersPerformOnFailure() {
        OneSignal.OSInternalExternalUserIdUpdateCompletionHandler handler;
        while ((handler = this.externalUserIdUpdateHandlers.poll()) != null) {
            handler.onComplete(this.getChannelString(), false);
        }
    }

    private void deviceInfoHandlersPerformOnSuccess() {
        OneSignalStateSynchronizer.OSDeviceInfoCompletionHandler handler;
        String language = OneSignalStateSynchronizer.getLanguage();
        while ((handler = this.deviceInfoCompletionHandler.poll()) != null) {
            handler.onSuccess(language);
        }
    }

    private void deviceInfoHandlersPerformOnFailure(OneSignalStateSynchronizer.OSDeviceInfoError error) {
        OneSignalStateSynchronizer.OSDeviceInfoCompletionHandler handler;
        while ((handler = this.deviceInfoCompletionHandler.poll()) != null) {
            handler.onFailure(error);
        }
    }

    class NetworkHandlerThread
    extends HandlerThread {
        private static final String THREAD_NAME_PREFIX = "OSH_NetworkHandlerThread_";
        protected static final int NETWORK_HANDLER_USERSTATE = 0;
        int mType;
        Handler mHandler;
        static final int MAX_RETRIES = 3;
        static final int NETWORK_CALL_DELAY_TO_BUFFER_MS = 5000;
        int currentRetry;

        NetworkHandlerThread(int type) {
            super(THREAD_NAME_PREFIX + (Object)((Object)UserStateSynchronizer.this.channel));
            this.mType = type;
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runNewJobDelayed() {
            if (!UserStateSynchronizer.this.canMakeUpdates) {
                return;
            }
            Handler handler = this.mHandler;
            synchronized (handler) {
                this.currentRetry = 0;
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler.postDelayed(this.getNewRunnable(), 5000L);
            }
        }

        private Runnable getNewRunnable() {
            switch (this.mType) {
                case 0: {
                    return new Runnable(){

                        @Override
                        public void run() {
                            boolean syncUserState;
                            boolean bl = syncUserState = !UserStateSynchronizer.this.runningSyncUserState.get();
                            if (syncUserState) {
                                UserStateSynchronizer.this.syncUserState(false);
                            }
                        }
                    };
                }
            }
            return null;
        }

        void stopScheduledRunnable() {
            this.mHandler.removeCallbacksAndMessages(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean doRetry() {
            Handler handler = this.mHandler;
            synchronized (handler) {
                boolean doRetry = this.currentRetry < 3;
                boolean futureSync = this.mHandler.hasMessages(0);
                if (doRetry && !futureSync) {
                    ++this.currentRetry;
                    this.mHandler.postDelayed(this.getNewRunnable(), (long)(this.currentRetry * 15000));
                }
                return this.mHandler.hasMessages(0);
            }
        }
    }

    static class GetTagsResult {
        boolean serverSuccess;
        JSONObject result;

        GetTagsResult(boolean serverSuccess, JSONObject result) {
            this.serverSuccess = serverSuccess;
            this.result = result;
        }
    }
}

