/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OSNotification;
import com.onesignal.OSNotificationAction;
import com.onesignal.OSTimeoutHandler;
import com.onesignal.OneSignal;
import org.json.JSONException;
import org.json.JSONObject;

public class OSNotificationOpenedResult
implements OneSignal.EntryStateListener {
    private static final long PROCESS_NOTIFICATION_TIMEOUT = 5000L;
    private final OSTimeoutHandler timeoutHandler;
    private final Runnable timeoutRunnable;
    private OSNotification notification;
    private OSNotificationAction action;
    private boolean isComplete = false;

    public OSNotificationOpenedResult(OSNotification notification, OSNotificationAction action) {
        this.notification = notification;
        this.action = action;
        this.timeoutHandler = OSTimeoutHandler.getTimeoutHandler();
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Running complete from OSNotificationOpenedResult timeout runnable!");
                OSNotificationOpenedResult.this.complete(false);
            }
        };
        this.timeoutHandler.startTimeout(5000L, this.timeoutRunnable);
    }

    private void complete(boolean opened) {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "OSNotificationOpenedResult complete called with opened: " + opened);
        this.timeoutHandler.destroyTimeout(this.timeoutRunnable);
        if (this.isComplete) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "OSNotificationOpenedResult already completed");
            return;
        }
        this.isComplete = true;
        if (opened) {
            OneSignal.applicationOpenedByNotification(this.notification.getNotificationId());
        }
        OneSignal.removeEntryStateListener(this);
    }

    @Override
    public void onEntryStateChange(OneSignal.AppEntryAction appEntryState) {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "OSNotificationOpenedResult onEntryStateChange called with appEntryState: " + (Object)((Object)appEntryState));
        this.complete(OneSignal.AppEntryAction.APP_CLOSE.equals((Object)appEntryState));
    }

    @Deprecated
    public String stringify() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put("action", (Object)this.action.toJSONObject());
            mainObj.put("notification", (Object)this.notification.toJSONObject());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mainObj.toString();
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put("action", (Object)this.action.toJSONObject());
            mainObj.put("notification", (Object)this.notification.toJSONObject());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mainObj;
    }

    public OSNotification getNotification() {
        return this.notification;
    }

    public OSNotificationAction getAction() {
        return this.action;
    }

    public String toString() {
        return "OSNotificationOpenedResult{notification=" + this.notification + ", action=" + this.action + ", isComplete=" + this.isComplete + '}';
    }
}

