/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.onesignal.FCMBroadcastReceiver;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationOpenedProcessor;
import com.onesignal.OSNotificationFormatHelper;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class NotificationPayloadProcessorHMS {
    NotificationPayloadProcessorHMS() {
    }

    static void handleHMSNotificationOpenIntent(@NonNull Activity activity, @Nullable Intent intent) {
        OneSignal.initWithContext(activity.getApplicationContext());
        if (intent == null) {
            return;
        }
        JSONObject jsonData = NotificationPayloadProcessorHMS.covertHMSOpenIntentToJson(intent);
        if (jsonData == null) {
            return;
        }
        NotificationPayloadProcessorHMS.handleProcessJsonOpenData(activity, jsonData);
    }

    @Nullable
    private static JSONObject covertHMSOpenIntentToJson(@Nullable Intent intent) {
        if (!OSNotificationFormatHelper.isOneSignalIntent(intent)) {
            return null;
        }
        Bundle bundle = intent.getExtras();
        JSONObject jsonData = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        NotificationPayloadProcessorHMS.reformatButtonClickAction(jsonData);
        return jsonData;
    }

    private static void reformatButtonClickAction(@NonNull JSONObject jsonData) {
        try {
            JSONObject custom = NotificationBundleProcessor.getCustomJSONObject(jsonData);
            String actionId = (String)custom.remove("actionId");
            if (actionId == null) {
                return;
            }
            jsonData.put("actionId", (Object)actionId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void handleProcessJsonOpenData(@NonNull Activity activity, @NonNull JSONObject jsonData) {
        if (NotificationOpenedProcessor.handleIAMPreviewOpen(activity, jsonData)) {
            return;
        }
        OneSignal.handleNotificationOpen(activity, new JSONArray().put((Object)jsonData), false, OSNotificationFormatHelper.getOSNotificationIdFromJson(jsonData));
    }

    public static void processDataMessageReceived(final @NonNull Context context, @Nullable String data) {
        OneSignal.initWithContext(context);
        if (data == null) {
            return;
        }
        final Bundle bundle = OSUtils.jsonStringToBundle(data);
        if (bundle == null) {
            return;
        }
        NotificationBundleProcessor.ProcessBundleReceiverCallback bundleReceiverCallback2 = new NotificationBundleProcessor.ProcessBundleReceiverCallback(){

            @Override
            public void onBundleProcessed(@Nullable NotificationBundleProcessor.ProcessedBundleResult processedResult) {
                if (processedResult != null && processedResult.processed()) {
                    return;
                }
                FCMBroadcastReceiver.startFCMService(context, bundle);
            }
        };
        NotificationBundleProcessor.processBundleFromReceiver(context, bundle, bundleReceiverCallback2);
    }
}

