/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.ActivityLifecycleListener;
import com.onesignal.InAppMessageView;
import com.onesignal.OSInAppMessageContent;
import com.onesignal.OSInAppMessageInternal;
import com.onesignal.OSUtils;
import com.onesignal.OSViewUtils;
import com.onesignal.OSWebView;
import com.onesignal.OneSignal;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=19)
class WebViewManager
extends ActivityLifecycleHandler.ActivityAvailableListener {
    private static final String TAG = WebViewManager.class.getCanonicalName();
    private static final int MARGIN_PX_SIZE = OSViewUtils.dpToPx(24);
    private static final int IN_APP_MESSAGE_INIT_DELAY = 200;
    private final Object messageViewSyncLock = new Object(){};
    @Nullable
    private OSWebView webView;
    @Nullable
    private InAppMessageView messageView;
    @Nullable
    protected static WebViewManager lastInstance = null;
    @NonNull
    private Activity activity;
    @NonNull
    private OSInAppMessageInternal message;
    @NonNull
    private OSInAppMessageContent messageContent;
    @Nullable
    private String currentActivityName = null;
    private Integer lastPageHeight = null;
    private boolean dismissFired = false;
    private boolean closing = false;

    protected WebViewManager(@NonNull OSInAppMessageInternal message, @NonNull Activity activity, @NonNull OSInAppMessageContent content) {
        this.message = message;
        this.activity = activity;
        this.messageContent = content;
    }

    static void showMessageContent(final @NonNull OSInAppMessageInternal message, final @NonNull OSInAppMessageContent content) {
        final Activity currentActivity = OneSignal.getCurrentActivity();
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "in app message showMessageContent on currentActivity: " + currentActivity);
        if (currentActivity != null) {
            if (lastInstance != null && message.isPreview) {
                lastInstance.dismissAndAwaitNextMessage(new OneSignalGenericCallback(){

                    @Override
                    public void onComplete() {
                        lastInstance = null;
                        WebViewManager.initInAppMessage(currentActivity, message, content);
                    }
                });
            } else {
                WebViewManager.initInAppMessage(currentActivity, message, content);
            }
            return;
        }
        Looper.prepare();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                WebViewManager.showMessageContent(message, content);
            }
        }, 200L);
    }

    static void dismissCurrentInAppMessage() {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "WebViewManager IAM dismissAndAwaitNextMessage lastInstance: " + lastInstance);
        if (lastInstance != null) {
            lastInstance.dismissAndAwaitNextMessage(null);
        }
    }

    private static void initInAppMessage(final @NonNull Activity currentActivity, @NonNull OSInAppMessageInternal message, @NonNull OSInAppMessageContent content) {
        try {
            WebViewManager webViewManager;
            final String base64Str = Base64.encodeToString((byte[])content.getContentHtml().getBytes("UTF-8"), (int)2);
            lastInstance = webViewManager = new WebViewManager(message, currentActivity, content);
            OSUtils.runOnMainUIThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        webViewManager.setupWebView(currentActivity, base64Str);
                    }
                    catch (Exception e) {
                        if (e.getMessage() != null && e.getMessage().contains("No WebView installed")) {
                            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error setting up WebView: ", e);
                        }
                        throw e;
                    }
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Catch on initInAppMessage: ", e);
            e.printStackTrace();
        }
    }

    private static int pageRectToViewHeight(@NonNull Activity activity, @NonNull JSONObject jsonObject) {
        try {
            int pageHeight = jsonObject.getJSONObject("rect").getInt("height");
            int pxHeight = OSViewUtils.dpToPx(pageHeight);
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "getPageHeightData:pxHeight: " + pxHeight);
            int maxPxHeight = WebViewManager.getWebViewMaxSizeY(activity);
            if (pxHeight > maxPxHeight) {
                pxHeight = maxPxHeight;
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "getPageHeightData:pxHeight is over screen max: " + maxPxHeight);
            }
            return pxHeight;
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "pageRectToViewHeight could not get page height", e);
            return -1;
        }
    }

    private void calculateHeightAndShowWebViewAfterNewActivity() {
        if (this.messageView == null) {
            return;
        }
        if (this.messageView.getDisplayPosition() == Position.FULL_SCREEN) {
            this.showMessageView(null);
            return;
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "In app message new activity, calculate height and show ");
        OSViewUtils.decorViewReady(this.activity, new Runnable(){

            @Override
            public void run() {
                WebViewManager.this.setWebViewToMaxSize(WebViewManager.this.activity);
                WebViewManager.this.webView.evaluateJavascript("getPageMetaData()", (ValueCallback)new ValueCallback<String>(){

                    public void onReceiveValue(String value) {
                        try {
                            int pagePxHeight = WebViewManager.pageRectToViewHeight(WebViewManager.this.activity, new JSONObject(value));
                            WebViewManager.this.showMessageView(pagePxHeight);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    @Override
    void available(@NonNull Activity activity) {
        String lastActivityName = this.currentActivityName;
        this.activity = activity;
        this.currentActivityName = activity.getLocalClassName();
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "In app message activity available currentActivityName: " + this.currentActivityName + " lastActivityName: " + lastActivityName);
        if (lastActivityName == null) {
            this.showMessageView(null);
        } else if (!lastActivityName.equals(this.currentActivityName)) {
            if (!this.closing) {
                if (this.messageView != null) {
                    this.messageView.removeAllViews();
                }
                this.showMessageView(this.lastPageHeight);
            }
        } else {
            this.calculateHeightAndShowWebViewAfterNewActivity();
        }
    }

    @Override
    void stopped(@NonNull Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "In app message activity stopped, cleaning views, currentActivityName: " + this.currentActivityName + "\nactivity: " + this.activity + "\nmessageView: " + this.messageView);
        if (this.messageView != null && activity.getLocalClassName().equals(this.currentActivityName)) {
            this.messageView.removeAllViews();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessageView(@Nullable Integer newHeight) {
        Object object = this.messageViewSyncLock;
        synchronized (object) {
            if (this.messageView == null) {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "No messageView found to update a with a new height.");
                return;
            }
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "In app message, showing first one with height: " + newHeight);
            this.messageView.setWebView(this.webView);
            if (newHeight != null) {
                this.lastPageHeight = newHeight;
                this.messageView.updateHeight(newHeight);
            }
            this.messageView.showView(this.activity);
            this.messageView.checkIfShouldDismiss();
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void setupWebView(final @NonNull Activity currentActivity, final @NonNull String base64Message) {
        WebViewManager.enableWebViewRemoteDebugging();
        this.webView = new OSWebView((Context)currentActivity);
        this.webView.setOverScrollMode(2);
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.addJavascriptInterface(new OSJavaScriptInterface(), "OSAndroid");
        this.blurryRenderingWebViewForKitKatWorkAround(this.webView);
        OSViewUtils.decorViewReady(currentActivity, new Runnable(){

            @Override
            public void run() {
                WebViewManager.this.setWebViewToMaxSize(currentActivity);
                WebViewManager.this.webView.loadData(base64Message, "text/html; charset=utf-8", "base64");
            }
        });
    }

    private void blurryRenderingWebViewForKitKatWorkAround(@NonNull WebView webView) {
        if (Build.VERSION.SDK_INT == 19) {
            webView.setLayerType(1, null);
        }
    }

    private void setWebViewToMaxSize(Activity activity) {
        this.webView.layout(0, 0, WebViewManager.getWebViewMaxSizeX(activity), WebViewManager.getWebViewMaxSizeY(activity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMessageView(InAppMessageView view) {
        Object object = this.messageViewSyncLock;
        synchronized (object) {
            this.messageView = view;
        }
    }

    private void createNewInAppMessageView(boolean dragToDismissDisabled) {
        this.lastPageHeight = this.messageContent.getPageHeight();
        InAppMessageView newView = new InAppMessageView(this.webView, this.messageContent, dragToDismissDisabled);
        this.setMessageView(newView);
        this.messageView.setMessageController(new InAppMessageView.InAppMessageViewListener(){

            @Override
            public void onMessageWasShown() {
                OneSignal.getInAppMessageController().onMessageWasShown(WebViewManager.this.message);
            }

            @Override
            public void onMessageWillDismiss() {
                OneSignal.getInAppMessageController().onMessageWillDismiss(WebViewManager.this.message);
            }

            @Override
            public void onMessageWasDismissed() {
                OneSignal.getInAppMessageController().messageWasDismissed(WebViewManager.this.message);
                WebViewManager.this.removeActivityListener();
            }
        });
        ActivityLifecycleHandler activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler();
        if (activityLifecycleHandler != null) {
            activityLifecycleHandler.addActivityAvailableListener(TAG + this.message.messageId, this);
        }
    }

    private static void enableWebViewRemoteDebugging() {
        if (Build.VERSION.SDK_INT >= 19 && OneSignal.atLogLevel(OneSignal.LOG_LEVEL.DEBUG)) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
    }

    private static int getWebViewMaxSizeX(Activity activity) {
        return OSViewUtils.getWindowWidth(activity) - MARGIN_PX_SIZE * 2;
    }

    private static int getWebViewMaxSizeY(Activity activity) {
        return OSViewUtils.getWindowHeight(activity) - MARGIN_PX_SIZE * 2;
    }

    private void removeActivityListener() {
        ActivityLifecycleHandler activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler();
        if (activityLifecycleHandler != null) {
            activityLifecycleHandler.removeActivityAvailableListener(TAG + this.message.messageId);
        }
    }

    protected void dismissAndAwaitNextMessage(final @Nullable OneSignalGenericCallback callback) {
        if (this.messageView == null || this.dismissFired) {
            if (callback != null) {
                callback.onComplete();
            }
            return;
        }
        if (this.message != null && this.messageView != null) {
            OneSignal.getInAppMessageController().onMessageWillDismiss(this.message);
        }
        this.messageView.dismissAndAwaitNextMessage(new OneSignalGenericCallback(){

            @Override
            public void onComplete() {
                WebViewManager.this.dismissFired = false;
                WebViewManager.this.setMessageView(null);
                if (callback != null) {
                    callback.onComplete();
                }
            }
        });
        this.dismissFired = true;
    }

    class OSJavaScriptInterface {
        static final String JS_OBJ_NAME = "OSAndroid";
        static final String GET_PAGE_META_DATA_JS_FUNCTION = "getPageMetaData()";
        static final String EVENT_TYPE_KEY = "type";
        static final String EVENT_TYPE_RENDERING_COMPLETE = "rendering_complete";
        static final String EVENT_TYPE_ACTION_TAKEN = "action_taken";
        static final String EVENT_TYPE_PAGE_CHANGE = "page_change";
        static final String IAM_DISPLAY_LOCATION_KEY = "displayLocation";
        static final String IAM_PAGE_META_DATA_KEY = "pageMetaData";
        static final String IAM_DRAG_TO_DISMISS_DISABLED_KEY = "dragToDismissDisabled";

        OSJavaScriptInterface() {
        }

        @JavascriptInterface
        public void postMessage(String message) {
            try {
                String messageType;
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "OSJavaScriptInterface:postMessage: " + message);
                JSONObject jsonObject = new JSONObject(message);
                switch (messageType = jsonObject.getString(EVENT_TYPE_KEY)) {
                    case "rendering_complete": {
                        this.handleRenderComplete(jsonObject);
                        break;
                    }
                    case "action_taken": {
                        if (WebViewManager.this.messageView.isDragging()) break;
                        this.handleActionTaken(jsonObject);
                        break;
                    }
                    case "page_change": {
                        this.handlePageChange(jsonObject);
                        break;
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        private void handleRenderComplete(JSONObject jsonObject) {
            Position displayType = this.getDisplayLocation(jsonObject);
            int pageHeight = displayType == Position.FULL_SCREEN ? -1 : this.getPageHeightData(jsonObject);
            boolean dragToDismissDisabled = this.getDragToDismissDisabled(jsonObject);
            WebViewManager.this.messageContent.setDisplayLocation(displayType);
            WebViewManager.this.messageContent.setPageHeight(pageHeight);
            WebViewManager.this.createNewInAppMessageView(dragToDismissDisabled);
        }

        private int getPageHeightData(JSONObject jsonObject) {
            try {
                return WebViewManager.pageRectToViewHeight(WebViewManager.this.activity, jsonObject.getJSONObject(IAM_PAGE_META_DATA_KEY));
            }
            catch (JSONException e) {
                return -1;
            }
        }

        @NonNull
        private Position getDisplayLocation(JSONObject jsonObject) {
            Position displayLocation = Position.FULL_SCREEN;
            try {
                if (jsonObject.has(IAM_DISPLAY_LOCATION_KEY) && !jsonObject.get(IAM_DISPLAY_LOCATION_KEY).equals("")) {
                    displayLocation = Position.valueOf(jsonObject.optString(IAM_DISPLAY_LOCATION_KEY, "FULL_SCREEN").toUpperCase());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return displayLocation;
        }

        private boolean getDragToDismissDisabled(JSONObject jsonObject) {
            try {
                return jsonObject.getBoolean(IAM_DRAG_TO_DISMISS_DISABLED_KEY);
            }
            catch (JSONException e) {
                return false;
            }
        }

        private void handleActionTaken(JSONObject jsonObject) throws JSONException {
            JSONObject body = jsonObject.getJSONObject("body");
            String id2 = body.optString("id", null);
            WebViewManager.this.closing = body.getBoolean("close");
            if (((WebViewManager)WebViewManager.this).message.isPreview) {
                OneSignal.getInAppMessageController().onMessageActionOccurredOnPreview(WebViewManager.this.message, body);
            } else if (id2 != null) {
                OneSignal.getInAppMessageController().onMessageActionOccurredOnMessage(WebViewManager.this.message, body);
            }
            if (WebViewManager.this.closing) {
                WebViewManager.this.dismissAndAwaitNextMessage(null);
            }
        }

        private void handlePageChange(JSONObject jsonObject) throws JSONException {
            OneSignal.getInAppMessageController().onPageChanged(WebViewManager.this.message, jsonObject);
        }
    }

    static interface OneSignalGenericCallback {
        public void onComplete();
    }

    static enum Position {
        TOP_BANNER,
        BOTTOM_BANNER,
        CENTER_MODAL,
        FULL_SCREEN;


        boolean isBanner() {
            switch (this) {
                case TOP_BANNER: 
                case BOTTOM_BANNER: {
                    return true;
                }
            }
            return false;
        }
    }
}

