/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.huawei.hms.push.RemoteMessage;
import com.onesignal.NotificationPayloadProcessorHMS;
import com.onesignal.OneSignal;
import com.onesignal.PushRegistratorHMS;
import java.util.concurrent.atomic.AtomicBoolean;

public class OneSignalHmsEventBridge {
    private static final AtomicBoolean firstToken = new AtomicBoolean(true);

    public static void onNewToken(@NonNull Context context, @NonNull String token, @Nullable Bundle bundle) {
        if (firstToken.compareAndSet(true, false)) {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "OneSignalHmsEventBridge onNewToken - HMS token: " + token + " Bundle: " + bundle);
            PushRegistratorHMS.fireCallback(token);
        } else {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "OneSignalHmsEventBridge ignoring onNewToken - HMS token: " + token + " Bundle: " + bundle);
        }
    }

    @Deprecated
    public static void onNewToken(@NonNull Context context, @NonNull String token) {
        OneSignalHmsEventBridge.onNewToken(context, token, null);
    }

    public static void onMessageReceived(@NonNull Context context, @NonNull RemoteMessage message) {
        NotificationPayloadProcessorHMS.processDataMessageReceived(context, message.getData());
    }
}

