/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OSLogger;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0014J\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/onesignal/OSDelayTaskController;", "", "logger", "Lcom/onesignal/OSLogger;", "(Lcom/onesignal/OSLogger;)V", "maxDelay", "", "minDelay", "scheduledThreadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "delayTaskByRandom", "", "runnable", "Ljava/lang/Runnable;", "getRandomDelay", "shutdownNow", "JobThreadFactory", "onesignal_release"})
public class OSDelayTaskController {
    private final int maxDelay;
    private final int minDelay;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final OSLogger logger;

    protected int getRandomDelay() {
        return MathKt.roundToInt((double)(Math.random() * (double)(this.maxDelay - this.minDelay + 1) + (double)this.minDelay));
    }

    public void delayTaskByRandom(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        int randomNum = this.getRandomDelay();
        this.logger.debug("OSDelayTaskController delaying task " + randomNum + " second from thread: " + Thread.currentThread());
        this.scheduledThreadPoolExecutor.schedule(runnable, (long)randomNum, TimeUnit.SECONDS);
    }

    public final void shutdownNow() {
        this.scheduledThreadPoolExecutor.shutdownNow();
    }

    public OSDelayTaskController(@NotNull OSLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.maxDelay = 25;
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new JobThreadFactory());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/onesignal/OSDelayTaskController$JobThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "delayThreadName", "", "newThread", "Ljava/lang/Thread;", "runnable", "Ljava/lang/Runnable;", "onesignal_release"})
    private static final class JobThreadFactory
    implements ThreadFactory {
        private final String delayThreadName;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            return new Thread(runnable, this.delayThreadName);
        }

        public JobThreadFactory() {
            this.delayThreadName = "ONE_SIGNAL_DELAY";
        }
    }
}

