/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.work.ListenableWorker;
import com.onesignal.OSDelayTaskController;
import com.onesignal.OSReceiveReceiptRepository;
import com.onesignal.OSRemoteParamController;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;

class OSReceiveReceiptController {
    private final OSDelayTaskController taskController;
    private final OSReceiveReceiptRepository repository;
    private final OSRemoteParamController remoteParamController;
    private static OSReceiveReceiptController sInstance;

    private OSReceiveReceiptController(OSRemoteParamController remoteParamController, OSDelayTaskController taskController) {
        this.remoteParamController = remoteParamController;
        this.taskController = taskController;
        this.repository = new OSReceiveReceiptRepository();
    }

    public static synchronized OSReceiveReceiptController getInstance() {
        if (sInstance == null) {
            sInstance = new OSReceiveReceiptController(OneSignal.getRemoteParamController(), OneSignal.getDelayTaskController());
        }
        return sInstance;
    }

    void sendReceiveReceipt(final CallbackToFutureAdapter.Completer<ListenableWorker.Result> callbackCompleter, final @NonNull String notificationId) {
        final String appId = OneSignal.appId == null || OneSignal.appId.isEmpty() ? OneSignal.getSavedAppId() : OneSignal.appId;
        final String playerId = OneSignal.getUserId();
        if (!this.remoteParamController.isReceiveReceiptEnabled()) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "sendReceiveReceipt disable");
            this.endCallbackCompleterWithSuccess(callbackCompleter);
            return;
        }
        Runnable receiveReceiptRunnable = new Runnable(){

            @Override
            public void run() {
                OSReceiveReceiptController.this.repository.sendReceiveReceipt(appId, playerId, notificationId, new OneSignalRestClient.ResponseHandler(){

                    @Override
                    void onSuccess(String response) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Receive receipt sent for notificationID: " + notificationId);
                        OSReceiveReceiptController.this.endCallbackCompleterWithSuccess((CallbackToFutureAdapter.Completer<ListenableWorker.Result>)callbackCompleter);
                    }

                    @Override
                    void onFailure(int statusCode, String response, Throwable throwable) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Receive receipt failed with statusCode: " + statusCode + " response: " + response);
                        OSReceiveReceiptController.this.endCallbackCompleterWithSuccess((CallbackToFutureAdapter.Completer<ListenableWorker.Result>)callbackCompleter);
                    }
                });
            }
        };
        this.taskController.delayTaskByRandom(receiveReceiptRunnable);
    }

    private void endCallbackCompleterWithSuccess(CallbackToFutureAdapter.Completer<ListenableWorker.Result> callbackCompleter) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Receive receipt ending with success callback completer: " + callbackCompleter);
        if (callbackCompleter != null) {
            callbackCompleter.set((Object)ListenableWorker.Result.success());
        }
    }
}

