/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.iid.FirebaseInstanceId;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRemoteParams;
import com.onesignal.PushRegistratorAbstractGoogle;

class PushRegistratorFCM
extends PushRegistratorAbstractGoogle {
    private static final String FCM_DEFAULT_PROJECT_ID = "onesignal-shared-public";
    private static final String FCM_DEFAULT_APP_ID = "1:754795614042:android:c682b8144a8dd52bc1ad63";
    private static final String FCM_DEFAULT_API_KEY_BASE64 = "QUl6YVN5QW5UTG41LV80TWMyYTJQLWRLVWVFLWFCdGd5Q3JqbFlV";
    private static final String FCM_APP_NAME = "ONESIGNAL_SDK_FCM_APP_NAME";
    private FirebaseApp firebaseApp;

    PushRegistratorFCM() {
    }

    @Override
    String getProviderName() {
        return "FCM";
    }

    @Override
    String getToken(String senderId) throws Throwable {
        this.initFirebaseApp(senderId);
        FirebaseInstanceId instanceId = FirebaseInstanceId.getInstance((FirebaseApp)this.firebaseApp);
        return instanceId.getToken(senderId, "FCM");
    }

    private void initFirebaseApp(String senderId) {
        if (this.firebaseApp != null) {
            return;
        }
        OneSignalRemoteParams.Params remoteParams = OneSignal.getRemoteParams();
        FirebaseOptions firebaseOptions = new FirebaseOptions.Builder().setGcmSenderId(senderId).setApplicationId(PushRegistratorFCM.getAppId(remoteParams)).setApiKey(PushRegistratorFCM.getApiKey(remoteParams)).setProjectId(PushRegistratorFCM.getProjectId(remoteParams)).build();
        this.firebaseApp = FirebaseApp.initializeApp((Context)OneSignal.appContext, (FirebaseOptions)firebaseOptions, (String)FCM_APP_NAME);
    }

    @NonNull
    private static String getAppId(OneSignalRemoteParams.Params remoteParams) {
        if (remoteParams.fcmParams.appId != null) {
            return remoteParams.fcmParams.appId;
        }
        return FCM_DEFAULT_APP_ID;
    }

    @NonNull
    private static String getApiKey(OneSignalRemoteParams.Params remoteParams) {
        if (remoteParams.fcmParams.apiKey != null) {
            return remoteParams.fcmParams.apiKey;
        }
        return new String(Base64.decode((String)FCM_DEFAULT_API_KEY_BASE64, (int)0));
    }

    @NonNull
    private static String getProjectId(OneSignalRemoteParams.Params remoteParams) {
        if (remoteParams.fcmParams.projectId != null) {
            return remoteParams.fcmParams.projectId;
        }
        return FCM_DEFAULT_PROJECT_ID;
    }
}

