/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.onesignal.JSONUtils;
import com.onesignal.OSLogger;
import com.onesignal.OneSignal;
import com.onesignal.influence.data.OSChannelTracker;
import com.onesignal.influence.data.OSTrackerFactory;
import com.onesignal.influence.domain.OSInfluence;
import com.onesignal.influence.domain.OSInfluenceType;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class OSSessionManager {
    private static final String OS_END_CURRENT_SESSION = "OS_END_CURRENT_SESSION";
    protected OSTrackerFactory trackerFactory;
    private SessionListener sessionListener;
    private OSLogger logger;

    public OSSessionManager(@NonNull SessionListener sessionListener, OSTrackerFactory trackerFactory, OSLogger logger) {
        this.sessionListener = sessionListener;
        this.trackerFactory = trackerFactory;
        this.logger = logger;
    }

    void initSessionFromCache() {
        this.logger.debug("OneSignal SessionManager initSessionFromCache");
        this.trackerFactory.initFromCache();
    }

    void addSessionIds(@NonNull JSONObject jsonObject, List<OSInfluence> endingInfluences) {
        this.logger.debug("OneSignal SessionManager addSessionData with influences: " + endingInfluences.toString());
        this.trackerFactory.addSessionData(jsonObject, endingInfluences);
        this.logger.debug("OneSignal SessionManager addSessionIds on jsonObject: " + jsonObject);
    }

    void restartSessionIfNeeded(OneSignal.AppEntryAction entryAction) {
        List<OSChannelTracker> channelTrackers = this.trackerFactory.getChannelsToResetByEntryAction(entryAction);
        ArrayList<OSInfluence> updatedInfluences = new ArrayList<OSInfluence>();
        this.logger.debug("OneSignal SessionManager restartSessionIfNeeded with entryAction: " + (Object)((Object)entryAction) + "\n channelTrackers: " + channelTrackers.toString());
        for (OSChannelTracker channelTracker : channelTrackers) {
            JSONArray lastIds = channelTracker.getLastReceivedIds();
            this.logger.debug("OneSignal SessionManager restartSessionIfNeeded lastIds: " + lastIds);
            OSInfluence influence = channelTracker.getCurrentSessionInfluence();
            boolean updated = lastIds.length() > 0 ? this.setSession(channelTracker, OSInfluenceType.INDIRECT, null, lastIds) : this.setSession(channelTracker, OSInfluenceType.UNATTRIBUTED, null, null);
            if (!updated) continue;
            updatedInfluences.add(influence);
        }
        this.sendSessionEndingWithInfluences(updatedInfluences);
    }

    void onInAppMessageReceived(@NonNull String messageId) {
        this.logger.debug("OneSignal SessionManager onInAppMessageReceived messageId: " + messageId);
        OSChannelTracker inAppMessageTracker = this.trackerFactory.getIAMChannelTracker();
        inAppMessageTracker.saveLastId(messageId);
        inAppMessageTracker.resetAndInitInfluence();
    }

    void onDirectInfluenceFromIAMClick(@NonNull String messageId) {
        this.logger.debug("OneSignal SessionManager onDirectInfluenceFromIAMClick messageId: " + messageId);
        OSChannelTracker inAppMessageTracker = this.trackerFactory.getIAMChannelTracker();
        this.setSession(inAppMessageTracker, OSInfluenceType.DIRECT, messageId, null);
    }

    void onDirectInfluenceFromIAMClickFinished() {
        this.logger.debug("OneSignal SessionManager onDirectInfluenceFromIAMClickFinished");
        OSChannelTracker inAppMessageTracker = this.trackerFactory.getIAMChannelTracker();
        inAppMessageTracker.resetAndInitInfluence();
    }

    void onNotificationReceived(@Nullable String notificationId) {
        this.logger.debug("OneSignal SessionManager onNotificationReceived notificationId: " + notificationId);
        if (notificationId == null || notificationId.isEmpty()) {
            return;
        }
        OSChannelTracker notificationTracker = this.trackerFactory.getNotificationChannelTracker();
        notificationTracker.saveLastId(notificationId);
    }

    void onDirectInfluenceFromNotificationOpen(OneSignal.AppEntryAction entryAction, @Nullable String notificationId) {
        this.logger.debug("OneSignal SessionManager onDirectInfluenceFromNotificationOpen notificationId: " + notificationId);
        if (notificationId == null || notificationId.isEmpty()) {
            return;
        }
        this.attemptSessionUpgrade(entryAction, notificationId);
    }

    @NonNull
    List<OSInfluence> getInfluences() {
        return this.trackerFactory.getInfluences();
    }

    @NonNull
    List<OSInfluence> getSessionInfluences() {
        return this.trackerFactory.getSessionInfluences();
    }

    void attemptSessionUpgrade(OneSignal.AppEntryAction entryAction) {
        this.attemptSessionUpgrade(entryAction, null);
    }

    private void attemptSessionUpgrade(OneSignal.AppEntryAction entryAction, @Nullable String directId) {
        this.logger.debug("OneSignal SessionManager attemptSessionUpgrade with entryAction: " + (Object)((Object)entryAction));
        OSChannelTracker channelTrackerByAction = this.trackerFactory.getChannelByEntryAction(entryAction);
        List<OSChannelTracker> channelTrackersToReset = this.trackerFactory.getChannelsToResetByEntryAction(entryAction);
        ArrayList<OSInfluence> influencesToEnd = new ArrayList<OSInfluence>();
        OSInfluence lastInfluence = null;
        boolean updated = false;
        if (channelTrackerByAction != null) {
            lastInfluence = channelTrackerByAction.getCurrentSessionInfluence();
            updated = this.setSession(channelTrackerByAction, OSInfluenceType.DIRECT, directId == null ? channelTrackerByAction.getDirectId() : directId, null);
        }
        if (updated) {
            this.logger.debug("OneSignal SessionManager attemptSessionUpgrade channel updated, search for ending direct influences on channels: " + channelTrackersToReset);
            influencesToEnd.add(lastInfluence);
            for (OSChannelTracker tracker : channelTrackersToReset) {
                if (!tracker.getInfluenceType().isDirect()) continue;
                influencesToEnd.add(tracker.getCurrentSessionInfluence());
                tracker.resetAndInitInfluence();
            }
        }
        this.logger.debug("OneSignal SessionManager attemptSessionUpgrade try UNATTRIBUTED to INDIRECT upgrade");
        for (OSChannelTracker channelTracker : channelTrackersToReset) {
            JSONArray lastIds;
            if (!channelTracker.getInfluenceType().isUnattributed() || (lastIds = channelTracker.getLastReceivedIds()).length() <= 0 || entryAction.isAppClose()) continue;
            OSInfluence influence = channelTracker.getCurrentSessionInfluence();
            updated = this.setSession(channelTracker, OSInfluenceType.INDIRECT, null, lastIds);
            if (!updated) continue;
            influencesToEnd.add(influence);
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Trackers after update attempt: " + this.trackerFactory.getChannels().toString());
        this.sendSessionEndingWithInfluences(influencesToEnd);
    }

    private boolean setSession(@NonNull OSChannelTracker channelTracker, @NonNull OSInfluenceType influenceType, @Nullable String directNotificationId, @Nullable JSONArray indirectNotificationIds) {
        if (!this.willChangeSession(channelTracker, influenceType, directNotificationId, indirectNotificationIds)) {
            return false;
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "OSChannelTracker changed: " + channelTracker.getIdTag() + "\nfrom:\ninfluenceType: " + (Object)((Object)channelTracker.getInfluenceType()) + ", directNotificationId: " + channelTracker.getDirectId() + ", indirectNotificationIds: " + channelTracker.getIndirectIds() + "\nto:\ninfluenceType: " + (Object)((Object)influenceType) + ", directNotificationId: " + directNotificationId + ", indirectNotificationIds: " + indirectNotificationIds);
        channelTracker.setInfluenceType(influenceType);
        channelTracker.setDirectId(directNotificationId);
        channelTracker.setIndirectIds(indirectNotificationIds);
        channelTracker.cacheState();
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Trackers changed to: " + this.trackerFactory.getChannels().toString());
        return true;
    }

    private boolean willChangeSession(@NonNull OSChannelTracker channelTracker, @NonNull OSInfluenceType influenceType, @Nullable String directNotificationId, @Nullable JSONArray indirectNotificationIds) {
        if (!influenceType.equals((Object)channelTracker.getInfluenceType())) {
            return true;
        }
        OSInfluenceType channelInfluenceType = channelTracker.getInfluenceType();
        if (channelInfluenceType.isDirect() && channelTracker.getDirectId() != null && !channelTracker.getDirectId().equals(directNotificationId)) {
            return true;
        }
        return channelInfluenceType.isIndirect() && channelTracker.getIndirectIds() != null && channelTracker.getIndirectIds().length() > 0 && !JSONUtils.compareJSONArrays(channelTracker.getIndirectIds(), indirectNotificationIds);
    }

    private void sendSessionEndingWithInfluences(final List<OSInfluence> endingInfluences) {
        this.logger.debug("OneSignal SessionManager sendSessionEndingWithInfluences with influences: " + endingInfluences);
        if (endingInfluences.size() > 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setPriority(10);
                    OSSessionManager.this.sessionListener.onSessionEnding(endingInfluences);
                }
            }, OS_END_CURRENT_SESSION).start();
        }
    }

    public static interface SessionListener {
        public void onSessionEnding(@NonNull List<OSInfluence> var1);
    }
}

