/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.SharedPreferences;
import android.os.Handler;
import android.os.HandlerThread;
import com.onesignal.OneSignal;
import java.util.HashMap;

class OneSignalPrefs {
    static final String PREFS_ONESIGNAL = OneSignal.class.getSimpleName();
    static final String PREFS_PLAYER_PURCHASES = "GTPlayerPurchases";
    static final String PREFS_OS_LAST_LOCATION_TIME = "OS_LAST_LOCATION_TIME";
    static final String PREFS_GT_SOUND_ENABLED = "GT_SOUND_ENABLED";
    static final String PREFS_OS_LAST_SESSION_TIME = "OS_LAST_SESSION_TIME";
    static final String PREFS_GT_VIBRATE_ENABLED = "GT_VIBRATE_ENABLED";
    static final String PREFS_GT_FIREBASE_TRACKING_ENABLED = "GT_FIREBASE_TRACKING_ENABLED";
    static final String PREFS_OS_FILTER_OTHER_GCM_RECEIVERS = "OS_FILTER_OTHER_GCM_RECEIVERS";
    static final String PREFS_GT_APP_ID = "GT_APP_ID";
    static final String PREFS_GT_PLAYER_ID = "GT_PLAYER_ID";
    static final String PREFS_OS_EMAIL_ID = "OS_EMAIL_ID";
    static final String PREFS_GT_UNSENT_ACTIVE_TIME = "GT_UNSENT_ACTIVE_TIME";
    static final String PREFS_ONESIGNAL_USERSTATE_DEPENDVALYES_ = "ONESIGNAL_USERSTATE_DEPENDVALYES_";
    static final String PREFS_ONESIGNAL_USERSTATE_SYNCVALYES_ = "ONESIGNAL_USERSTATE_SYNCVALYES_";
    static final String PREFS_ONESIGNAL_ACCEPTED_NOTIFICATION_LAST = "ONESIGNAL_ACCEPTED_NOTIFICATION_LAST";
    static final String PREFS_ONESIGNAL_SUBSCRIPTION_LAST = "ONESIGNAL_SUBSCRIPTION_LAST";
    static final String PREFS_ONESIGNAL_PLAYER_ID_LAST = "ONESIGNAL_PLAYER_ID_LAST";
    static final String PREFS_ONESIGNAL_PUSH_TOKEN_LAST = "ONESIGNAL_PUSH_TOKEN_LAST";
    static final String PREFS_ONESIGNAL_PERMISSION_ACCEPTED_LAST = "ONESIGNAL_PERMISSION_ACCEPTED_LAST";
    static final String PREFS_ONESIGNAL_EMAIL_ID_LAST = "PREFS_ONESIGNAL_EMAIL_ID_LAST";
    static final String PREFS_ONESIGNAL_EMAIL_ADDRESS_LAST = "PREFS_ONESIGNAL_EMAIL_ADDRESS_LAST";
    static final String PREFS_GT_DO_NOT_SHOW_MISSING_GPS = "GT_DO_NOT_SHOW_MISSING_GPS";
    static final String PREFS_ONESIGNAL_SUBSCRIPTION = "ONESIGNAL_SUBSCRIPTION";
    static final String PREFS_ONESIGNAL_SYNCED_SUBSCRIPTION = "ONESIGNAL_SYNCED_SUBSCRIPTION";
    static final String PREFS_GT_REGISTRATION_ID = "GT_REGISTRATION_ID";
    static final String PREFS_ONESIGNAL_USER_PROVIDED_CONSENT = "ONESIGNAL_USER_PROVIDED_CONSENT";
    static final String PREFS_PURCHASE_TOKENS = "purchaseTokens";
    static final String PREFS_EXISTING_PURCHASES = "ExistingPurchases";
    static HashMap<String, HashMap<String, Object>> prefsToApply;
    public static WritePrefHandlerThread prefsHandler;

    OneSignalPrefs() {
    }

    public static void initializePool() {
        prefsToApply = new HashMap();
        prefsToApply.put(PREFS_ONESIGNAL, new HashMap());
        prefsToApply.put(PREFS_PLAYER_PURCHASES, new HashMap());
        prefsHandler = new WritePrefHandlerThread();
    }

    static void saveString(String prefsName, String key, String value) {
        OneSignalPrefs.save(prefsName, key, value);
    }

    static void saveBool(String prefsName, String key, boolean value) {
        OneSignalPrefs.save(prefsName, key, value);
    }

    static void saveInt(String prefsName, String key, int value) {
        OneSignalPrefs.save(prefsName, key, value);
    }

    static void saveLong(String prefsName, String key, long value) {
        OneSignalPrefs.save(prefsName, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(String prefsName, String key, Object value) {
        HashMap<String, Object> pref;
        HashMap<String, Object> hashMap = pref = prefsToApply.get(prefsName);
        synchronized (hashMap) {
            pref.put(key, value);
        }
        prefsHandler.startDelayedWrite();
    }

    static String getString(String prefsName, String key, String defValue) {
        return (String)OneSignalPrefs.get(prefsName, key, String.class, defValue);
    }

    static boolean getBool(String prefsName, String key, boolean defValue) {
        return (Boolean)OneSignalPrefs.get(prefsName, key, Boolean.class, defValue);
    }

    static int getInt(String prefsName, String key, int defValue) {
        return (Integer)OneSignalPrefs.get(prefsName, key, Integer.class, defValue);
    }

    static long getLong(String prefsName, String key, long defValue) {
        return (Long)OneSignalPrefs.get(prefsName, key, Long.class, defValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object get(String prefsName, String key, Class type, Object defValue) {
        HashMap<String, Object> pref;
        HashMap<String, Object> hashMap = pref = prefsToApply.get(prefsName);
        synchronized (hashMap) {
            if (type.equals(Object.class) && pref.containsKey(key)) {
                return true;
            }
            Object cachedValue = pref.get(key);
            if (cachedValue != null || pref.containsKey(key)) {
                return cachedValue;
            }
        }
        SharedPreferences prefs = OneSignalPrefs.getSharedPrefsByName(prefsName);
        if (prefs != null) {
            if (type.equals(String.class)) {
                return prefs.getString(key, (String)defValue);
            }
            if (type.equals(Boolean.class)) {
                return prefs.getBoolean(key, ((Boolean)defValue).booleanValue());
            }
            if (type.equals(Integer.class)) {
                return prefs.getInt(key, ((Integer)defValue).intValue());
            }
            if (type.equals(Long.class)) {
                return prefs.getLong(key, ((Long)defValue).longValue());
            }
            if (type.equals(Object.class)) {
                return prefs.contains(key);
            }
            return null;
        }
        return defValue;
    }

    private static synchronized SharedPreferences getSharedPrefsByName(String prefsName) {
        if (OneSignal.appContext == null) {
            return null;
        }
        return OneSignal.appContext.getSharedPreferences(prefsName, 0);
    }

    static {
        OneSignalPrefs.initializePool();
    }

    public static class WritePrefHandlerThread
    extends HandlerThread {
        public Handler mHandler;
        private static final int WRITE_CALL_DELAY_TO_BUFFER_MS = 200;
        private long lastSyncTime = 0L;

        WritePrefHandlerThread() {
            super("OSH_WritePrefs");
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startDelayedWrite() {
            Handler handler = this.mHandler;
            synchronized (handler) {
                this.mHandler.removeCallbacksAndMessages(null);
                if (this.lastSyncTime == 0L) {
                    this.lastSyncTime = System.currentTimeMillis();
                }
                long delay = this.lastSyncTime - System.currentTimeMillis() + 200L;
                this.mHandler.postDelayed(this.getNewRunnable(), delay);
            }
        }

        private Runnable getNewRunnable() {
            return new Runnable(){

                @Override
                public void run() {
                    WritePrefHandlerThread.this.flushBufferToDisk();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushBufferToDisk() {
            for (String pref : prefsToApply.keySet()) {
                HashMap<String, Object> prefHash;
                SharedPreferences prefsToWrite = OneSignalPrefs.getSharedPrefsByName(pref);
                SharedPreferences.Editor editor = prefsToWrite.edit();
                HashMap<String, Object> hashMap = prefHash = prefsToApply.get(pref);
                synchronized (hashMap) {
                    for (String key : prefHash.keySet()) {
                        Object value = prefHash.get(key);
                        if (value instanceof String) {
                            editor.putString(key, (String)value);
                            continue;
                        }
                        if (value instanceof Boolean) {
                            editor.putBoolean(key, ((Boolean)value).booleanValue());
                            continue;
                        }
                        if (value instanceof Integer) {
                            editor.putInt(key, ((Integer)value).intValue());
                            continue;
                        }
                        if (!(value instanceof Long)) continue;
                        editor.putLong(key, ((Long)value).longValue());
                    }
                    prefHash.clear();
                }
                editor.apply();
            }
            this.lastSyncTime = System.currentTimeMillis();
        }
    }
}

