/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.PersistableBundle;
import android.service.notification.StatusBarNotification;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.text.TextUtils;
import com.onesignal.GcmIntentService;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationExtenderService;
import com.onesignal.NotificationRestoreService;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.RestoreJobService;
import com.onesignal.RestoreKickoffJobService;
import java.io.Serializable;
import java.util.ArrayList;

class NotificationRestorer {
    private static final int RESTORE_KICKOFF_REQUEST_CODE = 2071862120;
    static final String[] COLUMNS_FOR_RESTORE = new String[]{"android_notification_id", "full_data", "created_time"};
    public static boolean restored;

    NotificationRestorer() {
    }

    static void asyncRestore(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NotificationRestorer.restore(context);
            }
        }, "OS_RESTORE_NOTIFS").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restore(Context context) {
        StatusBarNotification[] activeNotifs;
        NotificationManager notifManager;
        if (restored) {
            return;
        }
        restored = true;
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "restoring notifications");
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        SQLiteDatabase writableDb = null;
        try {
            writableDb = dbHelper.getWritableDbWithRetries();
            writableDb.beginTransaction();
            NotificationBundleProcessor.deleteOldNotifications(writableDb);
            writableDb.setTransactionSuccessful();
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error deleting old notification records! ", t);
        }
        finally {
            if (writableDb != null) {
                try {
                    writableDb.endTransaction();
                }
                catch (Throwable t) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                }
            }
        }
        StringBuilder dbQuerySelection = new StringBuilder("created_time > " + (System.currentTimeMillis() / 1000L - 604800L) + " AND " + "dismissed" + " = 0 AND " + "opened" + " = 0 AND " + "is_summary" + " = 0");
        if (Build.VERSION.SDK_INT >= 23 && (notifManager = (NotificationManager)context.getSystemService("notification")) != null && (activeNotifs = notifManager.getActiveNotifications()).length > 0) {
            ArrayList<Integer> activeNotifIds = new ArrayList<Integer>();
            for (StatusBarNotification activeNotif : activeNotifs) {
                activeNotifIds.add(activeNotif.getId());
            }
            dbQuerySelection.append(" AND android_notification_id NOT IN (").append(TextUtils.join((CharSequence)",", activeNotifIds)).append(")");
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Querying DB for notfs to restore: " + dbQuerySelection.toString());
        Cursor cursor = null;
        try {
            SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
            cursor = readableDb.query("notification", COLUMNS_FOR_RESTORE, dbQuerySelection.toString(), null, null, null, "_id ASC");
            NotificationRestorer.showNotifications(context, cursor);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error restoring notification records! ", t);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    static void showNotifications(Context context, Cursor cursor) {
        if (cursor.moveToFirst()) {
            boolean useExtender = NotificationExtenderService.getIntent(context) != null;
            do {
                int existingId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                String fullData = cursor.getString(cursor.getColumnIndex("full_data"));
                Long datetime = cursor.getLong(cursor.getColumnIndex("created_time"));
                Intent serviceIntent = useExtender ? NotificationExtenderService.getIntent(context) : new Intent().setComponent(new ComponentName(context.getPackageName(), GcmIntentService.class.getName()));
                serviceIntent.putExtra("json_payload", fullData);
                serviceIntent.putExtra("android_notif_id", existingId);
                serviceIntent.putExtra("restoring", true);
                serviceIntent.putExtra("timestamp", (Serializable)datetime);
                if (Build.VERSION.SDK_INT >= 22) {
                    if (useExtender) {
                        NotificationExtenderService.enqueueWork(context, serviceIntent.getComponent(), 2071862121, serviceIntent);
                        continue;
                    }
                    OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "scheduleRestoreNotif:" + existingId);
                    PersistableBundle restoreBundle = new PersistableBundle();
                    restoreBundle.putString("json_payload", fullData);
                    restoreBundle.putInt("android_notif_id", existingId);
                    restoreBundle.putBoolean("restoring", true);
                    restoreBundle.putLong("timestamp", datetime.longValue());
                    JobInfo.Builder jobBuilder = new JobInfo.Builder(existingId, new ComponentName(context, RestoreJobService.class));
                    JobInfo job = jobBuilder.setOverrideDeadline(0L).setExtras(restoreBundle).build();
                    JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
                    jobScheduler.schedule(job);
                    continue;
                }
                NotificationRestorer.startService(context, serviceIntent);
            } while (cursor.moveToNext());
        }
    }

    private static void startService(Context context, Intent intent) {
        context.startService(intent);
    }

    static void startRestoreTaskFromReceiver(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationRestorer.restore(context);
        } else {
            Intent intentForService = new Intent();
            intentForService.setComponent(new ComponentName(context.getPackageName(), NotificationRestoreService.class.getName()));
            WakefulBroadcastReceiver.startWakefulService((Context)context, (Intent)intentForService);
        }
    }

    static void startDelayedRestoreTaskFromReceiver(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "scheduleRestoreKickoffJob");
            JobInfo.Builder jobBuilder = new JobInfo.Builder(2071862120, new ComponentName(context, RestoreKickoffJobService.class));
            JobInfo job = jobBuilder.setOverrideDeadline(15000L).setMinimumLatency(15000L).build();
            JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            jobScheduler.schedule(job);
        } else {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "scheduleRestoreKickoffAlarmTask");
            Intent intentForService = new Intent();
            intentForService.setComponent(new ComponentName(context.getPackageName(), NotificationRestoreService.class.getName()));
            PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)2071862120, (Intent)intentForService, (int)0x10000000);
            long scheduleTime = System.currentTimeMillis() + 15000L;
            AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
            alarm.set(0, scheduleTime, pendingIntent);
        }
    }
}

