/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.GoogleApiClientCompatProxy;
import com.onesignal.OneSignal;
import com.onesignal.PermissionsActivity;
import com.onesignal.SyncService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;

class LocationGMS {
    private static final int TIME_FOREGROUND = 300;
    private static final int TIME_BACKGROUND = 600;
    private static GoogleApiClientCompatProxy mGoogleApiClient;
    static String requestPermission;
    private static Context classContext;
    private static LocationHandlerThread locationHandlerThread;
    private static LocationHandler locationHandler;
    private static Thread fallbackFailThread;
    private static boolean locationCoarse;
    private static LocationUpdateListener locationUpdateListener;

    LocationGMS() {
    }

    static void scheduleUpdate(Context context) {
        if (!LocationGMS.hasLocationPermission(context) && OneSignal.shareLocation) {
            return;
        }
        long lastTime = LocationGMS.getLastLocationTime(context);
        long minTime = 1000 * (OneSignal.isForeground() ? 300 : 600);
        long scheduleTime = lastTime + minTime;
        SyncService.scheduleServiceSyncTask(context, scheduleTime);
    }

    private static void setLastLocationTime(long time) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(classContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong("OS_LAST_LOCATION_TIME", time);
        editor.apply();
    }

    private static long getLastLocationTime(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getLong("OS_LAST_LOCATION_TIME", -600000L);
    }

    private static boolean hasLocationPermission(Context context) {
        return AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION") == 0 || AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION") == 0;
    }

    static void getLocation(Context context, boolean promptLocation, LocationHandler handler) {
        block14: {
            classContext = context;
            locationHandler = handler;
            if (!OneSignal.shareLocation) {
                LocationGMS.fireFailedComplete();
                return;
            }
            int locationCoarsePermission = -1;
            int locationFinePermission = AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            if (locationFinePermission == -1) {
                locationCoarsePermission = AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
                locationCoarse = true;
            }
            if (Build.VERSION.SDK_INT < 23) {
                if (locationFinePermission != 0 && locationCoarsePermission != 0) {
                    handler.complete(null);
                    return;
                }
                LocationGMS.startGetLocation();
            } else if (locationFinePermission != 0) {
                try {
                    PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
                    List<String> permissionList = Arrays.asList(packageInfo.requestedPermissions);
                    if (permissionList.contains("android.permission.ACCESS_FINE_LOCATION")) {
                        requestPermission = "android.permission.ACCESS_FINE_LOCATION";
                    } else if (permissionList.contains("android.permission.ACCESS_COARSE_LOCATION") && locationCoarsePermission != 0) {
                        requestPermission = "android.permission.ACCESS_COARSE_LOCATION";
                    }
                    if (requestPermission != null && promptLocation) {
                        PermissionsActivity.startPrompt();
                        break block14;
                    }
                    if (locationCoarsePermission == 0) {
                        LocationGMS.startGetLocation();
                        break block14;
                    }
                    LocationGMS.fireFailedComplete();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                LocationGMS.startGetLocation();
            }
        }
    }

    static void startGetLocation() {
        if (fallbackFailThread != null) {
            return;
        }
        try {
            LocationGMS.startFallBackThread();
            if (locationHandlerThread == null) {
                locationHandlerThread = new LocationHandlerThread();
            }
            GoogleApiClientListener googleApiClientListener = new GoogleApiClientListener();
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(classContext).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)googleApiClientListener).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)googleApiClientListener).setHandler(LocationGMS.locationHandlerThread.mHandler).build();
            mGoogleApiClient = new GoogleApiClientCompatProxy(googleApiClient);
            mGoogleApiClient.connect();
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Location permission exists but there was an error initializing: ", t);
            LocationGMS.fireFailedComplete();
        }
    }

    private static void startFallBackThread() {
        fallbackFailThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(30000L);
                    OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Location permission exists but GoogleApiClient timed out. Maybe related to mismatch google-play aar versions.");
                    LocationGMS.fireFailedComplete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, "OS_GMS_LOCATION_FALLBACK");
        fallbackFailThread.start();
    }

    static void fireFailedComplete() {
        PermissionsActivity.answered = false;
        LocationGMS.fireComplete(null);
        if (mGoogleApiClient != null) {
            mGoogleApiClient.disconnect();
        }
    }

    private static synchronized void fireComplete(LocationPoint point) {
        locationHandler.complete(point);
        if (fallbackFailThread != null && !Thread.currentThread().equals(fallbackFailThread)) {
            fallbackFailThread.interrupt();
        }
        fallbackFailThread = null;
    }

    private static void receivedLocationPoint(Location location) {
        LocationPoint point = new LocationPoint();
        point.accuracy = Float.valueOf(location.getAccuracy());
        point.bg = !OneSignal.isForeground();
        point.type = locationCoarse ? 0 : 1;
        point.timeStamp = location.getTime();
        if (locationCoarse) {
            point.lat = new BigDecimal(location.getLatitude()).setScale(7, RoundingMode.HALF_UP).doubleValue();
            point.log = new BigDecimal(location.getLongitude()).setScale(7, RoundingMode.HALF_UP).doubleValue();
        } else {
            point.lat = location.getLatitude();
            point.log = location.getLongitude();
        }
        LocationGMS.fireComplete(point);
        LocationGMS.setLastLocationTime(System.currentTimeMillis());
        LocationGMS.scheduleUpdate(classContext);
    }

    private static class LocationHandlerThread
    extends HandlerThread {
        Handler mHandler = null;

        LocationHandlerThread() {
            super("OSH_LocationHandlerThread");
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }
    }

    static class FusedLocationApiWrapper {
        FusedLocationApiWrapper() {
        }

        static PendingResult<Status> requestLocationUpdates(GoogleApiClient googleApiClient, LocationRequest locationRequest, LocationListener locationListener) {
            if (googleApiClient.isConnected()) {
                return LocationServices.FusedLocationApi.requestLocationUpdates(googleApiClient, locationRequest, locationListener);
            }
            return null;
        }

        static PendingResult<Status> removeLocationUpdates(GoogleApiClient googleApiClient, LocationListener locationListener) {
            if (googleApiClient.isConnected()) {
                return LocationServices.FusedLocationApi.removeLocationUpdates(googleApiClient, locationListener);
            }
            return null;
        }

        static Location getLastLocation(GoogleApiClient googleApiClient) {
            if (googleApiClient.isConnected()) {
                return LocationServices.FusedLocationApi.getLastLocation(googleApiClient);
            }
            return null;
        }
    }

    private static class LocationUpdateListener
    implements LocationListener {
        private GoogleApiClient mGoogleApiClient;

        LocationUpdateListener(GoogleApiClient googleApiClient) {
            this.mGoogleApiClient = googleApiClient;
            FusedLocationApiWrapper.removeLocationUpdates(this.mGoogleApiClient, this);
            LocationRequest locationRequest = new LocationRequest();
            locationRequest.setMaxWaitTime(20000L);
            locationRequest.setPriority(102);
            FusedLocationApiWrapper.requestLocationUpdates(this.mGoogleApiClient, locationRequest, this);
        }

        public void onLocationChanged(Location location) {
            LocationGMS.receivedLocationPoint(location);
            if (this.mGoogleApiClient.isConnected()) {
                FusedLocationApiWrapper.removeLocationUpdates(this.mGoogleApiClient, this);
                this.mGoogleApiClient.disconnect();
            }
        }
    }

    private static class GoogleApiClientListener
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private GoogleApiClientListener() {
        }

        public void onConnected(Bundle bundle) {
            PermissionsActivity.answered = false;
            Location location = FusedLocationApiWrapper.getLastLocation(mGoogleApiClient.realInstance());
            if (location != null) {
                LocationGMS.receivedLocationPoint(location);
                mGoogleApiClient.disconnect();
            } else {
                locationUpdateListener = new LocationUpdateListener(mGoogleApiClient.realInstance());
            }
        }

        public void onConnectionSuspended(int i) {
            LocationGMS.fireFailedComplete();
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            LocationGMS.fireFailedComplete();
        }
    }

    static interface LocationHandler {
        public void complete(LocationPoint var1);
    }

    static class LocationPoint {
        Double lat;
        Double log;
        Float accuracy;
        Integer type;
        Boolean bg;
        Long timeStamp;

        LocationPoint() {
        }
    }
}

