/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.onesignal.GcmIntentService;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.OneSignal;

public class GcmBroadcastReceiver
extends WakefulBroadcastReceiver {
    private static final String GCM_RECEIVE_ACTION = "com.google.android.c2dm.intent.RECEIVE";
    private static final String GCM_TYPE = "gcm";
    private static final String MESSAGE_TYPE_EXTRA_KEY = "message_type";

    private static boolean isGcmMessage(Intent intent) {
        if (GCM_RECEIVE_ACTION.equals(intent.getAction())) {
            String messageType = intent.getStringExtra(MESSAGE_TYPE_EXTRA_KEY);
            return messageType == null || GCM_TYPE.equals(messageType);
        }
        return false;
    }

    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null || "google.com/iid".equals(bundle.getString("from"))) {
            return;
        }
        NotificationBundleProcessor.ProcessedBundleResult processedResult = GcmBroadcastReceiver.processOrderBroadcast(context, intent, bundle);
        if (processedResult == null) {
            this.setResultCode(-1);
            return;
        }
        if (processedResult.isDup || processedResult.hasExtenderService) {
            this.abortBroadcast();
            return;
        }
        if (processedResult.isOneSignalPayload && OneSignal.getFilterOtherGCMReceivers(context)) {
            this.abortBroadcast();
            return;
        }
        this.setResultCode(-1);
    }

    private static NotificationBundleProcessor.ProcessedBundleResult processOrderBroadcast(Context context, Intent intent, Bundle bundle) {
        if (!GcmBroadcastReceiver.isGcmMessage(intent)) {
            return null;
        }
        NotificationBundleProcessor.ProcessedBundleResult processedResult = NotificationBundleProcessor.processBundle(context, bundle);
        if (processedResult.processed()) {
            return processedResult;
        }
        Intent intentForService = new Intent();
        intentForService.putExtra("json_payload", NotificationBundleProcessor.bundleAsJSONObject(bundle).toString());
        intentForService.putExtra("timestamp", System.currentTimeMillis() / 1000L);
        intentForService.setComponent(new ComponentName(context.getPackageName(), GcmIntentService.class.getName()));
        GcmBroadcastReceiver.startWakefulService((Context)context, (Intent)intentForService);
        return processedResult;
    }
}

