/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.Nullable;
import com.onesignal.ImmutableJSONObject;
import com.onesignal.JSONUtils;
import com.onesignal.LocationController;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.UserState;
import java.util.HashMap;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

abstract class UserStateSynchronizer {
    protected final Object LOCK = new Object();
    private OneSignalStateSynchronizer.UserStateSynchronizerType channel;
    private boolean canMakeUpdates;
    private AtomicBoolean runningSyncUserState = new AtomicBoolean();
    private final Queue<OneSignal.ChangeTagsUpdateHandler> sendTagsHandlers = new ConcurrentLinkedQueue<OneSignal.ChangeTagsUpdateHandler>();
    private final Queue<OneSignal.OSInternalExternalUserIdUpdateCompletionHandler> externalUserIdUpdateHandlers = new ConcurrentLinkedQueue<OneSignal.OSInternalExternalUserIdUpdateCompletionHandler>();
    HashMap<Integer, NetworkHandlerThread> networkHandlerThreads = new HashMap();
    private final Object networkHandlerSyncLock = new Object(){};
    protected boolean waitingForSessionResponse = false;
    protected UserState currentUserState;
    protected UserState toSyncUserState;

    UserStateSynchronizer(OneSignalStateSynchronizer.UserStateSynchronizerType channel) {
        this.channel = channel;
    }

    OneSignalStateSynchronizer.UserStateSynchronizerType getChannelType() {
        return this.channel;
    }

    String getChannelString() {
        return this.channel.name().toLowerCase();
    }

    abstract boolean getSubscribed();

    String getRegistrationId() {
        return this.getToSyncUserState().getSyncValues().optString("identifier", null);
    }

    abstract GetTagsResult getTags(boolean var1);

    @Nullable
    abstract String getExternalId(boolean var1);

    boolean hasQueuedHandlers() {
        return this.externalUserIdUpdateHandlers.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject generateJsonDiff(JSONObject cur, JSONObject changedTo, JSONObject baseOutput, Set<String> includeFields) {
        Object object = this.LOCK;
        synchronized (object) {
            return JSONUtils.generateJsonDiff(cur, changedTo, baseOutput, includeFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserState getCurrentUserState() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.currentUserState == null) {
                this.currentUserState = this.newUserState("CURRENT_STATE", true);
            }
        }
        return this.currentUserState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserState getToSyncUserState() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.toSyncUserState == null) {
                this.toSyncUserState = this.newUserState("TOSYNC_STATE", true);
            }
        }
        return this.toSyncUserState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initUserState() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.currentUserState == null) {
                this.currentUserState = this.newUserState("CURRENT_STATE", true);
            }
        }
        this.getToSyncUserState();
    }

    protected abstract UserState newUserState(String var1, boolean var2);

    void clearLocation() {
        this.getToSyncUserState().clearLocation();
        this.getToSyncUserState().persistState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean persist() {
        if (this.toSyncUserState != null) {
            Object object = this.LOCK;
            synchronized (object) {
                boolean unSynced = this.currentUserState.generateJsonDiff(this.toSyncUserState, this.isSessionCall()) != null;
                this.toSyncUserState.persistState();
                return unSynced;
            }
        }
        return false;
    }

    protected abstract OneSignal.LOG_LEVEL getLogLevel();

    protected abstract String getId();

    private boolean isSessionCall() {
        boolean toSyncSession = this.getToSyncUserState().getDependValues().optBoolean("session");
        return (toSyncSession || this.getId() == null) && !this.waitingForSessionResponse;
    }

    private boolean syncEmailLogout() {
        return this.getToSyncUserState().getDependValues().optBoolean("logoutEmail", false);
    }

    void syncUserState(boolean fromSyncService) {
        this.runningSyncUserState.set(true);
        this.internalSyncUserState(fromSyncService);
        this.runningSyncUserState.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSyncUserState(boolean fromSyncService) {
        JSONObject dependDiff;
        JSONObject jsonBody;
        String userId = this.getId();
        if (this.syncEmailLogout() && userId != null) {
            this.doEmailLogout(userId);
            return;
        }
        if (this.currentUserState == null) {
            this.initUserState();
        }
        boolean isSessionCall = !fromSyncService && this.isSessionCall();
        Object object = this.LOCK;
        synchronized (object) {
            jsonBody = this.currentUserState.generateJsonDiff(this.getToSyncUserState(), isSessionCall);
            UserState toSyncState = this.getToSyncUserState();
            dependDiff = this.currentUserState.generateJsonDiffFromDependValues(toSyncState, null);
            if (jsonBody == null) {
                this.currentUserState.persistStateAfterSync(dependDiff, null);
                this.sendTagsHandlersPerformOnSuccess();
                this.externalUserIdUpdateHandlersPerformOnSuccess();
                return;
            }
            this.getToSyncUserState().persistState();
        }
        if (!isSessionCall) {
            this.doPutSync(userId, jsonBody, dependDiff);
        } else {
            this.doCreateOrNewSession(userId, jsonBody, dependDiff);
        }
    }

    private void doEmailLogout(String userId) {
        String urlStr = "players/" + userId + "/email_logout";
        JSONObject jsonBody = new JSONObject();
        try {
            ImmutableJSONObject syncValues;
            ImmutableJSONObject dependValues = this.currentUserState.getDependValues();
            if (dependValues.has("email_auth_hash")) {
                jsonBody.put("email_auth_hash", (Object)dependValues.optString("email_auth_hash"));
            }
            if ((syncValues = this.currentUserState.getSyncValues()).has("parent_player_id")) {
                jsonBody.put("parent_player_id", (Object)syncValues.optString("parent_player_id"));
            }
            jsonBody.put("app_id", (Object)syncValues.optString("app_id"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        OneSignalRestClient.postSync(urlStr, jsonBody, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Failed last request. statusCode: " + statusCode + "\nresponse: " + response);
                if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "already logged out of email")) {
                    UserStateSynchronizer.this.logoutEmailSyncSuccess();
                    return;
                }
                if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "not a valid device_type")) {
                    UserStateSynchronizer.this.handlePlayerDeletedFromServer();
                } else {
                    UserStateSynchronizer.this.handleNetworkFailure(statusCode);
                }
            }

            @Override
            void onSuccess(String response) {
                UserStateSynchronizer.this.logoutEmailSyncSuccess();
            }
        });
    }

    private void logoutEmailSyncSuccess() {
        this.getToSyncUserState().removeFromDependValues("logoutEmail");
        this.toSyncUserState.removeFromDependValues("email_auth_hash");
        this.toSyncUserState.removeFromSyncValues("parent_player_id");
        this.toSyncUserState.persistState();
        this.currentUserState.removeFromDependValues("email_auth_hash");
        this.currentUserState.removeFromSyncValues("parent_player_id");
        String emailLoggedOut = this.currentUserState.getSyncValues().optString("email");
        this.currentUserState.removeFromSyncValues("email");
        OneSignalStateSynchronizer.setNewSessionForEmail();
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Device successfully logged out of email: " + emailLoggedOut);
        OneSignal.handleSuccessfulEmailLogout();
    }

    private void doPutSync(String userId, final JSONObject jsonBody, final JSONObject dependDiff) {
        if (userId == null) {
            OneSignal.onesignalLog(this.getLogLevel(), "Error updating the user record because of the null user id");
            this.sendTagsHandlersPerformOnFailure(new OneSignal.SendTagsError(-1, "Unable to update tags: the current user is not registered with OneSignal"));
            this.externalUserIdUpdateHandlersPerformOnFailure();
            return;
        }
        OneSignalRestClient.putSync("players/" + userId, jsonBody, new OneSignalRestClient.ResponseHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Failed PUT sync request with status code: " + statusCode + " and response: " + response);
                Object object = UserStateSynchronizer.this.LOCK;
                synchronized (object) {
                    if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "No user with this id found")) {
                        UserStateSynchronizer.this.handlePlayerDeletedFromServer();
                    } else {
                        UserStateSynchronizer.this.handleNetworkFailure(statusCode);
                    }
                }
                if (jsonBody.has("tags")) {
                    UserStateSynchronizer.this.sendTagsHandlersPerformOnFailure(new OneSignal.SendTagsError(statusCode, response));
                }
                if (jsonBody.has("external_user_id")) {
                    OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Error setting external user id for push with status code: " + statusCode + " and message: " + response);
                    UserStateSynchronizer.this.externalUserIdUpdateHandlersPerformOnFailure();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onSuccess(String response) {
                Object object = UserStateSynchronizer.this.LOCK;
                synchronized (object) {
                    UserStateSynchronizer.this.currentUserState.persistStateAfterSync(dependDiff, jsonBody);
                    UserStateSynchronizer.this.onSuccessfulSync(jsonBody);
                }
                if (jsonBody.has("tags")) {
                    UserStateSynchronizer.this.sendTagsHandlersPerformOnSuccess();
                }
                if (jsonBody.has("external_user_id")) {
                    UserStateSynchronizer.this.externalUserIdUpdateHandlersPerformOnSuccess();
                }
            }
        });
    }

    private void doCreateOrNewSession(final String userId, final JSONObject jsonBody, final JSONObject dependDiff) {
        String urlStr = userId == null ? "players" : "players/" + userId + "/on_session";
        this.waitingForSessionResponse = true;
        this.addOnSessionOrCreateExtras(jsonBody);
        OneSignalRestClient.postSync(urlStr, jsonBody, new OneSignalRestClient.ResponseHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                Object object = UserStateSynchronizer.this.LOCK;
                synchronized (object) {
                    UserStateSynchronizer.this.waitingForSessionResponse = false;
                    OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Failed last request. statusCode: " + statusCode + "\nresponse: " + response);
                    if (UserStateSynchronizer.this.response400WithErrorsContaining(statusCode, response, "not a valid device_type")) {
                        UserStateSynchronizer.this.handlePlayerDeletedFromServer();
                    } else {
                        UserStateSynchronizer.this.handleNetworkFailure(statusCode);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onSuccess(String response) {
                Object object = UserStateSynchronizer.this.LOCK;
                synchronized (object) {
                    UserStateSynchronizer.this.waitingForSessionResponse = false;
                    UserStateSynchronizer.this.currentUserState.persistStateAfterSync(dependDiff, jsonBody);
                    try {
                        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "doCreateOrNewSession:response: " + response);
                        JSONObject jsonResponse = new JSONObject(response);
                        if (jsonResponse.has("id")) {
                            String newUserId = jsonResponse.optString("id");
                            UserStateSynchronizer.this.updateIdDependents(newUserId);
                            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Device registered, UserId = " + newUserId);
                        } else {
                            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "session sent, UserId = " + userId);
                        }
                        UserStateSynchronizer.this.getUserStateForModification().putOnDependValues("session", false);
                        UserStateSynchronizer.this.getUserStateForModification().persistState();
                        if (jsonResponse.has("in_app_messages")) {
                            OneSignal.getInAppMessageController().receivedInAppMessageJson(jsonResponse.getJSONArray("in_app_messages"));
                        }
                        UserStateSynchronizer.this.onSuccessfulSync(jsonBody);
                    }
                    catch (JSONException e) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "ERROR parsing on_session or create JSON Response.", e);
                    }
                }
            }
        });
    }

    protected abstract void onSuccessfulSync(JSONObject var1);

    private void handleNetworkFailure(int statusCode) {
        if (statusCode == 403) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "403 error updating player, omitting further retries!");
            this.fireNetworkFailureEvents();
            return;
        }
        boolean retried = this.getNetworkHandlerThread(0).doRetry();
        if (!retried) {
            this.fireNetworkFailureEvents();
        }
    }

    private void fireNetworkFailureEvents() {
        JSONObject jsonBody = this.currentUserState.generateJsonDiff(this.toSyncUserState, false);
        if (jsonBody != null) {
            this.fireEventsForUpdateFailure(jsonBody);
        }
        if (this.getToSyncUserState().getDependValues().optBoolean("logoutEmail", false)) {
            OneSignal.handleFailedEmailLogout();
        }
    }

    protected abstract void fireEventsForUpdateFailure(JSONObject var1);

    protected abstract void addOnSessionOrCreateExtras(JSONObject var1);

    private boolean response400WithErrorsContaining(int statusCode, String response, String contains) {
        if (statusCode == 400 && response != null) {
            try {
                JSONObject responseJson = new JSONObject(response);
                return responseJson.has("errors") && responseJson.optString("errors").contains(contains);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NetworkHandlerThread getNetworkHandlerThread(Integer type) {
        Object object = this.networkHandlerSyncLock;
        synchronized (object) {
            if (!this.networkHandlerThreads.containsKey(type)) {
                this.networkHandlerThreads.put(type, new NetworkHandlerThread(type));
            }
            return this.networkHandlerThreads.get(type);
        }
    }

    protected UserState getUserStateForModification() {
        if (this.toSyncUserState == null) {
            this.toSyncUserState = this.getCurrentUserState().deepClone("TOSYNC_STATE");
        }
        this.scheduleSyncToServer();
        return this.toSyncUserState;
    }

    protected abstract void scheduleSyncToServer();

    void updateDeviceInfo(JSONObject deviceInfo) {
        this.getUserStateForModification().generateJsonDiffFromIntoSyncValued(deviceInfo, null);
    }

    abstract void updateState(JSONObject var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNewSession() {
        try {
            Object object = this.LOCK;
            synchronized (object) {
                this.getUserStateForModification().putOnDependValues("session", true);
                this.getUserStateForModification().persistState();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    boolean getSyncAsNewSession() {
        return this.getUserStateForModification().getDependValues().optBoolean("session");
    }

    void sendTags(JSONObject tags, @Nullable OneSignal.ChangeTagsUpdateHandler handler) {
        if (handler != null) {
            this.sendTagsHandlers.add(handler);
        }
        UserState userStateTags = this.getUserStateForModification();
        userStateTags.generateJsonDiffFromIntoSyncValued(tags, null);
    }

    void syncHashedEmail(JSONObject emailFields) {
        this.getUserStateForModification().generateJsonDiffFromIntoSyncValued(emailFields, null);
    }

    void setExternalUserId(String externalId, String externalIdAuthHash, OneSignal.OSInternalExternalUserIdUpdateCompletionHandler handler) throws JSONException {
        if (handler != null) {
            this.externalUserIdUpdateHandlers.add(handler);
        }
        UserState userState = this.getUserStateForModification();
        userState.putOnSyncValues("external_user_id", externalId);
        if (externalIdAuthHash != null) {
            userState.putOnSyncValues("external_user_id_auth_hash", externalIdAuthHash);
        }
    }

    abstract void setSubscription(boolean var1);

    private void handlePlayerDeletedFromServer() {
        OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Creating new player based on missing player_id noted above.");
        OneSignal.handleSuccessfulEmailLogout();
        this.resetCurrentState();
        this.updateIdDependents(null);
        this.scheduleSyncToServer();
    }

    void resetCurrentState() {
        this.currentUserState.setSyncValues(new JSONObject());
        this.currentUserState.persistState();
    }

    public abstract boolean getUserSubscribePreference();

    public abstract void setPermission(boolean var1);

    void updateLocation(LocationController.LocationPoint point) {
        UserState userState = this.getUserStateForModification();
        userState.setLocation(point);
    }

    abstract void updateIdDependents(String var1);

    abstract void logoutEmail();

    void readyToUpdate(boolean canMakeUpdates) {
        boolean changed = this.canMakeUpdates != canMakeUpdates;
        this.canMakeUpdates = canMakeUpdates;
        if (changed && canMakeUpdates) {
            this.scheduleSyncToServer();
        }
    }

    private void sendTagsHandlersPerformOnSuccess() {
        OneSignal.ChangeTagsUpdateHandler handler;
        JSONObject tags = OneSignalStateSynchronizer.getTags((boolean)false).result;
        while ((handler = this.sendTagsHandlers.poll()) != null) {
            handler.onSuccess(tags);
        }
    }

    private void sendTagsHandlersPerformOnFailure(OneSignal.SendTagsError error) {
        OneSignal.ChangeTagsUpdateHandler handler;
        while ((handler = this.sendTagsHandlers.poll()) != null) {
            handler.onFailure(error);
        }
    }

    private void externalUserIdUpdateHandlersPerformOnSuccess() {
        OneSignal.OSInternalExternalUserIdUpdateCompletionHandler handler;
        while ((handler = this.externalUserIdUpdateHandlers.poll()) != null) {
            handler.onComplete(this.getChannelString(), true);
        }
    }

    private void externalUserIdUpdateHandlersPerformOnFailure() {
        OneSignal.OSInternalExternalUserIdUpdateCompletionHandler handler;
        while ((handler = this.externalUserIdUpdateHandlers.poll()) != null) {
            handler.onComplete(this.getChannelString(), false);
        }
    }

    class NetworkHandlerThread
    extends HandlerThread {
        protected static final int NETWORK_HANDLER_USERSTATE = 0;
        int mType;
        Handler mHandler;
        static final int MAX_RETRIES = 3;
        static final int NETWORK_CALL_DELAY_TO_BUFFER_MS = 5000;
        int currentRetry;

        NetworkHandlerThread(int type) {
            super("OSH_NetworkHandlerThread");
            this.mHandler = null;
            this.mType = type;
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runNewJobDelayed() {
            if (!UserStateSynchronizer.this.canMakeUpdates) {
                return;
            }
            Handler handler = this.mHandler;
            synchronized (handler) {
                this.currentRetry = 0;
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler.postDelayed(this.getNewRunnable(), 5000L);
            }
        }

        private Runnable getNewRunnable() {
            switch (this.mType) {
                case 0: {
                    return new Runnable(){

                        @Override
                        public void run() {
                            if (!UserStateSynchronizer.this.runningSyncUserState.get()) {
                                UserStateSynchronizer.this.syncUserState(false);
                            }
                        }
                    };
                }
            }
            return null;
        }

        void stopScheduledRunnable() {
            this.mHandler.removeCallbacksAndMessages(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean doRetry() {
            Handler handler = this.mHandler;
            synchronized (handler) {
                boolean doRetry = this.currentRetry < 3;
                boolean futureSync = this.mHandler.hasMessages(0);
                if (doRetry && !futureSync) {
                    ++this.currentRetry;
                    this.mHandler.postDelayed(this.getNewRunnable(), (long)(this.currentRetry * 15000));
                }
                return this.mHandler.hasMessages(0);
            }
        }
    }

    static class GetTagsResult {
        boolean serverSuccess;
        JSONObject result;

        GetTagsResult(boolean serverSuccess, JSONObject result) {
            this.serverSuccess = serverSuccess;
            this.result = result;
        }
    }
}

