/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.outcomes;

import com.onesignal.OSLogger;
import com.onesignal.OneSignalApiResponseHandler;
import com.onesignal.influence.model.OSInfluence;
import com.onesignal.outcomes.OSOutcomeEventsCache;
import com.onesignal.outcomes.domain.OutcomeEventsService;
import com.onesignal.outcomes.model.OSOutcomeEventParams;
import java.util.List;
import java.util.Set;

abstract class OSOutcomeEventsRepository
implements com.onesignal.outcomes.domain.OSOutcomeEventsRepository {
    static final String APP_ID = "app_id";
    static final String DEVICE_TYPE = "device_type";
    protected final OSLogger logger;
    private final OSOutcomeEventsCache outcomeEventsCache;
    final OutcomeEventsService outcomeEventsService;

    OSOutcomeEventsRepository(OSLogger logger, OSOutcomeEventsCache outcomeEventsCache, OutcomeEventsService outcomeEventsService) {
        this.logger = logger;
        this.outcomeEventsCache = outcomeEventsCache;
        this.outcomeEventsService = outcomeEventsService;
    }

    @Override
    public abstract void requestMeasureOutcomeEvent(String var1, int var2, OSOutcomeEventParams var3, OneSignalApiResponseHandler var4);

    @Override
    public List<OSOutcomeEventParams> getSavedOutcomeEvents() {
        return this.outcomeEventsCache.getAllEventsToSend();
    }

    @Override
    public void saveOutcomeEvent(OSOutcomeEventParams event) {
        this.outcomeEventsCache.saveOutcomeEvent(event);
    }

    @Override
    public void removeEvent(OSOutcomeEventParams outcomeEvent) {
        this.outcomeEventsCache.deleteOldOutcomeEvent(outcomeEvent);
    }

    @Override
    public void saveUniqueOutcomeNotifications(OSOutcomeEventParams eventParams) {
        this.outcomeEventsCache.saveUniqueOutcomeEventParams(eventParams);
    }

    @Override
    public List<OSInfluence> getNotCachedUniqueOutcome(String name, List<OSInfluence> influences) {
        List<OSInfluence> influencesNotCached = this.outcomeEventsCache.getNotCachedUniqueInfluencesForOutcome(name, influences);
        this.logger.debug("OneSignal getNotCachedUniqueOutcome influences: " + influencesNotCached);
        return influencesNotCached;
    }

    @Override
    public Set<String> getUnattributedUniqueOutcomeEventsSent() {
        Set<String> unattributedUniqueOutcomeEvents = this.outcomeEventsCache.getUnattributedUniqueOutcomeEventsSentByChannel();
        this.logger.debug("OneSignal getUnattributedUniqueOutcomeEventsSentByChannel: " + unattributedUniqueOutcomeEvents);
        return unattributedUniqueOutcomeEvents;
    }

    @Override
    public void saveUnattributedUniqueOutcomeEventsSent(Set<String> unattributedUniqueOutcomeEvents) {
        this.logger.debug("OneSignal save unattributedUniqueOutcomeEvents: " + unattributedUniqueOutcomeEvents);
        this.outcomeEventsCache.saveUnattributedUniqueOutcomeEventsSentByChannel(unattributedUniqueOutcomeEvents);
    }
}

