/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence;

import android.support.annotation.NonNull;
import com.onesignal.OSLogger;
import com.onesignal.influence.OSChannelTracker;
import com.onesignal.influence.OSInfluenceDataRepository;
import com.onesignal.influence.model.OSInfluence;
import com.onesignal.influence.model.OSInfluenceChannel;
import com.onesignal.influence.model.OSInfluenceType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSInAppMessageTracker
extends OSChannelTracker {
    public static final String TAG = OSInAppMessageTracker.class.getCanonicalName();
    private static final String IAM_ID = "iam_id";

    OSInAppMessageTracker(@NonNull OSInfluenceDataRepository dataRepository, OSLogger logger) {
        super(dataRepository, logger);
    }

    @Override
    public String getIdTag() {
        return IAM_ID;
    }

    @Override
    OSInfluenceChannel getChannelType() {
        return OSInfluenceChannel.IAM;
    }

    @Override
    JSONArray getLastChannelObjectsReceivedByNewId(String id2) {
        JSONArray lastChannelObjectReceived;
        try {
            lastChannelObjectReceived = this.getLastChannelObjects();
        }
        catch (JSONException exception) {
            this.logger.error("Generating IAM tracker getLastChannelObjects JSONObject ", exception);
            return new JSONArray();
        }
        try {
            JSONArray auxLastChannelObjectReceived = new JSONArray();
            for (int i = 0; i < lastChannelObjectReceived.length(); ++i) {
                String objectId = lastChannelObjectReceived.getJSONObject(i).getString(this.getIdTag());
                if (id2.equals(objectId)) continue;
                auxLastChannelObjectReceived.put((Object)lastChannelObjectReceived.getJSONObject(i));
            }
            lastChannelObjectReceived = auxLastChannelObjectReceived;
        }
        catch (JSONException exception) {
            this.logger.error("Before KITKAT API, Generating tracker lastChannelObjectReceived get JSONObject ", exception);
        }
        return lastChannelObjectReceived;
    }

    @Override
    JSONArray getLastChannelObjects() throws JSONException {
        return this.dataRepository.getLastIAMsReceivedData();
    }

    @Override
    int getChannelLimit() {
        return this.dataRepository.getIAMLimit();
    }

    @Override
    int getIndirectAttributionWindow() {
        return this.dataRepository.getIAMIndirectAttributionWindow();
    }

    @Override
    void saveChannelObjects(JSONArray channelObjects) {
        this.dataRepository.saveIAMs(channelObjects);
    }

    @Override
    void initInfluencedTypeFromCache() {
        this.setInfluenceType(this.dataRepository.getIAMCachedInfluenceType());
        if (this.influenceType != null && this.influenceType.isIndirect()) {
            this.setIndirectIds(this.getLastReceivedIds());
        }
        this.logger.debug("OneSignal InAppMessageTracker initInfluencedTypeFromCache: " + this.toString());
    }

    @Override
    void addSessionData(@NonNull JSONObject jsonObject, OSInfluence influence) {
    }

    @Override
    public void cacheState() {
        OSInfluenceType influenceTypeToCache = this.influenceType == null ? OSInfluenceType.UNATTRIBUTED : this.influenceType;
        this.dataRepository.cacheIAMInfluenceType(influenceTypeToCache == OSInfluenceType.DIRECT ? OSInfluenceType.INDIRECT : influenceTypeToCache);
    }
}

