/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.outcomes;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import com.onesignal.influence.model.OSInfluenceChannel;

public class OSOutcomeTableProvider {
    private static final String INTEGER_PRIMARY_KEY_TYPE = " INTEGER PRIMARY KEY";
    private static final String TEXT_TYPE = " TEXT";
    private static final String INT_TYPE = " INTEGER";
    private static final String FLOAT_TYPE = " FLOAT";
    private static final String TIMESTAMP_TYPE = " TIMESTAMP";
    public static final String OUTCOME_EVENT_TABLE = "outcome";
    public static final String CACHE_UNIQUE_OUTCOME_TABLE = "cached_unique_outcome";
    public static final String CACHE_UNIQUE_OUTCOME_COLUMN_CHANNEL_INFLUENCE_ID = "channel_influence_id";
    public static final String CACHE_UNIQUE_OUTCOME_COLUMN_CHANNEL_TYPE = "channel_type";
    public static final String SQL_CREATE_OUTCOME_ENTRIES_V1 = "CREATE TABLE outcome (_id INTEGER PRIMARY KEY,notification_ids TEXT,name TEXT,session TEXT,params TEXT,timestamp TIMESTAMP);";
    public static final String SQL_CREATE_OUTCOME_ENTRIES_V2 = "CREATE TABLE outcome (_id INTEGER PRIMARY KEY,session TEXT,notification_ids TEXT,name TEXT,timestamp TIMESTAMP,weight FLOAT);";
    public static final String SQL_CREATE_OUTCOME_ENTRIES_V3 = "CREATE TABLE outcome (_id INTEGER PRIMARY KEY,notification_influence_type TEXT,iam_influence_type TEXT,notification_ids TEXT,iam_ids TEXT,name TEXT,timestamp TIMESTAMP,weight FLOAT);";
    public static final String SQL_CREATE_UNIQUE_OUTCOME_ENTRIES_V1 = "CREATE TABLE cached_unique_outcome_notification (_id INTEGER PRIMARY KEY,notification_id TEXT,name TEXT);";
    public static final String SQL_CREATE_UNIQUE_OUTCOME_ENTRIES_V2 = "CREATE TABLE cached_unique_outcome (_id INTEGER PRIMARY KEY,channel_influence_id TEXT,channel_type TEXT,name TEXT);";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeOutcomeTableRevision1To2(SQLiteDatabase db) {
        String commonColumns = "_id,session,notification_ids,name,timestamp";
        try {
            db.execSQL("BEGIN TRANSACTION;");
            db.execSQL("CREATE TEMPORARY TABLE outcome_backup(" + commonColumns + ");");
            db.execSQL("INSERT INTO outcome_backup SELECT " + commonColumns + " FROM outcome;");
            db.execSQL("DROP TABLE outcome;");
            db.execSQL(SQL_CREATE_OUTCOME_ENTRIES_V2);
            db.execSQL("INSERT INTO outcome (" + commonColumns + ", weight) SELECT " + commonColumns + ", 0 FROM outcome_backup;");
            db.execSQL("DROP TABLE outcome_backup;");
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
        finally {
            db.execSQL("COMMIT;");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeOutcomeTableRevision2To3(SQLiteDatabase db) {
        String commonColumns = "_id,name,timestamp,notification_ids,weight";
        String commonColumnsWithSessionColumn = commonColumns + "," + "session";
        String commonColumnsWithNewSessionColumn = commonColumns + "," + "notification_influence_type";
        String auxOutcomeTableName = "outcome_aux";
        try {
            db.execSQL("BEGIN TRANSACTION;");
            db.execSQL("ALTER TABLE outcome RENAME TO " + auxOutcomeTableName + ";");
            db.execSQL(SQL_CREATE_OUTCOME_ENTRIES_V3);
            db.execSQL("INSERT INTO outcome(" + commonColumnsWithNewSessionColumn + ") SELECT " + commonColumnsWithSessionColumn + " FROM " + auxOutcomeTableName + ";");
            db.execSQL("DROP TABLE " + auxOutcomeTableName + ";");
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
        finally {
            db.execSQL("COMMIT;");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeCacheOutcomeTableRevision1To2(SQLiteDatabase db) {
        String commonColumns = "_id,name";
        String commonColumnsWithNotificationIdColumn = commonColumns + "," + "notification_id";
        String commonColumnsWithNewInfluenceIdColumn = commonColumns + "," + CACHE_UNIQUE_OUTCOME_COLUMN_CHANNEL_INFLUENCE_ID;
        String oldCacheUniqueOutcomeTable = "cached_unique_outcome_notification";
        try {
            db.execSQL("BEGIN TRANSACTION;");
            db.execSQL(SQL_CREATE_UNIQUE_OUTCOME_ENTRIES_V2);
            db.execSQL("INSERT INTO cached_unique_outcome(" + commonColumnsWithNewInfluenceIdColumn + ") SELECT " + commonColumnsWithNotificationIdColumn + " FROM " + oldCacheUniqueOutcomeTable + ";");
            db.execSQL("UPDATE cached_unique_outcome SET channel_type = '" + OSInfluenceChannel.NOTIFICATION.toString() + "';");
            db.execSQL("DROP TABLE " + oldCacheUniqueOutcomeTable + ";");
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
        finally {
            db.execSQL("COMMIT;");
        }
    }
}

