/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.outcomes;

import com.onesignal.OSLogger;
import com.onesignal.OneSignalApiResponseHandler;
import com.onesignal.outcomes.OSOutcomeEventsCache;
import com.onesignal.outcomes.OSOutcomeEventsRepository;
import com.onesignal.outcomes.domain.OutcomeEventsService;
import com.onesignal.outcomes.model.OSOutcomeEventParams;
import org.json.JSONException;
import org.json.JSONObject;

class OSOutcomeEventsV2Repository
extends OSOutcomeEventsRepository {
    OSOutcomeEventsV2Repository(OSLogger logger, OSOutcomeEventsCache outcomeEventsCache, OutcomeEventsService outcomeEventsService) {
        super(logger, outcomeEventsCache, outcomeEventsService);
    }

    @Override
    public void requestMeasureOutcomeEvent(String appId, int deviceType, OSOutcomeEventParams event, OneSignalApiResponseHandler responseHandler) {
        try {
            JSONObject jsonObject = event.toJSONObject();
            jsonObject.put("app_id", (Object)appId);
            jsonObject.put("device_type", deviceType);
            this.outcomeEventsService.sendOutcomeEvent(jsonObject, responseHandler);
        }
        catch (JSONException e) {
            this.logger.error("Generating indirect outcome:JSON Failed.", e);
        }
    }
}

