/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence.model;

import android.support.annotation.NonNull;

public enum OSInfluenceType {
    DIRECT,
    INDIRECT,
    UNATTRIBUTED,
    DISABLED;


    public boolean isDirect() {
        return this.equals((Object)DIRECT);
    }

    public boolean isIndirect() {
        return this.equals((Object)INDIRECT);
    }

    public boolean isAttributed() {
        return this.isDirect() || this.isIndirect();
    }

    public boolean isUnattributed() {
        return this.equals((Object)UNATTRIBUTED);
    }

    public boolean isDisabled() {
        return this.equals((Object)DISABLED);
    }

    @NonNull
    public static OSInfluenceType fromString(String value) {
        if (value == null || value.isEmpty()) {
            return UNATTRIBUTED;
        }
        for (OSInfluenceType type : OSInfluenceType.values()) {
            if (!type.name().equalsIgnoreCase(value)) continue;
            return type;
        }
        return UNATTRIBUTED;
    }
}

