/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.influence.model.OSInfluenceType;
import com.onesignal.outcomes.model.OSOutcomeEventParams;
import com.onesignal.outcomes.model.OSOutcomeSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OutcomeEvent {
    private static final String SESSION = "session";
    private static final String NOTIFICATION_IDS = "notification_ids";
    private static final String OUTCOME_ID = "id";
    private static final String TIMESTAMP = "timestamp";
    private static final String WEIGHT = "weight";
    private OSInfluenceType session;
    private JSONArray notificationIds;
    private String name;
    private long timestamp;
    private Float weight;

    public OutcomeEvent(@NonNull OSInfluenceType session, @Nullable JSONArray notificationIds, @NonNull String name, long timestamp, float weight) {
        this.session = session;
        this.notificationIds = notificationIds;
        this.name = name;
        this.timestamp = timestamp;
        this.weight = Float.valueOf(weight);
    }

    public static OutcomeEvent fromOutcomeEventParamsV2toOutcomeEventV1(OSOutcomeEventParams outcomeEventParams) {
        OSInfluenceType influenceType = OSInfluenceType.UNATTRIBUTED;
        JSONArray notificationId = null;
        if (outcomeEventParams.getOutcomeSource() != null) {
            OSOutcomeSource source = outcomeEventParams.getOutcomeSource();
            if (source.getDirectBody() != null && source.getDirectBody().getNotificationIds() != null && source.getDirectBody().getNotificationIds().length() > 0) {
                influenceType = OSInfluenceType.DIRECT;
                notificationId = source.getDirectBody().getNotificationIds();
            } else if (source.getIndirectBody() != null && source.getIndirectBody().getNotificationIds() != null && source.getIndirectBody().getNotificationIds().length() > 0) {
                influenceType = OSInfluenceType.INDIRECT;
                notificationId = source.getIndirectBody().getNotificationIds();
            }
        }
        return new OutcomeEvent(influenceType, notificationId, outcomeEventParams.getOutcomeId(), outcomeEventParams.getTimestamp(), outcomeEventParams.getWeight().floatValue());
    }

    public OSInfluenceType getSession() {
        return this.session;
    }

    public JSONArray getNotificationIds() {
        return this.notificationIds;
    }

    public String getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public float getWeight() {
        return this.weight.floatValue();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject json = new JSONObject();
        json.put(SESSION, (Object)this.session);
        json.put(NOTIFICATION_IDS, (Object)this.notificationIds);
        json.put(OUTCOME_ID, (Object)this.name);
        json.put(TIMESTAMP, this.timestamp);
        json.put(WEIGHT, (Object)this.weight);
        return json;
    }

    public JSONObject toJSONObjectForMeasure() throws JSONException {
        JSONObject json = new JSONObject();
        if (this.notificationIds != null && this.notificationIds.length() > 0) {
            json.put(NOTIFICATION_IDS, (Object)this.notificationIds);
        }
        json.put(OUTCOME_ID, (Object)this.name);
        if (this.weight.floatValue() > 0.0f) {
            json.put(WEIGHT, (Object)this.weight);
        }
        if (this.timestamp > 0L) {
            json.put(TIMESTAMP, this.timestamp);
        }
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutcomeEvent event = (OutcomeEvent)o;
        return this.session.equals((Object)event.session) && this.notificationIds.equals((Object)event.notificationIds) && this.name.equals(event.name) && this.timestamp == event.timestamp && this.weight.equals(event.weight);
    }

    public int hashCode() {
        Object[] a = new Object[]{this.session, this.notificationIds, this.name, this.timestamp, this.weight};
        int result = 1;
        for (Object element : a) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public String toString() {
        return "OutcomeEvent{session=" + (Object)((Object)this.session) + ", notificationIds=" + this.notificationIds + ", name='" + this.name + '\'' + ", timestamp=" + this.timestamp + ", weight=" + this.weight + '}';
    }
}

