/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.ActivityLifecycleHandler;

class ActivityLifecycleListener
implements Application.ActivityLifecycleCallbacks {
    @Nullable
    private static ActivityLifecycleListener instance;
    @Nullable
    private static ComponentCallbacks configuration;

    ActivityLifecycleListener() {
    }

    static void registerActivityLifecycleCallbacks(@NonNull Application application) {
        if (instance == null) {
            instance = new ActivityLifecycleListener();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
        }
        if (configuration == null) {
            configuration = new ComponentCallbacks(){

                public void onConfigurationChanged(Configuration newConfig) {
                    ActivityLifecycleHandler.onConfigurationChanged(newConfig);
                }

                public void onLowMemory() {
                }
            };
            application.registerComponentCallbacks(configuration);
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        ActivityLifecycleHandler.onActivityCreated(activity);
    }

    public void onActivityStarted(Activity activity) {
        ActivityLifecycleHandler.onActivityStarted(activity);
    }

    public void onActivityResumed(Activity activity) {
        ActivityLifecycleHandler.onActivityResumed(activity);
    }

    public void onActivityPaused(Activity activity) {
        ActivityLifecycleHandler.onActivityPaused(activity);
    }

    public void onActivityStopped(Activity activity) {
        ActivityLifecycleHandler.onActivityStopped(activity);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        ActivityLifecycleHandler.onActivityDestroyed(activity);
    }
}

