/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.WorkerThread;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalPrefs;
import com.onesignal.influence.model.OSInfluenceChannel;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

class OneSignalCacheCleaner {
    private static final long NOTIFICATION_CACHE_DATA_LIFETIME = 604800L;
    private static final long IAM_CACHE_DATA_LIFETIME = 15552000L;
    private static final String OS_DELETE_CACHED_NOTIFICATIONS_THREAD = "OS_DELETE_CACHED_NOTIFICATIONS_THREAD";
    private static final String OS_DELETE_CACHED_REDISPLAYED_IAMS_THREAD = "OS_DELETE_CACHED_REDISPLAYED_IAMS_THREAD";

    OneSignalCacheCleaner() {
    }

    static void cleanOldCachedData(Context context) {
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        SQLiteDatabase writableDb = dbHelper.getSQLiteDatabaseWithRetries();
        OneSignalCacheCleaner.cleanNotificationCache(writableDb);
        OneSignalCacheCleaner.cleanCachedInAppMessages(writableDb);
    }

    static synchronized void cleanNotificationCache(final SQLiteDatabase writableDb) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                OneSignalCacheCleaner.cleanCachedNotifications(writableDb);
                OneSignalCacheCleaner.cleanCachedUniqueOutcomeEventNotifications(writableDb);
            }
        }, OS_DELETE_CACHED_NOTIFICATIONS_THREAD).start();
    }

    @WorkerThread
    static synchronized void cleanCachedInAppMessages(final SQLiteDatabase writableDb) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block11: {
                    Thread.currentThread().setPriority(10);
                    retColumns = new String[]{"message_id", "click_ids"};
                    whereStr = "last_display < ?";
                    sixMonthsAgoInSeconds = String.valueOf(System.currentTimeMillis() / 1000L - 15552000L);
                    whereArgs = new String[]{sixMonthsAgoInSeconds};
                    oldMessageIds = OSUtils.newConcurrentSet();
                    oldClickedClickIds = OSUtils.newConcurrentSet();
                    cursor = null;
                    cursor = writableDb.query("in_app_message", retColumns, whereStr, whereArgs, null, null, null);
                    if (cursor != null && cursor.getCount() != 0) break block11;
                    OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Attempted to clean 6 month old IAM data, but none exists!");
                    v0 = cursor != null;
                    if (v0 & cursor.isClosed() == false) {
                        cursor.close();
                    }
                    return;
                }
                try {
                    if (cursor.moveToFirst()) {
                        do {
                            oldMessageId = cursor.getString(cursor.getColumnIndex("message_id"));
                            oldClickIds = cursor.getString(cursor.getColumnIndex("click_ids"));
                            oldMessageIds.add(oldMessageId);
                            oldClickedClickIds.addAll(OSUtils.newStringSetFromJSONArray(new JSONArray(oldClickIds)));
                        } while (cursor.moveToNext());
                    }
                    v1 = cursor != null;
                }
                catch (JSONException e) {
                    try {
                        e.printStackTrace();
                        v2 = cursor != null;
                    }
                    catch (Throwable var10_11) {
                        if (cursor != null & cursor.isClosed() == false) {
                            cursor.close();
                        }
                        throw var10_11;
                    }
                    if (v2 & cursor.isClosed() == false) {
                        cursor.close();
                    } else {
                        ** GOTO lbl43
                    }
                }
                if (v1 & cursor.isClosed() == false) {
                    cursor.close();
                }
                writableDb.delete("in_app_message", whereStr, whereArgs);
                OneSignalCacheCleaner.access$200(oldMessageIds);
                OneSignalCacheCleaner.access$300(oldClickedClickIds);
            }
        }, OS_DELETE_CACHED_REDISPLAYED_IAMS_THREAD).start();
    }

    private static void cleanCachedNotifications(SQLiteDatabase writableDb) {
        String whereStr = "created_time < ?";
        String sevenDaysAgoInSeconds = String.valueOf(System.currentTimeMillis() / 1000L - 604800L);
        String[] whereArgs = new String[]{sevenDaysAgoInSeconds};
        writableDb.delete("notification", whereStr, whereArgs);
    }

    private static void cleanCachedUniqueOutcomeEventNotifications(SQLiteDatabase writableDb) {
        String whereStr = "NOT EXISTS(SELECT NULL FROM notification n WHERE n.notification_id = channel_influence_id AND channel_type = \"" + OSInfluenceChannel.NOTIFICATION.toString().toLowerCase() + "\")";
        writableDb.delete("cached_unique_outcome", whereStr, null);
    }

    private static void cleanInAppMessageIds(Set<String> oldMessageIds) {
        if (oldMessageIds != null && oldMessageIds.size() > 0) {
            Set<String> dismissedMessages = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", OSUtils.newConcurrentSet());
            Set<String> impressionedMessages = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", OSUtils.newConcurrentSet());
            if (dismissedMessages != null && dismissedMessages.size() > 0) {
                dismissedMessages.removeAll(oldMessageIds);
                OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", dismissedMessages);
            }
            if (impressionedMessages != null && impressionedMessages.size() > 0) {
                impressionedMessages.removeAll(oldMessageIds);
                OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", impressionedMessages);
            }
        }
    }

    private static void cleanInAppMessageClickedClickIds(Set<String> oldClickedClickIds) {
        Set<String> clickedClickIds;
        if (oldClickedClickIds != null && oldClickedClickIds.size() > 0 && (clickedClickIds = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", OSUtils.newConcurrentSet())) != null && clickedClickIds.size() > 0) {
            clickedClickIds.removeAll(oldClickedClickIds);
            OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", clickedClickIds);
        }
    }

    static /* synthetic */ void access$200(Set x0) {
        OneSignalCacheCleaner.cleanInAppMessageIds(x0);
    }

    static /* synthetic */ void access$300(Set x0) {
        OneSignalCacheCleaner.cleanInAppMessageClickedClickIds(x0);
    }
}

