/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OneSignalRemoteParams {
    private static int androidParamsRetries = 0;
    private static final String OUTCOME_PARAM = "outcomes";
    private static final String ENABLED_PARAM = "enabled";
    private static final String DIRECT_PARAM = "direct";
    private static final String INDIRECT_PARAM = "indirect";
    private static final String NOTIFICATION_ATTRIBUTION_PARAM = "notification_attribution";
    private static final String UNATTRIBUTED_PARAM = "unattributed";
    private static final String FCM_PARENT_PARAM = "fcm";
    private static final String FCM_PROJECT_ID = "project_id";
    private static final String FCM_APP_ID = "app_id";
    private static final String FCM_API_KEY = "api_key";
    private static final int INCREASE_BETWEEN_RETRIES = 10000;
    private static final int MIN_WAIT_BETWEEN_RETRIES = 30000;
    private static final int MAX_WAIT_BETWEEN_RETRIES = 90000;
    static final int DEFAULT_INDIRECT_ATTRIBUTION_WINDOW = 1440;
    static final int DEFAULT_NOTIFICATION_LIMIT = 10;

    OneSignalRemoteParams() {
    }

    static void makeAndroidParamsRequest(final @NonNull CallBack callBack) {
        OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                if (statusCode == 403) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "403 error getting OneSignal params, omitting further retries!");
                    return;
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int sleepTime = 30000 + androidParamsRetries * 10000;
                        if (sleepTime > 90000) {
                            sleepTime = 90000;
                        }
                        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Failed to get Android parameters, trying again in " + sleepTime / 1000 + " seconds.");
                        OSUtils.sleep(sleepTime);
                        androidParamsRetries++;
                        OneSignalRemoteParams.makeAndroidParamsRequest(callBack);
                    }
                }, "OS_PARAMS_REQUEST").start();
            }

            @Override
            void onSuccess(String response) {
                OneSignalRemoteParams.processJson(response, callBack);
            }
        };
        String params_url = "apps/" + OneSignal.appId + "/android_params.js";
        String userId = OneSignal.getUserId();
        if (userId != null) {
            params_url = params_url + "?player_id=" + userId;
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Starting request to get Android parameters.");
        OneSignalRestClient.get(params_url, responseHandler, "CACHE_KEY_REMOTE_PARAMS");
    }

    private static void processJson(String json, @NonNull CallBack callBack) {
        JSONObject responseJson;
        try {
            responseJson = new JSONObject(json);
        }
        catch (NullPointerException | JSONException t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "Error parsing android_params!: ", t);
            OneSignal.Log(OneSignal.LOG_LEVEL.FATAL, "Response that errored from android_params!: " + json);
            return;
        }
        Params params = new Params(){
            {
                this.enterprise = responseJson.optBoolean("enterp", false);
                this.useEmailAuth = responseJson.optBoolean("use_email_auth", false);
                this.notificationChannels = responseJson.optJSONArray("chnl_lst");
                this.firebaseAnalytics = responseJson.optBoolean("fba", false);
                this.restoreTTLFilter = responseJson.optBoolean("restore_ttl_filter", true);
                this.googleProjectNumber = responseJson.optString("android_sender_id", null);
                this.clearGroupOnSummaryClick = responseJson.optBoolean("clear_group_on_summary_click", true);
                this.receiveReceiptEnabled = responseJson.optBoolean("receive_receipts_enable", false);
                this.outcomesParams = new OutcomesParams();
                if (responseJson.has(OneSignalRemoteParams.OUTCOME_PARAM)) {
                    JSONObject outcomes = responseJson.optJSONObject(OneSignalRemoteParams.OUTCOME_PARAM);
                    if (outcomes.has(OneSignalRemoteParams.DIRECT_PARAM)) {
                        JSONObject direct = outcomes.optJSONObject(OneSignalRemoteParams.DIRECT_PARAM);
                        this.outcomesParams.directEnabled = direct.optBoolean(OneSignalRemoteParams.ENABLED_PARAM);
                    }
                    if (outcomes.has(OneSignalRemoteParams.INDIRECT_PARAM)) {
                        JSONObject indirect = outcomes.optJSONObject(OneSignalRemoteParams.INDIRECT_PARAM);
                        this.outcomesParams.indirectEnabled = indirect.optBoolean(OneSignalRemoteParams.ENABLED_PARAM);
                        if (indirect.has(OneSignalRemoteParams.NOTIFICATION_ATTRIBUTION_PARAM)) {
                            JSONObject indirectNotificationAttribution = indirect.optJSONObject(OneSignalRemoteParams.NOTIFICATION_ATTRIBUTION_PARAM);
                            this.outcomesParams.indirectAttributionWindow = indirectNotificationAttribution.optInt("minutes_since_displayed", 1440);
                            this.outcomesParams.notificationLimit = indirectNotificationAttribution.optInt("limit", 10);
                        }
                    }
                    if (outcomes.has(OneSignalRemoteParams.UNATTRIBUTED_PARAM)) {
                        JSONObject unattributed = outcomes.optJSONObject(OneSignalRemoteParams.UNATTRIBUTED_PARAM);
                        this.outcomesParams.unattributedEnabled = unattributed.optBoolean(OneSignalRemoteParams.ENABLED_PARAM);
                    }
                }
                this.fcmParams = new FCMParams();
                if (responseJson.has(OneSignalRemoteParams.FCM_PARENT_PARAM)) {
                    JSONObject fcm = responseJson.optJSONObject(OneSignalRemoteParams.FCM_PARENT_PARAM);
                    this.fcmParams.apiKey = fcm.optString(OneSignalRemoteParams.FCM_API_KEY, null);
                    this.fcmParams.appId = fcm.optString(OneSignalRemoteParams.FCM_APP_ID, null);
                    this.fcmParams.projectId = fcm.optString(OneSignalRemoteParams.FCM_PROJECT_ID, null);
                }
            }
        };
        callBack.complete(params);
    }

    static interface CallBack {
        public void complete(Params var1);
    }

    static class Params {
        String googleProjectNumber;
        boolean enterprise;
        boolean useEmailAuth;
        JSONArray notificationChannels;
        boolean firebaseAnalytics;
        boolean restoreTTLFilter;
        boolean clearGroupOnSummaryClick;
        boolean receiveReceiptEnabled;
        OutcomesParams outcomesParams;
        FCMParams fcmParams;

        Params() {
        }
    }

    static class OutcomesParams {
        int indirectAttributionWindow = 1440;
        int notificationLimit = 10;
        boolean directEnabled = false;
        boolean indirectEnabled = false;
        boolean unattributedEnabled = false;

        OutcomesParams() {
        }
    }

    static class FCMParams {
        @Nullable
        String projectId;
        @Nullable
        String appId;
        @Nullable
        String apiKey;

        FCMParams() {
        }
    }
}

