/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.GoogleApiClientCompatProxy;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalSyncServiceUtils;
import com.onesignal.PermissionsActivity;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

class LocationGMS {
    private static final long TIME_FOREGROUND_SEC = 300L;
    private static final long TIME_BACKGROUND_SEC = 600L;
    private static final long FOREGROUND_UPDATE_TIME_MS = 270000L;
    private static final long BACKGROUND_UPDATE_TIME_MS = 570000L;
    private static GoogleApiClientCompatProxy mGoogleApiClient;
    private static Location mLastLocation;
    static String requestPermission;
    private static Context classContext;
    private static LocationHandlerThread locationHandlerThread;
    protected static final Object syncLock;
    private static ConcurrentHashMap<PermissionType, LocationHandler> locationHandlers;
    private static final List<LocationPromptCompletionHandler> promptHandlers;
    private static Thread fallbackFailThread;
    private static boolean locationCoarse;
    static LocationUpdateListener locationUpdateListener;

    LocationGMS() {
    }

    static boolean scheduleUpdate(Context context) {
        if (!LocationGMS.hasLocationPermission(context) || !OneSignal.shareLocation) {
            return false;
        }
        long lastTime = System.currentTimeMillis() - LocationGMS.getLastLocationTime();
        long minTime = 1000L * (OneSignal.isForeground() ? 300L : 600L);
        long scheduleTime = minTime - lastTime;
        OneSignalSyncServiceUtils.scheduleLocationUpdateTask(context, scheduleTime);
        return true;
    }

    private static void setLastLocationTime(long time) {
        OneSignalPrefs.saveLong(OneSignalPrefs.PREFS_ONESIGNAL, "OS_LAST_LOCATION_TIME", time);
    }

    private static long getLastLocationTime() {
        return OneSignalPrefs.getLong(OneSignalPrefs.PREFS_ONESIGNAL, "OS_LAST_LOCATION_TIME", -600000L);
    }

    private static boolean hasLocationPermission(Context context) {
        return AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION") == 0 || AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION") == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPromptHandlerIfAvailable(LocationHandler handler) {
        if (handler instanceof LocationPromptCompletionHandler) {
            List<LocationPromptCompletionHandler> list = promptHandlers;
            synchronized (list) {
                promptHandlers.add((LocationPromptCompletionHandler)handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendAndClearPromptHandlers(boolean promptLocation, boolean accepted) {
        if (!promptLocation) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "LocationGMS sendAndClearPromptHandlers from non prompt flow");
            return;
        }
        List<LocationPromptCompletionHandler> list = promptHandlers;
        synchronized (list) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "LocationGMS calling prompt handlers");
            for (LocationPromptCompletionHandler promptHandler : promptHandlers) {
                promptHandler.onAnswered(accepted);
            }
            promptHandlers.clear();
        }
    }

    static void getLocation(Context context, boolean promptLocation, LocationHandler handler) {
        block16: {
            LocationGMS.addPromptHandlerIfAvailable(handler);
            classContext = context;
            locationHandlers.put(handler.getType(), handler);
            if (!OneSignal.shareLocation) {
                LocationGMS.sendAndClearPromptHandlers(promptLocation, false);
                LocationGMS.fireFailedComplete();
                return;
            }
            int locationCoarsePermission = -1;
            int locationFinePermission = AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION");
            if (locationFinePermission == -1) {
                locationCoarsePermission = AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
                locationCoarse = true;
            }
            if (Build.VERSION.SDK_INT < 23) {
                if (locationFinePermission != 0 && locationCoarsePermission != 0) {
                    LocationGMS.sendAndClearPromptHandlers(promptLocation, false);
                    handler.complete(null);
                    return;
                }
                LocationGMS.sendAndClearPromptHandlers(promptLocation, true);
                LocationGMS.startGetLocation();
            } else if (locationFinePermission != 0) {
                try {
                    PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
                    List<String> permissionList = Arrays.asList(packageInfo.requestedPermissions);
                    if (permissionList.contains("android.permission.ACCESS_FINE_LOCATION")) {
                        requestPermission = "android.permission.ACCESS_FINE_LOCATION";
                    } else if (permissionList.contains("android.permission.ACCESS_COARSE_LOCATION")) {
                        if (locationCoarsePermission != 0) {
                            requestPermission = "android.permission.ACCESS_COARSE_LOCATION";
                        }
                    } else {
                        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.INFO, "Location permissions not added on AndroidManifest file");
                    }
                    if (requestPermission != null && promptLocation) {
                        PermissionsActivity.startPrompt();
                        break block16;
                    }
                    if (locationCoarsePermission == 0) {
                        LocationGMS.sendAndClearPromptHandlers(promptLocation, true);
                        LocationGMS.startGetLocation();
                        break block16;
                    }
                    LocationGMS.sendAndClearPromptHandlers(promptLocation, false);
                    LocationGMS.fireFailedComplete();
                }
                catch (PackageManager.NameNotFoundException e) {
                    LocationGMS.sendAndClearPromptHandlers(promptLocation, false);
                    e.printStackTrace();
                }
            } else {
                LocationGMS.sendAndClearPromptHandlers(promptLocation, true);
                LocationGMS.startGetLocation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startGetLocation() {
        if (fallbackFailThread != null) {
            return;
        }
        try {
            Object object = syncLock;
            synchronized (object) {
                LocationGMS.startFallBackThread();
                if (locationHandlerThread == null) {
                    locationHandlerThread = new LocationHandlerThread();
                }
                if (mGoogleApiClient == null || mLastLocation == null) {
                    GoogleApiClientListener googleApiClientListener = new GoogleApiClientListener();
                    GoogleApiClient googleApiClient = new GoogleApiClient.Builder(classContext).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)googleApiClientListener).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)googleApiClientListener).setHandler(LocationGMS.locationHandlerThread.mHandler).build();
                    mGoogleApiClient = new GoogleApiClientCompatProxy(googleApiClient);
                    mGoogleApiClient.connect();
                } else if (mLastLocation != null) {
                    LocationGMS.fireCompleteForLocation(mLastLocation);
                }
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Location permission exists but there was an error initializing: ", t);
            LocationGMS.fireFailedComplete();
        }
    }

    private static int getApiFallbackWait() {
        return 30000;
    }

    private static void startFallBackThread() {
        fallbackFailThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(LocationGMS.getApiFallbackWait());
                    OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "Location permission exists but GoogleApiClient timed out. Maybe related to mismatch google-play aar versions.");
                    LocationGMS.fireFailedComplete();
                    LocationGMS.scheduleUpdate(classContext);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "OS_GMS_LOCATION_FALLBACK");
        fallbackFailThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireFailedComplete() {
        PermissionsActivity.answered = false;
        Object object = syncLock;
        synchronized (object) {
            if (mGoogleApiClient != null) {
                mGoogleApiClient.disconnect();
            }
            mGoogleApiClient = null;
        }
        LocationGMS.fireComplete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void fireComplete(LocationPoint point) {
        HashMap<PermissionType, LocationHandler> _locationHandlers = new HashMap<PermissionType, LocationHandler>();
        Class<LocationGMS> clazz = LocationGMS.class;
        // MONITORENTER : com.onesignal.LocationGMS.class
        _locationHandlers.putAll(locationHandlers);
        locationHandlers.clear();
        Thread _fallbackFailThread = fallbackFailThread;
        // MONITOREXIT : clazz
        for (PermissionType type : _locationHandlers.keySet()) {
            ((LocationHandler)_locationHandlers.get((Object)type)).complete(point);
        }
        if (_fallbackFailThread != null && !Thread.currentThread().equals(_fallbackFailThread)) {
            _fallbackFailThread.interrupt();
        }
        if (_fallbackFailThread == fallbackFailThread) {
            clazz = LocationGMS.class;
            // MONITORENTER : com.onesignal.LocationGMS.class
            if (_fallbackFailThread == fallbackFailThread) {
                fallbackFailThread = null;
            }
            // MONITOREXIT : clazz
        }
        LocationGMS.setLastLocationTime(System.currentTimeMillis());
    }

    private static void fireCompleteForLocation(Location location) {
        LocationPoint point = new LocationPoint();
        point.accuracy = Float.valueOf(location.getAccuracy());
        point.bg = !OneSignal.isForeground();
        point.type = locationCoarse ? 0 : 1;
        point.timeStamp = location.getTime();
        if (locationCoarse) {
            point.lat = new BigDecimal(location.getLatitude()).setScale(7, RoundingMode.HALF_UP).doubleValue();
            point.log = new BigDecimal(location.getLongitude()).setScale(7, RoundingMode.HALF_UP).doubleValue();
        } else {
            point.lat = location.getLatitude();
            point.log = location.getLongitude();
        }
        LocationGMS.fireComplete(point);
        LocationGMS.scheduleUpdate(classContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onFocusChange() {
        Object object = syncLock;
        synchronized (object) {
            if (mGoogleApiClient == null || !mGoogleApiClient.realInstance().isConnected()) {
                return;
            }
            GoogleApiClient googleApiClient = mGoogleApiClient.realInstance();
            if (locationUpdateListener != null) {
                LocationServices.FusedLocationApi.removeLocationUpdates(googleApiClient, (LocationListener)locationUpdateListener);
            }
            locationUpdateListener = new LocationUpdateListener(googleApiClient);
        }
    }

    static {
        syncLock = new Object(){};
        locationHandlers = new ConcurrentHashMap();
        promptHandlers = new ArrayList<LocationPromptCompletionHandler>();
    }

    private static class LocationHandlerThread
    extends HandlerThread {
        Handler mHandler;

        LocationHandlerThread() {
            super("OSH_LocationHandlerThread");
            this.start();
            this.mHandler = new Handler(this.getLooper());
        }
    }

    static class FusedLocationApiWrapper {
        FusedLocationApiWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void requestLocationUpdates(GoogleApiClient googleApiClient, LocationRequest locationRequest, LocationListener locationListener) {
            try {
                Object object = syncLock;
                synchronized (object) {
                    if (googleApiClient.isConnected()) {
                        LocationServices.FusedLocationApi.requestLocationUpdates(googleApiClient, locationRequest, locationListener);
                    }
                }
            }
            catch (Throwable t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "FusedLocationApi.requestLocationUpdates failed!", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Location getLastLocation(GoogleApiClient googleApiClient) {
            Object object = syncLock;
            synchronized (object) {
                if (googleApiClient.isConnected()) {
                    return LocationServices.FusedLocationApi.getLastLocation(googleApiClient);
                }
            }
            return null;
        }
    }

    static class LocationUpdateListener
    implements LocationListener {
        private GoogleApiClient mGoogleApiClient;

        LocationUpdateListener(GoogleApiClient googleApiClient) {
            this.mGoogleApiClient = googleApiClient;
            long updateInterval = 570000L;
            if (OneSignal.isForeground()) {
                updateInterval = 270000L;
            }
            LocationRequest locationRequest = LocationRequest.create().setFastestInterval(updateInterval).setInterval(updateInterval).setMaxWaitTime((long)((double)updateInterval * 1.5)).setPriority(102);
            FusedLocationApiWrapper.requestLocationUpdates(this.mGoogleApiClient, locationRequest, this);
        }

        public void onLocationChanged(Location location) {
            mLastLocation = location;
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Location Change Detected");
        }
    }

    private static class GoogleApiClientListener
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private GoogleApiClientListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnected(Bundle bundle) {
            Object object = syncLock;
            synchronized (object) {
                PermissionsActivity.answered = false;
                if (mGoogleApiClient == null || mGoogleApiClient.realInstance() == null) {
                    return;
                }
                if (mLastLocation == null) {
                    mLastLocation = FusedLocationApiWrapper.getLastLocation(mGoogleApiClient.realInstance());
                    if (mLastLocation != null) {
                        LocationGMS.fireCompleteForLocation(mLastLocation);
                    }
                }
                locationUpdateListener = new LocationUpdateListener(mGoogleApiClient.realInstance());
            }
        }

        public void onConnectionSuspended(int i) {
            LocationGMS.fireFailedComplete();
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            LocationGMS.fireFailedComplete();
        }
    }

    static abstract class LocationPromptCompletionHandler
    implements LocationHandler {
        LocationPromptCompletionHandler() {
        }

        void onAnswered(boolean accepted) {
        }
    }

    static interface LocationHandler {
        public PermissionType getType();

        public void complete(LocationPoint var1);
    }

    static enum PermissionType {
        STARTUP,
        PROMPT_LOCATION,
        SYNC_SERVICE;

    }

    static class LocationPoint {
        Double lat;
        Double log;
        Float accuracy;
        Integer type;
        Boolean bg;
        Long timeStamp;

        LocationPoint() {
        }
    }
}

