/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OutcomeEvent;
import com.onesignal.OutcomeEventsCache;
import com.onesignal.OutcomeEventsService;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OutcomeEventsRepository {
    private static final String APP_ID = "app_id";
    private static final String DEVICE_TYPE = "device_type";
    private static final String DIRECT = "direct";
    private final OutcomeEventsService outcomeEventsService;
    private final OneSignalDbHelper dbHelper;

    OutcomeEventsRepository(OneSignalDbHelper dbHelper) {
        this.outcomeEventsService = new OutcomeEventsService();
        this.dbHelper = dbHelper;
    }

    OutcomeEventsRepository(OutcomeEventsService outcomeEventsService, OneSignalDbHelper dbHelper) {
        this.outcomeEventsService = outcomeEventsService;
        this.dbHelper = dbHelper;
    }

    List<OutcomeEvent> getSavedOutcomeEvents() {
        return OutcomeEventsCache.getAllEventsToSend(this.dbHelper);
    }

    void saveOutcomeEvent(OutcomeEvent event) {
        OutcomeEventsCache.saveOutcomeEvent(event, this.dbHelper);
    }

    void removeEvent(OutcomeEvent outcomeEvent) {
        OutcomeEventsCache.deleteOldOutcomeEvent(outcomeEvent, this.dbHelper);
    }

    void requestMeasureDirectOutcomeEvent(String appId, int deviceType, OutcomeEvent event, OneSignalRestClient.ResponseHandler responseHandler) {
        JSONObject jsonObject = event.toJSONObjectForMeasure();
        try {
            jsonObject.put(APP_ID, (Object)appId);
            jsonObject.put(DEVICE_TYPE, deviceType);
            jsonObject.put(DIRECT, true);
            this.outcomeEventsService.sendOutcomeEvent(jsonObject, responseHandler);
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating direct outcome:JSON Failed.", e);
        }
    }

    void requestMeasureIndirectOutcomeEvent(String appId, int deviceType, OutcomeEvent event, OneSignalRestClient.ResponseHandler responseHandler) {
        JSONObject jsonObject = event.toJSONObjectForMeasure();
        try {
            jsonObject.put(APP_ID, (Object)appId);
            jsonObject.put(DEVICE_TYPE, deviceType);
            jsonObject.put(DIRECT, false);
            this.outcomeEventsService.sendOutcomeEvent(jsonObject, responseHandler);
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating indirect outcome:JSON Failed.", e);
        }
    }

    void requestMeasureUnattributedOutcomeEvent(String appId, int deviceType, OutcomeEvent event, OneSignalRestClient.ResponseHandler responseHandler) {
        JSONObject jsonObject = event.toJSONObjectForMeasure();
        try {
            jsonObject.put(APP_ID, (Object)appId);
            jsonObject.put(DEVICE_TYPE, deviceType);
            this.outcomeEventsService.sendOutcomeEvent(jsonObject, responseHandler);
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating unattributed outcome:JSON Failed.", e);
        }
    }

    void saveUniqueOutcomeNotifications(JSONArray notificationIds, String name) {
        OutcomeEventsCache.saveUniqueOutcomeNotifications(notificationIds, name, this.dbHelper);
    }

    JSONArray getNotCachedUniqueOutcomeNotifications(String name, JSONArray notificationIds) {
        return OutcomeEventsCache.getNotCachedUniqueOutcomeNotifications(name, notificationIds, this.dbHelper);
    }
}

