/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OSDynamicTriggerController;
import com.onesignal.OSInAppMessage;
import com.onesignal.OSInAppMessageAction;
import com.onesignal.OSInAppMessageDummyController;
import com.onesignal.OSInAppMessageOutcome;
import com.onesignal.OSInAppMessagePrompt;
import com.onesignal.OSInAppMessageRepository;
import com.onesignal.OSInAppMessageTag;
import com.onesignal.OSSystemConditionController;
import com.onesignal.OSTriggerController;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalChromeTab;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRestClient;
import com.onesignal.WebViewManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class OSInAppMessageController
implements OSDynamicTriggerController.OSDynamicTriggerControllerObserver,
OSSystemConditionController.OSSystemConditionObserver {
    private static ArrayList<String> PREFERRED_VARIANT_ORDER = new ArrayList<String>(){
        {
            this.add("android");
            this.add("app");
            this.add("all");
        }
    };
    public static final String IN_APP_MESSAGES_JSON_KEY = "in_app_messages";
    private static final String OS_SAVE_IN_APP_MESSAGE = "OS_SAVE_IN_APP_MESSAGE";
    private static final String OS_DELETE_IN_APP_MESSAGE = "OS_DELETE_IN_APP_MESSAGE";
    OSTriggerController triggerController;
    private OSSystemConditionController systemConditionController;
    private OSInAppMessageRepository inAppMessageRepository;
    @NonNull
    private ArrayList<OSInAppMessage> messages = new ArrayList();
    @NonNull
    private final Set<String> dismissedMessages = OSUtils.newConcurrentSet();
    @NonNull
    private final Set<String> impressionedMessages;
    @NonNull
    private final Set<String> clickedClickIds;
    @NonNull
    private final ArrayList<OSInAppMessage> messageDisplayQueue = new ArrayList();
    @NonNull
    private List<OSInAppMessage> redisplayedInAppMessages;
    private OSInAppMessagePrompt currentPrompt = null;
    private boolean inAppMessagingEnabled = true;
    private boolean inAppMessageShowing = false;
    @Nullable
    Date lastTimeInAppDismissed;
    private int htmlNetworkRequestAttemptCount = 0;
    @Nullable
    private static OSInAppMessageController sharedInstance;

    public static OSInAppMessageController getController() {
        OneSignalDbHelper dbHelper = OneSignal.getDBHelperInstance();
        if (Build.VERSION.SDK_INT <= 18) {
            sharedInstance = new OSInAppMessageDummyController(null);
        }
        if (sharedInstance == null) {
            sharedInstance = new OSInAppMessageController(dbHelper);
        }
        return sharedInstance;
    }

    protected OSInAppMessageController(OneSignalDbHelper dbHelper) {
        Set<String> tempClickedMessageIdsSet;
        Set<String> tempImpressionsSet;
        this.impressionedMessages = OSUtils.newConcurrentSet();
        this.clickedClickIds = OSUtils.newConcurrentSet();
        this.triggerController = new OSTriggerController(this);
        this.systemConditionController = new OSSystemConditionController(this);
        Set<String> tempDismissedSet = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", null);
        if (tempDismissedSet != null) {
            this.dismissedMessages.addAll(tempDismissedSet);
        }
        if ((tempImpressionsSet = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", null)) != null) {
            this.impressionedMessages.addAll(tempImpressionsSet);
        }
        if ((tempClickedMessageIdsSet = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", null)) != null) {
            this.clickedClickIds.addAll(tempClickedMessageIdsSet);
        }
        this.initRedisplayData(dbHelper);
    }

    protected void initRedisplayData(OneSignalDbHelper dbHelper) {
        this.inAppMessageRepository = new OSInAppMessageRepository(dbHelper);
        this.redisplayedInAppMessages = this.inAppMessageRepository.getRedisplayedInAppMessages();
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "redisplayedInAppMessages: " + this.redisplayedInAppMessages.toString());
    }

    void initWithCachedInAppMessages() {
        if (!this.messages.isEmpty()) {
            return;
        }
        String cachedIamsStr = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CACHED_IAMS", null);
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "initWithCachedInAppMessages: " + cachedIamsStr);
        if (cachedIamsStr == null) {
            return;
        }
        try {
            this.processInAppMessageJson(new JSONArray(cachedIamsStr));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    void receivedInAppMessageJson(@NonNull JSONArray json) throws JSONException {
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CACHED_IAMS", json.toString());
        this.resetRedisplayMessagesBySession();
        this.processInAppMessageJson(json);
        this.deleteOldRedisplayedInAppMessages();
    }

    private void resetRedisplayMessagesBySession() {
        for (OSInAppMessage redisplayInAppMessage : this.redisplayedInAppMessages) {
            redisplayInAppMessage.setDisplayedInSession(false);
        }
    }

    private void processInAppMessageJson(@NonNull JSONArray json) throws JSONException {
        ArrayList<OSInAppMessage> newMessages = new ArrayList<OSInAppMessage>();
        for (int i = 0; i < json.length(); ++i) {
            JSONObject messageJson = json.getJSONObject(i);
            OSInAppMessage message = new OSInAppMessage(messageJson);
            newMessages.add(message);
        }
        this.messages = newMessages;
        this.evaluateInAppMessages();
    }

    private void deleteOldRedisplayedInAppMessages() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                OSInAppMessageController.this.inAppMessageRepository.deleteOldRedisplayedInAppMessages();
            }
        }, OS_DELETE_IN_APP_MESSAGE).start();
    }

    private void evaluateInAppMessages() {
        for (OSInAppMessage message : this.messages) {
            this.setDataForRedisplay(message);
            if (this.dismissedMessages.contains(message.messageId) || !this.triggerController.evaluateMessageTriggers(message)) continue;
            this.queueMessageForDisplay(message);
        }
    }

    @Nullable
    private static String variantIdForMessage(@NonNull OSInAppMessage message) {
        String languageIdentifier = OSUtils.getCorrectedLanguage();
        for (String variant : PREFERRED_VARIANT_ORDER) {
            if (!message.variants.containsKey(variant)) continue;
            HashMap<String, String> variantMap = message.variants.get(variant);
            if (variantMap.containsKey(languageIdentifier)) {
                return variantMap.get(languageIdentifier);
            }
            return variantMap.get("default");
        }
        return null;
    }

    private static void printHttpSuccessForInAppMessageRequest(String requestType, String response) {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Successful post for in-app message " + requestType + " request: " + response);
    }

    private static void printHttpErrorForInAppMessageRequest(String requestType, int statusCode, String response) {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Encountered a " + statusCode + " error while attempting in-app message " + requestType + " request: " + response);
    }

    void onMessageWasShown(final @NonNull OSInAppMessage message) {
        if (message.isPreview) {
            return;
        }
        if (this.impressionedMessages.contains(message.messageId)) {
            return;
        }
        this.impressionedMessages.add(message.messageId);
        final String variantId = OSInAppMessageController.variantIdForMessage(message);
        if (variantId == null) {
            return;
        }
        try {
            JSONObject json = new JSONObject(){
                {
                    this.put("app_id", OneSignal.appId);
                    this.put("player_id", OneSignal.getUserId());
                    this.put("variant_id", variantId);
                    this.put("device_type", new OSUtils().getDeviceType());
                    this.put("first_impression", true);
                }
            };
            OneSignalRestClient.post("in_app_messages/" + message.messageId + "/impression", json, new OneSignalRestClient.ResponseHandler(){

                @Override
                void onSuccess(String response) {
                    OSInAppMessageController.printHttpSuccessForInAppMessageRequest("impression", response);
                    OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_IMPRESSIONED_IAMS", OSInAppMessageController.this.impressionedMessages);
                }

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OSInAppMessageController.printHttpErrorForInAppMessageRequest("impression", statusCode, response);
                    OSInAppMessageController.this.impressionedMessages.remove(message.messageId);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Unable to execute in-app message impression HTTP request due to invalid JSON");
        }
    }

    void onMessageActionOccurredOnMessage(@NonNull OSInAppMessage message, @NonNull JSONObject actionJson) throws JSONException {
        OSInAppMessageAction action = new OSInAppMessageAction(actionJson);
        action.firstClick = message.takeActionAsUnique();
        this.firePublicClickHandler(action);
        this.beginProcessingPrompts(message, action.prompts);
        this.fireClickAction(action);
        this.fireRESTCallForClick(message, action);
        this.fireTagCallForClick(action);
        this.fireOutcomesForClick(action.outcomes);
    }

    void onMessageActionOccurredOnPreview(@NonNull OSInAppMessage message, @NonNull JSONObject actionJson) throws JSONException {
        OSInAppMessageAction action = new OSInAppMessageAction(actionJson);
        action.firstClick = message.takeActionAsUnique();
        this.firePublicClickHandler(action);
        this.beginProcessingPrompts(message, action.prompts);
        this.fireClickAction(action);
        this.logInAppMessagePreviewActions(action);
    }

    private void logInAppMessagePreviewActions(OSInAppMessageAction action) {
        if (action.tags != null) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Tags detected inside of the action click payload, ignoring because action came from IAM preview:: " + action.tags.toString());
        }
        if (action.outcomes.size() > 0) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Outcomes detected inside of the action click payload, ignoring because action came from IAM preview: " + action.outcomes.toString());
        }
    }

    private void beginProcessingPrompts(OSInAppMessage message, List<OSInAppMessagePrompt> prompts) {
        if (prompts.size() > 0) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "IAM showing prompts from IAM: " + message.toString());
            WebViewManager.dismissCurrentInAppMessage();
            this.showMultiplePrompts(message, prompts);
        }
    }

    private void showMultiplePrompts(final OSInAppMessage message, final List<OSInAppMessagePrompt> prompts) {
        for (OSInAppMessagePrompt prompt : prompts) {
            if (prompt.hasPrompted()) continue;
            this.currentPrompt = prompt;
            break;
        }
        if (this.currentPrompt != null) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "IAM prompt to handle: " + this.currentPrompt.toString());
            this.currentPrompt.setPrompted(true);
            this.currentPrompt.handlePrompt(new OneSignal.OSPromptActionCompletionCallback(){

                @Override
                public void completed(boolean accepted) {
                    OSInAppMessageController.this.currentPrompt = null;
                    OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "IAM prompt to handle finished accepted: " + accepted);
                    OSInAppMessageController.this.showMultiplePrompts(message, prompts);
                }
            });
        } else {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "No IAM prompt to handle, dismiss message: " + message.messageId);
            this.messageWasDismissed(message);
        }
    }

    private void fireOutcomesForClick(@NonNull List<OSInAppMessageOutcome> outcomes) {
        for (OSInAppMessageOutcome outcome : outcomes) {
            String name = outcome.getName();
            if (outcome.isUnique()) {
                OneSignal.sendClickActionUniqueOutcome(name);
                continue;
            }
            if (outcome.getWeight() > 0.0f) {
                OneSignal.sendClickActionOutcomeWithValue(name, outcome.getWeight());
                continue;
            }
            OneSignal.sendClickActionOutcome(name);
        }
    }

    private void fireTagCallForClick(@NonNull OSInAppMessageAction action) {
        if (action.tags != null) {
            OSInAppMessageTag tags = action.tags;
            if (tags.getTagsToAdd() != null) {
                OneSignal.sendTags(tags.getTagsToAdd());
            }
            if (tags.getTagsToRemove() != null) {
                OneSignal.deleteTags(tags.getTagsToRemove(), null);
            }
        }
    }

    private void firePublicClickHandler(final @NonNull OSInAppMessageAction action) {
        if (OneSignal.mInitBuilder.mInAppMessageClickHandler == null) {
            return;
        }
        OSUtils.runOnMainUIThread(new Runnable(){

            @Override
            public void run() {
                OneSignal.mInitBuilder.mInAppMessageClickHandler.inAppMessageClicked(action);
            }
        });
    }

    private void fireClickAction(@NonNull OSInAppMessageAction action) {
        if (action.clickUrl != null && !action.clickUrl.isEmpty()) {
            if (action.urlTarget == OSInAppMessageAction.OSInAppMessageActionUrlType.BROWSER) {
                OSUtils.openURLInBrowser(action.clickUrl);
            } else if (action.urlTarget == OSInAppMessageAction.OSInAppMessageActionUrlType.IN_APP_WEBVIEW) {
                OneSignalChromeTab.open(action.clickUrl, true);
            }
        }
    }

    private void fireRESTCallForClick(@NonNull OSInAppMessage message, final @NonNull OSInAppMessageAction action) {
        boolean clickAvailableByRedisplay;
        final String variantId = OSInAppMessageController.variantIdForMessage(message);
        if (variantId == null) {
            return;
        }
        final String clickId = action.clickId;
        boolean bl = clickAvailableByRedisplay = message.getDisplayStats().isRedisplayEnabled() && message.isClickAvailable(clickId);
        if (!clickAvailableByRedisplay && this.clickedClickIds.contains(clickId)) {
            return;
        }
        this.clickedClickIds.add(clickId);
        message.addClickId(clickId);
        try {
            JSONObject json = new JSONObject(){
                {
                    this.put("app_id", OneSignal.appId);
                    this.put("device_type", new OSUtils().getDeviceType());
                    this.put("player_id", OneSignal.getUserId());
                    this.put("click_id", clickId);
                    this.put("variant_id", variantId);
                    if (action.firstClick) {
                        this.put("first_click", true);
                    }
                }
            };
            OneSignalRestClient.post("in_app_messages/" + message.messageId + "/click", json, new OneSignalRestClient.ResponseHandler(){

                @Override
                void onSuccess(String response) {
                    OSInAppMessageController.printHttpSuccessForInAppMessageRequest("engagement", response);
                    OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_CLICKED_CLICK_IDS_IAMS", OSInAppMessageController.this.clickedClickIds);
                }

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OSInAppMessageController.printHttpErrorForInAppMessageRequest("engagement", statusCode, response);
                    OSInAppMessageController.this.clickedClickIds.remove(action.clickId);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Unable to execute in-app message action HTTP request due to invalid JSON");
        }
    }

    private void setDataForRedisplay(OSInAppMessage message) {
        if (!message.getDisplayStats().isRedisplayEnabled()) {
            return;
        }
        boolean messageDismissed = this.dismissedMessages.contains(message.messageId);
        int index = this.redisplayedInAppMessages.indexOf(message);
        if (messageDismissed && index != -1) {
            boolean triggerHasChanged;
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "setDataForRedisplay: " + message.messageId);
            OSInAppMessage savedIAM = this.redisplayedInAppMessages.get(index);
            message.getDisplayStats().setDisplayStats(savedIAM.getDisplayStats());
            boolean bl = triggerHasChanged = message.isTriggerChanged() || !savedIAM.isDisplayedInSession() && message.triggers.isEmpty();
            if (triggerHasChanged && message.getDisplayStats().isDelayTimeSatisfied() && message.getDisplayStats().shouldDisplayAgain()) {
                this.dismissedMessages.remove(message.messageId);
                this.impressionedMessages.remove(message.messageId);
                message.clearClickIds();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueMessageForDisplay(@NonNull OSInAppMessage message) {
        ArrayList<OSInAppMessage> arrayList = this.messageDisplayQueue;
        synchronized (arrayList) {
            if (!this.messageDisplayQueue.contains(message)) {
                this.messageDisplayQueue.add(message);
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "In app message with id, " + message.messageId + ", added to the queue");
            }
            this.attemptToShowInAppMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptToShowInAppMessage() {
        ArrayList<OSInAppMessage> arrayList = this.messageDisplayQueue;
        synchronized (arrayList) {
            if (!this.systemConditionController.systemConditionsAvailable()) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.WARN, "In app message not showing due to system condition not correct");
                return;
            }
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "displayFirstIAMOnQueue: " + this.messageDisplayQueue);
            if (this.messageDisplayQueue.size() > 0 && !this.isInAppMessageShowing()) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "No IAM showing currently, showing first item in the queue!");
                this.displayMessage(this.messageDisplayQueue.get(0));
                return;
            }
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "In app message is currently showing or there are no IAMs left in the queue!");
        }
    }

    boolean isInAppMessageShowing() {
        return this.inAppMessageShowing;
    }

    @Nullable
    OSInAppMessage getCurrentDisplayedInAppMessage() {
        return this.inAppMessageShowing ? this.messageDisplayQueue.get(0) : null;
    }

    void messageWasDismissed(@NonNull OSInAppMessage message) {
        if (!message.isPreview) {
            this.dismissedMessages.add(message.messageId);
            OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_DISPLAYED_IAMS", this.dismissedMessages);
            this.lastTimeInAppDismissed = new Date();
            this.persistInAppMessageForRedisplay(message);
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "OSInAppMessageController messageWasDismissed dismissedMessages: " + this.dismissedMessages.toString());
        }
        this.dismissCurrentMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dismissCurrentMessage(@Nullable OSInAppMessage message) {
        if (this.currentPrompt != null) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Stop evaluateMessageDisplayQueue because prompt is currently displayed");
            return;
        }
        this.inAppMessageShowing = false;
        ArrayList<OSInAppMessage> arrayList = this.messageDisplayQueue;
        synchronized (arrayList) {
            if (this.messageDisplayQueue.size() > 0) {
                if (message != null && !this.messageDisplayQueue.contains(message)) {
                    OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Message already removed from the queue!");
                    return;
                }
                String removedMessageId = this.messageDisplayQueue.remove((int)0).messageId;
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "In app message with id, " + removedMessageId + ", dismissed (removed) from the queue!");
            }
            if (this.messageDisplayQueue.size() > 0) {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "In app message on queue available: " + this.messageDisplayQueue.get((int)0).messageId);
                this.displayMessage(this.messageDisplayQueue.get(0));
            } else {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "In app message dismissed evaluating messages");
                this.evaluateInAppMessages();
            }
        }
    }

    private void persistInAppMessageForRedisplay(final OSInAppMessage message) {
        if (!message.getDisplayStats().isRedisplayEnabled()) {
            return;
        }
        long displayTimeSeconds = System.currentTimeMillis() / 1000L;
        message.getDisplayStats().setLastDisplayTime(displayTimeSeconds);
        message.getDisplayStats().incrementDisplayQuantity();
        message.setTriggerChanged(false);
        message.setDisplayedInSession(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                OSInAppMessageController.this.inAppMessageRepository.saveInAppMessage(message);
            }
        }, OS_SAVE_IN_APP_MESSAGE).start();
        int index = this.redisplayedInAppMessages.indexOf(message);
        if (index != -1) {
            this.redisplayedInAppMessages.set(index, message);
        } else {
            this.redisplayedInAppMessages.add(message);
        }
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "persistInAppMessageForRedisplay: " + message.toString() + " with msg array data: " + this.redisplayedInAppMessages.toString());
    }

    @Nullable
    private static String htmlPathForMessage(OSInAppMessage message) {
        String variantId = OSInAppMessageController.variantIdForMessage(message);
        if (variantId == null) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Unable to find a variant for in-app message " + message.messageId);
            return null;
        }
        return "in_app_messages/" + message.messageId + "/variants/" + variantId + "/html?app_id=" + OneSignal.appId;
    }

    private void displayMessage(final @NonNull OSInAppMessage message) {
        if (!this.inAppMessagingEnabled) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.VERBOSE, "In app messaging is currently paused, iam will not be shown!");
            return;
        }
        this.inAppMessageShowing = true;
        String htmlPath = OSInAppMessageController.htmlPathForMessage(message);
        OneSignalRestClient.getSync(htmlPath, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OSInAppMessageController.this.inAppMessageShowing = false;
                OSInAppMessageController.printHttpErrorForInAppMessageRequest("html", statusCode, response);
                if (!OSUtils.shouldRetryNetworkRequest(statusCode) || OSInAppMessageController.this.htmlNetworkRequestAttemptCount >= OSUtils.MAX_NETWORK_REQUEST_ATTEMPT_COUNT) {
                    OSInAppMessageController.this.htmlNetworkRequestAttemptCount = 0;
                    OSInAppMessageController.this.messageWasDismissed(message);
                    return;
                }
                OSInAppMessageController.this.htmlNetworkRequestAttemptCount++;
                OSInAppMessageController.this.queueMessageForDisplay(message);
            }

            @Override
            void onSuccess(String response) {
                OSInAppMessageController.this.htmlNetworkRequestAttemptCount = 0;
                try {
                    JSONObject jsonResponse = new JSONObject(response);
                    String htmlStr = jsonResponse.getString("html");
                    double displayDuration = jsonResponse.optDouble("display_duration");
                    message.setDisplayDuration(displayDuration);
                    WebViewManager.showHTMLString(message, htmlStr);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, null);
    }

    void displayPreviewMessage(@NonNull String previewUUID) {
        this.inAppMessageShowing = true;
        String htmlPath = "in_app_messages/device_preview?preview_id=" + previewUUID + "&app_id=" + OneSignal.appId;
        OneSignalRestClient.get(htmlPath, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OSInAppMessageController.printHttpErrorForInAppMessageRequest("html", statusCode, response);
                OSInAppMessageController.this.dismissCurrentMessage(null);
            }

            @Override
            void onSuccess(String response) {
                try {
                    JSONObject jsonResponse = new JSONObject(response);
                    String htmlStr = jsonResponse.getString("html");
                    OSInAppMessage message = new OSInAppMessage(true);
                    double displayDuration = jsonResponse.optDouble("display_duration");
                    message.setDisplayDuration(displayDuration);
                    WebViewManager.showHTMLString(message, htmlStr);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, null);
    }

    @Override
    public void messageTriggerConditionChanged() {
        this.evaluateInAppMessages();
    }

    @Override
    public void systemConditionChanged() {
        this.attemptToShowInAppMessage();
    }

    private void makeRedisplayMessagesAvailableWithTriggers(Collection<String> newTriggersKeys) {
        for (OSInAppMessage message : this.messages) {
            if (!this.redisplayedInAppMessages.contains(message) || !this.triggerController.isTriggerOnMessage(message, newTriggersKeys)) continue;
            message.setTriggerChanged(true);
        }
    }

    void addTriggers(Map<String, Object> newTriggers) {
        this.triggerController.addTriggers(newTriggers);
        this.makeRedisplayMessagesAvailableWithTriggers(newTriggers.keySet());
        this.evaluateInAppMessages();
    }

    void removeTriggersForKeys(Collection<String> keys) {
        this.triggerController.removeTriggersForKeys(keys);
        this.makeRedisplayMessagesAvailableWithTriggers(keys);
        this.evaluateInAppMessages();
    }

    void setInAppMessagingEnabled(boolean enabled) {
        this.inAppMessagingEnabled = enabled;
        if (enabled) {
            this.evaluateInAppMessages();
        }
    }

    @Nullable
    Object getTriggerValue(String key) {
        return this.triggerController.getTriggerValue(key);
    }

    @NonNull
    public ArrayList<OSInAppMessage> getInAppMessageDisplayQueue() {
        return this.messageDisplayQueue;
    }

    @NonNull
    public List<OSInAppMessage> getRedisplayedInAppMessages() {
        return this.redisplayedInAppMessages;
    }
}

