/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.WorkerThread;
import com.onesignal.OSSessionManager;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OutcomeEvent;
import com.onesignal.OutcomeParams;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

class OutcomeEventsCache {
    private static final Object lock = new Object();

    OutcomeEventsCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static void deleteOldOutcomeEvent(OutcomeEvent event, OneSignalDbHelper dbHelper) {
        Object object = lock;
        synchronized (object) {
            SQLiteDatabase writableDb = dbHelper.getWritableDbWithRetries();
            try {
                writableDb.beginTransaction();
                writableDb.delete("outcome", "timestamp = ?", new String[]{String.valueOf(event.getTimestamp())});
                writableDb.setTransactionSuccessful();
            }
            catch (Throwable t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error deleting old outcome event records! ", t);
            }
            finally {
                if (writableDb != null) {
                    try {
                        writableDb.endTransaction();
                    }
                    catch (Throwable t) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static void saveOutcomeEvent(OutcomeEvent event, OneSignalDbHelper dbHelper) {
        Object object = lock;
        synchronized (object) {
            SQLiteDatabase writableDb = dbHelper.getWritableDbWithRetries();
            String notificationIds = event.getNotificationIds() != null ? event.getNotificationIds().toString() : "[]";
            ContentValues values = new ContentValues();
            values.put("notification_ids", notificationIds);
            values.put("session", event.getSession().toString().toLowerCase());
            values.put("name", event.getName());
            values.put("timestamp", Long.valueOf(event.getTimestamp()));
            if (event.getParams() != null) {
                values.put("params", event.getParams());
            }
            writableDb.insert("outcome", null, values);
            writableDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static List<OutcomeEvent> getAllEventsToSend(OneSignalDbHelper dbHelper) {
        ArrayList<OutcomeEvent> events = new ArrayList<OutcomeEvent>();
        Object object = lock;
        synchronized (object) {
            Cursor cursor = null;
            try {
                SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
                cursor = readableDb.query("outcome", null, null, null, null, null, null);
                if (cursor.moveToFirst()) {
                    do {
                        String notificationIds = cursor.getString(cursor.getColumnIndex("notification_ids"));
                        String name = cursor.getString(cursor.getColumnIndex("name"));
                        String sessionString = cursor.getString(cursor.getColumnIndex("session"));
                        OSSessionManager.Session session = OSSessionManager.Session.fromString(sessionString);
                        long timestamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
                        int paramsIndex = cursor.getColumnIndex("params");
                        String paramsString = cursor.isNull(paramsIndex) ? null : cursor.getString(paramsIndex);
                        OutcomeParams params = paramsString != null ? OutcomeParams.Builder.newInstance().setJsonString(paramsString).build() : null;
                        try {
                            OutcomeEvent event = new OutcomeEvent(session, new JSONArray(notificationIds), name, timestamp, params);
                            events.add(event);
                        }
                        catch (JSONException e) {
                            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating JSONArray from notifications ids outcome:JSON Failed.", e);
                        }
                    } while (cursor.moveToNext());
                }
            }
            finally {
                if (cursor != null && !cursor.isClosed()) {
                    cursor.close();
                }
            }
        }
        return events;
    }
}

